/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.TipoUtilizacao;
import br.com.elotech.tributos.domain.Utilizacao;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoDSMResponse;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoLoteResponse;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaDestinacao;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaTipoObra;
import br.com.elotech.tributos.repository.CertificadoRepository;
import br.com.elotech.tributos.service.AssinaturaXMLService;
import br.com.elotech.tributos.service.sisobra.SisObraClient;
import java.io.ByteArrayInputStream;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Service
public class SisObraServiceUtils {
    private final CertificadoRepository certificadoRepository;
    private final AssinaturaXMLService assinaturaXMLService;
    private final SisObraClient sisObraClient;
    private static final Long ALVENARIA = 1L;
    private static final Long MADEIRA = 2L;
    private static final Long MISTA = 3L;
    private static final Long METALICA = 4L;
    private static final Long CONCRETO = 5L;
    private static final Long STEEL_FRAME = 6L;

    public Boolean isXMLEnviadoComErro(String xml) {
        Boolean xmlComErro = Boolean.TRUE;
        try {
            String codRetorno;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("UTF-8"))));
            Node codRetornoNode = document.getElementsByTagName("codRetorno").item(0);
            if (codRetornoNode != null && Strings.isNotBlank((String)(codRetorno = codRetornoNode.getTextContent())) && codRetorno.contains("IN")) {
                xmlComErro = Boolean.FALSE;
            }
            return xmlComErro;
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao processar XML de retorno : " + e.getMessage());
        }
    }

    public Certificado getCertificadoByEntidade(Long Id2) {
        return (Certificado)this.certificadoRepository.findById((Object)Id2).orElseThrow(() -> new EloValidationException("Certificado n\u00e3o encontrado"));
    }

    public String getMensagemDeErro(byte[] xmlBytes) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new ByteArrayInputStream(xmlBytes)));
            Node descricaoNode = document.getElementsByTagName("descricao").item(0);
            Node codRetornoNode = document.getElementsByTagName("codRetorno").item(0);
            if (descricaoNode != null && codRetornoNode != null && codRetornoNode.getTextContent().contains("ER")) {
                return String.format("%s - %s", codRetornoNode.getTextContent(), descricaoNode.getTextContent());
            }
            return null;
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao obter mensagem de erro de XML de retorno : " + e.getMessage());
        }
    }

    public String getXmlAssinado(String xml, String uri, String tagToInsert, Certificado certificado) {
        String xmlAssinado;
        try {
            xmlAssinado = this.assinaturaXMLService.assinar(xml, certificado, uri, tagToInsert);
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao assinar XML: " + e.getMessage());
        }
        return xmlAssinado;
    }

    public String enviarLoteXmlReceitaFederal(String xml, Certificado certificado) {
        RecepcaoLoteResponse recepcaoLoteResponse = this.sisObraClient.getRecepcaoResponse(xml, certificado.getKeyStore(), certificado.getSenha().toCharArray());
        return recepcaoLoteResponse.getXmlResultado();
    }

    public String enviarDsmXmlReceitaFederal(String xml, Certificado certificado) {
        RecepcaoDSMResponse recepcaoDSMResponse = this.sisObraClient.getRecepcaoDsmResponse(xml, certificado.getKeyStore(), certificado.getSenha().toCharArray());
        return recepcaoDSMResponse.getXmlResultado();
    }

    public Long getTipoObra(Long tipoConstrucao) {
        if (ALVENARIA.equals(tipoConstrucao) || METALICA.equals(tipoConstrucao) || CONCRETO.equals(tipoConstrucao) || STEEL_FRAME.equals(tipoConstrucao)) {
            return AlvaraAreaTipoObra.ALVENARIA.getId();
        }
        if (MADEIRA.equals(tipoConstrucao)) {
            return AlvaraAreaTipoObra.MADEIRA.getId();
        }
        if (MISTA.equals(tipoConstrucao)) {
            return AlvaraAreaTipoObra.MISTA.getId();
        }
        return null;
    }

    public Long getDestinacao(TipoSegmento tipoSegmento, Utilizacao utilizacao) {
        if (Objects.nonNull(tipoSegmento.getDestinacaoSisObra())) {
            return this.getDestinacaoBySegmento(tipoSegmento);
        }
        return this.getDestinacaoByUtilizacao(utilizacao);
    }

    public Long getDestinacaoBySegmento(TipoSegmento tipoSegmento) {
        return AlvaraAreaDestinacao.fromValue((Long)tipoSegmento.getDestinacaoSisObra()).getId();
    }

    public Long getDestinacaoByUtilizacao(Utilizacao utilizacao) {
        if (TipoUtilizacao.RESIDENCIAL.equals((Object)utilizacao.getTipoUtilizacao())) {
            return AlvaraAreaDestinacao.RESIDENCIAL_UNIFAMILIAR.getId();
        }
        if (TipoUtilizacao.INDUSTRIAL.equals((Object)utilizacao.getTipoUtilizacao())) {
            return AlvaraAreaDestinacao.GALPAO_INDUSTRIAL.getId();
        }
        if (TipoUtilizacao.RESIDENCIALCOMECIAL.equals((Object)utilizacao.getTipoUtilizacao()) || TipoUtilizacao.COMERCIAL.equals((Object)utilizacao.getTipoUtilizacao())) {
            return AlvaraAreaDestinacao.COMERCIAL_SALAS_LOJAS.getId();
        }
        return null;
    }

    @Generated
    public SisObraServiceUtils(CertificadoRepository certificadoRepository, AssinaturaXMLService assinaturaXMLService, SisObraClient sisObraClient) {
        this.certificadoRepository = certificadoRepository;
        this.assinaturaXMLService = assinaturaXMLService;
        this.sisObraClient = sisObraClient;
    }
}

