/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.Utilizacao;
import br.com.elotech.tributos.domain.sisobra.SisObraHabitese;
import br.com.elotech.tributos.domain.sisobra.SisObraHabiteseArea;
import br.com.elotech.tributos.domain.sisobra.SisObraHabiteseHistorico;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sisobra.DocumentosSisobraParaEnviarDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraAreaDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseDadosAlvaraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseHistoricoDTO;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaCategoria;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaComplementarTipo;
import br.com.elotech.tributos.enums.sisobra.StatusDocumentos;
import br.com.elotech.tributos.enums.sisobra.TipoArea;
import br.com.elotech.tributos.enums.sisobra.TipoHabitese;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraAreaRepositoryImpl;
import br.com.elotech.tributos.repository.sisobra.SisObraHabiteseAreaRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraHabiteseHistoricoRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraHabiteseRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoSegmentoService;
import br.com.elotech.tributos.service.UtilizacaoService;
import br.com.elotech.tributos.service.sisobra.SisObraServiceUtils;
import br.com.elotech.tributos.util.sisobra.SisObraHabiteseXmlBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SisObraHabiteseService
extends CrudService<SisObraHabitese, Long> {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    private final SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl;
    private final SisObraHabiteseRepository sisObraHabiteseRepository;
    private final SisObraHabiteseAreaRepository sisObraHabiteseAreaRepository;
    private final ContextService contextService;
    private final SisObraHabiteseHistoricoRepository sisObraHabiteseHistoricoRepository;
    private final SisObraServiceUtils sisObraServiceUtils;
    private final DocumentoService documentoService;
    private final TipoSegmentoService tipoSegmentoService;
    private final UtilizacaoService utilizacaoService;
    private final ParametroGeralService parametroGeralService;

    public Page<SisObraHabiteseDTO> findDocumentoSisObraHabitese(DocumentosSisobraParaEnviarDTO dto, Pageable pageable) {
        return this.sisObraHabiteseRepository.findDocumentoSisObraHabitese(dto, pageable);
    }

    public List<SisObraHabiteseDTO> findAllSisObraHabitese(DocumentosSisobraParaEnviarDTO dto) {
        return this.sisObraHabiteseRepository.findDocumentoSisObraHabitese(dto, Pageable.unpaged()).getContent();
    }

    public Page<SisObraHabiteseHistoricoDTO> findHistoricoHabitese(Long id, Pageable pageable) {
        List sisObraHabiteseHistorico = this.sisObraHabiteseHistoricoRepository.findByIdHabitese(id, pageable);
        List sisObraHabiteseHistoricoDTO = sisObraHabiteseHistorico.stream().map(SisObraHabiteseHistoricoDTO::from).collect(Collectors.toList());
        sisObraHabiteseHistoricoDTO.stream().filter(dto -> "E".equals(dto.getStatusEnvio())).forEach(arg_0 -> this.buildMessageErro(arg_0));
        return new PageImpl(sisObraHabiteseHistoricoDTO, pageable, (long)pageable.getPageSize());
    }

    private void buildMessageErro(SisObraHabiteseHistoricoDTO dto) {
        if (dto.getXmlRetorno().length > 0) {
            String mensagemRetorno = this.sisObraServiceUtils.getMensagemDeErro(dto.getXmlRetorno());
            dto.setMensagemRetorno(mensagemRetorno);
        }
    }

    public List<String> gravarDados(DocumentosSisobraParaEnviarDTO sisobraParaEnviarDTO, UserSecurityDTO user) {
        Certificado certificado = this.sisObraServiceUtils.getCertificadoByEntidade(this.contextService.getEntidadePrincipal());
        ArrayList<String> listaDocumentosComErro = new ArrayList<String>();
        List habiteses = Boolean.TRUE.equals(sisobraParaEnviarDTO.getTodosSelecionados()) ? this.findAllSisObraHabitese(sisobraParaEnviarDTO) : sisobraParaEnviarDTO.getHabiteses();
        List documentosNaoEnviados = habiteses.stream().filter(documento -> Boolean.FALSE.equals(documento.getEnviadoComSucesso())).collect(Collectors.toList());
        Boolean buscaDadosDocumento = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.BUSCA_AREA_DOCUMENTO_SISOBRA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Boolean enviaSomenteNumeroDocumentoSisObra = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ENVIA_SOMENTE_NUMERO_DOCUMENTO_SISOBRA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        for (SisObraHabiteseDTO habitese : documentosNaoEnviados) {
            SisObraHabiteseDadosAlvaraDTO dadosAlvara;
            String xmlRetorno = "";
            SisObraHabitese habiteseToSave = new SisObraHabitese();
            if (habitese.getIdSisObraHabitese() > 0L) {
                habiteseToSave = (SisObraHabitese)this.sisObraHabiteseRepository.findOne((Object)habitese.getIdSisObraHabitese());
                this.deleteAreasHabiteseById(habitese.getIdSisObraHabitese());
            }
            List items = null;
            if (Boolean.TRUE.equals(buscaDadosDocumento)) {
                items = this.getItensDocumento(entidadePrincipal, habitese.getExercicioDocumento(), habitese.getTipoDocumento(), habitese.getDocumento());
            }
            if (Objects.isNull(dadosAlvara = this.getDadosAlvaraHabitese(habitese.getNroAlvaraHabitese(), habitese.getDataAlvaraHabitese(), habitese.getTipoDocumentoAlvara(), habitese.getAnoAlvaraHabitese(), enviaSomenteNumeroDocumentoSisObra)) && Boolean.FALSE.equals(buscaDadosDocumento)) {
                throw new EloValidationException("Alv\u00e1ra n\u00e3o encontrado para o Habite-se.");
            }
            if (Objects.isNull(dadosAlvara) && Boolean.TRUE.equals(buscaDadosDocumento)) {
                dadosAlvara = this.buildDadosAlvaraByHabitese(habitese, items);
            }
            habiteseToSave.setNumeroHabitese(String.valueOf(habitese.getDocumento()));
            habiteseToSave.setDataHabitese(habitese.getDataEmissao());
            habiteseToSave.setDataInicioObra(habitese.getDataInicio());
            habiteseToSave.setDataFinalObra(habitese.getDataEncerramento());
            if (Boolean.TRUE.equals(buscaDadosDocumento)) {
                habiteseToSave.setTipoHabitese(this.getTipoHabitese(items, dadosAlvara).getId());
            } else {
                habiteseToSave.setTipoHabitese(this.getTipoHabitese(habitese, dadosAlvara).getId());
            }
            habiteseToSave.setUnidadeMedida(UnidadeMedida.M2.getId());
            habiteseToSave.setValorUnidadeMedida(Double.valueOf(0.0));
            habiteseToSave.setIdAlvara(dadosAlvara.getIdAlvara());
            habiteseToSave.setDataAlvara(habitese.getDataAlvaraHabitese());
            habiteseToSave.setNumeroAlvaraDoc(habitese.getNroAlvaraHabitese());
            habiteseToSave.setTipoDocumento(habitese.getTipoDocumento());
            habiteseToSave.setIdSisobraHabitese(habitese.getExercicioDocumento() + String.format("%04d", habitese.getTipoDocumento()) + String.format("%06d", habitese.getDocumento()));
            this.sisObraHabiteseRepository.save((Object)habiteseToSave);
            List listHabiteseArea = Boolean.TRUE.equals(buscaDadosDocumento) ? this.gravarDadosAreaByDocumento(habiteseToSave.getId(), items) : this.gravarDadosArea(habiteseToSave.getId(), this.contextService.getEntidadePrincipal(), habitese.getExercicioProjeto(), habitese.getProjeto());
            String xmlToSave = this.getHabiteseXml(habiteseToSave, listHabiteseArea, habitese.getCnpjCpfDocumento(), dadosAlvara);
            String xmlToSaveAssinado = this.sisObraServiceUtils.getXmlAssinado(xmlToSave, "infHabitese", "Habitese", certificado);
            boolean enviadoComSucesso = Boolean.FALSE;
            if (Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ENVIO_DOCUMENTO_SISOBRA_ATIVO, ModuloEnum.MODULO_TRIBUTARIO.getValue()))) {
                xmlRetorno = this.sisObraServiceUtils.enviarLoteXmlReceitaFederal(xmlToSaveAssinado, certificado);
                enviadoComSucesso = this.sisObraServiceUtils.isXMLEnviadoComErro(xmlRetorno) == false;
            }
            this.updateHabiteseWithXml(habiteseToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, Boolean.valueOf(enviadoComSucesso));
            this.gravarHistoricoHabitese(habiteseToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, enviadoComSucesso, user);
            if (enviadoComSucesso) continue;
            String documentoExercicio = habiteseToSave.getNumeroHabitese().concat("/").concat(habitese.getExercicioDocumento().toString());
            listaDocumentosComErro.add(documentoExercicio);
        }
        return listaDocumentosComErro;
    }

    public SisObraHabiteseDadosAlvaraDTO buildDadosAlvaraByHabitese(SisObraHabiteseDTO habitese, List<DocumentoCertidaoItemDTO> items) {
        SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvaraDTO = new SisObraHabiteseDadosAlvaraDTO();
        sisObraHabiteseDadosAlvaraDTO.setDataAlvara(String.valueOf(habitese.getDataAlvaraHabitese()));
        sisObraHabiteseDadosAlvaraDTO.setIdSisObraAlvara(String.format("%s/%s", habitese.getNroAlvaraHabitese(), habitese.getAnoAlvaraHabitese()));
        sisObraHabiteseDadosAlvaraDTO.setCnpjProprietarioObra(habitese.getCnpjProprietarioObra());
        sisObraHabiteseDadosAlvaraDTO.setCpfProprietarioObra(habitese.getCpfProprietarioObra());
        BigDecimal areaHabitese = items.stream().map(arg_0 -> this.getAreaTotal(arg_0)).reduce(BigDecimal.ZERO, BigDecimal::add);
        sisObraHabiteseDadosAlvaraDTO.setArea(areaHabitese);
        return sisObraHabiteseDadosAlvaraDTO;
    }

    public List<DocumentoCertidaoItemDTO> getItensDocumento(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento alvara = this.documentoService.getDocumento(entidade, exercicio, tipoDocumento, documento);
        return this.documentoService.getDTODocumentoCertidaoItens(alvara);
    }

    public List<SisObraHabiteseArea> gravarDadosAreaByDocumento(Long idHabitese, List<DocumentoCertidaoItemDTO> items) {
        ArrayList<SisObraHabiteseArea> listHabiteseArea = new ArrayList<SisObraHabiteseArea>();
        long sequencia = 0L;
        for (DocumentoCertidaoItemDTO habiteSeArea : items) {
            TipoSegmento tipoSegmento = (TipoSegmento)this.tipoSegmentoService.findOne((Serializable)habiteSeArea.getIdTipoSegmento());
            Utilizacao utilizacao = (Utilizacao)this.utilizacaoService.findOne((Serializable)habiteSeArea.getIdUtilizacao());
            SisObraHabiteseArea sisObraHabiteseArea = new SisObraHabiteseArea();
            sisObraHabiteseArea.setIdHabitese(idHabitese);
            sisObraHabiteseArea.setSequencia(Long.valueOf(sequencia += ACRESCIMO_DE_SEQUENCIA.longValue()));
            sisObraHabiteseArea.setTipo(tipoSegmento.getTipoAreaSisObra());
            if (TipoArea.COMPLEMENTAR.getFlagDescricao().equals(sisObraHabiteseArea.getTipo())) {
                sisObraHabiteseArea.setTipoArea(AlvaraAreaComplementarTipo.fromValue((Long)tipoSegmento.getIdTipoAreaSisObra()).getId());
                sisObraHabiteseArea.setAreaDescoberta(this.getAreaDescoberta(habiteSeArea));
                sisObraHabiteseArea.setAreaCoberta(this.getAreaCoberta(habiteSeArea));
            }
            sisObraHabiteseArea.setCategoria(AlvaraAreaCategoria.OBRA_NOVA.getId());
            sisObraHabiteseArea.setDestinacao(this.sisObraServiceUtils.getDestinacao(tipoSegmento, utilizacao));
            sisObraHabiteseArea.setTipoObra(this.sisObraServiceUtils.getTipoObra(habiteSeArea.getIdTipoConstrucao()));
            sisObraHabiteseArea.setArea(this.getAreaTotal(habiteSeArea));
            sisObraHabiteseArea.setQtdTotalUnidade(BigDecimal.ZERO);
            this.sisObraHabiteseAreaRepository.save((Object)sisObraHabiteseArea);
            listHabiteseArea.add(sisObraHabiteseArea);
        }
        return listHabiteseArea;
    }

    public BigDecimal getAreaTotal(DocumentoCertidaoItemDTO item) {
        BigDecimal somaAreasParciais = Optional.ofNullable(item.getAreaCobertaParcial()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAreaDescobertaParcial()).orElse(BigDecimal.ZERO));
        BigDecimal somaAreasTotais = Optional.ofNullable(item.getAreaCoberta()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAreaDescoberta()).orElse(BigDecimal.ZERO));
        if (somaAreasParciais.compareTo(BigDecimal.ZERO) > 0) {
            return somaAreasParciais;
        }
        return somaAreasTotais;
    }

    public BigDecimal getAreaCoberta(DocumentoCertidaoItemDTO item) {
        BigDecimal areaParcial = Optional.ofNullable(item.getAreaCobertaParcial()).orElse(BigDecimal.ZERO);
        BigDecimal areaTotal = Optional.ofNullable(item.getAreaCoberta()).orElse(BigDecimal.ZERO);
        if (areaParcial.compareTo(BigDecimal.ZERO) > 0) {
            return areaParcial;
        }
        return areaTotal;
    }

    public BigDecimal getAreaDescoberta(DocumentoCertidaoItemDTO item) {
        BigDecimal areaParcial = Optional.ofNullable(item.getAreaDescobertaParcial()).orElse(BigDecimal.ZERO);
        BigDecimal areaTotal = Optional.ofNullable(item.getAreaDescoberta()).orElse(BigDecimal.ZERO);
        if (areaParcial.compareTo(BigDecimal.ZERO) > 0) {
            return areaParcial;
        }
        return areaTotal;
    }

    public void deleteAreasHabiteseById(Long idHabitese) {
        this.sisObraHabiteseAreaRepository.deleteByIdHabitese(idHabitese);
    }

    private void gravarHistoricoHabitese(SisObraHabitese habitese, String xml, String xmlAssinado, String xmlRetorno, boolean enviadoComSucesso, UserSecurityDTO user) {
        StatusDocumentos status = StatusDocumentos.ENVIADO_COM_ERRO;
        if (enviadoComSucesso) {
            status = StatusDocumentos.ENVIADO_COM_SUCESSO;
        }
        SisObraHabiteseHistorico sisObraHabiteseHistorico = new SisObraHabiteseHistorico();
        sisObraHabiteseHistorico.setSisObraHabitese(habitese);
        sisObraHabiteseHistorico.setSequencia(this.sisObraHabiteseHistoricoRepository.findMaxSequenciaHistoricoByIdHabitese(habitese.getId()));
        sisObraHabiteseHistorico.setStatusEnvio(status.getDescricao());
        sisObraHabiteseHistorico.setUsuarioEnvio(user.getPreferredUsername());
        sisObraHabiteseHistorico.setDataEnvio(LocalDate.now());
        sisObraHabiteseHistorico.setXmlEnvio(xml.getBytes());
        sisObraHabiteseHistorico.setXmlEnvioAssinado(xmlAssinado.getBytes());
        sisObraHabiteseHistorico.setXmlRetorno(xmlRetorno.getBytes());
        this.sisObraHabiteseHistoricoRepository.save((Object)sisObraHabiteseHistorico);
    }

    public TipoHabitese getTipoHabitese(List<DocumentoCertidaoItemDTO> items, SisObraHabiteseDadosAlvaraDTO areaAlvara) {
        BigDecimal areaHabitese = items.stream().map(arg_0 -> this.getAreaTotal(arg_0)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (areaAlvara != null && areaHabitese.compareTo(areaAlvara.getArea()) < 0) {
            return TipoHabitese.PARCIAL;
        }
        return TipoHabitese.TOTAL;
    }

    public TipoHabitese getTipoHabitese(SisObraHabiteseDTO habitese, SisObraHabiteseDadosAlvaraDTO areaAlvara) {
        BigDecimal areaHabitese;
        BigDecimal bigDecimal = areaHabitese = habitese.getAreaTotal().compareTo(BigDecimal.ZERO) > 0 ? habitese.getAreaTotal() : habitese.getArea();
        if (areaAlvara != null && areaHabitese.compareTo(areaAlvara.getArea()) < 0) {
            return TipoHabitese.PARCIAL;
        }
        return TipoHabitese.TOTAL;
    }

    public SisObraHabiteseDadosAlvaraDTO getDadosAlvaraHabitese(String numeroAlvara, LocalDate dataAlvara, Long tipoDocumentoAlvara, Long exercicioAlvara, Boolean enviaSomenteNumeroDocumento) {
        List dadosAlvara = this.sisObraHabiteseRepository.findDadosAlvara(numeroAlvara, dataAlvara);
        if (dadosAlvara == null || dadosAlvara.isEmpty()) {
            return this.getDadosAlvaraHabiteseByDocumento(this.contextService.getEntidadePrincipal(), exercicioAlvara, tipoDocumentoAlvara, Long.valueOf(Long.parseLong(numeroAlvara)), enviaSomenteNumeroDocumento);
        }
        SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvaraDTO = new SisObraHabiteseDadosAlvaraDTO();
        sisObraHabiteseDadosAlvaraDTO.setIdAlvara(((SisObraHabiteseDadosAlvaraDTO)dadosAlvara.getFirst()).getIdAlvara());
        sisObraHabiteseDadosAlvaraDTO.setDataAlvara(((SisObraHabiteseDadosAlvaraDTO)dadosAlvara.getFirst()).getDataAlvara());
        sisObraHabiteseDadosAlvaraDTO.setIdSisObraAlvara(((SisObraHabiteseDadosAlvaraDTO)dadosAlvara.getFirst()).getIdSisObraAlvara());
        sisObraHabiteseDadosAlvaraDTO.setCnpjProprietarioObra(((SisObraHabiteseDadosAlvaraDTO)dadosAlvara.getFirst()).getCnpjProprietarioObra());
        sisObraHabiteseDadosAlvaraDTO.setCpfProprietarioObra(((SisObraHabiteseDadosAlvaraDTO)dadosAlvara.getFirst()).getCpfProprietarioObra());
        BigDecimal totalArea = dadosAlvara.stream().map(SisObraHabiteseDadosAlvaraDTO::getArea).reduce(BigDecimal.ZERO, BigDecimal::add);
        sisObraHabiteseDadosAlvaraDTO.setArea(totalArea);
        return sisObraHabiteseDadosAlvaraDTO;
    }

    public SisObraHabiteseDadosAlvaraDTO getDadosAlvaraHabiteseByDocumento(Long entidade, Long exercicio, Long tipoDocumento, Long documento, Boolean enviaSomenteNumeroDocumento) {
        Optional alvara = this.documentoService.getDocumentoOrEmpty(entidade, exercicio, tipoDocumento, documento);
        if (alvara.isPresent()) {
            List documentoItens = this.documentoService.getDTODocumentoCertidaoItens((Documento)alvara.get());
            SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvaraDTO = new SisObraHabiteseDadosAlvaraDTO();
            sisObraHabiteseDadosAlvaraDTO.setDataAlvara(String.valueOf(((Documento)alvara.get()).getDataEmissao()));
            sisObraHabiteseDadosAlvaraDTO.setIdSisObraAlvara(this.getIdSisObraAlvara(((Documento)alvara.get()).getDocumento(), ((Documento)alvara.get()).getExercicio(), enviaSomenteNumeroDocumento));
            sisObraHabiteseDadosAlvaraDTO.setCnpjProprietarioObra(((Documento)alvara.get()).getCnpjCpf());
            sisObraHabiteseDadosAlvaraDTO.setCpfProprietarioObra(((Documento)alvara.get()).getCnpjCpf());
            BigDecimal areaAlvara = documentoItens.stream().map(arg_0 -> this.getAreaTotal(arg_0)).reduce(BigDecimal.ZERO, BigDecimal::add);
            sisObraHabiteseDadosAlvaraDTO.setArea(areaAlvara);
            return sisObraHabiteseDadosAlvaraDTO;
        }
        return null;
    }

    public String getIdSisObraAlvara(Long documento, Long exercicio, Boolean enviaSomenteNumeroDocumento) {
        if (Boolean.TRUE.equals(enviaSomenteNumeroDocumento)) {
            return String.valueOf(documento);
        }
        return String.format("%s/%s", documento, exercicio);
    }

    private List<SisObraHabiteseArea> gravarDadosArea(Long idHabitese, Long entidade, Long exercicio, Long projeto) {
        List alvaraAreas = this.sisObraAlvaraAreaRepositoryImpl.getAreaAlvaraByProjeto(entidade, exercicio, projeto);
        ArrayList<SisObraHabiteseArea> listHabiteseArea = new ArrayList<SisObraHabiteseArea>();
        long sequencia = 0L;
        for (SisObraAlvaraAreaDTO alvaraArea : alvaraAreas) {
            SisObraHabiteseArea sisObraHabiteseArea = new SisObraHabiteseArea();
            sisObraHabiteseArea.setIdHabitese(idHabitese);
            sisObraHabiteseArea.setSequencia(Long.valueOf(sequencia += ACRESCIMO_DE_SEQUENCIA.longValue()));
            sisObraHabiteseArea.setTipo(alvaraArea.getTipoAreaSisObra());
            if (TipoArea.COMPLEMENTAR.getFlagDescricao().equals(sisObraHabiteseArea.getTipo())) {
                sisObraHabiteseArea.setTipoArea(AlvaraAreaComplementarTipo.fromValue((Long)alvaraArea.getIdTipoAreaSisObra()).getId());
                sisObraHabiteseArea.setAreaDescoberta(BigDecimal.valueOf(alvaraArea.getAreaDescoberta()));
                sisObraHabiteseArea.setAreaCoberta(BigDecimal.valueOf(alvaraArea.getAreaCoberta()));
            }
            sisObraHabiteseArea.setCategoria(alvaraArea.getCategoria());
            sisObraHabiteseArea.setDestinacao(alvaraArea.getDestinacao());
            sisObraHabiteseArea.setTipoObra(alvaraArea.getTipoObra());
            sisObraHabiteseArea.setArea(Optional.ofNullable(alvaraArea.getArea()).map(BigDecimal::valueOf).orElse(BigDecimal.ZERO));
            sisObraHabiteseArea.setQtdTotalUnidade(Optional.ofNullable(alvaraArea.getQtdeTotalUnidade()).map(BigDecimal::valueOf).orElse(BigDecimal.ZERO));
            this.sisObraHabiteseAreaRepository.save((Object)sisObraHabiteseArea);
            listHabiteseArea.add(sisObraHabiteseArea);
        }
        return listHabiteseArea;
    }

    public String getHabiteseXml(SisObraHabitese habitese, List<SisObraHabiteseArea> habiteseAreas, String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        return SisObraHabiteseXmlBuilder.buildXmlHabitese((SisObraHabitese)habitese, habiteseAreas, (String)cnpjCpfDocumento, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara);
    }

    private void updateHabiteseWithXml(SisObraHabitese habitese, String xml, String xmlAssinado, String xmlRetorno, Boolean enviadoComSucesso) {
        habitese.setXmlEnviado(xml.getBytes());
        habitese.setXmlEnviadoAssinado(xmlAssinado.getBytes());
        habitese.setXmlRetorno(xmlRetorno.getBytes());
        habitese.setEnviado(Boolean.TRUE);
        habitese.setEnviadoComSucesso(enviadoComSucesso);
        this.sisObraHabiteseRepository.save((Object)habitese);
    }

    @Generated
    public SisObraHabiteseService(SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl, SisObraHabiteseRepository sisObraHabiteseRepository, SisObraHabiteseAreaRepository sisObraHabiteseAreaRepository, ContextService contextService, SisObraHabiteseHistoricoRepository sisObraHabiteseHistoricoRepository, SisObraServiceUtils sisObraServiceUtils, DocumentoService documentoService, TipoSegmentoService tipoSegmentoService, UtilizacaoService utilizacaoService, ParametroGeralService parametroGeralService) {
        this.sisObraAlvaraAreaRepositoryImpl = sisObraAlvaraAreaRepositoryImpl;
        this.sisObraHabiteseRepository = sisObraHabiteseRepository;
        this.sisObraHabiteseAreaRepository = sisObraHabiteseAreaRepository;
        this.contextService = contextService;
        this.sisObraHabiteseHistoricoRepository = sisObraHabiteseHistoricoRepository;
        this.sisObraServiceUtils = sisObraServiceUtils;
        this.documentoService = documentoService;
        this.tipoSegmentoService = tipoSegmentoService;
        this.utilizacaoService = utilizacaoService;
        this.parametroGeralService = parametroGeralService;
    }
}

