/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.Utilizacao;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvara;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvaraArea;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvaraHistorico;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sisobra.DocumentosSisobraParaEnviarDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraAreaDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraHistoricoDTO;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaCategoria;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaComplementarTipo;
import br.com.elotech.tributos.enums.sisobra.StatusDocumentos;
import br.com.elotech.tributos.enums.sisobra.TipoAlvara;
import br.com.elotech.tributos.enums.sisobra.TipoArea;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraAreaRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraAreaRepositoryImpl;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraHistoricoRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoSegmentoService;
import br.com.elotech.tributos.service.UtilizacaoService;
import br.com.elotech.tributos.service.sisobra.SisObraServiceUtils;
import br.com.elotech.tributos.util.sisobra.SisObraAlvaraXmlBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SisObraAlvaraService
extends CrudService<SisObraAlvara, Long> {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    private final SisObraAlvaraRepository sisObraAlvaraRepository;
    private final SisObraAlvaraAreaRepository sisObraAlvaraAreaRepository;
    private final SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl;
    private final ContextService contextService;
    private final SisObraAlvaraHistoricoRepository sisObraAlvaraHistoricoRepository;
    private final SisObraServiceUtils sisObraServiceUtils;
    private final DocumentoService documentoService;
    private final TipoSegmentoService tipoSegmentoService;
    private final UtilizacaoService utilizacaoService;
    private final ParametroGeralService parametroGeralService;

    public Page<SisObraAlvaraDTO> findDocumentoSisObraAlvara(DocumentosSisobraParaEnviarDTO dto, Pageable pageable) {
        return this.sisObraAlvaraRepository.findDocumentoSisObraAlvara(dto, pageable);
    }

    public List<SisObraAlvaraDTO> findAllSisObraAlvara(DocumentosSisobraParaEnviarDTO dto) {
        return this.sisObraAlvaraRepository.findDocumentoSisObraAlvara(dto, Pageable.unpaged()).getContent();
    }

    public Page<SisObraAlvaraHistoricoDTO> findHistoricoAlvara(Long id, Pageable pageable) {
        List sisObraAlvaraHistorico = this.sisObraAlvaraHistoricoRepository.findByIdAlvara(id, pageable);
        List sisObraAlvaraHistoricoDTO = sisObraAlvaraHistorico.stream().map(SisObraAlvaraHistoricoDTO::from).collect(Collectors.toList());
        sisObraAlvaraHistoricoDTO.stream().filter(dto -> "E".equals(dto.getStatusEnvio())).forEach(arg_0 -> this.buildMessageErro(arg_0));
        return new PageImpl(sisObraAlvaraHistoricoDTO, pageable, (long)pageable.getPageSize());
    }

    public List<String> gravarDados(DocumentosSisobraParaEnviarDTO sisobraParaEnviarDTO, TipoAlvara tipoAlvara, UserSecurityDTO user) {
        Certificado certificado = this.sisObraServiceUtils.getCertificadoByEntidade(this.contextService.getEntidadePrincipal());
        ArrayList<String> listaDocumentosComErro = new ArrayList<String>();
        List alvaras = Boolean.TRUE.equals(sisobraParaEnviarDTO.getTodosSelecionados()) ? this.findAllSisObraAlvara(sisobraParaEnviarDTO) : sisobraParaEnviarDTO.getAlvaras();
        List documentosNaoEnviados = alvaras.stream().filter(documento -> Boolean.FALSE.equals(documento.getEnviadoComSucesso())).collect(Collectors.toList());
        for (SisObraAlvaraDTO alvara : documentosNaoEnviados) {
            SisObraAlvara alvaraToSave = new SisObraAlvara();
            if (alvara.getIdSisObraAlvara() > 0L) {
                alvaraToSave = (SisObraAlvara)this.sisObraAlvaraRepository.findOne((Object)alvara.getIdSisObraAlvara());
                this.deleteAreasByIdAlvara(alvara.getIdSisObraAlvara());
            }
            String xmlRetorno = "";
            alvaraToSave.setNumeroAlvara(String.valueOf(alvara.getDocumento()));
            if (tipoAlvara.equals((Object)TipoAlvara.INICIAL)) {
                alvaraToSave.setNumeroProtocoloAnterior(null);
                alvaraToSave.setTipoAlvara(TipoAlvara.INICIAL.getId());
            }
            alvaraToSave.setNomeObra(alvara.getObraNome());
            alvaraToSave.setDataAlvara(alvara.getDataEmissao());
            alvaraToSave.setDataInicioObra(alvara.getDataInicio());
            alvaraToSave.setDataFinalObra(alvara.getDataEncerramento());
            alvaraToSave.setProprietarioImovel(alvara.getProprietarioImovel());
            alvaraToSave.setTipoVinculo(alvara.getTipoVinculo());
            alvaraToSave.setCnpjDonoObra(alvara.getCnpjDonoObra());
            alvaraToSave.setCpfDonoObra(alvara.getCpfDonoObra());
            alvaraToSave.setCnpjIncorporadorConcivil(alvara.getCnpjIncorporadora());
            alvaraToSave.setCpfIncorporadorConcivil(alvara.getCpfIncorporadora());
            alvaraToSave.setCnpjEmpresaConstrutora(alvara.getCnpjConstrutora());
            alvaraToSave.setObraCep(alvara.getObraCEP());
            alvaraToSave.setObraTipoLogradouro(alvara.getObraTipoLogradouro());
            alvaraToSave.setObraLogradouro(alvara.getObraLogradouro());
            alvaraToSave.setObraNumero(alvara.getObraNumero());
            alvaraToSave.setObraComplemento(alvara.getObraComplemento());
            alvaraToSave.setObraBairro(alvara.getObraBairro());
            alvaraToSave.setUnidadeMedida(UnidadeMedida.M2.getId());
            alvaraToSave.setCpfProprietarioObra(alvara.getCpfProprietarioObra());
            alvaraToSave.setCnpjProprietarioObra(alvara.getCnpjProprietarioObra());
            alvaraToSave.setNumeroProcesso(alvara.getNumeroProcesso());
            alvaraToSave.setRespTecnicoNomeEngenheiro(alvara.getNomeEngenheiroRespExec());
            alvaraToSave.setRespTecnicoCreaEngenheiro(alvara.getCreaEngenheiroRespExec());
            alvaraToSave.setRespTecnicoNumeroArt(alvara.getArtEngenheiro());
            alvaraToSave.setRespTecnicoNomeArquiteto(alvara.getNomeArquitetoRespExec());
            alvaraToSave.setRespTecnicoCauArquiteto(alvara.getCauArquitetoRespExec());
            alvaraToSave.setRespTecnicoNumeroRrt(alvara.getRrtArquiteto());
            alvaraToSave.setRespProjNomeEngenheiro(alvara.getNomeEngenheiroRespProj());
            alvaraToSave.setRespProjCreaEngenheiro(alvara.getCreaEngenheiroRespProj());
            alvaraToSave.setRespProjNumeroArt(alvara.getArtEngenheiro());
            alvaraToSave.setRespProjNomeArquiteto(alvara.getNomeArquitetoRespProj());
            alvaraToSave.setRespProjCauArquiteto(alvara.getCauArquitetoRespProj());
            alvaraToSave.setRespProjNumeroRrt(alvara.getRrtArquiteto());
            alvaraToSave.setTipoDocumento(alvara.getTipoDocumento());
            alvaraToSave.setIdSisobraAlvara(alvara.getExercicioDocumento() + String.format("%04d", alvara.getTipoDocumento()) + String.format("%06d", alvara.getDocumento()));
            alvaraToSave.setTipoRespExec(alvara.getTipoRespExec());
            alvaraToSave.setTipoRespProjeto(alvara.getTipoRespProjeto());
            alvaraToSave.setRespTecnicoNumeroTrt(alvara.getTrtTecnicoInd());
            alvaraToSave.setObservacao(alvara.getObservacao());
            alvaraToSave.setEspecificacao(alvara.getEspecificacao());
            alvaraToSave.setNroCarteiraRespProjeto(alvara.getNroCarteiraRespProjeto());
            alvaraToSave.setNroCarteiraRespTecnico(alvara.getNroCarteiraRespExec());
            this.sisObraAlvaraRepository.save((Object)alvaraToSave);
            List listAlvaraArea = Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.BUSCA_AREA_DOCUMENTO_SISOBRA, ModuloEnum.MODULO_TRIBUTARIO.getValue())) ? this.gravarDadosAreaByDocumento(alvaraToSave.getId(), this.contextService.getEntidadePrincipal(), alvara.getExercicioDocumento(), alvara.getTipoDocumento(), alvara.getDocumento()) : this.gravarDadosArea(alvaraToSave.getId(), this.contextService.getEntidadePrincipal(), alvara.getExercicioProjeto(), alvara.getProjeto());
            String xmlToSave = this.getAlvaraXml(alvaraToSave, listAlvaraArea);
            String xmlToSaveAssinado = this.sisObraServiceUtils.getXmlAssinado(xmlToSave, "infAlvara", "Alvara", certificado);
            boolean enviadoComSucesso = Boolean.FALSE;
            if (Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ENVIO_DOCUMENTO_SISOBRA_ATIVO, ModuloEnum.MODULO_TRIBUTARIO.getValue()))) {
                xmlRetorno = this.sisObraServiceUtils.enviarLoteXmlReceitaFederal(xmlToSaveAssinado, certificado);
                enviadoComSucesso = this.sisObraServiceUtils.isXMLEnviadoComErro(xmlRetorno) == false;
            }
            this.updateAlvaraWithXml(alvaraToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, Boolean.valueOf(enviadoComSucesso));
            this.gravarHistoricoAlvara(alvaraToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, enviadoComSucesso, user);
            if (enviadoComSucesso) continue;
            String documentoExercicio = alvaraToSave.getNumeroAlvara().concat("/").concat(alvara.getExercicioDocumento().toString());
            listaDocumentosComErro.add(documentoExercicio);
        }
        return listaDocumentosComErro;
    }

    public BigDecimal getAreaTotal(DocumentoCertidaoItemDTO item) {
        BigDecimal somaAreasTotais = Optional.ofNullable(item.getAreaCoberta()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAreaDescoberta()).orElse(BigDecimal.ZERO));
        BigDecimal somaAreasAprovadas = Optional.ofNullable(item.getAreaCobertaAprovada()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAreaDescobertaAprovada()).orElse(BigDecimal.ZERO));
        BigDecimal somaAreasAConcluir = Optional.ofNullable(item.getAreaCobertaAConcluir()).orElse(BigDecimal.ZERO);
        if (somaAreasTotais.compareTo(BigDecimal.ZERO) > 0) {
            return somaAreasTotais;
        }
        if (somaAreasAprovadas.compareTo(BigDecimal.ZERO) > 0) {
            return somaAreasAprovadas;
        }
        if (somaAreasAConcluir.compareTo(BigDecimal.ZERO) > 0) {
            return somaAreasAConcluir;
        }
        return somaAreasAprovadas;
    }

    public BigDecimal getAreaCoberta(DocumentoCertidaoItemDTO item) {
        BigDecimal areaParcial = Optional.ofNullable(item.getAreaCobertaParcial()).orElse(BigDecimal.ZERO);
        BigDecimal areaTotal = Optional.ofNullable(item.getAreaCoberta()).orElse(BigDecimal.ZERO);
        if (areaParcial.compareTo(BigDecimal.ZERO) > 0) {
            return areaParcial;
        }
        return areaTotal;
    }

    public BigDecimal getAreaDescoberta(DocumentoCertidaoItemDTO item) {
        BigDecimal areaParcial = Optional.ofNullable(item.getAreaDescobertaParcial()).orElse(BigDecimal.ZERO);
        BigDecimal areaTotal = Optional.ofNullable(item.getAreaDescoberta()).orElse(BigDecimal.ZERO);
        if (areaParcial.compareTo(BigDecimal.ZERO) > 0) {
            return areaParcial;
        }
        return areaTotal;
    }

    private void deleteAreasByIdAlvara(Long idAlvara) {
        this.sisObraAlvaraAreaRepository.deleteByIdAlvara(idAlvara);
    }

    public List<SisObraAlvaraArea> gravarDadosArea(Long idAlvara, Long entidade, Long exercicio, Long projeto) {
        List alvaraAreas = this.sisObraAlvaraAreaRepositoryImpl.getAreaAlvaraByProjeto(entidade, exercicio, projeto);
        ArrayList<SisObraAlvaraArea> listAlvaraArea = new ArrayList<SisObraAlvaraArea>();
        long sequencia = 0L;
        for (SisObraAlvaraAreaDTO alvaraArea : alvaraAreas) {
            SisObraAlvaraArea sisObraAlvaraArea = new SisObraAlvaraArea();
            sisObraAlvaraArea.setIdAlvara(idAlvara);
            sisObraAlvaraArea.setSequencia(Long.valueOf(sequencia += ACRESCIMO_DE_SEQUENCIA.longValue()));
            sisObraAlvaraArea.setTipo(alvaraArea.getTipoAreaSisObra());
            if (TipoArea.COMPLEMENTAR.getFlagDescricao().equals(sisObraAlvaraArea.getTipo())) {
                sisObraAlvaraArea.setTipoArea(AlvaraAreaComplementarTipo.fromValue((Long)alvaraArea.getIdTipoAreaSisObra()).getId());
                sisObraAlvaraArea.setAreaDescoberta(BigDecimal.valueOf(alvaraArea.getAreaDescoberta()));
                sisObraAlvaraArea.setAreaCoberta(BigDecimal.valueOf(alvaraArea.getAreaCoberta()));
            }
            sisObraAlvaraArea.setCategoria(alvaraArea.getCategoria());
            sisObraAlvaraArea.setDestinacao(alvaraArea.getDestinacao());
            sisObraAlvaraArea.setTipoObra(alvaraArea.getTipoObra());
            sisObraAlvaraArea.setArea(Optional.ofNullable(alvaraArea.getArea()).map(BigDecimal::valueOf).orElse(BigDecimal.ZERO));
            sisObraAlvaraArea.setQtdTotalUnidade(Optional.ofNullable(alvaraArea.getQtdeTotalUnidade()).map(BigDecimal::valueOf).orElse(BigDecimal.ZERO));
            this.sisObraAlvaraAreaRepository.save((Object)sisObraAlvaraArea);
            listAlvaraArea.add(sisObraAlvaraArea);
        }
        return listAlvaraArea;
    }

    public List<SisObraAlvaraArea> gravarDadosAreaByDocumento(Long idAlvara, Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento alvara = this.documentoService.getDocumento(entidade, exercicio, tipoDocumento, documento);
        List alvaraSegmentos = this.documentoService.getDTODocumentoCertidaoItens(alvara);
        ArrayList<SisObraAlvaraArea> listAlvaraArea = new ArrayList<SisObraAlvaraArea>();
        long sequencia = 0L;
        for (DocumentoCertidaoItemDTO alvaraArea : alvaraSegmentos) {
            TipoSegmento tipoSegmento = (TipoSegmento)this.tipoSegmentoService.findOne((Serializable)alvaraArea.getIdTipoSegmento());
            Utilizacao utilizacao = (Utilizacao)this.utilizacaoService.findOne((Serializable)alvaraArea.getIdUtilizacao());
            SisObraAlvaraArea sisObraAlvaraArea = new SisObraAlvaraArea();
            sisObraAlvaraArea.setIdAlvara(idAlvara);
            sisObraAlvaraArea.setSequencia(Long.valueOf(sequencia += ACRESCIMO_DE_SEQUENCIA.longValue()));
            sisObraAlvaraArea.setTipo(tipoSegmento.getTipoAreaSisObra());
            if (TipoArea.COMPLEMENTAR.getFlagDescricao().equals(sisObraAlvaraArea.getTipo())) {
                sisObraAlvaraArea.setTipoArea(AlvaraAreaComplementarTipo.fromValue((Long)tipoSegmento.getIdTipoAreaSisObra()).getId());
                sisObraAlvaraArea.setAreaDescoberta(this.getAreaDescoberta(alvaraArea));
                sisObraAlvaraArea.setAreaCoberta(this.getAreaCoberta(alvaraArea));
            }
            sisObraAlvaraArea.setCategoria(AlvaraAreaCategoria.OBRA_NOVA.getId());
            sisObraAlvaraArea.setDestinacao(this.sisObraServiceUtils.getDestinacao(tipoSegmento, utilizacao));
            sisObraAlvaraArea.setTipoObra(this.sisObraServiceUtils.getTipoObra(alvaraArea.getIdTipoConstrucao()));
            sisObraAlvaraArea.setArea(this.getAreaTotal(alvaraArea));
            sisObraAlvaraArea.setQtdTotalUnidade(BigDecimal.ZERO);
            this.sisObraAlvaraAreaRepository.save((Object)sisObraAlvaraArea);
            listAlvaraArea.add(sisObraAlvaraArea);
        }
        return listAlvaraArea;
    }

    private void updateAlvaraWithXml(SisObraAlvara alvara, String xml, String xmlAssinado, String xmlRetorno, Boolean enviadoComSucesso) {
        alvara.setXmlEnviado(xml.getBytes());
        alvara.setXmlEnviadoAssinado(xmlAssinado.getBytes());
        alvara.setXmlRetorno(xmlRetorno.getBytes());
        alvara.setEnviado(Boolean.TRUE);
        alvara.setEnviadoComSucesso(enviadoComSucesso);
        this.sisObraAlvaraRepository.save((Object)alvara);
    }

    private void gravarHistoricoAlvara(SisObraAlvara alvara, String xml, String xmlAssinado, String xmlRetorno, boolean enviadoComSucesso, UserSecurityDTO user) {
        StatusDocumentos status = StatusDocumentos.ENVIADO_COM_ERRO;
        if (enviadoComSucesso) {
            status = StatusDocumentos.ENVIADO_COM_SUCESSO;
        }
        SisObraAlvaraHistorico sisObraAlvaraHistorico = new SisObraAlvaraHistorico();
        sisObraAlvaraHistorico.setSisObraAlvara(alvara);
        sisObraAlvaraHistorico.setSequencia(this.sisObraAlvaraHistoricoRepository.findMaxSequenciaHistoricoByIdAlvara(alvara.getId()));
        sisObraAlvaraHistorico.setStatusEnvio(status.getDescricao());
        sisObraAlvaraHistorico.setUsuarioEnvio(user.getPreferredUsername());
        sisObraAlvaraHistorico.setDataEnvio(LocalDate.now());
        sisObraAlvaraHistorico.setXmlEnvio(xml.getBytes());
        sisObraAlvaraHistorico.setXmlEnvioAssinado(xmlAssinado.getBytes());
        sisObraAlvaraHistorico.setXmlRetorno(xmlRetorno.getBytes());
        this.sisObraAlvaraHistoricoRepository.save((Object)sisObraAlvaraHistorico);
    }

    public String getAlvaraXml(SisObraAlvara alvara, List<SisObraAlvaraArea> alvaraArea) {
        return SisObraAlvaraXmlBuilder.buildXmlAlvara((SisObraAlvara)alvara, alvaraArea);
    }

    private void buildMessageErro(SisObraAlvaraHistoricoDTO dto) {
        if (dto.getXmlRetorno().length > 0) {
            String mensagemRetorno = this.sisObraServiceUtils.getMensagemDeErro(dto.getXmlRetorno());
            dto.setMensagemRetorno(mensagemRetorno);
        }
    }

    @Generated
    public SisObraAlvaraService(SisObraAlvaraRepository sisObraAlvaraRepository, SisObraAlvaraAreaRepository sisObraAlvaraAreaRepository, SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl, ContextService contextService, SisObraAlvaraHistoricoRepository sisObraAlvaraHistoricoRepository, SisObraServiceUtils sisObraServiceUtils, DocumentoService documentoService, TipoSegmentoService tipoSegmentoService, UtilizacaoService utilizacaoService, ParametroGeralService parametroGeralService) {
        this.sisObraAlvaraRepository = sisObraAlvaraRepository;
        this.sisObraAlvaraAreaRepository = sisObraAlvaraAreaRepository;
        this.sisObraAlvaraAreaRepositoryImpl = sisObraAlvaraAreaRepositoryImpl;
        this.contextService = contextService;
        this.sisObraAlvaraHistoricoRepository = sisObraAlvaraHistoricoRepository;
        this.sisObraServiceUtils = sisObraServiceUtils;
        this.documentoService = documentoService;
        this.tipoSegmentoService = tipoSegmentoService;
        this.utilizacaoService = utilizacaoService;
        this.parametroGeralService = parametroGeralService;
    }
}

