/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.sisobra.SisObraAlteraSituacaoHistorico;
import br.com.elotech.tributos.domain.sisobra.SisObraAlteracaoSituacao;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sisobra.DocumentosSisobraParaEnviarDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlteraSituacaoDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlteraSituacaoHistoricoDTO;
import br.com.elotech.tributos.enums.sisobra.SituacaoDocumento;
import br.com.elotech.tributos.enums.sisobra.StatusDocumentos;
import br.com.elotech.tributos.repository.sisobra.SisObraAlteraSituacaoHistoricoRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraAlteracaoSituacaoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.sisobra.SisObraServiceUtils;
import br.com.elotech.tributos.util.sisobra.SisObraAlteraSituacaoXmlBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SisObraAlteraSituacaoService
extends CrudService<SisObraAlteracaoSituacao, Long> {
    private final SisObraAlteracaoSituacaoRepository sisObraAlteracaoSituacaoRepository;
    private final ContextService contextService;
    private final SisObraAlteraSituacaoHistoricoRepository sisObraAlteraSituacaoHistoricoRepository;
    private final SisObraServiceUtils sisObraServiceUtils;
    private final ParametroGeralService parametroGeralService;

    public Page<SisObraAlteraSituacaoDTO> findDocumentoSisObraAlteraSituacao(DocumentosSisobraParaEnviarDTO dto, Pageable pageable) {
        return this.sisObraAlteracaoSituacaoRepository.findDocumentoSisObraCancelamento(dto, pageable);
    }

    public List<SisObraAlteraSituacaoDTO> findAllSisObraAlteraSituacao(DocumentosSisobraParaEnviarDTO dto) {
        return this.sisObraAlteracaoSituacaoRepository.findDocumentoSisObraCancelamento(dto, Pageable.unpaged()).getContent();
    }

    public List<String> gravarDados(DocumentosSisobraParaEnviarDTO sisobraParaEnviarDTO, UserSecurityDTO user) {
        Certificado certificado = this.sisObraServiceUtils.getCertificadoByEntidade(this.contextService.getEntidadePrincipal());
        ArrayList<String> listaDocumentosComErro = new ArrayList<String>();
        List documentos = Boolean.TRUE.equals(sisobraParaEnviarDTO.getTodosSelecionados()) ? this.findAllSisObraAlteraSituacao(sisobraParaEnviarDTO) : sisobraParaEnviarDTO.getAlteracoesSituacao();
        List documentosNaoEnviados = documentos.stream().filter(documento -> Boolean.FALSE.equals(documento.getEnviadoComSucesso())).collect(Collectors.toList());
        for (SisObraAlteraSituacaoDTO documento2 : documentosNaoEnviados) {
            String xmlRetorno = "";
            SisObraAlteracaoSituacao documentoToSave = new SisObraAlteracaoSituacao();
            if (documento2.getIdAlteraSituacao() > 0L) {
                documentoToSave = (SisObraAlteracaoSituacao)this.sisObraAlteracaoSituacaoRepository.findOne((Object)documento2.getIdAlteraSituacao());
            }
            documentoToSave.setTipoDocumentoOriginal(documento2.getTipoDocumento());
            documentoToSave.setTipoDocumento(documento2.getTipoDocumentoAlteracao());
            documentoToSave.setNumeroDocumento(String.valueOf(documento2.getDocumento()));
            documentoToSave.setDataDocumento(documento2.getDataDocumento());
            documentoToSave.setDataCancelamento(documento2.getDataCancelamento());
            documentoToSave.setNumeroProtocoloEnvio(this.getNumeroProtocolo(documento2));
            documentoToSave.setSituacaoAlteracao(SituacaoDocumento.CANCELADO.getId());
            documentoToSave.setAno(documento2.getAnoDocumento());
            documentoToSave.setMes(documento2.getMesDocumento());
            documentoToSave.setNumeroDocumentoSisObra(documento2.getExercicio() + String.format("%04d", documento2.getTipoDocumento()) + String.format("%06d", documento2.getDocumento()));
            this.sisObraAlteracaoSituacaoRepository.save((Object)documentoToSave);
            String xmlToSave = this.getAlteracaoSituacaoXml(documentoToSave);
            String xmlToSaveAssinado = this.sisObraServiceUtils.getXmlAssinado(xmlToSave, "infDocumento", "AlteraSituacao", certificado);
            boolean enviadoComSucesso = Boolean.FALSE;
            if (Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ENVIO_DOCUMENTO_SISOBRA_ATIVO, ModuloEnum.MODULO_TRIBUTARIO.getValue()))) {
                xmlRetorno = this.sisObraServiceUtils.enviarLoteXmlReceitaFederal(xmlToSaveAssinado, certificado);
                enviadoComSucesso = this.sisObraServiceUtils.isXMLEnviadoComErro(xmlRetorno) == false;
            }
            this.updateAlteracaoSituacaoWithXml(documentoToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, Boolean.valueOf(enviadoComSucesso));
            this.gravarHistoricoAlteraSituacao(documentoToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, enviadoComSucesso, user);
            if (enviadoComSucesso) continue;
            String documentoExercicio = documentoToSave.getNumeroDocumento().concat("/").concat(documentoToSave.getAno().toString());
            listaDocumentosComErro.add(documentoExercicio);
        }
        return listaDocumentosComErro;
    }

    public void gravarHistoricoAlteraSituacao(SisObraAlteracaoSituacao alteraSituacao, String xml, String xmlAssinado, String xmlRetorno, boolean enviadoComSucesso, UserSecurityDTO user) {
        StatusDocumentos status = StatusDocumentos.ENVIADO_COM_ERRO;
        if (enviadoComSucesso) {
            status = StatusDocumentos.ENVIADO_COM_SUCESSO;
        }
        SisObraAlteraSituacaoHistorico sisObraAlteraSituacaoHistorico = new SisObraAlteraSituacaoHistorico();
        sisObraAlteraSituacaoHistorico.setSisObraAlteracaoSituacao(alteraSituacao);
        sisObraAlteraSituacaoHistorico.setSequencia(this.sisObraAlteraSituacaoHistoricoRepository.findMaxSequenciaHistoricoByIdAlteraSituacao(alteraSituacao.getId()));
        sisObraAlteraSituacaoHistorico.setStatusEnvio(status.getDescricao());
        sisObraAlteraSituacaoHistorico.setUsuarioEnvio(user.getPreferredUsername());
        sisObraAlteraSituacaoHistorico.setDataEnvio(LocalDate.now());
        sisObraAlteraSituacaoHistorico.setXmlEnvio(xml.getBytes());
        sisObraAlteraSituacaoHistorico.setXmlEnvioAssinado(xmlAssinado.getBytes());
        sisObraAlteraSituacaoHistorico.setXmlRetorno(xmlRetorno.getBytes());
        this.sisObraAlteraSituacaoHistoricoRepository.save((Object)sisObraAlteraSituacaoHistorico);
    }

    public Page<SisObraAlteraSituacaoHistoricoDTO> findHistoricoAlteraSituacao(Long id, Pageable pageable) {
        List sisObraAlteraSituacaoHistorico = this.sisObraAlteraSituacaoHistoricoRepository.findByIdAlteraSituacao(id, pageable);
        List sisObraAlteraSituacaoHistoricoDTO = sisObraAlteraSituacaoHistorico.stream().map(SisObraAlteraSituacaoHistoricoDTO::from).collect(Collectors.toList());
        sisObraAlteraSituacaoHistoricoDTO.stream().filter(dto -> "E".equals(dto.getStatusEnvio())).forEach(arg_0 -> this.buildMessageErro(arg_0));
        return new PageImpl(sisObraAlteraSituacaoHistoricoDTO, pageable, (long)pageable.getPageSize());
    }

    private void buildMessageErro(SisObraAlteraSituacaoHistoricoDTO dto) {
        if (dto.getXmlRetorno().length > 0) {
            String mensagemRetorno = this.sisObraServiceUtils.getMensagemDeErro(dto.getXmlRetorno());
            dto.setMensagemRetorno(mensagemRetorno);
        }
    }

    public String getNumeroProtocolo(SisObraAlteraSituacaoDTO documento) {
        if (documento.getNumeroProtocoloAlvara() != null && !documento.getNumeroProtocoloAlvara().isEmpty()) {
            return documento.getNumeroProtocoloAlvara();
        }
        if (documento.getNumeroProtocoloHabitese() != null && !documento.getNumeroProtocoloHabitese().isEmpty()) {
            return documento.getNumeroProtocoloHabitese();
        }
        return "";
    }

    private void updateAlteracaoSituacaoWithXml(SisObraAlteracaoSituacao documento, String xml, String xmlAssinado, String xmlRetorno, Boolean enviadoComSucesso) {
        documento.setXmlEnviado(xml.getBytes());
        documento.setXmlEnviadoAssinado(xmlAssinado.getBytes());
        documento.setXmlRetorno(xmlRetorno.getBytes());
        documento.setEnviado(Boolean.TRUE);
        documento.setEnviadoComSucesso(enviadoComSucesso);
        this.sisObraAlteracaoSituacaoRepository.save((Object)documento);
    }

    public String getAlteracaoSituacaoXml(SisObraAlteracaoSituacao documento) {
        return SisObraAlteraSituacaoXmlBuilder.buildXmlAlteraSituacao((SisObraAlteracaoSituacao)documento);
    }

    @Generated
    public SisObraAlteraSituacaoService(SisObraAlteracaoSituacaoRepository sisObraAlteracaoSituacaoRepository, ContextService contextService, SisObraAlteraSituacaoHistoricoRepository sisObraAlteraSituacaoHistoricoRepository, SisObraServiceUtils sisObraServiceUtils, ParametroGeralService parametroGeralService) {
        this.sisObraAlteracaoSituacaoRepository = sisObraAlteracaoSituacaoRepository;
        this.contextService = contextService;
        this.sisObraAlteraSituacaoHistoricoRepository = sisObraAlteraSituacaoHistoricoRepository;
        this.sisObraServiceUtils = sisObraServiceUtils;
        this.parametroGeralService = parametroGeralService;
    }
}

