/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.InscricaoDividaAtivaValidacao;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class InscricaoDividaAtivaValidacaoSimAmService {
    public List<ErrosImportacaoSIMAM> validateInscricaoDividaAtiva(InscricaoDividaAtivaValidacao inscricao, StepExecution stepExecution) {
        LocalDate dataProcessamento = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        ArrayList<ErrosImportacaoSIMAM> erros = new ArrayList<ErrosImportacaoSIMAM>();
        inscricao.loadInformacoesAdicionais();
        this.validaRegistroDuplicado(inscricao, erros);
        this.validaSequenciaNrDivida(inscricao, erros);
        this.validaTipoOperacaoCredito(inscricao, erros);
        this.validaInscricaoEmDividaAtiva(inscricao, erros);
        this.validaInscricaoPorImplantacaoDeSaldoOuARestituirDeAnosAnteriores(inscricao, erros);
        this.validaSeAInscricaoTemTipoCreditoConsolidado(inscricao, erros);
        this.validaSeEEscopoMunicipal(inscricao, erros);
        this.validaSeAInscricaoFoiDepoisDoLancamentoDeCredito(inscricao, erros);
        this.validaSeADataDeInscricaoEstaNoMesProcessado(inscricao, erros, dataProcessamento);
        this.validaSeOValorENegativo(inscricao, erros);
        this.validaSeTemCreditoRepetidoNaImplantacaoDeSaldoOuARestituirDeAnosAnteriores(inscricao, erros);
        this.validaSeTemCreditoRepetidoNasInscricoes(inscricao, erros);
        this.validaSeEImplantacaoDeSaldo(inscricao, erros);
        this.validaSeEInscricaoEmDividaAtiva(inscricao, erros);
        this.validaSeAnoDividaEhValido(inscricao, erros);
        this.validaSeAnoCreditoEhValido(inscricao, erros);
        return erros;
    }

    private void validaRegistroDuplicado(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (inscricao.isDuplicado()) {
            String message = "O conjunto (nrDivida e nrAnoDivida) declarado na tabela (InscricaoDividaAtiva) apresenta-se com registro duplicado.";
            Long codigoDoErro = 1353L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSequenciaNrDivida(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isSequenciaValida()) {
            String message = "O N\u00famero e Ano da D\u00edvida Ativa (nrDivida e nrAnoDivida) declarados na tabela (InscricaoDividaAtiva) apresenta quebra da sequencia num\u00e9rica no ano de trabalho.";
            Long codigoDoErro = 1354L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaTipoOperacaoCredito(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isTipoOperacaoCreditoValida()) {
            String message = "O Tipo de Opera\u00e7\u00e3o (idTipoOperacaoCredito) declarado na tabela (InscricaoDividaAtiva) deve existir na tabela (TipoOperacaoCredito) e n\u00e3o pode ser diferente de 2 ou 3.";
            Long codigoDoErro = 1355L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaInscricaoEmDividaAtiva(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        boolean isInscricaoEmDividaAtiva = inscricao.getCurrentTipoOperacaoCredito().equals((Object)TipoOperacaoCredito.INSCRICAO_DIVIDA_ATIVA);
        if (!inscricao.isInscricaoEmDividaAtivaSemNrCreditoESemNrAnoCredito() && isInscricaoEmDividaAtiva) {
            String message = "O Tipo de Opera\u00e7\u00e3o (idTipoOperacaoCredito) declarado na tabela (InscricaoDividaAtiva) \u00e9 = 3 - Inscri\u00e7\u00e3o em D\u00edvida Ativa, portanto, os campos (nrCredito e nrAnoCredito) passam a ser obrigat\u00f3rios.";
            Long codigoDoErro = 1356L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaInscricaoPorImplantacaoDeSaldoOuARestituirDeAnosAnteriores(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        List<TipoOperacaoCredito> tipoOperacoesAValidar = Arrays.asList(TipoOperacaoCredito.IMPLANTACAO_SALDOS_ANTERIORES, TipoOperacaoCredito.DIVIDAS_A_RESTITUIR);
        if (!inscricao.isInscricaoPorImplantacaoDeSaldoOuARestituiDeAnosAnterioresValida() && tipoOperacoesAValidar.contains(inscricao.getCurrentTipoOperacaoCredito())) {
            String message = "O Tipo de Opera\u00e7\u00e3o (idTipoOperacaoCredito) declarado na tabela (InscricaoDividaAtiva) \u00e9 = 2 - Implanta\u00e7\u00e3o de Saldos de Exerc\u00edcios Anteriores ou 5- D\u00edvida Ativa a Restituir de Exerc\u00edcios Anteriores, portanto, os campos (idTipoNaturezaCredito, idTipoCredito e nrAnoBase) passam a ser obrigat\u00f3rios.";
            Long codigoDoErro = 1357L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeAInscricaoTemTipoCreditoConsolidado(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isTipoCreditoConsolidado() && inscricao.getIdTipoNaturezaCredito() != null) {
            String message = "A combina\u00e7\u00e3o dos campos (idTipoNaturezaCredito e idTipoCredito) declarada na tabela (InscricaoDividaAtiva) n\u00e3o existe nas posibilidades v\u00e1lidas da tabela (ConsolidacaoTipoCredito).";
            Long codigoDoErro = 1358L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeEEscopoMunicipal(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isEscopoMunicipal()) {
            String message = "O Controle de Lei/Ato (cdControleLeiAto) declarado na  tabela (InscricaoDividaAtiva) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.";
            Long codigoDoErro = 1360L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeAInscricaoFoiDepoisDoLancamentoDeCredito(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isInscricaoDepoisDoLancamentoDeCredito()) {
            String message = "A data da inscri\u00e7\u00e3o em d\u00edvida ativa (dtInscricao) declarada na tabela (InscricaoDividaAtiva) n\u00e3o pode ser menor que a data do lan\u00e7amento (dtLancamento) informada na tabela (LancamentoCredito).";
            Long codigoDoErro = 1361L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeADataDeInscricaoEstaNoMesProcessado(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros, LocalDate dataProcessamento) {
        if (inscricao.isDataDeInscricaoDepoisDoMesProcessado(dataProcessamento)) {
            String message = "A data da Inscri\u00e7\u00e3o em D\u00edvida Ativa (dtInscricao) declarada na  tabela (InscricaoDividaAtiva) n\u00e3o pode ser maior que o m\u00eas/ano de trabalho.";
            Long codigoDoErro = 1362L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeOValorENegativo(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isValorPositivo()) {
            String message = "O valor inscrito em d\u00edvida ativa (vlInscricao) declarado na tabela (InscricaoDividaAtiva) n\u00e3o pode ser negativo.";
            Long codigoDoErro = 1363L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeTemCreditoRepetidoNaImplantacaoDeSaldoOuARestituirDeAnosAnteriores(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (inscricao.isCreditoRepetidoEmImplantacaoDeSaldoOuARestuirDeAnosAnteriores()) {
            String message = "O registro declarado na tabela (InscricaoDividaAtiva) para o conjunto  nrAnoDivida, idTipoOperacaoCredito, nrCredito, nrAnoCredito, idTipoNaturezaCredito, idTipoCredito, nrAnoBase, cdControleLeiAto, dtInscricao, nrAnoInscricao e m\u00eas da remessa) n\u00e3o pode ser duplicado.";
            Long codigoDoErro = 2117L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeTemCreditoRepetidoNasInscricoes(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (inscricao.isCreditoRepetido()) {
            String message = "O registro declarado na tabela (InscricaoDividaAtiva) para o conjunto  nrAnoDivida, idTipoOperacaoCredito, nrCredito, nrAnoCredito, idTipoNaturezaCredito, idTipoCredito, nrAnoBase, cdControleLeiAto, dtInscricao, nrAnoInscricao e m\u00eas da remessa) n\u00e3o pode ser duplicado.";
            Long codigoDoErro = 2256L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeEImplantacaoDeSaldo(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        List<TipoOperacaoCredito> tipoOperacoesAValidar = Arrays.asList(TipoOperacaoCredito.IMPLANTACAO_SALDOS_ANTERIORES, TipoOperacaoCredito.DIVIDAS_A_RESTITUIR);
        if (!inscricao.isImplantacaoDeSaldoValida() && tipoOperacoesAValidar.contains(inscricao.getCurrentTipoOperacaoCredito()) && inscricao.getIdTipoNaturezaCredito() != null) {
            String message = "O Munic\u00edpio informou o c\u00f3digo (idTipoOperacaoCredito = 2 - Implanta\u00e7\u00e3o de Saldos de Exerc\u00edcios Anteriores) na tabela (InscricaoDividaAtiva), portanto, os campos (nrCredito e nrAnoCredito) devem ser vazios.";
            Long codigoDoErro = 2122L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeEInscricaoEmDividaAtiva(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (inscricao.isInscricaoEmDividaAtivaSemTipoNaturezaCreditoSemTipoCreditoSemNrAnoBase()) {
            String message = "O Munic\u00edpio informou o c\u00f3digo (idTipoOperacaoCredito = 3 - Inscri\u00e7\u00e3o em D\u00edvida Ativa) na tabela (InscricaoDividaAtiva), portanto, os campos (idTipoNaturezaCredito, idTipoCredito e nrAnoBase) devem ser vazios.";
            Long codigoDoErro = 2123L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeAnoDividaEhValido(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isNrAnoDividaValido() && inscricao.getNrAnoDivida() != null) {
            String message = "O registro declarado na tabela (InscricaoDividaAtiva) n\u00e3o pode conter o valor do campo (nrAnoDivida) menor que o exerc\u00edcio financeiro de 2023";
            Long codigoDoErro = 2236L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeAnoCreditoEhValido(InscricaoDividaAtivaValidacao inscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!inscricao.isNrAnoCreditoValido() && inscricao.getNrAnoCredito() != null) {
            String message = "O registro declarado na tabela (InscricaoDividaAtiva) n\u00e3o pode estar vinculado com ano de cr\u00e9dito (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023";
            Long codigoDoErro = 2247L;
            erros.add(ErrosImportacaoSIMAM.inscricaoDividaAtiva((InscricaoDividaAtivaValidacao)inscricao, (String)message, (Long)codigoDoErro));
        }
    }
}

