/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.DeducaoCreditoValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class DeducaoCreditoValidacaoAMService {
    private static final Long TRIBUTOS_MUNICIPAIS = 22L;

    public List<ErrosImportacaoSIMAM> validate(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        LocalDate dataRemessa = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        erros.add(this.validateRegistroDuplicadoNrDeducao(deducaoCreditoValidacaoDTO));
        erros.add(this.validateSequenciaNrDeducao(deducaoCreditoValidacaoDTO));
        erros.add(this.validateNrCreditoExistente(deducaoCreditoValidacaoDTO));
        erros.add(this.validateTipoDeducaoCredito(deducaoCreditoValidacaoDTO));
        erros.add(this.validateCdControleLeiAto(deducaoCreditoValidacaoDTO));
        erros.add(this.validateDtLancamentoCredito(deducaoCreditoValidacaoDTO, dataRemessa));
        erros.add(this.validateVlDeducao(deducaoCreditoValidacaoDTO));
        erros.add(this.validateTamanhoDsMotivo(deducaoCreditoValidacaoDTO));
        erros.add(this.validateRegistroDuplicadoNrCredito(deducaoCreditoValidacaoDTO));
        erros.add(this.validateNrCreditoExercicioFinanceiro(deducaoCreditoValidacaoDTO));
        return erros.stream().flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicadoNrDeducao(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (deducaoCreditoValidacaoDTO.getNrRegistroDeducao() > 1L) {
            String mensagemErro = "O conjunto (nrDeducao e nrAnoDeducao) da tabela (DeducaoCredito) apresenta-se com registro duplicado.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1339L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequenciaNrDeducao(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (deducaoCreditoValidacaoDTO.getNrDeducaoAnterior() != 0L && deducaoCreditoValidacaoDTO.getNrDeducao() - deducaoCreditoValidacaoDTO.getNrDeducaoAnterior() != 1L) {
            String mensagemErro = "A combina\u00e7\u00e3o (nrDeducao e nrAnoDeducao) da tabela (DeducaoCredito) apresenta-se com quebra da ordem sequencial no ano de trabalho.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1340L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrCreditoExistente(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoValidacaoDTO.getNrCreditoLancCredito()) || Objects.isNull(deducaoCreditoValidacaoDTO.getNrAnoCreditoLancCredito())) {
            String mensagemErro = "O N\u00famero e Ano do Cr\u00e9dito (nrCredito e nrAnoCredito) da tabela (DeducaoCredito) n\u00e3o existe na tabela (LancamentoCredito).";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1341L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateTipoDeducaoCredito(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoValidacaoDTO.getTipoDeducaoTribTipoDeducao())) {
            String mensagemErro = "O Tipo de Dedu\u00e7\u00e3o do Cr\u00e9dito (idTipoDeducaoCredito) da tabela (DeducaoCredito) n\u00e3o existe na tabela (TipoDeducaoCredito).";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1342L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoValidacaoDTO.getCdControleLeiAtoCgAto()) || !TRIBUTOS_MUNICIPAIS.equals(deducaoCreditoValidacaoDTO.getEscopoLei())) {
            String mensagemErro = "O Controle de Lei/Ato (cdControleLeiAto) da tabela (DeducaoCredito) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1343L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDtLancamentoCredito(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO, LocalDate dataRemessa) {
        if (Objects.nonNull(deducaoCreditoValidacaoDTO.getDtLancamentoCredito()) && deducaoCreditoValidacaoDTO.getDtDeducao().isBefore(deducaoCreditoValidacaoDTO.getDtLancamentoCredito()) || deducaoCreditoValidacaoDTO.getDtDeducao().isAfter(dataRemessa)) {
            String mensagemErro = "A data da dedu\u00e7\u00e3o (dtDeducao) da tabela (DeducaoCredito) n\u00e3o pode ser menor que (dtLancamento) informada na tabela (LancamentoCredito) ou maior que o m\u00eas/ano de trabalho.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1344L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlDeducao(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (deducaoCreditoValidacaoDTO.getVlDeducao().compareTo(BigDecimal.ZERO) < 0) {
            String mensagemErro = "O valor da dedu\u00e7\u00e3o do cr\u00e9dito (vlDeducao) da tabela (DeducaoCredito) n\u00e3o pode ser negativo.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1345L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateTamanhoDsMotivo(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoValidacaoDTO.getDsMotivo()) || deducaoCreditoValidacaoDTO.getDsMotivo().length() < 20) {
            String mensagemErro = "A descri\u00e7\u00e3o do motivo da dedu\u00e7\u00e3o do cr\u00e9dito (dsMotivo) da tabela (DeducaoCredito) deve conter no m\u00ednimo 20 (vinte) caracteres.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(1346L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicadoNrCredito(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (deducaoCreditoValidacaoDTO.getNrRegistroCredito() > 1L) {
            String mensagemErro = "O registro da tabela (DeducaoCredito) para o conjunto (nrAnoDeducao, nrCredito, nrAnoCredito, idTipoDeducaoCredito, cdControleLeiAto, dtDeducao) n\u00e3o pode ser duplicado.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(2116L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrCreditoExercicioFinanceiro(DeducaoCreditoValidacaoDTO deducaoCreditoValidacaoDTO) {
        if (deducaoCreditoValidacaoDTO.getNrAnoCredito() < 2023L) {
            String mensagemErro = "O registro da tabela (DeducaoCredito) n\u00e3o pode estar vinculado com ano de cr\u00e9dito (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(deducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.DEDUCAO_CREDITO).codigoErro(Long.valueOf(2245L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }
}

