/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.AtualizacaoMonetariaDAEstValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaDAEstValidacaoAMService {
    private static final Long CODIGO_ESCOPO_LEI = 22L;

    public List<ErrosImportacaoSIMAM> validateAtualizacaoMonetariaDAEst(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroDuplicado(atualizacaoMonetariaDAEstValidacaoDTO));
        erros.add(this.validateSequenciaNrEstorno(atualizacaoMonetariaDAEstValidacaoDTO));
        erros.add(this.validateAtualizacaoExistente(atualizacaoMonetariaDAEstValidacaoDTO));
        erros.add(this.validateCdControleLeiAto(atualizacaoMonetariaDAEstValidacaoDTO));
        erros.add(this.validateDataEstorno(atualizacaoMonetariaDAEstValidacaoDTO, stepExecution));
        erros.add(this.validateVlEstorno(atualizacaoMonetariaDAEstValidacaoDTO));
        erros.add(this.validateTamanhoDsMotivo(atualizacaoMonetariaDAEstValidacaoDTO));
        erros.add(this.validateRegistroDuplicadoNrRegistro(atualizacaoMonetariaDAEstValidacaoDTO));
        erros.add(this.validateNrAnoEstorno(atualizacaoMonetariaDAEstValidacaoDTO));
        return erros.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicado(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (atualizacaoMonetariaDAEstValidacaoDTO.getNrRegistrosEstorno() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"O conjunto(nrEstorno e nrAnoEstorno) declarado da tabela (EstornoAtualizacaoDividaAtiva) apresenta-se com registro duplicado.", (Long)1382L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequenciaNrEstorno(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (atualizacaoMonetariaDAEstValidacaoDTO.isNrEstornoOuNrEstornoAnteriorNull().booleanValue() || atualizacaoMonetariaDAEstValidacaoDTO.isNrEstornoQuebrandoSequencia().booleanValue()) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"O N\u00famero e Ano do Cr\u00e9dito (nrEstorno e nrAnoEstorno) da tabela (EstornoAtualizacaoDividaAtiva) apresenta-se quebra da ordem num\u00e9rica no ano de trabalho com ou cronol\u00f3gica associada a num\u00e9rica", (Long)1383L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateAtualizacaoExistente(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (atualizacaoMonetariaDAEstValidacaoDTO.getNrRegistrosDA() < 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"O conjunto(nrAtualizacao e nrAnoAtualizacao) declarado da tabela (EstornoAtualizacaoDividaAtiva)  n\u00e3o existe na tabela (AtualizacaoDividaAtiva).", (Long)1384L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAEstValidacaoDTO.getCdControleLeiAto()) || !CODIGO_ESCOPO_LEI.equals(atualizacaoMonetariaDAEstValidacaoDTO.getEscopoLei())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"O C\u00f3digo de Controle da Lei ou Ato (cdControleLeiAto) da tabela (EstornoAtualizacaoDividaAtiva) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1385L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDataEstorno(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO, StepExecution stepExecution) {
        if (Objects.isNull(atualizacaoMonetariaDAEstValidacaoDTO.getDtAtualizacao())) {
            return Optional.empty();
        }
        LocalDate mesValidacao = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Month mesEstorno = atualizacaoMonetariaDAEstValidacaoDTO.getDtEstorno().getMonth();
        Year anoEstorno = Year.of(atualizacaoMonetariaDAEstValidacaoDTO.getDtEstorno().getYear());
        if (atualizacaoMonetariaDAEstValidacaoDTO.getDtEstorno().isBefore(atualizacaoMonetariaDAEstValidacaoDTO.getDtAtualizacao()) || !mesEstorno.equals(mesValidacao.getMonth()) || !anoEstorno.equals(Year.of(mesValidacao.getYear()))) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"A data do estorno (dtEstorno) n\u00e3o pode ser menor que (dtAtualizacao) informada na tabela (AtualizacaoDividaAtiva) OU diferente que o m\u00eas/ano de trabalho.", (Long)1386L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlEstorno(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAEstValidacaoDTO.getVlEstorno()) || atualizacaoMonetariaDAEstValidacaoDTO.getVlEstorno().compareTo(BigDecimal.ZERO) < 0) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"O valor do estorno (vlEstorno) da tabela (EstornoAtualizacaoDividaAtiva) n\u00e3o pode ser menor que 0.", (Long)1387L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateTamanhoDsMotivo(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAEstValidacaoDTO.getDsMotivo()) || atualizacaoMonetariaDAEstValidacaoDTO.getDsMotivo().length() < 20) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"A descri\u00e7\u00e3o do motivo do estorno (dsMotivo) da tabela (EstornoAtualizacaoDividaAtiva) deve conter no m\u00ednimo 20 (vinte) caracteres.", (Long)1388L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicadoNrRegistro(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (atualizacaoMonetariaDAEstValidacaoDTO.getNrRegistrosEstornoAgrupado() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"O conjunto(nrAnoEstorno, nrAtualizacao, nrAnoAtualizacao, cdControleLeiAto e dtEstorno) declarado da tabela (EstornoAtualizacaoDividaAtiva) apresenta-se com registro duplicado.", (Long)2238L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrAnoEstorno(AtualizacaoMonetariaDAEstValidacaoDTO atualizacaoMonetariaDAEstValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAEstValidacaoDTO.getNrAnoEstorno())) {
            return Optional.empty();
        }
        if (atualizacaoMonetariaDAEstValidacaoDTO.getNrAnoEstorno() < 2023L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAEstValidacaoDTO.getIdTceAtualizaMoneCredDAEst(), (String)"O registro da tabela (EstornoAtualizacaoDividaAtiva) n\u00e3o pode estar vinculado com ano de d\u00edvida (nrAnoDivida) menor que o exerc\u00edcio financeiro de 2023.", (Long)2250L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }
}

