/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaCreditoDARepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EstornoAtualizacaoMonetariaCreditoDAMaService
implements ManutencaoArquivoSimAmService<EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO> {
    private final EntityManager entityManager;
    private final EstornoAtualizacaoMonetariaCreditoDARepository estornoAtualizacaoCreditoDARepository;
    private final ContextService contextService;
    private final AtoRepository atoRepository;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA;
    }

    public Page<EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtEstorno"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification especification = StringUtils.isBlank((CharSequence)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.estornoAtualizacaoCreditoDARepository.findAll(especification, pageable).map(EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO::from);
    }

    public List<EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO> updateAll(List<EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO::hasError).collect(Collectors.toList());
        }
        this.estornoAtualizacaoCreditoDARepository.saveAll((Iterable)arquivos.stream().map(EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO::toEstAtualizacaoMonetariaCreditoDA).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO> estArrecadacaoTipoCreditoDA) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return estArrecadacaoTipoCreditoDA.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaCdControleLeiAto(EstornoAtualizacaoMonetariaCreditoDividaAtivaMaDTO estArrecadacaoTipoCreditoDA, Long entidade) {
        Optional<Long> idAto = this.atoRepository.findByIdAto(entidade, estArrecadacaoTipoCreditoDA.getCdControleLeiAto()).map(Ato::getIdAto);
        if (idAto.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela AtualizacaoMonetariaCreditoDA n\u00e3o est\u00e1 presente na tabela CgAto.", estArrecadacaoTipoCreditoDA.getCdControleLeiAto(), estArrecadacaoTipoCreditoDA.getId()));
        }
    }

    @Generated
    public EstornoAtualizacaoMonetariaCreditoDAMaService(EntityManager entityManager, EstornoAtualizacaoMonetariaCreditoDARepository estornoAtualizacaoCreditoDARepository, ContextService contextService, AtoRepository atoRepository) {
        this.entityManager = entityManager;
        this.estornoAtualizacaoCreditoDARepository = estornoAtualizacaoCreditoDARepository;
        this.contextService = contextService;
        this.atoRepository = atoRepository;
    }
}

