/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoArrecadacaoTipoCreditoMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoRepository;
import br.com.elotech.tributos.repository.simam.EstornoArrecadacaoCreditoRepository;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EstornoArrecadacaoTipoCreditoMaService
implements ManutencaoArquivoSimAmService<EstornoArrecadacaoTipoCreditoMaDTO> {
    private final EstornoArrecadacaoCreditoRepository estornoArrecadacaoCreditoRepository;
    private final ArrecadacaoCreditoRepository arrecadacaoCreditoRepository;
    private final EntityManager entityManager;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ESTORNO_ARRECADACAO_TIPO_CREDITO;
    }

    public Page<EstornoArrecadacaoTipoCreditoMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get("nrMes"), cb.literal((Object)dataInicial.getMonthValue())), (Expression)cb.equal((Expression)root.get("nrAno"), cb.literal((Object)dataInicial.getYear())));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.estornoArrecadacaoCreditoRepository.findAll(specification, pageable).map(EstornoArrecadacaoTipoCreditoMaDTO::from);
    }

    public List<EstornoArrecadacaoTipoCreditoMaDTO> updateAll(List<EstornoArrecadacaoTipoCreditoMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(EstornoArrecadacaoTipoCreditoMaDTO::hasError).collect(Collectors.toList());
        }
        this.estornoArrecadacaoCreditoRepository.saveAll((Iterable)arquivos.stream().map(EstornoArrecadacaoTipoCreditoMaDTO::toEstornoArrecadacaoCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<EstornoArrecadacaoTipoCreditoMaDTO> arrecadacaoTipoCredito) {
        return arrecadacaoTipoCredito.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaNrArrecadacao(current);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaNrArrecadacao(EstornoArrecadacaoTipoCreditoMaDTO arrecadacaoTipoCredito) {
        if (!this.arrecadacaoCreditoRepository.existsByNrArrecadacaoAndNrAnoArrecadacao(arrecadacaoTipoCredito.getNrArrecadacao(), arrecadacaoTipoCredito.getNrAnoArrecadacao()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de arrecada\u00e7\u00e3o de cr\u00e9dito com a chave nrArrecadacao/nrAnoArrecadacao com os valores %s/%s.", arrecadacaoTipoCredito.getNrArrecadacao(), arrecadacaoTipoCredito.getNrAnoArrecadacao()));
        }
    }

    @Generated
    public EstornoArrecadacaoTipoCreditoMaService(EstornoArrecadacaoCreditoRepository estornoArrecadacaoCreditoRepository, ArrecadacaoCreditoRepository arrecadacaoCreditoRepository, EntityManager entityManager) {
        this.estornoArrecadacaoCreditoRepository = estornoArrecadacaoCreditoRepository;
        this.arrecadacaoCreditoRepository = arrecadacaoCreditoRepository;
        this.entityManager = entityManager;
    }
}

