/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.ArrecadacaoTipoCreditoMaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.AtualizacaoMonetariaCreditoMaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.BaseArquivoSimAmDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.DeducaoCreditoMaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.InscricaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.NrDisponivel;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.simam.NrCreditoCustomRepository;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.AtribuirNrCreditoService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmFactory;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.nrcredito.AtribuiNrCreditoArrecadacaoTipoCredito;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.nrcredito.AtribuiNrCreditoAtualizacaoMonetaria;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.nrcredito.AtribuiNrCreditoDeducaoCredito;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.nrcredito.AtribuiNrCreditoInscricaoDA;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AtribuirNrCreditoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtribuirNrCreditoService.class);
    private final NrCreditoCustomRepository nrCreditoCustomRepository;
    private final ManutencaoArquivoSimAmFactory manutencaoArquivoSimAmFactory;

    @Transactional
    public void atribuirNrCredito(BaseArquivoSimAmDTO dto) {
        this.manutencaoArquivoSimAmFactory.getService(dto.getTipoRegistroSimAm()).updateAll(List.of(this.findAndSetNrCredito(dto)));
    }

    public BaseArquivoSimAmDTO findAndSetNrCredito(BaseArquivoSimAmDTO dto) {
        try {
            switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoRegistroSimAm[dto.getTipoRegistroSimAm().ordinal()]) {
                case 1: {
                    AtualizacaoMonetariaCreditoMaDTO dtoAtualizacaoMonetaria = (AtualizacaoMonetariaCreditoMaDTO)dto;
                    List resultForAtualizacao = this.nrCreditoCustomRepository.getNrCredito(dtoAtualizacaoMonetaria.getTipoRegistroSimAm(), dtoAtualizacaoMonetaria.getIdTipoCredito(), dtoAtualizacaoMonetaria.getDtAtualizacao(), null, null);
                    NrDisponivel nrCreditoDTOForAtualizacao = this.getNewNrCredito(dto.getTipoRegistroSimAm(), resultForAtualizacao, dtoAtualizacaoMonetaria.getVlAtualizacao());
                    return new AtribuiNrCreditoAtualizacaoMonetaria(dtoAtualizacaoMonetaria).atribui(nrCreditoDTOForAtualizacao.getNr(), nrCreditoDTOForAtualizacao.getNrAno());
                }
                case 2: {
                    DeducaoCreditoMaDTO dtoDeducaoCredito = (DeducaoCreditoMaDTO)dto;
                    List resultForDeducao = this.nrCreditoCustomRepository.getNrCredito(dtoDeducaoCredito.getTipoRegistroSimAm(), dtoDeducaoCredito.getIdTipoCredito(), dtoDeducaoCredito.getDtDeducao(), null, null);
                    NrDisponivel nrCreditoDTOForDeducao = this.getNewNrCredito(dto.getTipoRegistroSimAm(), resultForDeducao, dtoDeducaoCredito.getVlDeducao());
                    return new AtribuiNrCreditoDeducaoCredito(dtoDeducaoCredito).atribui(nrCreditoDTOForDeducao.getNr(), nrCreditoDTOForDeducao.getNrAno());
                }
                case 3: {
                    InscricaoCreditoDividaAtivaMaDTO dtoInscricaoDA = (InscricaoCreditoDividaAtivaMaDTO)dto;
                    List resultForInscricaoDA = this.nrCreditoCustomRepository.getNrCredito(dtoInscricaoDA.getTipoRegistroSimAm(), dtoInscricaoDA.getIdTipoCredito(), dtoInscricaoDA.getDtInscricao(), null, null);
                    NrDisponivel nrCreditoDTOForInscricaoDA = this.getNewNrCredito(dto.getTipoRegistroSimAm(), resultForInscricaoDA, dtoInscricaoDA.getVlInscricao());
                    return new AtribuiNrCreditoInscricaoDA(dtoInscricaoDA).atribui(nrCreditoDTOForInscricaoDA.getNr(), nrCreditoDTOForInscricaoDA.getNrAno());
                }
                case 4: {
                    ArrecadacaoTipoCreditoMaDTO dtoArrecadacao = (ArrecadacaoTipoCreditoMaDTO)dto;
                    List resultForArrecadacao = this.nrCreditoCustomRepository.getNrCredito(dtoArrecadacao.getTipoRegistroSimAm(), dtoArrecadacao.getIdTipoCredito(), DateUtils.getLocalDateComUltimoDiaDoMes((LocalDate)LocalDate.of(dtoArrecadacao.getNrAno().intValue(), dtoArrecadacao.getNrMes().intValue(), 1)), dtoArrecadacao.getNrAno(), dtoArrecadacao.getNrMes());
                    NrDisponivel nrCreditoDTOForArrecadacao = this.getNewNrCredito(dto.getTipoRegistroSimAm(), resultForArrecadacao, dtoArrecadacao.getValorArrecadacao());
                    return new AtribuiNrCreditoArrecadacaoTipoCredito(dtoArrecadacao).atribui(nrCreditoDTOForArrecadacao.getNr(), nrCreditoDTOForArrecadacao.getNrAno());
                }
            }
            throw new EloValidationException("Tipo de registro n\u00e3o suportado para atribui\u00e7\u00e3o de NrCredito.");
        }
        catch (Exception e) {
            log.error("N\u00e3o foi gerado atribui\u00e7\u00e3o para o registro {}", (Object)dto, (Object)e);
            return dto;
        }
    }

    private NrDisponivel getNewNrCredito(TipoRegistroSimAm tipoRegistroSimAm, List<NrDisponivel> rows, BigDecimal valor) {
        if (CollectionUtils.isEmpty(rows)) {
            throw new EloValidationException("N\u00e3o foi encontrado NrCredito para a opera\u00e7\u00e3o");
        }
        return rows.stream().filter(row -> !tipoRegistroSimAm.equals((Object)TipoRegistroSimAm.DEDUCAO_CREDITO) || row.getValorSoma().compareTo(valor) > 0).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado NrCredito disponivel"));
    }

    @Generated
    public AtribuirNrCreditoService(NrCreditoCustomRepository nrCreditoCustomRepository, ManutencaoArquivoSimAmFactory manutencaoArquivoSimAmFactory) {
        this.nrCreditoCustomRepository = nrCreditoCustomRepository;
        this.manutencaoArquivoSimAmFactory = manutencaoArquivoSimAmFactory;
    }
}

