/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.dto.diarioarrecadacao.TipoOrigemReceita;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.ArrecadacaoTipoCreditoMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoRepository;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoRepository;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ArrecadacaoTipoCreditoMaService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoTipoCreditoMaService
implements ManutencaoArquivoSimAmService<ArrecadacaoTipoCreditoMaDTO> {
    private final ArrecadacaoCreditoRepository arrecadacaoCreditoRepository;
    private final LancamentoCreditoRepository lancamentoCreditoRepository;
    private final InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository;
    private final EntityManager entityManager;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ARRECADACAO_TIPO_CREDITO;
    }

    public Page<ArrecadacaoTipoCreditoMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get("nrMes"), cb.literal((Object)dataInicial.getMonthValue())), (Expression)cb.equal((Expression)root.get("nrAno"), cb.literal((Object)dataInicial.getYear())));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.arrecadacaoCreditoRepository.findAll(specification, pageable).map(ArrecadacaoTipoCreditoMaDTO::from);
    }

    public List<ArrecadacaoTipoCreditoMaDTO> updateAll(List<ArrecadacaoTipoCreditoMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(ArrecadacaoTipoCreditoMaDTO::hasError).collect(Collectors.toList());
        }
        this.arrecadacaoCreditoRepository.saveAll((Iterable)arquivos.stream().map(ArrecadacaoTipoCreditoMaDTO::toArrecadacaoCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<ArrecadacaoTipoCreditoMaDTO> arrecadacaoTipoCredito) {
        return arrecadacaoTipoCredito.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.resolveValidator(current).accept(current);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private Consumer<ArrecadacaoTipoCreditoMaDTO> resolveValidator(ArrecadacaoTipoCreditoMaDTO arrecadacaoTipoCreditoMaDTO) {
        switch (1.$SwitchMap$br$com$elotech$tributos$dto$diarioarrecadacao$TipoOrigemReceita[TipoOrigemReceita.fromValue((Long)arrecadacaoTipoCreditoMaDTO.getIdTipoOrigemReceita()).ordinal()]) {
            case 1: {
                return arg_0 -> this.validaNrCredito(arg_0);
            }
            case 2: {
                return arg_0 -> this.validaNrDivida(arg_0);
            }
        }
        return o -> {};
    }

    private void validaNrCredito(ArrecadacaoTipoCreditoMaDTO arrecadacaoTipoCredito) {
        if (!this.lancamentoCreditoRepository.existsByNrCreditoAndNrAnoCredito(arrecadacaoTipoCredito.getNrCredito(), arrecadacaoTipoCredito.getNrAnoCredito()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de lan\u00e7amento de cr\u00e9dito com a chave nrCredito/nrAnoCredito com os valores %s/%s.", arrecadacaoTipoCredito.getNrCredito(), arrecadacaoTipoCredito.getNrAnoCredito()));
        }
    }

    private void validaNrDivida(ArrecadacaoTipoCreditoMaDTO arrecadacaoTipoCredito) {
        if (!this.inscricaoCreditoDividaAtivaRepository.existsByNrDividaAndNrAnoDivida(arrecadacaoTipoCredito.getNrDivida(), arrecadacaoTipoCredito.getNrAnoDivida()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de inscri\u00e7\u00e3o em d\u00edvida ativa com a chave nrDivida/nrAnoDivida com os valores %s/%s.", arrecadacaoTipoCredito.getNrDivida(), arrecadacaoTipoCredito.getNrAnoDivida()));
        }
    }

    @Generated
    public ArrecadacaoTipoCreditoMaService(ArrecadacaoCreditoRepository arrecadacaoCreditoRepository, LancamentoCreditoRepository lancamentoCreditoRepository, InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository, EntityManager entityManager) {
        this.arrecadacaoCreditoRepository = arrecadacaoCreditoRepository;
        this.lancamentoCreditoRepository = lancamentoCreditoRepository;
        this.inscricaoCreditoDividaAtivaRepository = inscricaoCreditoDividaAtivaRepository;
        this.entityManager = entityManager;
    }
}

