/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.sanepar.SaneparMatricula;
import br.com.elotech.tributos.dto.sanepar.SaneparMatriculaDTO;
import br.com.elotech.tributos.repository.sanepar.SaneparMatriculaRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SaneparMatriculaService
extends CrudService<SaneparMatricula, Long> {
    private final CadastroGeralService cadastroGeralService;
    private final SaneparMatriculaRepository repository;

    public Page<SaneparMatriculaDTO> getAllMatriculas(String search, Pageable pageable) {
        Page saneparMatriculas = this.findByRsql(search, pageable);
        return saneparMatriculas.map(SaneparMatriculaDTO::from);
    }

    public List<SaneparMatricula> findAllByMatricula(String matricula) {
        return this.repository.findAllByMatricula(matricula);
    }

    public boolean existsByMatricula(String matricula) {
        return this.repository.existsByMatricula(matricula);
    }

    public boolean existsVinculoComCadastroAvulsoRuralMobiliarioOuImobiliario(String matricula) {
        return this.repository.existsVinculoComCadastroAvulsoRuralMobiliarioOuImobiliario(matricula.trim());
    }

    public int countByMatricula(String matricula) {
        return this.findAllByMatricula(matricula).size();
    }

    @Generated
    public SaneparMatriculaService(CadastroGeralService cadastroGeralService, SaneparMatriculaRepository repository) {
        this.cadastroGeralService = cadastroGeralService;
        this.repository = repository;
    }
}

