/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar;
import br.com.elotech.tributos.repository.sanepar.BaixaSaneparItemRepository;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.sanepar.GeracaoDebitoBoletoSaneparService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessamentoSaneparService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoSaneparService.class);
    private final GeracaoDebitoBoletoSaneparService geracaoDebitoBoletoSaneparService;
    private final BaixaSaneparItemRepository baixaSaneparItemRepository;
    private final PagamentoService pagamentoService;
    private final PagamentoLoteService pagamentoLoteService;
    private final String SUCCESS_MENSAGEM_TEMPLATE = "Pago";
    private final String ERROR_MENSAGEM_TEMPLATE = "Erro na gera\u00e7\u00e3o do pagamento. Erro: %s";

    public void processarBaixaBatch(BaixaSaneparItem item) {
        this.processar(item);
    }

    public void processarBaixaIndividual(Long idBaixaSanepar, Long idBaixaSaneparItem) {
        BaixaSaneparItem item = this.findBaixaSaneparItems(idBaixaSanepar, idBaixaSaneparItem);
        this.processar(item);
        this.save(item);
    }

    private void processar(BaixaSaneparItem item) {
        this.criaDebitosEBoletos(item);
        this.baixaDebitosEBoletos(item);
    }

    private void criaDebitosEBoletos(BaixaSaneparItem item) {
        this.geracaoDebitoBoletoSaneparService.gerarDebitoEBoleto(item);
    }

    private void baixaDebitosEBoletos(BaixaSaneparItem item) {
        PagamentoLote pagamentoLote = item.getBaixa().getLote();
        if (!item.getSituacao().permiteBaixa()) {
            log.debug("Gerando pagamento: Lote: [{}] Matr\u00edcula: [{}] Linha: [{}] N\u00e3o permite baixa. Situa\u00e7\u00e3o atual do item \u00e9:[{}]", new Object[]{item.getBaixa().getId(), item.getMatricula(), item.getLinha(), item.getSituacao().getDescricao()});
            return;
        }
        try {
            log.debug("Gerando pagamento para o Boleto: [{}] D\u00e9bito: [{}] Lote:[{}] Matr\u00edcula:[{}] Linha:[{}] ", new Object[]{item.getBoleto().getId(), item.getDebito().getId(), item.getBaixa().getId(), item.getMatricula(), item.getLinha()});
            this.baixarItem(item);
            this.atualizaItemComPagamentoEfetuado(item);
        }
        catch (Exception e) {
            log.error("Erro ao gerar pagamento para o Boleto: [{}] D\u00e9bito: [{}] Lote: [{}] Matr\u00edcula: [{}] Linha: [{}]. Erro: [{}] ", new Object[]{item.getBoleto().getId(), item.getDebito().getId(), item.getBaixa().getId(), item.getMatricula(), item.getLinha(), e.getMessage()});
            this.atualizaItemComErroNaGeracaoDePagamento(item, e);
        }
        this.pagamentoLoteService.fecharLote(pagamentoLote);
    }

    private void baixarItem(BaixaSaneparItem item) {
        PagamentoLote pagamentoLote = item.getBaixa().getLote();
        item.getBoleto().setUtilizaValorBloqueto(Boolean.TRUE);
        Pagamento pagamento = this.pagamentoService.geraPagamentoBaixaManual(pagamentoLote, item.getBoleto(), Boolean.TRUE, item.getLinha());
        item.setPagamento(pagamento);
    }

    private BaixaSaneparItem findBaixaSaneparItems(Long idBaixaSanepar, Long idBaixaSaneparItem) {
        return (BaixaSaneparItem)this.baixaSaneparItemRepository.findById((Object)idBaixaSaneparItem).orElseThrow(() -> new EloValidationException(String.format("Item %s do lote %s n\u00e3o encontrado", idBaixaSaneparItem, idBaixaSanepar)));
    }

    private void atualizaItemComPagamentoEfetuado(BaixaSaneparItem item) {
        item.setSituacao(SituacaoItemSanepar.PAGO);
        item.setMensagem("Pago");
    }

    private void atualizaItemComErroNaGeracaoDePagamento(BaixaSaneparItem item, Exception exception) {
        item.setSituacao(SituacaoItemSanepar.ERRO_GERACAO_PAGAMENTO);
        item.setMensagem(String.format("Erro na gera\u00e7\u00e3o do pagamento. Erro: %s", exception.getMessage()));
    }

    private void save(BaixaSaneparItem item) {
        this.baixaSaneparItemRepository.save((Object)item);
    }

    @Generated
    public ProcessamentoSaneparService(GeracaoDebitoBoletoSaneparService geracaoDebitoBoletoSaneparService, BaixaSaneparItemRepository baixaSaneparItemRepository, PagamentoService pagamentoService, PagamentoLoteService pagamentoLoteService) {
        this.geracaoDebitoBoletoSaneparService = geracaoDebitoBoletoSaneparService;
        this.baixaSaneparItemRepository = baixaSaneparItemRepository;
        this.pagamentoService = pagamentoService;
        this.pagamentoLoteService = pagamentoLoteService;
    }
}

