/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rol;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.utils.ObjectMapperUtils;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.rol.Rol;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.rol.GeraRolDTO;
import br.com.elotech.tributos.dto.rol.RolDebitoParcelaTributoDTO;
import br.com.elotech.tributos.repository.rol.GeraRolRepository;
import br.com.elotech.tributos.repository.rol.RolRepository;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

@Service
public class RolService
extends CrudService<Rol, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RolService.class);
    private final ParametroGeralService parametroGeralService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final FormaPagamentoService formaPagamentoService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private final RolRepository rolRepository;
    private final GeraRolRepository geraRolRepository;
    private final PlatformTransactionManager transactionManager;
    private final ObjectMapper mapper;
    private static final Map<NotificationStatus, String> messagesNotificacao = Map.of(NotificationStatus.STARTED, "Iniciado gera\u00e7\u00e3o do rol de d\u00edvidas", NotificationStatus.COMPLETED, "Conclu\u00eddo gera\u00e7\u00e3o do rol de d\u00edvidas", NotificationStatus.FAILED, "Gera\u00e7\u00e3o do rol de d\u00edvidas falhou");

    @Async
    public void gerarRolAsync(GeraRolDTO dto, UserSecurityDTO user) {
        log.info("gerarRolAsync - Criando e persistindo estado inicial do rol de d\u00edvidas, no caso o rol sem os seus d\u00e9bitos. Utilizado os seguintes dados como base de cria\u00e7\u00e3o: {}", (Object)dto);
        Rol rol = this.createRolAndPrepareDTO(dto);
        TarefaAssincronaExecucao tarefaEmExecucao = this.tarefaAssincronaService.createTarefaAssincronaGerarRol(dto.getIdRol());
        this.updateRolAfterStartTarefaAssincrona(dto, rol, tarefaEmExecucao);
        UUID idNotificacao = this.notificaCliente(tarefaEmExecucao, null, user, NotificationStatus.STARTED);
        this.gerarRol(user, dto, rol, tarefaEmExecucao, idNotificacao, Boolean.TRUE.booleanValue());
    }

    @Async
    public void reiniciarRolAsync(Long idTarefaAssincronaExecucao, UserSecurityDTO user) {
        Rol rol = (Rol)this.rolRepository.findByIdTarefaAssincronaExecucao(idTarefaAssincronaExecucao).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o rol com o id de tarefa %d", idTarefaAssincronaExecucao)));
        log.info("reiniciarRolAsync - Reiniciando gera\u00e7\u00e3o do rol de d\u00edvidas para o rol de id {}", (Object)rol.getId());
        TarefaAssincronaExecucao tarefaEmExecucao = this.tarefaAssincronaService.reiniciarTarefaAssincronaExecucao(idTarefaAssincronaExecucao);
        if (Objects.isNull(tarefaEmExecucao)) {
            return;
        }
        UUID idNotificacao = this.notificaCliente(tarefaEmExecucao, null, user, NotificationStatus.STARTED);
        GeraRolDTO dto = (GeraRolDTO)ObjectMapperUtils.read((ObjectMapper)this.mapper, (String)rol.getParametros(), GeraRolDTO.class);
        this.gerarRol(user, dto, rol, tarefaEmExecucao, idNotificacao, Boolean.FALSE.booleanValue());
    }

    private void gerarRol(UserSecurityDTO user, GeraRolDTO dto, Rol rol, TarefaAssincronaExecucao tarefaEmExecucao, UUID idNotificacao, boolean isNew) {
        try {
            log.info("gerarRol - Iniciando gera\u00e7\u00e3o dos d\u00e9bitos, parcelas e tributos do rol de d\u00edvidas");
            this.gerarDebitosParcelasTributosPorExercicio(dto, isNew);
            log.info("gerarRol - Finalizado a inser\u00e7\u00e3o dos d\u00e9bitos, parcelas e tributos do rol de d\u00edvidas. Esses s\u00e3o dados que j\u00e1 foram persistidos no banco em outra transa\u00e7\u00e3o");
            this.updateRolDataFim(rol);
            log.info("gerarRol - Atualizado a data fim do rol de d\u00edvidas");
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.COMPLETED, null);
            log.info("gerarRol - Finalizado a gera\u00e7\u00e3o do rol de d\u00edvidas");
        }
        catch (Exception ex) {
            log.error("gerarRol - Erro ao realizar rotina de gera\u00e7\u00e3o do rol de d\u00edvidas", (Throwable)ex);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, ex);
        }
    }

    private void gerarDebitosParcelasTributosPorExercicio(GeraRolDTO dto, boolean isNew) {
        AtomicLong rowsDebitos = new AtomicLong(0L);
        AtomicLong rowsParcelas = new AtomicLong(0L);
        AtomicLong rowsTributos = new AtomicLong(0L);
        List exercicios = this.findExercicios(dto, isNew);
        Long formaPagamento = this.findFormaPagamentoPadrao(dto);
        ListasNecessariasCalculaAcrescimoDTO listas = this.createNecessariasCalculaAcrescimo(dto);
        for (Long exercicio : exercicios) {
            TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(3));
            try {
                log.info("gerarDebitosParcelasTributosPorExercicio - Iniciando gera\u00e7\u00e3o dos d\u00e9bitos do rol de d\u00edvidas para o exerc\u00edcio {}", (Object)exercicio);
                rowsDebitos.set(rowsDebitos.get() + this.gerarDebitos(dto, exercicio));
                if (rowsDebitos.get() > 0L) {
                    log.info("gerarDebitosParcelasTributosPorExercicio - Iniciando gera\u00e7\u00e3o das parcelas do rol de d\u00edvidas para o exerc\u00edcio {}", (Object)exercicio);
                    rowsParcelas.set(rowsParcelas.get() + this.gerarParcelas(dto, exercicio));
                    log.info("gerarDebitosParcelasTributosPorExercicio - Iniciando gera\u00e7\u00e3o dos tributos do rol de d\u00edvidas para o exerc\u00edcio {}", (Object)exercicio);
                    rowsTributos.set(rowsTributos.get() + this.gerarTributos(dto, exercicio, formaPagamento, listas));
                }
                this.getEm().flush();
                this.getEm().clear();
                this.transactionManager.commit(transaction);
            }
            catch (Exception e) {
                this.transactionManager.rollback(transaction);
                throw e;
            }
        }
        this.validateAfterGerarDebitosParcelasTributos(isNew, Long.valueOf(rowsDebitos.get()), Long.valueOf(rowsParcelas.get()), Long.valueOf(rowsTributos.get()));
    }

    private List<Long> findExercicios(GeraRolDTO dto, boolean isNew) {
        return this.geraRolRepository.findExercicios(dto, isNew).stream().sorted(Comparator.comparing(e -> e)).toList();
    }

    private Long findFormaPagamentoPadrao(GeraRolDTO dto) {
        return dto.calcularAcrescimos() ? this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty()).getId() : null;
    }

    private ListasNecessariasCalculaAcrescimoDTO createNecessariasCalculaAcrescimo(GeraRolDTO dto) {
        return dto.calcularAcrescimos() ? this.calculoAcrescimoService.createNecessariasCalculaAcrescimo() : null;
    }

    private void validateAfterGerarDebitosParcelasTributos(boolean isNew, Long rowsDebitos, Long rowsParcelas, Long rowsTributos) {
        if (isNew && (rowsDebitos < 1L || rowsParcelas < 1L || rowsTributos < 1L)) {
            throw new EloValidationException("N\u00e3o foi gerado nenhum d\u00e9bito/parcela/tributo para o rol. Poss\u00edveis solu\u00e7\u00f5es: 1. O d\u00e9bito deve estar constitu\u00eddo; 2. Data de inclus\u00e3o ou data de contabiliza\u00e7\u00e3o devem ser menor ou igual a data de refer\u00eancia; 3. Deve ser d\u00e9bito/parcela com a situa\u00e7\u00e3o aberta ou a data de situa\u00e7\u00e3o da parcela deve ser maior que a data de refer\u00eancia; 4. Verifique se existe algum d\u00e9bito com o filtro informado.");
        }
    }

    private UUID notificaCliente(TarefaAssincronaExecucao execucao, UUID idNotificacao, UserSecurityDTO user, NotificationStatus status) {
        String titulo = "Gera\u00e7\u00e3o do Rol de D\u00edvidas";
        String message = (String)messagesNotificacao.get(status);
        TarefaAssincrona tarefa = execucao.getTarefaAssincrona();
        return this.notificacaoService.send(titulo, message, tarefa, Optional.ofNullable(idNotificacao), user, status).orElse(null);
    }

    private void stopTarefaAssincrona(TarefaAssincronaExecucao execucao, UUID idNotificacao, UserSecurityDTO user, NotificationStatus status, Exception exception) {
        if (status.equals((Object)NotificationStatus.FAILED)) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
        } else {
            this.tarefaAssincronaService.finalizarExecucao(execucao);
        }
        this.notificaCliente(execucao, idNotificacao, user, status);
    }

    private Rol createRolAndPrepareDTO(GeraRolDTO dto) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(3));
        try {
            Rol rol = (Rol)this.rolRepository.saveAndFlush((Object)dto.toEntity());
            dto.setIgnorarIntervaloDividas(this.getIgnorarIntervaloDividas());
            dto.setIdRol(rol.getId());
            this.transactionManager.commit(transaction);
            return rol;
        }
        catch (Exception e) {
            this.transactionManager.rollback(transaction);
            throw e;
        }
    }

    private void updateRolAfterStartTarefaAssincrona(GeraRolDTO dto, Rol rol, TarefaAssincronaExecucao tarefaAssincronaExecucao) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(3));
        try {
            rol.setParametros(this.getStringGeraRolDTO(dto));
            rol.setIdTarefaAssincronaExecucao(tarefaAssincronaExecucao.getId());
            this.rolRepository.saveAndFlush((Object)rol);
            this.transactionManager.commit(transaction);
        }
        catch (Exception e) {
            this.transactionManager.rollback(transaction);
            throw e;
        }
    }

    private String getStringGeraRolDTO(GeraRolDTO dto) {
        try {
            return this.mapper.writeValueAsString((Object)dto);
        }
        catch (JsonProcessingException e) {
            throw new EloValidationException("Erro ao converter par\u00e2metros do rol de d\u00edvidas para JSON");
        }
    }

    private List<Long> getIgnorarIntervaloDividas() {
        String ignorarIntervaloDividas = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.ROL_GERACAO_IGNORAR_DIVIDAS, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (StringUtils.isBlank((CharSequence)ignorarIntervaloDividas)) {
            return Collections.emptyList();
        }
        return Arrays.stream(ignorarIntervaloDividas.split(",")).map(String::trim).map(Long::valueOf).toList();
    }

    private long gerarDebitos(GeraRolDTO dto, Long exercicio) {
        return this.geraRolRepository.insertDebitos(dto, exercicio);
    }

    private long gerarParcelas(GeraRolDTO dto, Long exercicio) {
        return this.geraRolRepository.insertParcelas(dto, exercicio);
    }

    private long gerarTributos(GeraRolDTO dto, Long exercicio, Long formaPagamento, ListasNecessariasCalculaAcrescimoDTO listas) {
        if (dto.calcularAcrescimos()) {
            return this.gerarTributosComAcrescimos(dto, exercicio, formaPagamento, listas);
        }
        return this.geraRolRepository.insertTributosSemAcrescimos(dto, exercicio);
    }

    private long gerarTributosComAcrescimos(GeraRolDTO dto, Long exercicio, Long formaPagamento, ListasNecessariasCalculaAcrescimoDTO listas) {
        String insertValues = this.calculoAcrescimoService.calculaAcrescimos(this.geraRolRepository.findTributos(dto, exercicio), formaPagamento, dto.getDataReferencia(), listas, Boolean.FALSE).stream().map(RolDebitoParcelaTributoDTO::buildInsertValues).map(RolDebitoParcelaTributoDTO::addComma).reduce(String::concat).map(s -> s.substring(0, s.length() - 1)).orElse("");
        return StringUtils.isNotBlank((CharSequence)insertValues) ? (long)this.geraRolRepository.insertTributosComAcrescimos(insertValues, exercicio) : 0L;
    }

    private void updateRolDataFim(Rol rol) {
        this.getEm().clear();
        String jpql = "update Rol r set r.dataFim = :dataFim where r.id = :id";
        this.getEm().createQuery(jpql).setParameter("dataFim", (Object)LocalDate.now()).setParameter("id", (Object)rol.getId()).executeUpdate();
    }

    @Generated
    public RolService(ParametroGeralService parametroGeralService, CalculoAcrescimoService calculoAcrescimoService, FormaPagamentoService formaPagamentoService, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService, RolRepository rolRepository, GeraRolRepository geraRolRepository, PlatformTransactionManager transactionManager, ObjectMapper mapper) {
        this.parametroGeralService = parametroGeralService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.formaPagamentoService = formaPagamentoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
        this.rolRepository = rolRepository;
        this.geraRolRepository = geraRolRepository;
        this.transactionManager = transactionManager;
        this.mapper = mapper;
    }
}

