/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.requerimento;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItem;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.dto.GerarDebitoResponseDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.requerimento.RequerimentoDTO;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.repository.requerimento.RequerimentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.TipoRequerimentoService;
import br.com.elotech.tributos.service.requerimento.RequerimentoBoletoService;
import br.com.elotech.tributos.service.requerimento.RequerimentoItemService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class RequerimentoService
extends CrudService<Requerimento, RequerimentoId> {
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final TipoRequerimentoService tipoRequerimentoService;
    private final AiseDebitoService aiseDebitoService;
    private final RequerimentoRepository requerimentoRepository;
    private final HistoricoAtendimentoService historicoAtendimentoService;
    private final RequerimentoItemService requerimentoItemService;
    private final RequerimentoBoletoService requerimentoBoletoService;

    public RequerimentoId gerar(RequerimentoDTO dto) {
        this.validarDependenciaProcesso(dto);
        Requerimento requerimento = this.criarRequerimentoBase(dto);
        Requerimento savedEntity = (Requerimento)this.requerimentoRepository.save((Object)requerimento);
        this.requerimentoItemService.adicionarItens(savedEntity, dto, requerimento.getTipoRequerimento());
        this.adicionarObservacoes(savedEntity, dto);
        this.requerimentoItemService.adicionarParcelaComValorAjustado(savedEntity, dto.getDataVencimento());
        DebitoIdDTO debitoIdDTO = this.gerarDebito(savedEntity);
        this.getEm().flush();
        Bloqueto boleto = this.requerimentoBoletoService.gerarBoleto(debitoIdDTO.getIdDebito(), dto.getCodigoModeloBloquetoSemRegistro());
        this.finalizarRequerimento(savedEntity, debitoIdDTO, boleto);
        this.registrarHistorico(savedEntity);
        return ((Requerimento)this.requerimentoRepository.save((Object)savedEntity)).getId();
    }

    private void validarDependenciaProcesso(RequerimentoDTO dto) {
        boolean exercicioInformado;
        boolean processoInformado = Objects.nonNull(dto.getIdProcesso());
        if (processoInformado != (exercicioInformado = Objects.nonNull(dto.getExercicioProcesso()))) {
            throw new EloValidationException("Os campos ano processo e n\u00b0 processo s\u00e3o dependentes e n\u00e3o podem ser preenchidos separadamente");
        }
    }

    private Requerimento criarRequerimentoBase(RequerimentoDTO dto) {
        Pessoa pessoaRequerente = (Pessoa)this.pessoaService.findById(dto.getRequerente()).orElseThrow(() -> new EloValidationException("Requerente n\u00e3o encontrado"));
        TipoRequerimento tipoRequerimento = (TipoRequerimento)this.tipoRequerimentoService.findById((Serializable)dto.getTipoRequerimento()).orElseThrow(() -> new EloValidationException("Tipo do requerimento n\u00e3o encontrado"));
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)dto.getTipoCadastro()), dto.getCadastroGeral()).orElseThrow(() -> new EloValidationException("Cadastro n\u00e3o encontrado"));
        RequerimentoId id = new RequerimentoId();
        id.setEntidade(dto.getEntidade());
        id.setExercicio(dto.getExercicio());
        Requerimento requerimento = new Requerimento();
        requerimento.setId(id);
        requerimento.setTipoRequerimento(tipoRequerimento);
        requerimento.setCadastroGeral(cadastroGeral);
        requerimento.setPessoa(pessoaRequerente);
        requerimento.setDataRequerimento(dto.getDataLancamento());
        requerimento.setIdProcesso(dto.getIdProcesso());
        requerimento.setExercicioProcesso(dto.getExercicioProcesso());
        requerimento.setUsuario(SecurityUtils.getUserAise());
        requerimento.setData(LocalDate.now());
        requerimento.setProcessoSei(dto.getProcessoSei());
        return requerimento;
    }

    private void adicionarObservacoes(Requerimento requerimento, RequerimentoDTO dto) {
        List observacoesAjuste = this.requerimentoItemService.coletarObservacoesAjuste(requerimento.getItens());
        ArrayList todasObservacoes = new ArrayList(dto.getObservacoes());
        todasObservacoes.addAll(observacoesAjuste);
        requerimento.addObservacoes(todasObservacoes);
    }

    private void finalizarRequerimento(Requerimento requerimento, DebitoIdDTO debitoIdDTO, Bloqueto boleto) {
        requerimento.setExercicioDebito(debitoIdDTO.getExercicio());
        requerimento.setDivida(debitoIdDTO.getDivida());
        requerimento.setSubDivida(debitoIdDTO.getSubDivida());
        requerimento.setBoleto(boleto);
    }

    private void registrarHistorico(Requerimento requerimento) {
        String mensagem = String.format("Gerado requerimento %s/%s do tipo %s", requerimento.getId().getRequerimento(), requerimento.getId().getExercicio(), requerimento.getTipoRequerimento().getDescricao());
        this.historicoAtendimentoService.createHistoricoAtendimento(mensagem, TipoAcaoAtendimento.GERACAO_REQUERIMENTO);
    }

    private DebitoIdDTO gerarDebito(Requerimento requerimento) {
        Optional requerimentoObservacao = requerimento.getObservacoes().stream().findFirst();
        Optional requerimentoParcela = requerimento.getParcelas().stream().findFirst();
        String receitas = requerimento.getItens().stream().map(arg_0 -> this.montarStringReceita(arg_0)).reduce("", String::concat);
        GerarDebitoRequestDTO gerarDebitoRequestDTO = new GerarDebitoRequestDTO();
        gerarDebitoRequestDTO.setEntidade(requerimento.getId().getEntidade());
        gerarDebitoRequestDTO.setExercicio(requerimento.getId().getExercicio());
        gerarDebitoRequestDTO.setTipoCadastro(requerimento.getCadastroGeral().getTipoCadastro().getValue());
        gerarDebitoRequestDTO.setCadastroGeral(requerimento.getCadastroGeral().getCadastroGeral());
        gerarDebitoRequestDTO.setGuiaRecolhimento(requerimento.getTipoRequerimento().getDivida().getDivida());
        Optional.of(receitas).ifPresent(arg_0 -> ((GerarDebitoRequestDTO)gerarDebitoRequestDTO).setReceitaLista(arg_0));
        gerarDebitoRequestDTO.setDataLancamento(requerimento.getDataRequerimento());
        gerarDebitoRequestDTO.setTelaOrigemDebito("Requerimento");
        requerimentoParcela.ifPresent(parcela -> gerarDebitoRequestDTO.setDataVencimento(parcela.getDataVencimento()));
        requerimentoParcela.ifPresent(parcela -> gerarDebitoRequestDTO.setValorPrincipal(parcela.getValor()));
        requerimentoObservacao.ifPresent(observacao -> gerarDebitoRequestDTO.setObservacao(observacao.getObservacao()));
        gerarDebitoRequestDTO.setObservacoes(requerimento.getObservacoes().stream().map(obs -> String.format("Requerimento %s/%s: %s", requerimento.getId().getRequerimento(), requerimento.getId().getExercicio(), obs.getObservacao())).toList());
        return DebitoIdDTO.from((GerarDebitoResponseDTO)this.aiseDebitoService.geraDebito(gerarDebitoRequestDTO));
    }

    public ImpressaoDTO imprimirBoletoRequerimento(RequerimentoId id) {
        return this.requerimentoBoletoService.imprimirBoleto(id);
    }

    public Optional<RelatorioPK> determinarRelatorioParaImpressao(Requerimento requerimento) {
        return this.requerimentoBoletoService.determinarRelatorioParaImpressao(requerimento);
    }

    private String montarStringReceita(RequerimentoItem item) {
        String tributo = item.getTributo().getTributo();
        BigDecimal valorAjustado = this.requerimentoItemService.calcularValorTotalAjustado(item);
        Locale locale = Locale.forLanguageTag("pt-BR");
        return String.format(locale, "%s|%.2f|0|0|0|%.2f;", tributo, valorAjustado, valorAjustado);
    }

    @Generated
    public RequerimentoService(CadastroGeralService cadastroGeralService, PessoaService pessoaService, TipoRequerimentoService tipoRequerimentoService, AiseDebitoService aiseDebitoService, RequerimentoRepository requerimentoRepository, HistoricoAtendimentoService historicoAtendimentoService, RequerimentoItemService requerimentoItemService, RequerimentoBoletoService requerimentoBoletoService) {
        this.cadastroGeralService = cadastroGeralService;
        this.pessoaService = pessoaService;
        this.tipoRequerimentoService = tipoRequerimentoService;
        this.aiseDebitoService = aiseDebitoService;
        this.requerimentoRepository = requerimentoRepository;
        this.historicoAtendimentoService = historicoAtendimentoService;
        this.requerimentoItemService = requerimentoItemService;
        this.requerimentoBoletoService = requerimentoBoletoService;
    }
}

