/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.requerimento;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.TipoRequerimentoItem;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItem;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItemId;
import br.com.elotech.tributos.domain.requerimento.RequerimentoParcela;
import br.com.elotech.tributos.domain.requerimento.RequerimentoParcelaId;
import br.com.elotech.tributos.dto.requerimento.RequerimentoDTO;
import br.com.elotech.tributos.dto.requerimento.RequerimentoItemDTO;
import br.com.elotech.tributos.service.TipoRequerimentoItemService;
import br.com.elotech.tributos.service.TributoService;
import br.com.elotech.tributos.service.requerimento.RequerimentoItemCalculator;
import br.com.elotech.tributos.validator.RequerimentoItemValidator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class RequerimentoItemService {
    private final TipoRequerimentoItemService tipoRequerimentoItemService;
    private final TributoService tributoService;
    private final RequerimentoItemValidator validator;
    private final RequerimentoItemCalculator calculator;

    public void adicionarItens(Requerimento requerimento, RequerimentoDTO requerimentoDTO, TipoRequerimento tipoRequerimento) {
        List itens = this.criarItens(requerimentoDTO, tipoRequerimento, requerimento);
        requerimento.getItens().addAll(itens);
    }

    public void adicionarParcelaComValorAjustado(Requerimento requerimento, LocalDate dataVencimento) {
        RequerimentoParcelaId parcelaId = new RequerimentoParcelaId(requerimento.getId());
        RequerimentoParcela parcela = new RequerimentoParcela();
        parcela.setId(parcelaId);
        parcela.setDataVencimento(dataVencimento);
        parcela.setValor(this.calcularValorTotalAjustado(requerimento));
        requerimento.getParcelas().add(parcela);
        requerimento.setNumeroParcelas(Long.valueOf(requerimento.getParcelas().size()));
    }

    public List<String> coletarObservacoesAjuste(List<RequerimentoItem> itens) {
        return itens.stream().map(item -> {
            TipoRequerimentoItem tipoItem = this.buscarTipoRequerimentoItem(item.getId().getServico());
            return this.calculator.obterObservacaoAjuste(item.getQuantidade(), item.getValorUnitario(), tipoItem);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public BigDecimal calcularValorTotalAjustado(RequerimentoItem item) {
        TipoRequerimentoItem tipoItem = this.buscarTipoRequerimentoItem(item.getId().getServico());
        return this.calculator.calcularValorTotalAjustado(item.getQuantidade(), item.getValorUnitario(), tipoItem);
    }

    private List<RequerimentoItem> criarItens(RequerimentoDTO dto, TipoRequerimento tipoRequerimento, Requerimento requerimento) {
        return dto.getItens().stream().filter(arg_0 -> ((RequerimentoItemValidator)this.validator).possuiValorMaiorQueZero(arg_0)).map(itemDto -> this.criarItem(itemDto, tipoRequerimento, requerimento)).toList();
    }

    private RequerimentoItem criarItem(RequerimentoItemDTO itemDto, TipoRequerimento tipoRequerimento, Requerimento requerimento) {
        TipoRequerimentoItem tipoItem = this.buscarTipoRequerimentoItem(itemDto.getTipoRequerimentoItem());
        this.validator.validarPertenceAoTipoRequerimento(tipoItem, tipoRequerimento);
        this.validator.validarQuantidadeFixa(itemDto, tipoItem);
        Tributo tributo = this.buscarTributo(tipoItem, requerimento.getId());
        BigDecimal quantidadeUtilizada = this.calculator.obterQuantidadeUtilizada(itemDto.getQuantidade(), tipoItem);
        return this.construirItem(requerimento.getId(), tipoItem, itemDto, tributo, quantidadeUtilizada);
    }

    private RequerimentoItem construirItem(RequerimentoId requerimentoId, TipoRequerimentoItem tipoItem, RequerimentoItemDTO itemDto, Tributo tributo, BigDecimal quantidade) {
        RequerimentoItem item = new RequerimentoItem();
        item.setId(new RequerimentoItemId(requerimentoId, tipoItem.getId()));
        item.setDescricao(tipoItem.getDescricao());
        item.setQuantidade(quantidade);
        item.setValorUnitario(itemDto.getValorUnitario());
        item.setTributo(tributo);
        return item;
    }

    private TipoRequerimentoItem buscarTipoRequerimentoItem(Long id) {
        return (TipoRequerimentoItem)this.tipoRequerimentoItemService.findById((Serializable)id).orElseThrow(() -> new EloValidationException("Item do Tipo Requerimento n\u00e3o encontrado."));
    }

    private Tributo buscarTributo(TipoRequerimentoItem tipoItem, RequerimentoId requerimentoId) {
        Tributo tributo = this.tributoService.findByEntidadeAndExercicioAndTributo(requerimentoId.getEntidade(), requerimentoId.getExercicio(), tipoItem.getTributo());
        if (Objects.isNull(tributo)) {
            throw new EloValidationException(String.format("Tributo %s n\u00e3o encontrado na entidade %d e exerc\u00edcio %d.", tipoItem.getTributo(), requerimentoId.getEntidade(), requerimentoId.getExercicio()));
        }
        return tributo;
    }

    private BigDecimal calcularValorTotalAjustado(Requerimento requerimento) {
        return requerimento.getItens().stream().map(arg_0 -> this.calcularValorTotalAjustado(arg_0)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public RequerimentoItemService(TipoRequerimentoItemService tipoRequerimentoItemService, TributoService tributoService, RequerimentoItemValidator validator, RequerimentoItemCalculator calculator) {
        this.tipoRequerimentoItemService = tipoRequerimentoItemService;
        this.tributoService = tributoService;
        this.validator = validator;
        this.calculator = calculator;
    }
}

