/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.requerimento;

import br.com.elotech.tributos.domain.TipoRequerimentoItem;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

@Component
public class RequerimentoItemCalculator {
    public BigDecimal calcularValorTotalAjustado(BigDecimal quantidade, BigDecimal valorUnitario, TipoRequerimentoItem tipoRequerimentoItem) {
        BigDecimal valorCalculado = quantidade.multiply(valorUnitario);
        if (tipoRequerimentoItem.getValorMaximo() != null && valorCalculado.compareTo(tipoRequerimentoItem.getValorMaximo()) > 0) {
            return tipoRequerimentoItem.getValorMaximo();
        }
        if (tipoRequerimentoItem.getValorMinimo() != null && valorCalculado.compareTo(tipoRequerimentoItem.getValorMinimo()) < 0) {
            return tipoRequerimentoItem.getValorMinimo();
        }
        return valorCalculado;
    }

    public String obterObservacaoAjuste(BigDecimal quantidade, BigDecimal valorUnitario, TipoRequerimentoItem tipoRequerimentoItem) {
        BigDecimal valorAjustado;
        BigDecimal valorCalculado = quantidade.multiply(valorUnitario);
        if (valorCalculado.compareTo(valorAjustado = this.calcularValorTotalAjustado(quantidade, valorUnitario, tipoRequerimentoItem)) != 0) {
            if (tipoRequerimentoItem.getValorMaximo() != null && valorCalculado.compareTo(tipoRequerimentoItem.getValorMaximo()) > 0) {
                return String.format("Item '%s': Valor ajustado de R$ %.2f para R$ %.2f para respeitar limite m\u00e1ximo de R$ %.2f.", tipoRequerimentoItem.getDescricao(), valorCalculado, valorAjustado, tipoRequerimentoItem.getValorMaximo());
            }
            if (tipoRequerimentoItem.getValorMinimo() != null && valorCalculado.compareTo(tipoRequerimentoItem.getValorMinimo()) < 0) {
                return String.format("Item '%s': Valor ajustado de R$ %.2f para R$ %.2f para respeitar limite m\u00ednimo de R$ %.2f.", tipoRequerimentoItem.getDescricao(), valorCalculado, valorAjustado, tipoRequerimentoItem.getValorMinimo());
            }
        }
        return null;
    }

    public BigDecimal obterQuantidadeUtilizada(BigDecimal quantidadeInformada, TipoRequerimentoItem tipoRequerimentoItem) {
        return Boolean.TRUE.equals(tipoRequerimentoItem.getQuantidadeFixa()) ? tipoRequerimentoItem.getQuantidade() : quantidadeInformada;
    }
}

