/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.requerimento;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.repository.requerimento.RequerimentoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.LongUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class RequerimentoBoletoService {
    private final GeraBoletoService geraBoletoService;
    private final ModeloBoletoService modeloBoletoService;
    private final ContextService contextService;
    private final AisePdfService aisePdfService;
    private final ParametroGeralService parametroGeralService;
    private final RequerimentoRepository requerimentoRepository;

    public Bloqueto gerarBoleto(Long idDebito, Long codigoModeloBloquetoSemRegistro) {
        ModeloBoleto modeloBoleto = this.determinarModeloBoleto(codigoModeloBloquetoSemRegistro);
        GeraBoletoDTO geraBoletoDTO = this.construirGeraBoletoDTO(idDebito, codigoModeloBloquetoSemRegistro, modeloBoleto);
        return (Bloqueto)this.geraBoletoService.geraBoleto(geraBoletoDTO).stream().findFirst().orElseThrow(() -> new IllegalStateException("Erro ao gerar boleto"));
    }

    public ImpressaoDTO imprimirBoleto(RequerimentoId id) {
        Requerimento requerimento = this.buscarRequerimentoParaImpressao(id);
        Long boleto = requerimento.getBoleto().getBloqueto();
        Long exercicioBoleto = requerimento.getBoleto().getExercicioBloqueto();
        return this.determinarRelatorioParaImpressao(requerimento).map(idRelatorio -> ImpressaoDTO.from((String)this.aisePdfService.fetchBoletoRequerimento(boleto, exercicioBoleto, Long.valueOf(idRelatorio.getRelatorio().longValue()), idRelatorio.getTipoRelatorio().getTipo()))).orElseGet(() -> ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(boleto, exercicioBoleto)));
    }

    private ModeloBoleto determinarModeloBoleto(Long codigoModeloBloquetoSemRegistro) {
        return codigoModeloBloquetoSemRegistro != null && codigoModeloBloquetoSemRegistro > 0L ? (ModeloBoleto)this.modeloBoletoService.findOne((Serializable)codigoModeloBloquetoSemRegistro) : this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
    }

    private GeraBoletoDTO construirGeraBoletoDTO(Long idDebito, Long codigoModeloBloquetoSemRegistro, ModeloBoleto modeloBoleto) {
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(idDebito);
        debitoParcelaDTO.setParcela(Long.valueOf(1L));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        geraBoletoDTO.setDebitos(Collections.singletonList(debitoParcelaDTO));
        geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        geraBoletoDTO.setSomenteConstituidos(Boolean.FALSE);
        geraBoletoDTO.setCodigoModeloBloquetoSemRegistro(codigoModeloBloquetoSemRegistro);
        geraBoletoDTO.setModeloBoleto(modeloBoleto);
        return geraBoletoDTO;
    }

    private Requerimento buscarRequerimentoParaImpressao(RequerimentoId id) {
        Requerimento requerimento = (Requerimento)this.requerimentoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException("Requerimento n\u00e3o encontrado!"));
        this.validarBoletoParaImpressao(requerimento.getBoleto());
        return requerimento;
    }

    private void validarBoletoParaImpressao(Bloqueto boleto) {
        if (Objects.isNull(boleto)) {
            throw new EloValidationException("Requerimento n\u00e3o possui um boleto.");
        }
        if (Boolean.TRUE.equals(boleto.getPago())) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel imprimir um boleto pago.");
        }
        if (Boolean.TRUE.equals(boleto.getVencido())) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel imprimir um boleto vencido.");
        }
    }

    public Optional<RelatorioPK> determinarRelatorioParaImpressao(Requerimento requerimento) {
        return Optional.ofNullable(requerimento.getTipoRequerimento()).map(TipoRequerimento::getRelatorioBoleto).map(Relatorio::getId).or(() -> this.buscarRelatorioPadrao());
    }

    private Optional<RelatorioPK> buscarRelatorioPadrao() {
        Long relatorioParamGeral = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.RELATORIO_PADRAO_REQUERIMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String tipoRelatorioParamGeral = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_RELATORIO_PADRAO_REQUERIMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        TipoRelatorio tipoRelatorio = TipoRelatorio.fromValue((String)tipoRelatorioParamGeral);
        if (LongUtils.isNullOrZero((Long)relatorioParamGeral) || Objects.isNull(tipoRelatorio)) {
            return Optional.empty();
        }
        return Optional.of(RelatorioPK.from((String)ModuloEnum.MODULO_TRIBUTARIO.getValue(), (TipoRelatorio)tipoRelatorio, (Integer)relatorioParamGeral.intValue()));
    }

    @Generated
    public RequerimentoBoletoService(GeraBoletoService geraBoletoService, ModeloBoletoService modeloBoletoService, ContextService contextService, AisePdfService aisePdfService, ParametroGeralService parametroGeralService, RequerimentoRepository requerimentoRepository) {
        this.geraBoletoService = geraBoletoService;
        this.modeloBoletoService = modeloBoletoService;
        this.contextService = contextService;
        this.aisePdfService = aisePdfService;
        this.parametroGeralService = parametroGeralService;
        this.requerimentoRepository = requerimentoRepository;
    }
}

