/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.report;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.oxy.reportexecutor.dto.ReportExecutorDTO;
import br.com.elotech.oxy.repository.dto.ReportDTO;
import br.com.elotech.reportexecutor.client.ReportExecutorFeignClient;
import br.com.elotech.repository.client.ReportFeignClient;
import br.com.elotech.tributos.domain.report.ConfiguracaoRelatorio;
import br.com.elotech.tributos.dto.report.ReportParamsDTO;
import br.com.elotech.tributos.enums.report.TipoRelatorioInterno;
import br.com.elotech.tributos.service.report.ConfiguracaoRelatorioService;
import br.com.elotech.tributos.util.report.ReportUtils;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    private final ConfiguracaoRelatorioService configuracaoRelatorioService;
    private final Optional<ReportFeignClient> reportFeignClient;
    private final Optional<ReportExecutorFeignClient> reportExecutorFeignClient;

    private void preencherParams(ReportParamsDTO params) {
        if (!params.getParamsValues().isEmpty()) {
            params.getParamsValues().forEach((name, param) -> Optional.ofNullable(param).ifPresent(filtro -> filtro.setName(name)));
        }
        if (!params.getFiltrosValues().isEmpty()) {
            params.getFiltrosValues().forEach((name, filtroDTO) -> Optional.ofNullable(filtroDTO).ifPresent(filtro -> filtro.setName(name)));
        }
    }

    public byte[] execute(ReportParamsDTO params) {
        this.preencherParams(params);
        TipoRelatorioInterno tipoRelatorio = params.getTipoRelatorio();
        UUID uuid = this.configuracaoRelatorioService.findByTipoRelatorio(tipoRelatorio).map(ConfiguracaoRelatorio::getRelatorio).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o existe configura\u00e7\u00e3o para o tipo de relat\u00f3rio %s", tipoRelatorio)));
        ReportDTO report = this.getReportFeignClient().findOne(uuid);
        ReportExecutorDTO reportExecutor = ReportUtils.createReportExecutor((ReportDTO)report, (ReportParamsDTO)params);
        return this.getReportExecutorFeignClient().execute(reportExecutor);
    }

    private ReportFeignClient getReportFeignClient() {
        return (ReportFeignClient)this.reportFeignClient.orElseThrow(() -> new EloValidationException("O feign do reportFeignClient n\u00e3o est\u00e1 disponivel no modo onpremise"));
    }

    private ReportExecutorFeignClient getReportExecutorFeignClient() {
        return (ReportExecutorFeignClient)this.reportExecutorFeignClient.orElseThrow(() -> new EloValidationException("O feign do reportExecutorFeignClient n\u00e3o est\u00e1 disponivel no modo onpremise"));
    }

    @Generated
    public ReportService(ConfiguracaoRelatorioService configuracaoRelatorioService, Optional<ReportFeignClient> reportFeignClient, Optional<ReportExecutorFeignClient> reportExecutorFeignClient) {
        this.configuracaoRelatorioService = configuracaoRelatorioService;
        this.reportFeignClient = reportFeignClient;
        this.reportExecutorFeignClient = reportExecutorFeignClient;
    }
}

