/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.relatoriogerencial.acompanhamentoperiodo;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.AnaliseArrecadacao;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.AnaliseArrecadacaoId;
import br.com.elotech.tributos.dto.relatoriogerencial.ResumoAnaliseArrecadacaoDTO;
import br.com.elotech.tributos.repository.relatoriogerencial.AcompanhamentoPeriodoRepository;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AcompanhamentoPeriodoService
extends CrudService<AnaliseArrecadacao, AnaliseArrecadacaoId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AcompanhamentoPeriodoService.class);
    private final AcompanhamentoPeriodoRepository acompanhamentoPeriodoRepository;

    public List<ResumoAnaliseArrecadacaoDTO> findResumoAnaliseArrecadacao(Long exercicio, Long mes) {
        LocalDate startDate = LocalDate.of(exercicio.intValue(), mes.intValue(), 1);
        LocalDate endDate = startDate.withDayOfMonth(startDate.lengthOfMonth());
        return this.acompanhamentoPeriodoRepository.findResumoAnaliseArrecadacaoByExercicioAndMes(startDate, endDate, mes);
    }

    @Generated
    public AcompanhamentoPeriodoService(AcompanhamentoPeriodoRepository acompanhamentoPeriodoRepository) {
        this.acompanhamentoPeriodoRepository = acompanhamentoPeriodoRepository;
    }
}

