/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.relatoriogerencial.acompanhamentoperiodo;

import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AcompanhamentoPeriodoJobStarter {
    private final JobLauncher jobLauncher;
    private final Job acompanhamentoPeriodoJob;

    public AcompanhamentoPeriodoJobStarter(JobLauncher jobLauncher, @Qualifier(value="acompanhamentoPeriodoBatchJob") Job acompanhamentoPeriodoJob) {
        this.jobLauncher = jobLauncher;
        this.acompanhamentoPeriodoJob = acompanhamentoPeriodoJob;
    }

    public JobExecution startJob(Long exercicio, Long mes, long dia) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("exercicio", exercicio, true);
        jobParametersBuilder.addLong("mes", mes, true);
        jobParametersBuilder.addLong("dia", Long.valueOf(dia), true);
        jobParametersBuilder.addDate("date", new Date());
        jobParametersBuilder.addLong("timestamp", Long.valueOf(System.currentTimeMillis()));
        return this.jobLauncher.run(this.acompanhamentoPeriodoJob, jobParametersBuilder.toJobParameters());
    }
}

