/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.regrabloqueio;

import br.com.elotech.tributos.service.regrabloqueio.RegraBloqueioPadrao;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RegraBloqueioMaringa
extends RegraBloqueioPadrao {
    private static final String CNPJ_MARINGA = "76282656000106";
    private static final Long DIVIDA_ALIENACAO_BENS_IMOVEIS = 19L;
    private static final String RECEITA_JFAIC = "JFAIC";
    private static final String RECEITA_JF = "JF";
    private static final String RECEITA_JF9 = "JF9";
    private static final String RECEITA_JFALC = "JFALC";
    private static final String RECEITA_JFAI = "JFAI";
    private static List<String> RECEITAS_BLOQUEADAS = List.of("JFAIC", "JF", "JF9", "JFALC", "JFAI");

    public Integer getIndex() {
        return 1;
    }

    public Boolean accept(String cnpj) {
        return CNPJ_MARINGA.equals(cnpj);
    }

    public Boolean bloqueiaDesconto(Long divida, String tributo) {
        return DIVIDA_ALIENACAO_BENS_IMOVEIS.compareTo(divida) == 0 && !RECEITAS_BLOQUEADAS.contains(tributo);
    }
}

