/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rastreamento;

import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.rastreamento.RastreamentoMaringaService;
import br.com.elotech.tributos.service.rastreamento.RastreamentoService;
import br.com.elotech.tributos.service.rastreamento.RastreamentoServiceInterface;
import org.springframework.stereotype.Component;

@Component
public class RastreamentoServiceFactory {
    private final RastreamentoService rastreamentoService;
    private final RastreamentoMaringaService rastreamentoMaringaService;
    private final ParametroGeralService parametroGeralService;

    public RastreamentoServiceFactory(RastreamentoService rastreamentoService, RastreamentoMaringaService rastreamentoMaringaService, ParametroGeralService parametroGeralService) {
        this.rastreamentoService = rastreamentoService;
        this.rastreamentoMaringaService = rastreamentoMaringaService;
        this.parametroGeralService = parametroGeralService;
    }

    public RastreamentoServiceInterface getService() {
        if (this.findParamValueAsBooleanOrFalse(ParametroGeralEnum.UTILIZA_RASTREAMENTO_ESPECIFICO)) {
            return this.rastreamentoMaringaService;
        }
        return this.rastreamentoService;
    }

    private boolean findParamValueAsBooleanOrFalse(ParametroGeralEnum param) {
        try {
            return this.parametroGeralService.getParamValueAsBoolean(param);
        }
        catch (Exception e) {
            return false;
        }
    }
}

