/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rastreamento;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoConsultaDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.rastreamento.RastreamentoCadastroImpressaoDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.enums.TipoArquivoRelatorioEnum;
import br.com.elotech.tributos.report.loader.RastreamentoCadastralParamLoader;
import br.com.elotech.tributos.repository.RastreamentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.PessoaNotFoundException;
import br.com.elotech.tributos.service.exception.RastreamentoException;
import br.com.elotech.tributos.service.rastreamento.RastreamentoServiceInterface;
import br.com.elotech.tributos.util.JasperUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="rastreamentoGeral")
public class RastreamentoService
implements RastreamentoServiceInterface {
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final RastreamentoRepository rastreamentoRepository;
    private final ParametroGeralService parametroGeralService;
    private final RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ArquivoJasperService arquivoJasperService;
    private final ObjectMapper objectMapper;
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    public Set<RastreamentoCadastroDTO> porCadastro(RastreamentoConsultaDTO param) {
        return this.porCadastro(param.getIdCadastro());
    }

    public Set<RastreamentoCadastroDTO> porCadastro(Long idCadastro) {
        CadastroImobiliario cadastroImobiliario;
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findOne((Serializable)idCadastro);
        this.validarCadastro(cadastroGeral);
        if (Boolean.TRUE.equals(this.utilizaConvencaoCondominio()) && TipoCadastro.IMOBILIARIO.equals((Object)cadastroGeral.getTipoCadastro()) && Boolean.FALSE.equals((cadastroImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(cadastroGeral.getTipoCadastro(), cadastroGeral.getCadastroGeral())).getConvencaoCondominio())) {
            return this.calculaPorImobiliarioSemConvencaoCondominio(cadastroImobiliario);
        }
        return this.calculaPorCadastro(idCadastro);
    }

    public Set<RastreamentoCadastroDTO> calculaPorImobiliarioSemConvencaoCondominio(CadastroImobiliario cadastroImobiliario) {
        List proprietarios = this.rastreamentoRepository.loadRastreamentoPorInscricaoCadastralCadastro(this.getPrefixoInscricao(cadastroImobiliario.getInscricaoCadastral(), this.configuracaoInscricaoCadastralService.getConfiguracao().getUnidade().getTamanho()));
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        Set cadastrosList = this.calculaSituacoesCadastroQuandoUtilizaConvencaoCondominio(cadastros).stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toCollection(LinkedHashSet::new));
        Boolean possuiCertidaoPositiva = cadastrosList.stream().anyMatch(RastreamentoCadastroDTO::getCertidaoPositivaDebito);
        if (possuiCertidaoPositiva.booleanValue()) {
            cadastros.forEach(rastreamentoCadastroDTO -> rastreamentoCadastroDTO.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA));
        }
        return cadastros;
    }

    public Set<RastreamentoCadastroDTO> calculaPorCadastro(Long idCadastro) {
        List proprietarios = this.rastreamentoRepository.loadRastreamentoPorCadastro(idCadastro, this.consideraCadastroAvulso());
        if (this.consideraDevedorSolidario().booleanValue()) {
            proprietarios.addAll(this.rastreamentoRepository.loadRastreamentoDevedorSolidarioPorCadastro(idCadastro));
        }
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        return this.calculaSituacoesCadastro(cadastros).stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(RastreamentoConsultaDTO param) {
        return this.porContribuinte(param.getIdContribuinte());
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(Long idContribuinte) {
        Pessoa pessoa = this.pessoaService.findOne(idContribuinte);
        this.validarPessoa(pessoa);
        if (Boolean.TRUE.equals(this.utilizaConvencaoCondominio())) {
            Set cadastrosList = this.calcularSituacaoCadastroPorContribuinte(pessoa);
            return this.verificarSituacoesImobiliariosSemConvencaoCondominio(cadastrosList);
        }
        return this.calcularSituacaoCadastroPorContribuinte(pessoa);
    }

    public Set<RastreamentoCadastroDTO> verificarSituacoesImobiliariosSemConvencaoCondominio(Set<RastreamentoCadastroDTO> cadastros) {
        Set cadastrosImobiliarios = cadastros.stream().filter(RastreamentoCadastroDTO::isImobiliarioSemConvencaoCondominio).collect(Collectors.toSet());
        Map<String, List<RastreamentoCadastroDTO>> gruposPorPrefixoInscricao = cadastrosImobiliarios.stream().collect(Collectors.groupingBy(dto -> this.getPrefixoInscricao(dto.getInscricaoCadastral(), this.configuracaoInscricaoCadastralService.getConfiguracao().getUnidade().getTamanho())));
        for (List<RastreamentoCadastroDTO> grupo : gruposPorPrefixoInscricao.values()) {
            boolean algumPossuiCertidaoPositiva = grupo.stream().anyMatch(RastreamentoCadastroDTO::getCertidaoPositivaDebito);
            if (!algumPossuiCertidaoPositiva) continue;
            grupo.forEach(dto -> dto.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA));
        }
        return cadastros;
    }

    private String getPrefixoInscricao(String inscricaoCadastral, Long tamanhoUnidade) {
        if (Objects.nonNull(inscricaoCadastral) && (long)inscricaoCadastral.length() > tamanhoUnidade) {
            return inscricaoCadastral.substring(0, (int)((long)inscricaoCadastral.length() - tamanhoUnidade));
        }
        return "";
    }

    public Set<RastreamentoCadastroDTO> calcularSituacaoCadastroPorContribuinte(Pessoa pessoa) {
        Boolean consideraCnpjRaiz = this.consideraCnpjRaiz();
        Boolean consideraCadastroAvulso = this.consideraCadastroAvulso();
        Boolean consideraSocios = this.consideraSocios();
        Boolean consideraContratoSocial = this.consideraContratoSocial();
        List proprietarios = this.rastreamentoRepository.loadRastreamentoPorCpfCnpj(pessoa.getCnpjCpf(), consideraCadastroAvulso, consideraCnpjRaiz);
        if (this.consideraDevedorSolidario().booleanValue()) {
            proprietarios.addAll(this.rastreamentoRepository.loadRastreamentoDevedorSolidarioPorCpfCnpj(pessoa.getCnpjCpf(), consideraCnpjRaiz));
        }
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        if (consideraSocios.booleanValue()) {
            cadastros.forEach(cadastro -> {
                List socios = this.rastreamentoRepository.buscaSocios(cadastro.getId());
                socios.forEach(socio -> {
                    Set cadastrosSocios = this.rastreamentoRepository.loadRastreamentoCadastrosSocios(socio.getCpfCnpj(), consideraCnpjRaiz, consideraCadastroAvulso);
                    socio.setCadastrosVinculados(cadastrosSocios.stream().filter(cadastroSocios -> !cadastroSocios.getId().equals(cadastro.getId())).collect(Collectors.toList()));
                });
                cadastro.getProprietarios().addAll(socios);
            });
            cadastros.addAll(this.rastreamentoRepository.loadRastreamentoCadastrosSocios(pessoa.getCnpjCpf(), consideraCnpjRaiz, consideraCadastroAvulso));
        }
        if (Boolean.TRUE.equals(consideraContratoSocial)) {
            List cadastrosContratoSocial = this.rastreamentoRepository.loadRastreamentoContratoSocialPorCpfCnpj(pessoa.getCnpjCpf(), consideraCnpjRaiz);
            Set cadastrosContratoSocialAgrupados = RastreamentoCadastroDTO.agruparPorCadastro((List)cadastrosContratoSocial);
            cadastros.addAll(cadastrosContratoSocialAgrupados);
        }
        return this.calculaSituacoesCadastro(cadastros).stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public byte[] imprimirRastreamento(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) throws IOException {
        List rastreamentoCadastroImpressaoDTOS = this.getRastreamentoCadastroImpressaoDTOS(rastreamentos, isDetalhado);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)rastreamentoCadastroImpressaoDTOS, RastreamentoCadastroImpressaoDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.rastreamentoCadastralParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).build();
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(TipoArquivoJasper.RASTREAMENTO_DEBITOS_DETALHADO);
        String fileName = JasperUtils.getDefaultOrCustomJasperFileName((ArquivoJasper)arquivoJasper, (String)TipoArquivoJasper.RASTREAMENTO_DEBITOS_DETALHADO.getNomeInternoComExtensaoJasper());
        return JasperUtils.builderExportacaoReport((ArquivoJasper)arquivoJasper, (String)fileName, (ReportDatasource)datasource, (TipoArquivoRelatorioEnum)TipoArquivoRelatorioEnum.PDF, (ObjectMapper)this.objectMapper, (ReportFileResolverFactory)this.reportFileResolverFactory);
    }

    public List<RastreamentoCadastroImpressaoDTO> getRastreamentoCadastroImpressaoDTOS(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) {
        return rastreamentos.stream().map(rc -> {
            RastreamentoCadastroImpressaoDTO rastreamentoCadastroImpressaoDTO = RastreamentoCadastroImpressaoDTO.toRastreamentoCadastroImpressaoDTO((RastreamentoCadastroDTO)rc);
            if (Boolean.TRUE.equals(isDetalhado)) {
                List debitosRastreamento = this.rastreamentoRepository.loadDebitosRastreamento(rastreamentoCadastroImpressaoDTO.getIdCadastro());
                List<RastreamentoDebitoDTO> debitosVencidosRastreamento = debitosRastreamento.stream().filter(rt -> rt.getVencido() != false && BigDecimal.ZERO.compareTo(rt.getValor()) < 0).toList();
                rastreamentoCadastroImpressaoDTO.setDebitosVencidos(debitosVencidosRastreamento);
                rastreamentoCadastroImpressaoDTO.setTotalValorDebitos(debitosVencidosRastreamento.stream().map(RastreamentoDebitoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            return rastreamentoCadastroImpressaoDTO;
        }).sorted(Comparator.comparing(RastreamentoCadastroImpressaoDTO::getTipoCadastro).thenComparing(RastreamentoCadastroImpressaoDTO::getCadastroGeral)).collect(Collectors.toList());
    }

    private Set<RastreamentoCadastroDTO> calculaSituacoesCadastroQuandoUtilizaConvencaoCondominio(Set<RastreamentoCadastroDTO> cadastros) {
        Boolean parametroCertidaoNegativaSemContrato = this.consideraCndParaDebitosAVencer();
        Boolean parametroConsideraContencioso = this.consideraContencioso();
        HashMap mapCadastros = new HashMap();
        cadastros.forEach(cadastro -> this.atualizaSituacoesCadastro(mapCadastros, cadastro, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso));
        return cadastros;
    }

    private Set<RastreamentoCadastroDTO> calculaSituacoesCadastro(Set<RastreamentoCadastroDTO> cadastros) {
        Boolean parametroCertidaoNegativaSemContrato = this.consideraCndParaDebitosAVencer();
        Boolean parametroConsideraContencioso = this.consideraContencioso();
        HashMap mapCadastros = new HashMap();
        cadastros.forEach(cadastro -> {
            this.atualizaSituacoesCadastro(mapCadastros, cadastro, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso);
            cadastro.getProprietarios().forEach(proprietario -> {
                if (Objects.nonNull(proprietario.getCadastrosVinculados())) {
                    proprietario.getCadastrosVinculados().forEach(cadastroVinculado -> this.atualizaSituacoesCadastro(mapCadastros, cadastroVinculado, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso));
                }
            });
        });
        return cadastros;
    }

    private void atualizaSituacoesCadastro(Map<Long, RastreamentoCadastroDTO> mapCadastros, RastreamentoCadastroDTO cadastro, Boolean parametroCertidaoNegativaSemContrato, Boolean parametroConsideraContencioso) {
        RastreamentoCadastroDTO cadastroMapeado = mapCadastros.computeIfAbsent(cadastro.getId(), c -> this.buscaDebitos(cadastro, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso));
        cadastro.setDebitos(cadastroMapeado.getDebitos());
        cadastro.setTipoCertidaoDebitos(cadastroMapeado.getTipoCertidaoDebitos());
    }

    private RastreamentoCadastroDTO buscaDebitos(RastreamentoCadastroDTO cadastro, Boolean parametroCertidaoNegativaSemContrato, Boolean parametroConsideraContencioso) {
        cadastro.setDebitos(this.rastreamentoRepository.loadDebitosRastreamento(cadastro.getId()));
        cadastro.calculaSituacaoDebitos(parametroCertidaoNegativaSemContrato, parametroConsideraContencioso);
        return cadastro;
    }

    private Boolean utilizaConvencaoCondominio() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_CONVENCAO_CONDOMINIO);
    }

    private Boolean emiteCertidaoCadastroMobiliario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.EMITE_CERTIDAO_CAD_MOBILIARIO);
    }

    private void validarCadastro(CadastroGeral cadastro) {
        if (Objects.isNull(cadastro)) {
            throw new CadastroNaoEncontradoException();
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastro.getTipoCadastro()) && !this.emiteCertidaoCadastroMobiliario().booleanValue()) {
            throw RastreamentoException.tipoCadastroInvalido();
        }
    }

    private void validarPessoa(Pessoa pessoa) {
        if (Objects.isNull(pessoa)) {
            throw new PessoaNotFoundException();
        }
    }

    public Boolean consideraCadastroAvulso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_AVULSO_RASTREAMENTO);
    }

    private Boolean consideraDevedorSolidario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_DEVEDOR_SOLIDARIO_CND);
    }

    private Boolean consideraCndParaDebitosAVencer() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CERTIDAO_CND_QDO_SEM_CONTRATO);
    }

    private Boolean consideraCnpjRaiz() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CNPJ_RAIZ_RASTREAMENTO);
    }

    private Boolean consideraSocios() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_SOCIO_RASTREAMENTO);
    }

    private Boolean consideraContencioso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CONTENCIOSO_CND);
    }

    private Boolean consideraContratoSocial() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CONTRATO_SOCIAL_RASTREAMENTO);
    }

    @Generated
    public RastreamentoService(CadastroGeralService cadastroGeralService, PessoaService pessoaService, RastreamentoRepository rastreamentoRepository, ParametroGeralService parametroGeralService, RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader, ReportFileResolverFactory reportFileResolverFactory, ArquivoJasperService arquivoJasperService, ObjectMapper objectMapper, CadastroImobiliarioService cadastroImobiliarioService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.cadastroGeralService = cadastroGeralService;
        this.pessoaService = pessoaService;
        this.rastreamentoRepository = rastreamentoRepository;
        this.parametroGeralService = parametroGeralService;
        this.rastreamentoCadastralParamLoader = rastreamentoCadastralParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.arquivoJasperService = arquivoJasperService;
        this.objectMapper = objectMapper;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }
}

