/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rastreamento;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Feriado;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoConsultaDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.SituacaoCadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.SituacaoCadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.rastreamento.RastreamentoCadastroImpressaoDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.enums.TipoArquivoRelatorioEnum;
import br.com.elotech.tributos.enums.TipoSituacaoDebitoFintel;
import br.com.elotech.tributos.report.loader.RastreamentoCadastralParamLoader;
import br.com.elotech.tributos.repository.FeriadoRepository;
import br.com.elotech.tributos.repository.RastreamentoMaringaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.PessoaNotFoundException;
import br.com.elotech.tributos.service.exception.RastreamentoException;
import br.com.elotech.tributos.service.rastreamento.RastreamentoServiceInterface;
import br.com.elotech.tributos.util.JasperUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Qualifier(value="rastreamentoMaringa")
public class RastreamentoMaringaService
implements RastreamentoServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RastreamentoMaringaService.class);
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final RastreamentoMaringaRepository rastreamentoMaringaRepository;
    private final ParametroGeralService parametroGeralService;
    private final DiaUtilService diaUtilService;
    private final RestTemplate restTemplate;
    private final RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ObjectMapper objectMapper;
    private final FeriadoRepository feriadoRepository;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final FormaPagamentoService formaPagamentoService;
    private final ContextService contextService;
    private final ArquivoJasperService arquivoJasperService;

    public byte[] imprimirRastreamento(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) throws IOException {
        List rastreamentoCadastroImpressaoDTOS = this.getRastreamentoCadastroImpressaoDTOS(rastreamentos, isDetalhado);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)rastreamentoCadastroImpressaoDTOS, RastreamentoCadastroImpressaoDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.rastreamentoCadastralParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).build();
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(TipoArquivoJasper.RASTREAMENTO_DEBITOS_DETALHADO);
        String fileName = JasperUtils.getDefaultOrCustomJasperFileName((ArquivoJasper)arquivoJasper, (String)TipoArquivoJasper.RASTREAMENTO_DEBITOS_DETALHADO.getNomeInternoComExtensaoJasper());
        return JasperUtils.builderExportacaoReport((ArquivoJasper)arquivoJasper, (String)fileName, (ReportDatasource)datasource, (TipoArquivoRelatorioEnum)TipoArquivoRelatorioEnum.PDF, (ObjectMapper)this.objectMapper, (ReportFileResolverFactory)this.reportFileResolverFactory);
    }

    public List<RastreamentoCadastroImpressaoDTO> getRastreamentoCadastroImpressaoDTOS(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) {
        List<RastreamentoCadastroImpressaoDTO> cadastrosImpressao = rastreamentos.stream().map(RastreamentoCadastroImpressaoDTO::toRastreamentoCadastroImpressaoDTO).collect(Collectors.toList());
        if (Boolean.TRUE.equals(isDetalhado)) {
            List feriados = this.feriadoRepository.findAll();
            FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual()));
            Set idsCadastros = cadastrosImpressao.stream().map(RastreamentoCadastroImpressaoDTO::getId).collect(Collectors.toSet());
            List debitosRastreamento = this.rastreamentoMaringaRepository.loadDebitosRastreamento(idsCadastros).stream().toList();
            LOGGER.trace("getRastreamentoCadastroImpressaoDTOS - Encontrou {} d\u00e9bitos/parcelas/receitas", (Object)debitosRastreamento.size());
            List<RastreamentoDebitoDTO> debitosRastreamentoAbertosPraCobranca = debitosRastreamento.stream().filter(RastreamentoDebitoDTO::isAbertoPraCobranca).toList();
            LOGGER.trace("getRastreamentoCadastroImpressaoDTOS - Filtrou {} d\u00e9bitos/parcelas/receitas abertos para cobran\u00e7a", (Object)debitosRastreamentoAbertosPraCobranca.size());
            List<RastreamentoDebitoDTO> debitosRastreamentoVencidos = debitosRastreamentoAbertosPraCobranca.stream().filter(rastreamentoDebitoDTO -> this.checkDebitoRastreamentoVencido(rastreamentoDebitoDTO, feriados)).toList();
            LOGGER.trace("getRastreamentoCadastroImpressaoDTOS - Filtros {} d\u00e9bitos/parcelas/receitas vencidos", (Object)debitosRastreamentoVencidos.size());
            List<AcrescimoDTO> dados = debitosRastreamentoVencidos.stream().map(debito -> AcrescimoDTO.of((RastreamentoDebitoDTO)debito, (Long)formaPagamentoPadrao.getId(), (LocalDate)LocalDate.now())).toList();
            Map<Long, BigDecimal> valores = this.calculoAcrescimoService.calculaAcrescimos(dados).stream().collect(Collectors.toMap(AcrescimoDTO::getIdDebitoParcelaTributo, AcrescimoDTO::getValorTotal));
            LOGGER.trace("getRastreamentoCadastroImpressaoDTOS - Finalizou o c\u00e1lculo de acr\u00e9scimos");
            debitosRastreamentoVencidos.forEach(debito -> debito.setValor((BigDecimal)valores.get(debito.getIdDebitoParcelaTributo())));
            Map<Long, List<RastreamentoDebitoDTO>> debitosRastreamentoPorCadastro = debitosRastreamentoVencidos.stream().collect(Collectors.groupingBy(RastreamentoDebitoDTO::getIdCadastro));
            debitosRastreamentoPorCadastro.forEach((idCadastro, debitos) -> cadastrosImpressao.stream().filter(cadastro -> cadastro.getId().equals(idCadastro)).findFirst().ifPresent(cadastro -> {
                List debitosAgrupadosPorParcela = this.mapearListaChaveValorToList(this.agrupaListaPorHashDaChaveDoDebito(debitos));
                cadastro.setDebitosVencidos(debitosAgrupadosPorParcela);
                cadastro.setTotalValorDebitos(debitosAgrupadosPorParcela.stream().map(RastreamentoDebitoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
            }));
        }
        cadastrosImpressao.sort(Comparator.comparing(RastreamentoCadastroImpressaoDTO::getTipoCadastro).thenComparing(RastreamentoCadastroImpressaoDTO::getCadastroGeral));
        return cadastrosImpressao;
    }

    public Map<Long, List<RastreamentoDebitoDTO>> agrupaListaPorHashDaChaveDoDebito(List<RastreamentoDebitoDTO> list) {
        return list.stream().collect(Collectors.groupingBy(arg_0 -> this.getHashByChaveComposta(arg_0)));
    }

    private RastreamentoDebitoDTO mapearListaParaDTOAgrupado(List<RastreamentoDebitoDTO> rastreamentoDebitoDTOList) {
        RastreamentoDebitoDTO debitoBase = rastreamentoDebitoDTOList.getFirst();
        BigDecimal valorTotal = rastreamentoDebitoDTOList.stream().map(RastreamentoDebitoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
        RastreamentoDebitoDTO rastreamentoDebitoDTO = new RastreamentoDebitoDTO();
        rastreamentoDebitoDTO.setEntidade(debitoBase.getEntidade());
        rastreamentoDebitoDTO.setExercicio(debitoBase.getExercicio());
        rastreamentoDebitoDTO.setTipoCadastro(debitoBase.getTipoCadastro());
        rastreamentoDebitoDTO.setCadastroGeral(debitoBase.getCadastroGeral());
        rastreamentoDebitoDTO.setDivida(debitoBase.getDivida());
        rastreamentoDebitoDTO.setSubDivida(debitoBase.getSubDivida());
        rastreamentoDebitoDTO.setParcela(debitoBase.getParcela());
        rastreamentoDebitoDTO.setDataVencimento(debitoBase.getDataVencimento());
        rastreamentoDebitoDTO.setDataVencimentoCotaUnica(debitoBase.getDataVencimentoCotaUnica());
        rastreamentoDebitoDTO.setRecursoAdministrativo(debitoBase.getRecursoAdministrativo());
        rastreamentoDebitoDTO.setParcelado(debitoBase.getParcelado());
        rastreamentoDebitoDTO.setReparcelado(debitoBase.getReparcelado());
        rastreamentoDebitoDTO.setValor(valorTotal);
        return rastreamentoDebitoDTO;
    }

    public List<RastreamentoDebitoDTO> mapearListaChaveValorToList(Map<Long, List<RastreamentoDebitoDTO>> list) {
        return list.values().stream().map(arg_0 -> this.mapearListaParaDTOAgrupado(arg_0)).sorted(Comparator.comparing(RastreamentoDebitoDTO::getExercicio).thenComparing(RastreamentoDebitoDTO::getTipoCadastro).thenComparing(RastreamentoDebitoDTO::getCadastroGeral).thenComparing(RastreamentoDebitoDTO::getDivida).thenComparing(RastreamentoDebitoDTO::getParcela)).collect(Collectors.toList());
    }

    public Long getHashByChaveComposta(RastreamentoDebitoDTO rastreamentoDebitoDTO) {
        return Objects.hash(rastreamentoDebitoDTO.getEntidade(), rastreamentoDebitoDTO.getExercicio(), rastreamentoDebitoDTO.getTipoCadastro(), rastreamentoDebitoDTO.getCadastroGeral(), rastreamentoDebitoDTO.getSubDivida(), rastreamentoDebitoDTO.getParcela());
    }

    public Set<RastreamentoCadastroDTO> porCadastro(Long id) {
        RastreamentoConsultaDTO rastreamentoConsultaDTO = RastreamentoConsultaDTO.builder().idCadastro(id).build();
        return this.porCadastro(rastreamentoConsultaDTO);
    }

    public Set<RastreamentoCadastroDTO> porCadastro(RastreamentoConsultaDTO param) {
        this.validarCadastro((CadastroGeral)this.cadastroGeralService.findOne((Serializable)param.getIdCadastro()));
        param.setConsideraCadastroAvulso(this.consideraCadastroAvulso());
        List proprietarios = this.rastreamentoMaringaRepository.loadRastreamento(param);
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        return this.handleSituacoesAndGetCadastros(cadastros).stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(Long id) {
        RastreamentoConsultaDTO rastreamentoConsultaDTO = RastreamentoConsultaDTO.builder().idContribuinte(id).build();
        return this.porContribuinte(rastreamentoConsultaDTO);
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(RastreamentoConsultaDTO param) {
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(param.getIdContribuinte()).orElseThrow(PessoaNotFoundException::new);
        param.setCpfCnpj(pessoa.getCnpjCpf());
        param.setConsideraCnpjRaiz(this.consideraCnpjRaiz());
        param.setConsideraCadastroAvulso(this.consideraCadastroAvulso());
        List proprietarios = this.rastreamentoMaringaRepository.loadRastreamento(param);
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        if (Boolean.TRUE.equals(this.consideraSocios())) {
            cadastros.forEach(cadastro -> {
                List socios = this.rastreamentoMaringaRepository.buscaProprietariosSocios(cadastro.getId());
                socios.forEach(socio -> {
                    Set cadastrosSocios = this.rastreamentoMaringaRepository.loadRastreamentoCadastrosSocios(param);
                    socio.setCadastrosVinculados(cadastrosSocios.stream().filter(cadastroSocios -> !cadastroSocios.getId().equals(cadastro.getId())).toList());
                });
                cadastro.getProprietarios().addAll(socios);
            });
            cadastros.addAll(this.rastreamentoMaringaRepository.loadRastreamentoCadastrosSocios(param));
        }
        return this.getListCadastros(cadastros, param.getSomenteEmpresasAtivas()).stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<RastreamentoCadastroDTO> getListCadastros(Set<RastreamentoCadastroDTO> cadastros, Boolean somenteEmpresasAtivas) {
        Set cadastrosList = this.handleSituacoesAndGetCadastros(cadastros);
        if (Boolean.TRUE.equals(somenteEmpresasAtivas)) {
            cadastrosList.removeIf(RastreamentoCadastroDTO::isCadastroInativo);
        }
        return Optional.ofNullable(cadastrosList).orElse(Collections.emptySet());
    }

    private Set<RastreamentoCadastroDTO> handleSituacoesAndGetCadastros(Set<RastreamentoCadastroDTO> cadastros) {
        if (cadastros.isEmpty()) {
            return Collections.emptySet();
        }
        Boolean parametroConsideraContencioso = this.consideraContencioso();
        HashMap cnpjsConsultadosFintel = new HashMap();
        List feriados = this.feriadoRepository.findAll();
        Map debitosPorCadastro = this.getDebitosAgrupadosPorCadastros(cadastros);
        Map debitosPorCadastroSocios = this.getDebitosAgrupadosPorCadastrosSocios(cadastros);
        debitosPorCadastro.forEach((idCadastro, debitos) -> cadastros.stream().filter(cadastro -> cadastro.getId().equals(idCadastro)).findFirst().ifPresent(cadastro -> this.handleSituacoesCadastros(cadastros, debitos, cadastro, parametroConsideraContencioso, feriados, cnpjsConsultadosFintel, debitosPorCadastroSocios)));
        return cadastros;
    }

    private void handleSituacoesCadastros(Set<RastreamentoCadastroDTO> cadastros, List<RastreamentoDebitoDTO> debitos, RastreamentoCadastroDTO cadastro, Boolean parametroConsideraContencioso, List<Feriado> feriados, Map<String, String> cnpjsConsultadosFintel, Map<Long, List<RastreamentoDebitoDTO>> debitosPorCadastroSocios) {
        cadastro.setDebitos(debitos);
        this.calculaSituacaoDebitos(cadastro, parametroConsideraContencioso, feriados);
        this.handleSituacaoCadastro(cadastro);
        cadastro.setSituacaoSGO(this.getSituacaoFintel(cnpjsConsultadosFintel, cadastro));
        cadastro.setTipoCertidaoDebitos(this.getTipoCertidaoDebitoFintel(cadastro));
        debitosPorCadastroSocios.forEach((idCadastroSocio, debitosSocio) -> cadastros.stream().filter(c -> Objects.nonNull(c.getProprietarios())).flatMap(c -> c.getProprietarios().stream()).filter(proprietario -> Objects.nonNull(proprietario.getCadastrosVinculados())).flatMap(proprietario -> proprietario.getCadastrosVinculados().stream()).filter(cadastroVinculado -> cadastroVinculado.getId().equals(idCadastroSocio)).findFirst().ifPresent(cadastroSocio -> {
            cadastroSocio.setDebitos(debitosSocio);
            this.calculaSituacaoDebitos(cadastroSocio, parametroConsideraContencioso, feriados);
            this.handleSituacaoCadastro(cadastro);
            cadastroSocio.setSituacaoSGO(this.getSituacaoFintel(cnpjsConsultadosFintel, cadastroSocio));
            cadastroSocio.setTipoCertidaoDebitos(this.getTipoCertidaoDebitoFintel(cadastroSocio));
        }));
    }

    @NotNull
    private Map<Long, List<RastreamentoDebitoDTO>> getDebitosAgrupadosPorCadastros(Set<RastreamentoCadastroDTO> cadastros) {
        Set<Long> idsCadastros = cadastros.stream().map(RastreamentoCadastroDTO::getId).collect(Collectors.toSet());
        Map<Long, List<RastreamentoDebitoDTO>> debitosPorCadastro = this.rastreamentoMaringaRepository.loadDebitosRastreamento(idsCadastros).stream().collect(Collectors.groupingBy(RastreamentoDebitoDTO::getIdCadastro));
        idsCadastros.forEach(id -> debitosPorCadastro.putIfAbsent((Long)id, Collections.emptyList()));
        return debitosPorCadastro;
    }

    @NotNull
    private Map<Long, List<RastreamentoDebitoDTO>> getDebitosAgrupadosPorCadastrosSocios(Set<RastreamentoCadastroDTO> cadastros) {
        Set<Long> idsCadastrosSocios = cadastros.stream().filter(cadastro -> Objects.nonNull(cadastro.getProprietarios())).flatMap(cadastro -> cadastro.getProprietarios().stream()).filter(proprietario -> Objects.nonNull(proprietario.getCadastrosVinculados())).flatMap(proprietario -> proprietario.getCadastrosVinculados().stream()).map(RastreamentoCadastroDTO::getId).collect(Collectors.toSet());
        Map<Long, List<RastreamentoDebitoDTO>> debitosPorCadastrosSocios = idsCadastrosSocios.isEmpty() ? Collections.emptyMap() : this.rastreamentoMaringaRepository.loadDebitosRastreamento(idsCadastrosSocios).stream().collect(Collectors.groupingBy(RastreamentoDebitoDTO::getIdCadastro));
        idsCadastrosSocios.forEach(id -> debitosPorCadastrosSocios.putIfAbsent((Long)id, Collections.emptyList()));
        return debitosPorCadastrosSocios;
    }

    private TipoCertidaoDebitos getTipoCertidaoDebitoFintel(RastreamentoCadastroDTO cadastroMapeado) {
        if (this.getSituacoesPositivasFintel().stream().anyMatch(cadastroMapeado.getSituacaoSGO()::equals)) {
            return TipoCertidaoDebitos.POSITIVA;
        }
        if (this.getSituacoesPositivasComEfeitoNegativaFintel().stream().anyMatch(cadastroMapeado.getSituacaoSGO()::equals)) {
            return TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA;
        }
        return cadastroMapeado.getTipoCertidaoDebitos();
    }

    private String getSituacaoFintel(Map<String, String> cnpjsConsultadosFintel, RastreamentoCadastroDTO cadastroMapeado) {
        String situacaoFintel;
        String urlSgo = this.consideraUrlSgo();
        if ("".equals(urlSgo) || Objects.isNull(urlSgo)) {
            return TipoSituacaoDebitoFintel.URL_NAO_CONFIGURADA.getDescricao();
        }
        Long tipoCadastro = cadastroMapeado.getTipoCadastro();
        if (TipoCadastro.IMOBILIARIO.getValue().equals(tipoCadastro)) {
            return TipoSituacaoDebitoFintel.OK.getDescricao();
        }
        String cpfCnpj = cadastroMapeado.getCpfCnpj();
        if (!cnpjsConsultadosFintel.containsKey(cpfCnpj)) {
            String urlCompleta = String.format(urlSgo.concat("/%s"), cpfCnpj);
            try {
                situacaoFintel = (String)this.restTemplate.exchange(urlCompleta, HttpMethod.GET, HttpEntityFactory.createJsonHttpEntityWithoutEntity(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
            }
            catch (Exception ex) {
                String message = String.format("Erro ao consultar a situacao na Fintel para o CNPJ %s", cpfCnpj);
                LOGGER.error("{} - {}", new Object[]{message, ex.getMessage(), ex});
                return TipoSituacaoDebitoFintel.VAZIO.getDescricao();
            }
            cnpjsConsultadosFintel.put(cpfCnpj, situacaoFintel);
        } else {
            situacaoFintel = cnpjsConsultadosFintel.get(cpfCnpj);
        }
        if (Objects.isNull(situacaoFintel) || "".equals(situacaoFintel) || "N".equals(situacaoFintel)) {
            return TipoSituacaoDebitoFintel.OK.getDescricao();
        }
        if ("Y".equals(situacaoFintel)) {
            return TipoSituacaoDebitoFintel.ISS_VENCIDO.getDescricao();
        }
        if (!TipoCadastro.MOBILIARIO.getValue().equals(tipoCadastro)) {
            return TipoSituacaoDebitoFintel.VAZIO.getDescricao();
        }
        return "X".equals(situacaoFintel) ? TipoSituacaoDebitoFintel.POSITIVA_NEGATIVA.getDescricao() : TipoSituacaoDebitoFintel.OCORRENCIA.getDescricao();
    }

    private void handleSituacaoCadastro(RastreamentoCadastroDTO cadastroMapeado) {
        if (TipoCadastro.IMOBILIARIO.getValue().equals(cadastroMapeado.getTipoCadastro())) {
            this.handleSituacaoDescricaoImobiliario(cadastroMapeado);
        }
        if (TipoCadastro.MOBILIARIO.getValue().equals(cadastroMapeado.getTipoCadastro())) {
            this.handleSituacaoDescricaoMobiliario(cadastroMapeado);
        }
    }

    private void handleSituacaoDescricaoMobiliario(RastreamentoCadastroDTO cadastro) {
        List situacaoMobiliario = this.rastreamentoMaringaRepository.loadSituacaoCadastroMobiliario(cadastro.getId());
        if (Objects.nonNull(situacaoMobiliario) && !situacaoMobiliario.isEmpty()) {
            String descricaoMobiliario = situacaoMobiliario.stream().map(SituacaoCadastroMobiliarioDTO::getSituacaoDescricao).collect(Collectors.joining("/"));
            Boolean isAnyEncerrado = situacaoMobiliario.stream().anyMatch(sm -> "S".equals(sm.getEncerramento()));
            if (situacaoMobiliario.stream().anyMatch(SituacaoCadastroMobiliarioDTO::isPessoaMobiliarioAvulso)) {
                descricaoMobiliario = descricaoMobiliario.concat("(AVULSO)");
            }
            cadastro.setSituacao(descricaoMobiliario);
            cadastro.setEncerramento(isAnyEncerrado);
            return;
        }
        cadastro.setSituacao("OK");
    }

    private void handleSituacaoDescricaoImobiliario(RastreamentoCadastroDTO cadastro) {
        List situacaoCadastroSegmentoDTOS = this.rastreamentoMaringaRepository.loadSituacaoCadastroImobiliario(cadastro.getId());
        if (Objects.nonNull(situacaoCadastroSegmentoDTOS) && !situacaoCadastroSegmentoDTOS.isEmpty()) {
            String situacao = situacaoCadastroSegmentoDTOS.stream().map(SituacaoCadastroImobiliarioDTO::getSituacaoDescricao).collect(Collectors.joining("/"));
            cadastro.setSituacao(situacao);
            return;
        }
        cadastro.setSituacao("OK");
    }

    private void calculaSituacaoDebitos(RastreamentoCadastroDTO cadastro, Boolean parametroConsideraContencioso, List<Feriado> feriados) {
        List debitos = cadastro.getDebitos();
        if (Objects.nonNull(debitos)) {
            boolean hasValorVencido = debitos.stream().anyMatch(rastreamentoDebitoDTO -> this.checkDebitoRastreamentoVencido(rastreamentoDebitoDTO, feriados));
            boolean hasValorAVencer = debitos.stream().anyMatch(rastreamentoDebitoDTO -> this.checkDebitoRastreamentoAVencer(rastreamentoDebitoDTO, feriados));
            boolean todosDebitosVencidosTemContencioso = debitos.stream().filter(debito -> debito.getVencido() != false && BigDecimal.ZERO.compareTo(debito.getValor()) < 0).map(RastreamentoDebitoDTO::getIdContencioso).allMatch(Objects::nonNull);
            if (hasValorVencido) {
                cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA);
                if (parametroConsideraContencioso.booleanValue() && todosDebitosVencidosTemContencioso) {
                    cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA);
                }
            } else if (!hasValorAVencer) {
                cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.NEGATIVA);
            } else {
                cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA);
            }
        } else {
            cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.NEGATIVA);
        }
    }

    private boolean checkDebitoRastreamentoAVencer(RastreamentoDebitoDTO debito, List<Feriado> feriados) {
        debito.setDataVencimento(this.diaUtilService.validateDiaUtil(debito.getDataVencimento(), feriados));
        debito.setDataVencimentoCotaUnica(Objects.nonNull(debito.getDataVencimentoCotaUnica()) ? debito.getDataVencimentoCotaUnica() : LocalDate.now().with(TemporalAdjusters.firstDayOfYear()));
        return BigDecimal.ZERO.compareTo(debito.getValor()) < 0 && (debito.getAVencer() != false || debito.getVencido() != false && debito.isVencidoCotaUnica() == false);
    }

    private boolean checkDebitoRastreamentoVencido(RastreamentoDebitoDTO debito, List<Feriado> feriados) {
        debito.setDataVencimento(this.diaUtilService.validateDiaUtil(debito.getDataVencimento(), feriados));
        debito.setDataVencimentoCotaUnica(Objects.nonNull(debito.getDataVencimentoCotaUnica()) ? debito.getDataVencimentoCotaUnica() : LocalDate.now().with(TemporalAdjusters.firstDayOfYear()));
        return BigDecimal.ZERO.compareTo(debito.getValor()) < 0 && debito.getVencido() != false && debito.isVencidoCotaUnica() != false;
    }

    private Boolean emiteCertidaoCadastroMobiliario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.EMITE_CERTIDAO_CAD_MOBILIARIO);
    }

    private void validarCadastro(CadastroGeral cadastro) {
        if (Objects.isNull(cadastro)) {
            throw new CadastroNaoEncontradoException();
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastro.getTipoCadastro()) && !this.emiteCertidaoCadastroMobiliario().booleanValue()) {
            throw RastreamentoException.tipoCadastroInvalido();
        }
    }

    private Boolean consideraCadastroAvulso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_AVULSO_RASTREAMENTO);
    }

    private Boolean consideraCnpjRaiz() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CNPJ_RAIZ_RASTREAMENTO);
    }

    private Boolean consideraSocios() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_SOCIO_RASTREAMENTO);
    }

    private Boolean consideraContencioso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CONTENCIOSO_CND);
    }

    private String consideraUrlSgo() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.URL_SGO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private static Set<String> getSituacoesPositivasFintel() {
        return Set.of(TipoSituacaoDebitoFintel.OCORRENCIA.getDescricao(), TipoSituacaoDebitoFintel.ISS_VENCIDO.getDescricao());
    }

    private static Set<String> getSituacoesPositivasComEfeitoNegativaFintel() {
        return Set.of(TipoSituacaoDebitoFintel.POSITIVA_NEGATIVA.getDescricao());
    }

    @Generated
    public RastreamentoMaringaService(CadastroGeralService cadastroGeralService, PessoaService pessoaService, RastreamentoMaringaRepository rastreamentoMaringaRepository, ParametroGeralService parametroGeralService, DiaUtilService diaUtilService, RestTemplate restTemplate, RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader, ReportFileResolverFactory reportFileResolverFactory, ObjectMapper objectMapper, FeriadoRepository feriadoRepository, CalculoAcrescimoService calculoAcrescimoService, FormaPagamentoService formaPagamentoService, ContextService contextService, ArquivoJasperService arquivoJasperService) {
        this.cadastroGeralService = cadastroGeralService;
        this.pessoaService = pessoaService;
        this.rastreamentoMaringaRepository = rastreamentoMaringaRepository;
        this.parametroGeralService = parametroGeralService;
        this.diaUtilService = diaUtilService;
        this.restTemplate = restTemplate;
        this.rastreamentoCadastralParamLoader = rastreamentoCadastralParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.objectMapper = objectMapper;
        this.feriadoRepository = feriadoRepository;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.formaPagamentoService = formaPagamentoService;
        this.contextService = contextService;
        this.arquivoJasperService = arquivoJasperService;
    }
}

