/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.projeto.construtora;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Profissional;
import br.com.elotech.tributos.domain.ProfissionalId;
import br.com.elotech.tributos.domain.projeto.construtora.Construtora;
import br.com.elotech.tributos.dto.ProfissionalDTO;
import br.com.elotech.tributos.dto.projeto.construtora.ConstrutoraDTO;
import br.com.elotech.tributos.service.ProfissionalService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ConstrutoraService
extends CrudService<Construtora, Long> {
    private final ProfissionalService profissionalService;

    public Page<ConstrutoraDTO> findByRsqlConstrutoraDTO(String search, Pageable pageable) {
        Page construtoras = this.findByRsql(search, pageable);
        return construtoras.map(c -> ConstrutoraDTO.from((Construtora)c, (List)this.findProfissionaisByConstrutora(c)));
    }

    public ConstrutoraDTO findOneConstrutoraDTO(Long id) {
        Construtora construtora = (Construtora)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a construtora com id " + id));
        return ConstrutoraDTO.from((Construtora)construtora, (List)this.findProfissionaisByConstrutora(construtora));
    }

    public List<ProfissionalDTO> findProfissionaisByConstrutora(Construtora construtora) {
        List ids = construtora.getProfissionais().stream().map(Profissional::getId).map(ProfissionalId::getPessoa).map(Pessoa::getId).collect(Collectors.toList());
        return this.profissionalService.findAllByIdProfissionalDTO(ids);
    }

    @Generated
    public ConstrutoraService(ProfissionalService profissionalService) {
        this.profissionalService = profissionalService;
    }
}

