/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.projeto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.service.CalculoProjetoService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.Utilizacao;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoDebito;
import br.com.elotech.tributos.domain.projeto.ProjetoItem;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.domain.projeto.TipoObra;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.DebitoProjetoManualDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.GerarParcelasDebitoDTO;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.dto.projeto.CalculoProjetoAggregateKey;
import br.com.elotech.tributos.dto.projeto.CalculoProjetoDTO;
import br.com.elotech.tributos.dto.projeto.TipoGeracaoDebitoProjeto;
import br.com.elotech.tributos.params.CalculoProjetoParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.projeto.ProjetoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class GeracaoDebitoProjetoService {
    private CalculoProjetoService calculoProjetoService;
    private GeraDebitoService geraDebitoService;
    private GeraBoletoService geraBoletoService;
    private ProjetoService projetoService;
    private ContextService contextService;
    private DebitoService debitoService;
    private static final BigDecimal CEM_PORCENTO = BigDecimal.valueOf(100L);

    public void validateTributoMenorOuIgualAZero(BigDecimal valorTributo) {
        if (valorTributo == null || valorTributo.compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException("O valor do tributo deve ser maior que zero!");
        }
    }

    public List<DebitoManualParcelaDTO> simulateDebitoPorTipoDeObra(DebitoProjetoManualDTO request) {
        this.updateDadosProjeto(request);
        Projeto projeto = request.getProjetoEntity();
        this.validateProjeto(projeto);
        BigDecimal valorTributo = this.calculateValorTributoPorTipoObra(projeto.getTipoObra(), projeto.getArea());
        List tributoDTOS = this.buildDebitoManualTributoDTO(request.getTributo().getTributo(), valorTributo);
        BigDecimal percentualEntrada = projeto.getTipoProjeto().getPercentualDeEntrada();
        return this.gerarParcelas(request, tributoDTOS, percentualEntrada);
    }

    public List<DebitoManualParcelaDTO> simulateDebitoPorFormula(DebitoProjetoManualDTO request) {
        this.updateDadosProjeto(request);
        Projeto projeto = request.getProjetoEntity();
        CalculoProjetoDTO formula = !request.getFormulas().isEmpty() ? (CalculoProjetoDTO)request.getFormulas().get(0) : (CalculoProjetoDTO)request.getFormulasProjeto().get(0);
        List tributos = null;
        tributos = TipoCalculoConfig.GERAL.equals((Object)formula.getTipoCalculoConfig()) ? this.geraTributosPorProjetoFormula(projeto, formula.getDivida().getDivida(), Collections.singletonList(formula.getTributo().getTributo())) : (Objects.nonNull(formula.getUtilizacao()) && Boolean.TRUE.equals(formula.getUtilizacao().getCalculoPorUtilizacao()) ? this.geraTributosPorUtilizacaoFormula(projeto, formula.getDivida().getDivida(), Collections.singletonList(formula.getTributo().getTributo()), formula.getUtilizacao()) : this.geraTributosPorFormula(projeto, formula));
        return this.gerarParcelas(request, tributos, BigDecimal.ZERO);
    }

    public List<BloquetoDTO> generateDebitoManual(DebitoProjetoManualDTO request) {
        this.updateDadosProjeto(request);
        Projeto projeto = request.getProjetoEntity();
        Long codigoDivida = request.getDivida();
        String tributo = request.getTributo().getTributo();
        String descricaoTributo = request.getTributo().getDescricao();
        BigDecimal valorTributo = request.getValor();
        this.validateTributoMenorOuIgualAZero(valorTributo);
        List tributos = this.buildDebitoManualTributoDTO(tributo, valorTributo);
        List parcelas = this.gerarParcelas(request, tributos, BigDecimal.ZERO);
        DebitoIdDTO debitoIdDTO = this.generateDebito(request, parcelas, tributos, codigoDivida, BigDecimal.ZERO, List.of(descricaoTributo), null);
        this.addDebitoInProjeto(projeto, null, null, debitoIdDTO);
        this.saveProjeto(projeto);
        Map parcelasAgrupadas = this.createDebitoParcelaAggregatedByNumeroParcela(List.of(debitoIdDTO), request.getNumeroParcelas());
        Long responsavelObra = Optional.ofNullable(projeto.getResponsavel()).map(Pessoa::getId).orElse(null);
        List bloquetos = this.generateAggregatedBoleto(parcelasAgrupadas, request.getDataVencimento(), responsavelObra);
        return this.geraBoletoService.resolveUrlImpressaoBoleto(bloquetos, Boolean.valueOf(false));
    }

    public DebitoIdDTO generateDebitoPorTipoDeObra(DebitoProjetoManualDTO request) {
        this.updateDadosProjeto(request);
        Projeto projeto = request.getProjetoEntity();
        this.validateProjeto(projeto);
        Long codigoDivida = request.getDivida();
        String tributo = request.getTributo().getTributo();
        String descricaoTributo = request.getTributo().getTributo();
        BigDecimal percentualEntrada = projeto.getTipoProjeto().getPercentualDeEntrada();
        BigDecimal valorTributo = this.calculateValorTributoPorTipoObra(projeto.getTipoObra(), projeto.getArea());
        List tributos = this.buildDebitoManualTributoDTO(tributo, valorTributo);
        List parcelas = this.gerarParcelas(request, tributos, percentualEntrada);
        DebitoIdDTO debitoIdDTO = this.generateDebito(request, parcelas, tributos, codigoDivida, percentualEntrada, List.of(descricaoTributo), null);
        this.addDebitoInProjeto(projeto, null, null, debitoIdDTO);
        this.saveProjeto(projeto);
        return debitoIdDTO;
    }

    @Transactional
    public List<BloquetoDTO> generateDebitoFormulaCalculo(DebitoProjetoManualDTO request) {
        ArrayList debitosGerados = new ArrayList();
        this.updateDadosProjeto(request);
        Projeto projeto = request.getProjetoEntity();
        List formulasProjeto = request.getFormulasProjeto();
        Map tributosPorProjetoEDivida = this.aggregateTributosByProjetoAndDivida(formulasProjeto);
        tributosPorProjetoEDivida.forEach((key, values) -> {
            List tributos = values.stream().map(TributoDTO::getTributo).collect(Collectors.toList());
            List descricoesTributos = values.stream().map(TributoDTO::getDescricaoTributo).collect(Collectors.toList());
            Long divida = key.getDivida();
            List receitas = this.geraTributosPorProjetoFormula(projeto, divida, tributos);
            List parcelas = this.gerarParcelas(request, receitas, BigDecimal.ZERO);
            DebitoIdDTO debitoIdDTO = this.generateDebito(request, parcelas, receitas, divida, BigDecimal.ZERO, descricoesTributos, null);
            this.addDebitoInProjeto(projeto, null, null, debitoIdDTO);
            debitosGerados.add(debitoIdDTO);
        });
        List<CalculoProjetoDTO> formulasComUtilizacao = request.getFormulas().stream().filter(f -> Objects.nonNull(f.getUtilizacao()) && Boolean.TRUE.equals(f.getUtilizacao().getCalculoPorUtilizacao())).toList();
        Map tributosPorProjetoUtilizacaoEDivida = this.aggregateTributosByProjetoUtilizacaoAndDivida(formulasComUtilizacao);
        tributosPorProjetoUtilizacaoEDivida.forEach((key, values) -> {
            List tributos = values.stream().map(TributoDTO::getTributo).collect(Collectors.toList());
            List descricoesTributos = values.stream().map(TributoDTO::getDescricaoTributo).collect(Collectors.toList());
            Utilizacao utilizacao = key.getUtilizacao();
            Long divida = key.getDivida();
            List receitas = this.geraTributosPorUtilizacaoFormula(projeto, divida, tributos, utilizacao);
            List parcelas = this.gerarParcelas(request, receitas, BigDecimal.ZERO);
            DebitoIdDTO debitoIdDTO = this.generateDebito(request, parcelas, receitas, divida, BigDecimal.ZERO, descricoesTributos, null, utilizacao);
            this.addDebitoInProjeto(projeto, null, utilizacao, debitoIdDTO);
            debitosGerados.add(debitoIdDTO);
        });
        List<CalculoProjetoDTO> formulasSemUtilizacao = request.getFormulas().stream().filter(f -> Objects.isNull(f.getUtilizacao()) || !Boolean.TRUE.equals(f.getUtilizacao().getCalculoPorUtilizacao())).toList();
        Map tributosPorProjetoItemEDivida = this.aggregateTributosByProjetoItemAndDivida(formulasSemUtilizacao);
        tributosPorProjetoItemEDivida.forEach((key, values) -> {
            List tributos = values.stream().map(TributoDTO::getTributo).collect(Collectors.toList());
            List descricoesTributos = values.stream().map(TributoDTO::getDescricaoTributo).collect(Collectors.toList());
            Long projetoItem = key.getProjetoItem();
            Long divida = key.getDivida();
            List receitas = this.geraTributosPorFormula(projeto, divida, tributos, projetoItem);
            List parcelas = this.gerarParcelas(request, receitas, BigDecimal.ZERO);
            DebitoIdDTO debitoIdDTO = this.generateDebito(request, parcelas, receitas, divida, BigDecimal.ZERO, descricoesTributos, projetoItem);
            this.addDebitoInProjeto(projeto, projetoItem, null, debitoIdDTO);
            debitosGerados.add(debitoIdDTO);
        });
        this.saveProjeto(projeto);
        Map parcelasAgrupadas = this.createDebitoParcelaAggregatedByNumeroParcela(debitosGerados, request.getNumeroParcelas());
        Long responsavelObra = Optional.ofNullable(projeto.getResponsavel()).map(Pessoa::getId).orElse(null);
        List bloquetos = this.generateAggregatedBoleto(parcelasAgrupadas, request.getDataVencimento(), responsavelObra);
        return this.geraBoletoService.resolveUrlImpressaoBoleto(bloquetos, Boolean.valueOf(false));
    }

    private Map<CalculoProjetoAggregateKey, List<TributoDTO>> aggregateTributosByProjetoItemAndDivida(List<CalculoProjetoDTO> formulas) {
        return formulas.stream().collect(Collectors.groupingBy(CalculoProjetoDTO::buildKeyItem, Collectors.mapping(CalculoProjetoDTO::getTributo, Collectors.toList())));
    }

    private Map<CalculoProjetoAggregateKey, List<TributoDTO>> aggregateTributosByProjetoUtilizacaoAndDivida(List<CalculoProjetoDTO> formulas) {
        return formulas.stream().collect(Collectors.groupingBy(CalculoProjetoDTO::buildKeyUtilizacao, Collectors.mapping(CalculoProjetoDTO::getTributo, Collectors.toList())));
    }

    private Map<CalculoProjetoAggregateKey, List<TributoDTO>> aggregateTributosByProjetoAndDivida(List<CalculoProjetoDTO> formulas) {
        return formulas.stream().collect(Collectors.groupingBy(CalculoProjetoDTO::buildKeyProjeto, Collectors.mapping(CalculoProjetoDTO::getTributo, Collectors.toList())));
    }

    private List<DebitoManualTributoDTO> geraTributosPorFormula(Projeto projeto, CalculoProjetoDTO formula) {
        Long divida = formula.getDivida().getDivida();
        String tributo = formula.getTributo().getTributo();
        Long projetoItem = formula.getProjetoItem();
        return this.geraTributosPorFormula(projeto, divida, List.of(tributo), projetoItem);
    }

    private List<DebitoManualTributoDTO> geraTributosPorFormula(Projeto projeto, Long divida, List<String> tributo, Long projetoItem) {
        Long exercicioAtual = this.contextService.getExercicioAtual();
        ProjetoPK projetoPK = projeto.getId();
        CalculoProjetoParams params = CalculoProjetoParams.from((ProjetoPK)projetoPK, (Long)projetoItem, (Long)0L);
        return this.calculoProjetoService.geraTributosParaDebito(exercicioAtual, divida, tributo, params);
    }

    private List<DebitoManualTributoDTO> geraTributosPorProjetoFormula(Projeto projeto, Long divida, List<String> tributo) {
        Long exercicioAtual = this.contextService.getExercicioAtual();
        ProjetoPK projetoPK = projeto.getId();
        CalculoProjetoParams params = CalculoProjetoParams.from((ProjetoPK)projetoPK, (Long)0L, (Long)0L);
        return this.calculoProjetoService.geraTributosParaDebito(exercicioAtual, divida, tributo, params);
    }

    private List<DebitoManualTributoDTO> geraTributosPorUtilizacaoFormula(Projeto projeto, Long divida, List<String> tributo, Utilizacao utilizacao) {
        Long exercicioAtual = this.contextService.getExercicioAtual();
        ProjetoPK projetoPK = projeto.getId();
        CalculoProjetoParams params = CalculoProjetoParams.from((ProjetoPK)projetoPK, (Long)0L, (Long)utilizacao.getId());
        return this.calculoProjetoService.geraTributosParaDebito(exercicioAtual, divida, tributo, params);
    }

    private List<BloquetoDTO> generateAggregatedBoleto(Map<Long, List<DebitoParcelaDTO>> parcelasAgrupadas, LocalDate dataVencimento, Long responsavelObra) {
        return parcelasAgrupadas.entrySet().stream().map(entry -> this.createBloqueto(entry, dataVencimento, responsavelObra)).flatMap(Collection::stream).map(Bloqueto::toBloquetoDTO).collect(Collectors.toList());
    }

    private Map<Long, List<DebitoParcelaDTO>> createDebitoParcelaAggregatedByNumeroParcela(List<DebitoIdDTO> debitos, Long quantidadeParcelas) {
        HashMap<Long, List<DebitoParcelaDTO>> parcelasAgrupadas = new HashMap<Long, List<DebitoParcelaDTO>>();
        for (DebitoIdDTO id : debitos) {
            int i = 1;
            while ((long)i <= quantidadeParcelas) {
                Long numeroParcela = i;
                DebitoParcelaDTO novaParcela = DebitoParcelaDTO.from((Long)id.getIdDebito(), (Long)numeroParcela);
                List parcelas = parcelasAgrupadas.getOrDefault(numeroParcela, new ArrayList());
                parcelas.add(novaParcela);
                parcelasAgrupadas.put(numeroParcela, parcelas);
                ++i;
            }
        }
        return parcelasAgrupadas;
    }

    private List<Bloqueto> createBloqueto(Map.Entry<Long, List<DebitoParcelaDTO>> entry, LocalDate dataVencimento, Long responsavelObra) {
        GeraBoletoDTO dto = new GeraBoletoDTO();
        dto.setTipoBoleto(TipoBloqueto.AGRUPADO);
        dto.setOrigemEmissao(OrigemEmissao.AISE);
        dto.setDebitos(entry.getValue());
        dto.setDataVencimento(dataVencimento.plusMonths(entry.getKey() - 1L));
        dto.setPessoa(responsavelObra);
        return this.geraBoletoService.geraBoleto(dto);
    }

    private DebitoIdDTO generateDebito(DebitoProjetoManualDTO debitoProjetoManualDTO, List<DebitoManualParcelaDTO> parcelas, List<DebitoManualTributoDTO> tributos, Long divida, BigDecimal percentualEntrada, List<String> descricoesTributos, Long idProjetoItem) {
        return this.generateDebito(debitoProjetoManualDTO, parcelas, tributos, divida, percentualEntrada, descricoesTributos, idProjetoItem, null);
    }

    private DebitoIdDTO generateDebito(DebitoProjetoManualDTO debitoProjetoManualDTO, List<DebitoManualParcelaDTO> parcelas, List<DebitoManualTributoDTO> tributos, Long divida, BigDecimal percentualEntrada, List<String> descricoesTributos, Long idProjetoItem, Utilizacao utilizacao) {
        Projeto projeto = debitoProjetoManualDTO.getProjetoEntity();
        ArrayList<DebitoManualObservacaoDTO> observacoes = new ArrayList<DebitoManualObservacaoDTO>();
        DebitoManualObservacaoDTO observacao = this.buildDebitoManualObservacaoDTO(projeto);
        observacoes.add(observacao);
        this.addObservacaoInformadaPeloUsuario(debitoProjetoManualDTO.getObservacao(), observacoes);
        this.addObservacoesAreasProjeto(debitoProjetoManualDTO, descricoesTributos, idProjetoItem, utilizacao, projeto, observacoes);
        DebitoManualDTO debitoManualDTO = this.mountDebitoManualDTO(debitoProjetoManualDTO);
        debitoManualDTO.setParcelas(parcelas);
        debitoManualDTO.setTributos(tributos);
        debitoManualDTO.setDivida(divida);
        debitoManualDTO.setPercentualEntrada(percentualEntrada);
        debitoManualDTO.setObservacoes(observacoes);
        debitoManualDTO.setUsuario(SecurityUtils.getPreferredUsername());
        debitoManualDTO.setPrograma("Projeto");
        return this.doGenerateDebito(debitoManualDTO);
    }

    public void addObservacoesAreasProjeto(DebitoProjetoManualDTO debitoProjetoManualDTO, List<String> descricoesTributos, Long idProjetoItem, Utilizacao utilizacao, Projeto projeto, ArrayList<DebitoManualObservacaoDTO> observacoes) {
        if (!TipoGeracaoDebitoProjeto.MANUAL.equals((Object)debitoProjetoManualDTO.getTipoGeracao())) {
            if (Objects.nonNull(idProjetoItem)) {
                this.addObservacaoItemProjeto(projeto, idProjetoItem, descricoesTributos, observacoes);
            } else if (Objects.nonNull(utilizacao)) {
                this.addObservacaoItemUtilizacaoProjeto(projeto, utilizacao, descricoesTributos, observacoes);
            } else {
                this.addObservacaoProjeto(projeto, descricoesTributos, observacoes);
            }
        }
    }

    public void addObservacaoItemProjeto(Projeto projeto, Long idProjetoItem, List<String> descricoesTributos, List<DebitoManualObservacaoDTO> observacoes) {
        ProjetoItem projetoItem = projeto.getItens().stream().filter(i -> Objects.equals(i.getId(), idProjetoItem)).findFirst().orElse(null);
        if (Objects.nonNull(projetoItem)) {
            observacoes.add(this.buildDebitoManualObservacaoItensProjeto(projetoItem.getArea(), projetoItem.getUtilizacao(), descricoesTributos));
        }
    }

    public void addObservacaoItemUtilizacaoProjeto(Projeto projeto, Utilizacao utilizacao, List<String> descricoesTributos, List<DebitoManualObservacaoDTO> observacoes) {
        BigDecimal areaTotal = projeto.getItens().stream().filter(i -> Objects.equals(i.getUtilizacao().getId(), utilizacao.getId())).map(i -> Optional.ofNullable(i.getArea()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        observacoes.add(this.buildDebitoManualObservacaoItensProjeto(areaTotal, utilizacao, descricoesTributos));
    }

    public void addObservacaoProjeto(Projeto projeto, List<String> descricoesTributos, List<DebitoManualObservacaoDTO> observacoes) {
        observacoes.add(this.buildDebitoManualObservacaoItensProjeto(projeto.getArea(), null, descricoesTributos));
    }

    public DebitoManualObservacaoDTO buildDebitoManualObservacaoItensProjeto(BigDecimal area, Utilizacao utilizacao, List<String> descricoesTributos) {
        return DebitoManualObservacaoDTO.of((String)String.format("%s %s: %.2f M\u00b2", Objects.nonNull(descricoesTributos) && !descricoesTributos.isEmpty() ? String.join((CharSequence)", ", descricoesTributos) : "", Optional.ofNullable(utilizacao).map(u -> String.format("(%s)", u.getDescricao())).orElse(""), area));
    }

    private void addObservacaoInformadaPeloUsuario(String observacao, List<DebitoManualObservacaoDTO> observacoes) {
        if (StringUtils.isNotBlank((CharSequence)observacao)) {
            observacoes.add(DebitoManualObservacaoDTO.of((String)observacao));
        }
    }

    private DebitoIdDTO doGenerateDebito(DebitoManualDTO debitoManualDTO) {
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    private DebitoManualDTO mountDebitoManualDTO(DebitoProjetoManualDTO debitoProjetoManualDTO) {
        return DebitoManualDTO.builder().exercicio(debitoProjetoManualDTO.getExercicio()).tipoCadastro(debitoProjetoManualDTO.getTipoCadastro()).cadastroGeral(debitoProjetoManualDTO.getCadastroGeral()).divida(debitoProjetoManualDTO.getDivida()).dataInclusao(LocalDate.now()).dataLancamento(debitoProjetoManualDTO.getDataLancamento()).build();
    }

    public ProjetoDebito buildProjetoDebito(Projeto projeto, DebitoIdDTO debitoIdDTO) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
        ProjetoDebito projetoDebito = new ProjetoDebito();
        projetoDebito.setDebito(debito);
        projetoDebito.setProjeto(projeto);
        projetoDebito.setExercicioDebito(debito.getExercicio());
        projetoDebito.setTipoCadastro(debito.getTipoCadastro());
        projetoDebito.setCadastroGeral(debito.getCadastroGeralId());
        projetoDebito.setDivida(debito.getGuiaRecolhimento());
        projetoDebito.setSubDivida(debito.getSubDivida());
        return projetoDebito;
    }

    public List<DebitoManualTributoDTO> buildDebitoManualTributoDTO(String tributo, BigDecimal valorTributo) {
        DebitoManualTributoDTO tributoDTO = new DebitoManualTributoDTO();
        tributoDTO.setTributo(tributo);
        tributoDTO.setValorTributo(valorTributo);
        ArrayList<DebitoManualTributoDTO> tributoDTOS = new ArrayList<DebitoManualTributoDTO>();
        tributoDTOS.add(tributoDTO);
        return tributoDTOS;
    }

    public GerarParcelasDebitoDTO buildGerarParcelasDebitoDTO(DebitoProjetoManualDTO request, List<DebitoManualTributoDTO> tributoDTOS, BigDecimal percentualEntrada) {
        GerarParcelasDebitoDTO gerarParcelasDebitoDTO = new GerarParcelasDebitoDTO();
        gerarParcelasDebitoDTO.setParcelaInicial(Long.valueOf(1L));
        gerarParcelasDebitoDTO.setQuantidadeParcelas(request.getNumeroParcelas());
        gerarParcelasDebitoDTO.setDataVencimentoInicial(request.getDataVencimento());
        gerarParcelasDebitoDTO.setTributos(tributoDTOS);
        gerarParcelasDebitoDTO.setPercentualEntrada(percentualEntrada);
        return gerarParcelasDebitoDTO;
    }

    public DebitoManualObservacaoDTO buildDebitoManualObservacaoDTO(Projeto projeto) {
        return DebitoManualObservacaoDTO.of((String)String.format("D\u00e9bito gerado pelo projeto %d/%d", projeto.getId().getProjeto(), projeto.getId().getExercicio()));
    }

    public BigDecimal calculateValorTributoPorTipoObra(TipoObra tipoObra, BigDecimal area) {
        BigDecimal baseCalculo = tipoObra.getBaseCalculo().divide(CEM_PORCENTO, 4, RoundingMode.HALF_EVEN);
        BigDecimal custoBasico = tipoObra.getCustoBasico();
        BigDecimal aliquota = tipoObra.getAliquota().divide(CEM_PORCENTO, 4, RoundingMode.HALF_EVEN);
        BigDecimal valorTributo = area.multiply(baseCalculo).multiply(custoBasico).multiply(aliquota).setScale(2, RoundingMode.HALF_EVEN);
        this.validateTributoMenorOuIgualAZero(valorTributo);
        return valorTributo;
    }

    private void addDebitoInProjeto(Projeto projeto, Long projetoItem, Utilizacao utilizacao, DebitoIdDTO debitoIdDTO) {
        ProjetoDebito projetoDebito = this.buildProjetoDebito(projeto, debitoIdDTO);
        projetoDebito.setProjetoItem(projetoItem);
        projetoDebito.setUtilizacao(utilizacao);
        projeto.getDebitos().add(projetoDebito);
    }

    private void saveProjeto(Projeto projeto) {
        this.projetoService.save((EloEntity)projeto, (Authentication)null);
    }

    private void updateDadosProjeto(DebitoProjetoManualDTO request) {
        this.projetoService.updateDadosProjeto(request);
    }

    private void validateProjeto(Projeto projeto) {
        this.projetoService.validateProjeto(projeto);
    }

    private List<DebitoManualParcelaDTO> gerarParcelas(DebitoProjetoManualDTO request, List<DebitoManualTributoDTO> tributoDTOS, BigDecimal percentualEntrada) {
        GerarParcelasDebitoDTO geraParcelasDTO = this.buildGerarParcelasDebitoDTO(request, tributoDTOS, percentualEntrada);
        if (geraParcelasDTO.getPercentualEntrada().compareTo(BigDecimal.ZERO) > 0 && geraParcelasDTO.getQuantidadeParcelas().intValue() - 1 > 0) {
            return this.geraDebitoService.gerarParcelasComPercentualDeEntrada(geraParcelasDTO);
        }
        return this.geraDebitoService.gerarParcelas(geraParcelasDTO);
    }

    @Generated
    public GeracaoDebitoProjetoService(CalculoProjetoService calculoProjetoService, GeraDebitoService geraDebitoService, GeraBoletoService geraBoletoService, ProjetoService projetoService, ContextService contextService, DebitoService debitoService) {
        this.calculoProjetoService = calculoProjetoService;
        this.geraDebitoService = geraDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.projetoService = projetoService;
        this.contextService = contextService;
        this.debitoService = debitoService;
    }
}

