/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.pagamentocredito;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.dto.pagamentocredito.PagamentoCreditoPageDTO;
import br.com.elotech.tributos.dto.pagamentocredito.PagamentoCreditoTotalizadorDTO;
import br.com.elotech.tributos.enums.pagamentocredito.OrigemCredito;
import br.com.elotech.tributos.repository.PagamentoDebitoRepository;
import br.com.elotech.tributos.repository.PagamentoRepository;
import br.com.elotech.tributos.repository.pagamentocredito.PagamentoCreditoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class CreditoService
extends CrudService<PagamentoCredito, Long> {
    private final PagamentoCreditoRepository repository;
    private final PagamentoRepository pagamentoRepository;
    private final PagamentoDebitoRepository pagamentoDebitoRepository;

    public List<PagamentoCredito> findAllById(List<Long> ids) {
        return this.repository.findAllById(ids);
    }

    public PagamentoCreditoPageDTO findByRsqlWithTotal(String search, Pageable pageable) {
        Page page = this.findByRsql(search, pageable);
        PagamentoCreditoTotalizadorDTO totalizador = this.findTotais(search);
        return PagamentoCreditoPageDTO.from((Page)page, (PagamentoCreditoTotalizadorDTO)totalizador);
    }

    public PagamentoCredito findByPagamentoId(PagamentoId pagamentoId) {
        Pagamento pagamento = (Pagamento)this.pagamentoRepository.findById((Object)pagamentoId).orElseThrow(() -> new EntityNotFoundException(String.format("Pagamento %d/%s n\u00e3o encontrado", pagamentoId.getPagamento(), pagamentoId.getExercicioPagamento())));
        return (PagamentoCredito)this.findByPagamentoOrigem(pagamento).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o encontrado cr\u00e9dito para o pagamento %s/%s", pagamentoId.getPagamento(), pagamentoId.getExercicioPagamento())));
    }

    public Optional<PagamentoCredito> findOptionalByPagamentoId(PagamentoId pagamentoId) {
        return this.pagamentoRepository.findById((Object)pagamentoId).flatMap(arg_0 -> this.findByPagamentoOrigem(arg_0));
    }

    public Optional<PagamentoCredito> findByPagamentoOrigem(Pagamento pagamentoOrigem) {
        return this.repository.findOneByPagamentoOrigem(pagamentoOrigem);
    }

    public Optional<PagamentoCredito> findByCreditoOrigem(PagamentoCredito creditoOrigem) {
        return this.repository.findOneByCreditoOrigem(creditoOrigem);
    }

    public List<PagamentoCredito> findCreditoByBoletoPago(Bloqueto boletoPago) {
        return this.repository.findByBoletoPago(boletoPago);
    }

    public PagamentoCredito novoCredito(Pagamento pagamento, OrigemCredito origemCredito) {
        PagamentoCredito pagamentoCredito = PagamentoCredito.makeTo((Pagamento)pagamento, (OrigemCredito)origemCredito, (Boolean)OrigemCredito.PAGO_MAIOR.equals((Object)origemCredito));
        return (PagamentoCredito)this.repository.save((Object)pagamentoCredito);
    }

    public PagamentoCredito novoCredito(PagamentoCredito credito, OrigemCredito origemCredito) {
        PagamentoCredito pagamentoCredito = PagamentoCredito.makeTo((PagamentoCredito)credito, (OrigemCredito)origemCredito);
        return (PagamentoCredito)this.repository.save((Object)pagamentoCredito);
    }

    public void transferirCredito(PagamentoCredito creditoTranferir, OrigemCredito origemCredito) {
        PagamentoCredito creditoTransferido = this.novoCredito(creditoTranferir, origemCredito);
        creditoTranferir.novaMovimentacao(creditoTransferido, SecurityUtils.getPreferredUsername());
        this.save(creditoTranferir);
    }

    public Map<PagamentoCredito, List<Bloqueto>> usarCredito(List<Bloqueto> bloquetos) {
        List creditos = this.repository.getPagamentoCreditoDisponiveis();
        return this.usarCredito(creditos, bloquetos);
    }

    public Map<PagamentoCredito, List<Bloqueto>> usarCredito(List<PagamentoCredito> creditos, List<Bloqueto> bloquetos) {
        if (this.totalDeSaldoContemplaTotalBoletos(creditos, bloquetos)) {
            return this.compensarCreditos(creditos, bloquetos);
        }
        throw new RestException(HttpStatus.BAD_REQUEST, "A somat\u00f3ria dos cr\u00e9ditos deve ser igual ou maior \u00e0 soma dos boletos a serem pagos");
    }

    public PagamentoCredito save(PagamentoCredito pagamentoCredito) {
        return (PagamentoCredito)this.save((EloEntity)pagamentoCredito, null);
    }

    public List<PagamentoCredito> save(List<PagamentoCredito> creditos) {
        return this.repository.saveAll(creditos);
    }

    public void remove(PagamentoCredito pagamentoCredito) {
        if (!pagamentoCredito.getMovimentacoes().isEmpty()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel excluir cr\u00e9dito com movimenta\u00e7\u00f5es.");
        }
        this.repository.delete((Object)pagamentoCredito);
    }

    private Map<PagamentoCredito, List<Bloqueto>> compensarCreditos(List<PagamentoCredito> creditos, List<Bloqueto> bloquetos) {
        String usuario = SecurityUtils.getPreferredUsername();
        HashMap<PagamentoCredito, List<Bloqueto>> responseTable = new HashMap<PagamentoCredito, List<Bloqueto>>();
        int indexCreditoACompensar = 0;
        for (Bloqueto bloqueto : bloquetos) {
            BigDecimal valorRestante = bloqueto.getValorBloqueto();
            while (valorRestante.compareTo(BigDecimal.ZERO) > 0) {
                PagamentoCredito credito = creditos.get(indexCreditoACompensar);
                BigDecimal valorAAbater = credito.existeSaldoParaOValor(valorRestante) ? valorRestante : credito.getSaldoDisponivel();
                credito.novaMovimentacao(valorAAbater, bloqueto, usuario);
                this.updateResponseTable(responseTable, credito, bloqueto);
                this.updatePagamentoDebito(credito, valorAAbater);
                if (!credito.existeSaldo()) {
                    ++indexCreditoACompensar;
                }
                valorRestante = valorRestante.subtract(valorAAbater).abs();
            }
        }
        return responseTable;
    }

    private void updatePagamentoDebito(PagamentoCredito credito, BigDecimal valorAAbater) {
        Optional.ofNullable(credito.getPagamentoOrigem()).ifPresent(pagamento -> {
            BigDecimal valorRestantePagamentoDebito = valorAAbater;
            List pagamentosDebito = pagamento.getPagamentoBoleto().getPagamentosDebito();
            ArrayList<PagamentoDebito> pagamentosToSave = new ArrayList<PagamentoDebito>();
            for (PagamentoDebito pagamentoDebito : pagamentosDebito) {
                if (valorRestantePagamentoDebito.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal saldoDisponivelPagamentoDebito = pagamentoDebito.getValorPago().subtract(Optional.ofNullable(pagamentoDebito.getValorDevolvido()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(pagamentoDebito.getValorAcerto()).orElse(BigDecimal.ZERO));
                if (saldoDisponivelPagamentoDebito.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal valorCompensadoPagamentoDebito = valorRestantePagamentoDebito.min(saldoDisponivelPagamentoDebito);
                pagamentoDebito.setValorAcerto(Optional.ofNullable(pagamentoDebito.getValorAcerto()).orElse(BigDecimal.ZERO).add(valorCompensadoPagamentoDebito));
                valorRestantePagamentoDebito = valorRestantePagamentoDebito.subtract(valorCompensadoPagamentoDebito);
                pagamentosToSave.add(pagamentoDebito);
            }
            Optional.of(pagamentosToSave).filter(a -> !a.isEmpty()).ifPresent(arg_0 -> ((PagamentoDebitoRepository)this.pagamentoDebitoRepository).saveAll(arg_0));
        });
    }

    private boolean totalDeSaldoContemplaTotalBoletos(List<PagamentoCredito> creditos, List<Bloqueto> bloquetos) {
        BigDecimal valorTotalDosDebito;
        BigDecimal valorTotalDeCreditos = creditos.stream().reduce(BigDecimal.ZERO, (acc, item) -> acc.add(item.getSaldoDisponivel()), BigDecimal::add);
        return valorTotalDeCreditos.compareTo(valorTotalDosDebito = bloquetos.stream().reduce(BigDecimal.ZERO, (acc, item) -> acc.add(item.getValorBloqueto()), BigDecimal::add)) >= 0;
    }

    private void updateResponseTable(Map<PagamentoCredito, List<Bloqueto>> responseTable, PagamentoCredito credito, Bloqueto bloqueto) {
        List bloquetos = responseTable.getOrDefault(credito, new ArrayList());
        bloquetos.add(bloqueto);
        responseTable.put(credito, bloquetos);
    }

    private PagamentoCreditoTotalizadorDTO findTotais(String search) {
        PagamentoCreditoTotalizadorDTO totalizador = new PagamentoCreditoTotalizadorDTO();
        Tuple tupleResultFiltrado = this.findColumnsSumValue(search, new String[]{"saldoDisponivel", "saldoOriginal"});
        totalizador.setSaldoDisponivelTotalFiltrado((BigDecimal)tupleResultFiltrado.get(0));
        totalizador.setSaldoOriginalTotalFiltrado((BigDecimal)tupleResultFiltrado.get(1));
        Tuple tupleResultGeral = this.findColumnsSumValue("", new String[]{"saldoDisponivel", "saldoOriginal"});
        totalizador.setSaldoDisponivelTotal((BigDecimal)tupleResultGeral.get(0));
        totalizador.setSaldoOriginalTotal((BigDecimal)tupleResultGeral.get(1));
        return totalizador;
    }

    private Tuple findColumnsSumValue(String search, String ... columns) {
        Specification spec = this.createSpecification(Optional.empty(), this.buildRsqlFilter(search));
        CriteriaBuilder criteriaBuilder = this.getEm().getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createTupleQuery();
        Root root = query.from(PagamentoCredito.class);
        query.where((Expression)spec.toPredicate(root, query, criteriaBuilder));
        List expressions = Arrays.stream(columns).map(column -> criteriaBuilder.sum((Expression)root.get(column))).collect(Collectors.toList());
        query.multiselect(expressions);
        return (Tuple)this.getEm().createQuery(query).getSingleResult();
    }

    @Generated
    public CreditoService(PagamentoCreditoRepository repository, PagamentoRepository pagamentoRepository, PagamentoDebitoRepository pagamentoDebitoRepository) {
        this.repository = repository;
        this.pagamentoRepository = pagamentoRepository;
        this.pagamentoDebitoRepository = pagamentoDebitoRepository;
    }
}

