/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.negociacaodebito;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteManualDTO;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.PagamentoNegociadoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.PagamentoLoteManualService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.negociacaodebito.NegociacaoDebitoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NegociacaoPagamentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NegociacaoPagamentoService.class);
    private final ContextService contextService;
    private final ConvenioService convenioService;
    private final DebitoService debitoService;
    private final EntityManager em;
    private final PagamentoLoteManualService pagamentoLoteManualService;
    private final PagamentoService pagamentoService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final PagamentoNegociadoRepository pagamentoNegociadoRepository;
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final NegociacaoDebitoService negociacaoDebitoService;

    public PagamentoNegociado gerar(ParametrosPagamentoNegociadoDTO parametros) {
        log.debug("Foi inicializado a gera\u00e7\u00e3o do pagamento negociado. ");
        log.debug("Preparando dados. ");
        Optional debitoParcialBaixados = parametros.getParcialmenteBaixados();
        log.debug("Gerando pagamento negociado. ");
        PagamentoNegociado pagamentoNegociado = this.criarPagamentoNegociado(parametros);
        if (debitoParcialBaixados.isPresent()) {
            DebitoPagamentoNegociadoDTO debitoOriginalAbatidoParcial = (DebitoPagamentoNegociadoDTO)debitoParcialBaixados.get();
            log.debug("Alterando a situa\u00e7\u00e3o da parcela origem {} abatida parcialmente no Pagamento negociado para {}", (Object)debitoOriginalAbatidoParcial.getParcela(), (Object)TipoEventoSituacaoParcelaEnum.PAGO_POR_PAGAMENTO_NEGOCIADO.getDescricao());
            this.updateSituacaoParcela(debitoOriginalAbatidoParcial);
        }
        log.debug("Gerando pagamento dos d\u00e9bitos Abatidos. ");
        pagamentoNegociado.setPagamentoGerado(this.gerarPagamentoDosDebitosAbatidos(parametros));
        log.debug("Pagamento negociado gerado com sucesso");
        pagamentoNegociado = (PagamentoNegociado)this.pagamentoNegociadoRepository.save((Object)pagamentoNegociado);
        this.insereObservacoes(pagamentoNegociado);
        return pagamentoNegociado;
    }

    private void createNovoDebitoNegociacao(DebitoPagamentoNegociadoDTO parcial, PagamentoNegociado negociacao) {
        DebitoIdDTO debitoNovoID = this.negociacaoDebitoService.gerarNovoDebito(parcial, "PagamentoNegociado");
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoNovoID.getIdDebito());
        DebitoParcela debitoParcelaOrigem = (DebitoParcela)this.debitoParcelaRepository.findOne((Object)DebitoParcelaId.from((DebitoPagamentoNegociadoDTO)parcial));
        PagamentoNegociadoDebNovo novoDebitoNegociacao = PagamentoNegociadoDebNovo.from((PagamentoNegociado)negociacao, (String)"Pagamento negociado novo gerado atrav\u00e9s do Oxy", (DebitoParcela)((DebitoParcela)debito.getParcelas().get(0)), (DebitoParcela)debitoParcelaOrigem);
        negociacao.setDebitosNovos(Collections.singletonList(novoDebitoNegociacao));
        negociacao.setValorDebitoNovo(novoDebitoNegociacao.getDebitoNovo().getValorTotal());
    }

    private void updateSituacaoParcela(DebitoPagamentoNegociadoDTO debitoPagamentoNegociado) {
        this.debitoParcelaRepository.findById((Object)DebitoParcelaId.from((DebitoPagamentoNegociadoDTO)debitoPagamentoNegociado)).ifPresent(debitoParcela -> {
            debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.PAGO_POR_PAGAMENTO_NEGOCIADO, debitoParcela.getSituacaoDebito()));
            this.debitoParcelaRepository.save(debitoParcela);
        });
    }

    private PagamentoNegociado criarPagamentoNegociado(ParametrosPagamentoNegociadoDTO parametros) {
        Convenio convenio = (Convenio)this.convenioService.findOne((Serializable)parametros.getDadosPagamento().getConvenio().getId());
        PagamentoNegociado pagamentoNegociado = PagamentoNegociado.from((ParametrosPagamentoNegociadoDTO)parametros, (Convenio)convenio);
        pagamentoNegociado.setDebitosOrigem(this.negociacaoDebitoService.createDebitosOrigem(parametros, pagamentoNegociado));
        parametros.getParcialmenteBaixados().ifPresent(p -> this.createNovoDebitoNegociacao(p, pagamentoNegociado));
        pagamentoNegociado.setEntidade(this.contextService.getEntidadePrincipal());
        return pagamentoNegociado;
    }

    private Pagamento gerarPagamentoDosDebitosAbatidos(ParametrosPagamentoNegociadoDTO parametros) {
        Convenio convenio = (Convenio)this.convenioService.findOne((Serializable)parametros.getDadosPagamento().getConvenio().getId());
        Bloqueto boleto = this.negociacaoDebitoService.createBoleto(parametros);
        this.em.detach((Object)boleto);
        LocalDate dataCredito = parametros.getDadosPagamento().getDataCredito();
        PagamentoLoteManualDTO pagamentoLoteManualDTO = PagamentoLoteManualDTO.from((Bloqueto)boleto, (Long)convenio.getId(), (LocalDate)dataCredito, (Long)this.contextService.getExercicioAtual(), (LocalDate)dataCredito);
        PagamentoLoteDTO pagamentoLoteDTO = this.pagamentoLoteManualService.salvarPagamentoLote(pagamentoLoteManualDTO);
        PagamentoLoteId pagamentoLoteID = new PagamentoLoteId();
        pagamentoLoteID.setLote(pagamentoLoteDTO.getLote());
        pagamentoLoteID.setExercicio(pagamentoLoteDTO.getExercicio());
        pagamentoLoteID.setEntidade(pagamentoLoteDTO.getEntidade());
        return (Pagamento)this.pagamentoService.buscarPagamentosPorPagamentoLoteId(pagamentoLoteID).get(0);
    }

    private void insereObservacoes(PagamentoNegociado pagamentoNegociado) {
        this.insereObservacaoNosDebitoParcelaTotalmenteBaixados(pagamentoNegociado);
        this.insereObservacaoNoDebitoParcelaPagoPorPagamentoNegociadoParcialmente(pagamentoNegociado);
        this.insereObservacoesNosDebitosNovos(pagamentoNegociado);
    }

    private void insereObservacaoNosDebitoParcelaTotalmenteBaixados(PagamentoNegociado pagamentoNegociado) {
        String observacao = String.format("Parcela(s) totalmente baixada(s) atrav\u00e9s do pagamento negociado %s: ", pagamentoNegociado.getId());
        pagamentoNegociado.getDebitosOrigem().stream().filter(PagamentoNegociadoDebOrigem::isTotalmenteBaixado).map(debito -> debito.getId().getDebitoParcela()).collect(Collectors.groupingBy(DebitoIdDTO::from)).forEach((debitoIdDTO, debitoParcelas) -> {
            String complementoObservacao = debitoParcelas.stream().map(parcela -> String.valueOf(parcela.getId().getParcela())).collect(Collectors.joining(", "));
            this.debitoObservacaoService.save(debitoIdDTO, observacao.concat(complementoObservacao));
        });
    }

    private void insereObservacaoNoDebitoParcelaPagoPorPagamentoNegociadoParcialmente(PagamentoNegociado pagamentoNegociado) {
        List parcelas = pagamentoNegociado.getDebitosOrigem().stream().filter(PagamentoNegociadoDebOrigem::isParcialmenteBaixado).map(origem -> origem.getId().getDebitoParcela()).collect(Collectors.toList());
        if (!parcelas.isEmpty()) {
            DebitoParcela parcela = (DebitoParcela)parcelas.get(0);
            String observacao = String.format("Parcela %s Paga por Pagamento Negociado %s.", parcela.getId().getParcela(), pagamentoNegociado.getId());
            this.debitoObservacaoService.save(DebitoIdDTO.from((Debito)parcela.getDebito()), observacao);
        }
    }

    private void insereObservacoesNosDebitosNovos(PagamentoNegociado pagamentoNegociado) {
        if (!pagamentoNegociado.getDebitosNovos().isEmpty()) {
            String observacao = String.format("D\u00e9bito criado a partir do pagamento negociado %s", pagamentoNegociado.getId());
            pagamentoNegociado.getDebitosNovos().stream().filter(x -> Objects.nonNull(x.getDebitoNovo())).map(PagamentoNegociadoDebNovo::getDebitoNovo).map(DebitoParcela::getDebito).map(DebitoIdDTO::from).forEach(idDTO -> this.debitoObservacaoService.save(idDTO, observacao));
        }
    }

    @Generated
    public NegociacaoPagamentoService(ContextService contextService, ConvenioService convenioService, DebitoService debitoService, EntityManager em, PagamentoLoteManualService pagamentoLoteManualService, PagamentoService pagamentoService, SituacaoParcelaService situacaoParcelaService, DebitoObservacaoService debitoObservacaoService, PagamentoNegociadoRepository pagamentoNegociadoRepository, DebitoParcelaRepository debitoParcelaRepository, NegociacaoDebitoService negociacaoDebitoService) {
        this.contextService = contextService;
        this.convenioService = convenioService;
        this.debitoService = debitoService;
        this.em = em;
        this.pagamentoLoteManualService = pagamentoLoteManualService;
        this.pagamentoService = pagamentoService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.pagamentoNegociadoRepository = pagamentoNegociadoRepository;
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.negociacaoDebitoService = negociacaoDebitoService;
    }
}

