/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.negociacaodebito;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoSituacaoEnum;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.negociacaodebito.EstornoNegociacaoDebitoParamsDTO;
import br.com.elotech.tributos.dto.negociacaodebito.GeraBoletoNegociacaoDTO;
import br.com.elotech.tributos.enums.negociacaodebito.TipoNegociacao;
import br.com.elotech.tributos.exception.negociacaodebito.NegociacaoDebitoNotFoundException;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.repository.PagamentoNegociadoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CancelamentoBoletoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import br.com.elotech.tributos.service.negociacaodebito.NegociacaoDebitoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NegociacaoJudicialService {
    private final ContextService contextService;
    private final GeraBoletoService geraBoletoService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final PagamentoNegociadoRepository pagamentoNegociadoRepository;
    private final BoletoRepository boletoRepository;
    private final DebitoRepository debitoRepository;
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final CancelamentoBoletoService cancelamentoBoletoService;
    private final MotivoDeducaoService motivoDeducaoService;
    private final NegociacaoDebitoService negociacaoDebitoService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final ParcelamentoRepository parcelamentoRepository;

    public PagamentoNegociado gerar(ParametrosPagamentoNegociadoDTO params) {
        Bloqueto boleto = this.negociacaoDebitoService.createBoleto(params);
        this.updateObservacoesDebitos(params, boleto);
        this.updateParcelas(params, boleto);
        PagamentoNegociado negociacao = PagamentoNegociado.from((ParametrosPagamentoNegociadoDTO)params, (Bloqueto)boleto);
        negociacao.setDebitosOrigem(this.negociacaoDebitoService.createDebitosOrigem(params, negociacao));
        params.getParcialmenteBaixados().ifPresent(p -> this.createNovoDebito(p, negociacao));
        negociacao.setEntidade(this.contextService.getEntidadePrincipal());
        PagamentoNegociado saved = (PagamentoNegociado)this.pagamentoNegociadoRepository.save((Object)negociacao);
        boleto.setPagamentoNegociado(saved.getId());
        this.boletoRepository.save((Object)boleto);
        return saved;
    }

    public void efetivarNegociacao(Pagamento pagamento, Bloqueto boleto) {
        if (Objects.isNull(boleto.getPagamentoNegociado())) {
            return;
        }
        PagamentoNegociado negociacao = (PagamentoNegociado)this.pagamentoNegociadoRepository.findById((Object)boleto.getPagamentoNegociado()).orElseThrow(() -> new NegociacaoDebitoNotFoundException(boleto.getPagamentoNegociado()));
        if (TipoNegociacao.JUDICIAL.equals((Object)negociacao.getTipoNegociacao())) {
            this.constituirNovoDebito(negociacao, pagamento);
            negociacao.setPagamentoGerado(pagamento);
            negociacao.setDataCredito(pagamento.getDataPagamento());
            negociacao.setCancelado(PagamentoNegociadoSituacaoEnum.EFETIVADO);
            this.pagamentoNegociadoRepository.save((Object)negociacao);
        }
    }

    public PagamentoNegociado estornar(PagamentoNegociado negociacao, EstornoNegociacaoDebitoParamsDTO dto) {
        Bloqueto boleto = negociacao.getBoletoGerado();
        this.validateBoletoJaPago(boleto);
        this.cancelamentoBoletoService.cancelarBoleto(negociacao.getBoletoGerado(), String.format("Boleto cancelado com sucesso por meio do estorno da negocia\u00e7\u00e3o judicial %d", negociacao.getId()));
        MotivoDeducao motivo = (MotivoDeducao)this.motivoDeducaoService.findOne((Serializable)dto.getIdMotivo());
        String motivoCancelamento = dto.getObservacao();
        this.validateNovoDebitoJaPago(negociacao);
        this.cancelarNovoDebito(negociacao, motivo, motivoCancelamento);
        this.reverterParcelasOrigem(negociacao);
        negociacao.setCancelado(PagamentoNegociadoSituacaoEnum.CANCELADO);
        negociacao.setMotivoDesconto(motivo.getId());
        negociacao.setMotivoCancelamento(motivoCancelamento);
        negociacao.setDataCancelamento(LocalDate.now());
        negociacao.setUsuarioCancelamento(SecurityUtils.getUserAise());
        return (PagamentoNegociado)this.pagamentoNegociadoRepository.save((Object)negociacao);
    }

    public List<BloquetoDTO> reemitirBoleto(PagamentoNegociado negociacao, LocalDate dataVencimento) {
        Bloqueto current = negociacao.getBoletoGerado();
        this.validateBoletoJaPago(current);
        Bloqueto created = this.reemitirBoleto(current, dataVencimento);
        created.setPagamentoNegociado(negociacao.getId());
        Bloqueto saved = (Bloqueto)this.boletoRepository.saveAndFlush((Object)created);
        this.cancelamentoBoletoService.cancelarBoleto(negociacao.getBoletoGerado(), String.format("Boleto cancelado com sucesso devido a reemis\u00e3o do novo boleto %d/%d da negocia\u00e7\u00e3o judicial %d", saved.getBloqueto(), saved.getExercicioBloqueto(), negociacao.getId()));
        negociacao.setBoletoGerado(saved);
        this.pagamentoNegociadoRepository.save((Object)negociacao);
        return this.geraBoletoService.resolveUrlImpressaoBoleto(List.of(saved.toBloquetoDTO()), Boolean.FALSE);
    }

    private Bloqueto reemitirBoleto(Bloqueto boleto, LocalDate dataVencimento) {
        GeraBoletoNegociacaoDTO dto = new GeraBoletoNegociacaoDTO();
        dto.setEntidade(this.contextService.getEntidadePrincipal());
        dto.setExercicio(this.contextService.getExercicioAtual());
        dto.setDataEmissao(this.contextService.getDataAtual());
        dto.setObservacao(boleto.getObservacao());
        dto.setDataVencimento(dataVencimento);
        return this.geraBoletoService.reemitirBoletoForNegociacaoJudicial(dto, boleto);
    }

    private void updateObservacoesDebitos(ParametrosPagamentoNegociadoDTO params, Bloqueto boleto) {
        Set<DebitoIdDTO> ids = params.getDebitos().stream().map(DebitoIdDTO::from).collect(Collectors.toSet());
        ids.forEach(id -> {
            String mensagem = String.format("D\u00e9bito adicionado em negocia\u00e7\u00e3o judicial com processo judicial %s, processo SEI %s, com o valor de alvar\u00e1 judicial de %.2f, gerando o boleto %d/%d. Parcela(s) em negocia\u00e7\u00e3o: ", params.getDadosPagamento().getProcessoSei(), params.getDadosPagamento().getProcessoJudicial(), params.getDadosPagamento().getValorNegociado(), boleto.getBloqueto(), boleto.getExercicioBloqueto()).concat(params.getParcelasWithCommaByDebito(id.getIdDebito()));
            this.debitoObservacaoService.save(id, mensagem);
        });
    }

    private void updateParcelas(ParametrosPagamentoNegociadoDTO params, Bloqueto boleto) {
        List ids = params.getDebitos().stream().map(DebitoParcelaId::from).collect(Collectors.toList());
        List emNegociacaoJudicial = this.debitoParcelaRepository.findByIdIn(ids);
        emNegociacaoJudicial.forEach(p -> {
            p.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.NEGOCIACAO_JUDICIAL, p.getSituacaoDebito()));
            p.getObservacoes().add(this.createObservacaoParcela(params, boleto, p));
        });
        this.debitoParcelaRepository.saveAll((Iterable)emNegociacaoJudicial);
    }

    private void createNovoDebito(DebitoPagamentoNegociadoDTO parcial, PagamentoNegociado negociacao) {
        DebitoParcela parcelaOrigem = (DebitoParcela)this.debitoParcelaRepository.findOne((Object)DebitoParcelaId.from((DebitoPagamentoNegociadoDTO)parcial));
        DebitoPagamentoNegociadoDTO debitoRestante = this.negociacaoDebitoService.criaDebitoRestante(parcial);
        Debito oldDebito = (Debito)this.debitoRepository.findOne((Object)debitoRestante.getIdDebito());
        DebitoIdDTO newDebitoId = this.negociacaoDebitoService.gerarNovoDebito(debitoRestante, oldDebito, "NegociacaoJudicial");
        Debito newDebito = (Debito)this.debitoRepository.findOne((Object)newDebitoId.getIdDebito());
        newDebito.getObservacoes().add(this.createObservacaoNovoDebito(newDebito, negociacao, parcelaOrigem));
        newDebito.setConstituido(Boolean.FALSE);
        this.addNewDebitoToParcelamento(oldDebito, newDebito);
        this.debitoRepository.save((Object)newDebito);
        DebitoParcela parcelaNova = newDebito.getPrimeiraParcela();
        parcelaNova.getObservacoes().add(this.createObservacaoNovaParcela(negociacao, parcelaNova, parcelaOrigem));
        this.debitoParcelaRepository.save((Object)parcelaNova);
        PagamentoNegociadoDebNovo novoDebitoNegociacao = PagamentoNegociadoDebNovo.from((PagamentoNegociado)negociacao, (String)"Negocia\u00e7\u00e3o judicial nova gerada atrav\u00e9s do Oxy", (DebitoParcela)parcelaNova, (DebitoParcela)parcelaOrigem);
        negociacao.setDebitosNovos(Collections.singletonList(novoDebitoNegociacao));
        negociacao.setValorDebitoNovo(novoDebitoNegociacao.getDebitoNovo().getValorTotal());
    }

    private void addNewDebitoToParcelamento(Debito oldDebito, Debito newDebito) {
        if (Objects.nonNull(oldDebito.getIdParcelamento())) {
            this.parcelamentoRepository.findById((Object)oldDebito.getIdParcelamento()).ifPresent(p -> {
                newDebito.setParcelado(oldDebito.getParcelado());
                newDebito.setReparcelado(oldDebito.getReparcelado());
                newDebito.setIdParcelamento(oldDebito.getIdParcelamento());
                p.getDebitos().add(newDebito);
                this.parcelamentoRepository.save(p);
            });
        }
    }

    public void validateBoletoJaPago(Bloqueto boleto) {
        if (Boolean.TRUE.equals(boleto.getPago())) {
            throw new EloValidationException(String.format("O boleto %d/%d da negocia\u00e7\u00e3o judicial %d j\u00e1 foi pago, n\u00e3o \u00e9 poss\u00edvel realizar o estorno dele!", boleto.getBloqueto(), boleto.getExercicioBloqueto(), boleto.getPagamentoNegociado()));
        }
    }

    private void reverterParcelasOrigem(PagamentoNegociado negociacao) {
        List parcelasNegociadas = negociacao.getParcelasOrigem();
        parcelasNegociadas.forEach(p -> {
            p.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.ESTORNO_NEGOCIACAO_JUDICIAL, p.getSituacaoDebito()));
            p.getObservacoes().add(this.createObservacaoEstornoParcela(p, negociacao));
        });
        this.debitoParcelaRepository.saveAll((Iterable)parcelasNegociadas);
        List debitosObservacoes = parcelasNegociadas.stream().map(DebitoParcela::getDebito).collect(Collectors.toSet()).stream().map(d -> this.createObservacaoEstornoDebito(d, negociacao)).collect(Collectors.toList());
        this.debitoObservacaoService.saveAll(debitosObservacoes);
    }

    private void constituirNovoDebito(PagamentoNegociado negociacao, Pagamento pagamento) {
        negociacao.getDebitosNovos().stream().findFirst().ifPresent(p -> {
            Debito debito = p.getDebitoNovo().getDebito();
            debito.setConstituido(Boolean.TRUE);
            debito.setDataContabilizacao(pagamento.getDataMovimento());
            this.debitoRepository.save((Object)debito);
        });
    }

    private void validateNovoDebitoJaPago(PagamentoNegociado negociacao) {
        negociacao.getDebitosNovos().stream().findFirst().map(PagamentoNegociadoDebNovo::getDebitoNovo).ifPresent(p -> {
            if (p.getDebito().hasParcelasPagas()) {
                throw new EloValidationException(String.format("O novo d\u00e9bito de %d com guia %d e sub %d gerado pela negocia\u00e7\u00e3o judicial %d j\u00e1 foi pago, n\u00e3o \u00e9 poss\u00edvel realizar o estorno da negocia\u00e7\u00e3o por conta dele!", p.getDebito().getExercicio(), p.getDebito().getGuiaRecolhimento(), p.getDebito().getSubDivida(), negociacao.getId()));
            }
        });
    }

    private void cancelarNovoDebito(PagamentoNegociado negociacao, MotivoDeducao motivo, String motivoCancelamento) {
        negociacao.getDebitosNovos().stream().findFirst().map(PagamentoNegociadoDebNovo::getDebitoNovo).ifPresent(p -> {
            this.removeFromParcelamentoIfExists(p.getDebito());
            this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(motivo, motivoCancelamento, Collections.singletonList(p));
        });
    }

    private void removeFromParcelamentoIfExists(Debito debito) {
        if (Objects.nonNull(debito.getIdParcelamento())) {
            this.parcelamentoRepository.findById((Object)debito.getIdParcelamento()).ifPresent(p -> {
                debito.setParcelado(Boolean.FALSE);
                debito.setReparcelado(Boolean.FALSE);
                debito.setIdParcelamento(null);
                p.getDebitos().removeIf(d -> Objects.equals(debito.getId(), d.getId()));
                this.parcelamentoRepository.save(p);
                this.debitoRepository.save((Object)debito);
            });
        }
    }

    private DebitoParcelaObservacao createObservacaoParcela(ParametrosPagamentoNegociadoDTO params, Bloqueto boleto, DebitoParcela p) {
        return DebitoParcelaObservacao.from((DebitoParcela)p, (String)String.format("Parcela %d foi adicionada em negocia\u00e7\u00e3o judicial com processo judicial %s, processo SEI %s, com o valor de alvar\u00e1 judicial de %.2f, gerando o boleto %d/%d", p.getId().getParcela(), params.getDadosPagamento().getProcessoSei(), params.getDadosPagamento().getProcessoJudicial(), params.getDadosPagamento().getValorNegociado(), boleto.getBloqueto(), boleto.getExercicioBloqueto()));
    }

    private DebitoObservacao createObservacaoNovoDebito(Debito debito, PagamentoNegociado negociacao, DebitoParcela parcelaOrigem) {
        return DebitoObservacao.from((Debito)debito, (String)String.format("D\u00e9bito criado por meio de negocia\u00e7\u00e3o judicial com processo judicial %s, processo SEI %s, com o valor de alvar\u00e1 judicial de %.2f, gerando o boleto %d/%d, a partir do d\u00e9bito de exercicio: %d, cad: %d/%d, divida: %d, sub: %d", negociacao.getProcessoJudicial(), negociacao.getProcessoSei(), negociacao.getValorNegociado(), negociacao.getBoletoGerado().getBloqueto(), negociacao.getBoletoGerado().getExercicioBloqueto(), parcelaOrigem.getId().getExercicio(), parcelaOrigem.getId().getTipoCadastro(), parcelaOrigem.getId().getCadastroGeral(), parcelaOrigem.getId().getDivida(), parcelaOrigem.getId().getSubDivida()));
    }

    private DebitoParcelaObservacao createObservacaoNovaParcela(PagamentoNegociado negociacao, DebitoParcela parcelaNova, DebitoParcela parcelaOrigem) {
        return DebitoParcelaObservacao.from((DebitoParcela)parcelaNova, (String)String.format("Parcela %d criada por meio de negocia\u00e7\u00e3o judicial com processo judicial %s, processo SEI %s, com o valor de alvar\u00e1 judicial de %.2f, gerando o boleto %d/%d, a partir do d\u00e9bito de exercicio: %d, cad: %d/%d, divida: %d, sub: %d", parcelaOrigem.getId().getParcela(), negociacao.getProcessoJudicial(), negociacao.getProcessoSei(), negociacao.getValorNegociado(), negociacao.getBoletoGerado().getBloqueto(), negociacao.getBoletoGerado().getExercicioBloqueto(), parcelaOrigem.getId().getExercicio(), parcelaOrigem.getId().getTipoCadastro(), parcelaOrigem.getId().getCadastroGeral(), parcelaOrigem.getId().getDivida(), parcelaOrigem.getId().getSubDivida()));
    }

    private DebitoObservacao createObservacaoEstornoDebito(Debito debito, PagamentoNegociado negociacao) {
        return DebitoObservacao.from((Debito)debito, (String)String.format("Revertendo negocia\u00e7\u00e3o judicial realizada neste d\u00e9bito. Referente a negocia\u00e7\u00e3o %d com processo judicial %s, processo SEI %s, com o valor de alvar\u00e1 judicial de %.2f. Parcela(s) revertida(s): ", negociacao.getId(), negociacao.getProcessoJudicial(), negociacao.getProcessoSei(), negociacao.getValorNegociado()).concat(negociacao.getParcelasOrigemWithCommaByDebito(debito.getId())));
    }

    private DebitoParcelaObservacao createObservacaoEstornoParcela(DebitoParcela parcela, PagamentoNegociado negociacao) {
        return DebitoParcelaObservacao.from((DebitoParcela)parcela, (String)String.format("Revertendo negocia\u00e7\u00e3o judicial realizada nesta parcela %d. Referente a negocia\u00e7\u00e3o %d com processo judicial %s, processo SEI %s, com o valor de alvar\u00e1 judicial de %.2f", parcela.getId().getParcela(), negociacao.getId(), negociacao.getProcessoJudicial(), negociacao.getProcessoSei(), negociacao.getValorNegociado()));
    }

    @Generated
    public NegociacaoJudicialService(ContextService contextService, GeraBoletoService geraBoletoService, SituacaoParcelaService situacaoParcelaService, PagamentoNegociadoRepository pagamentoNegociadoRepository, BoletoRepository boletoRepository, DebitoRepository debitoRepository, DebitoParcelaRepository debitoParcelaRepository, CancelamentoDebitoService cancelamentoDebitoService, CancelamentoBoletoService cancelamentoBoletoService, MotivoDeducaoService motivoDeducaoService, NegociacaoDebitoService negociacaoDebitoService, DebitoObservacaoService debitoObservacaoService, ParcelamentoRepository parcelamentoRepository) {
        this.contextService = contextService;
        this.geraBoletoService = geraBoletoService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.pagamentoNegociadoRepository = pagamentoNegociadoRepository;
        this.boletoRepository = boletoRepository;
        this.debitoRepository = debitoRepository;
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.cancelamentoBoletoService = cancelamentoBoletoService;
        this.motivoDeducaoService = motivoDeducaoService;
        this.negociacaoDebitoService = negociacaoDebitoService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.parcelamentoRepository = parcelamentoRepository;
    }
}

