/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.negociacaodebito;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.negociacaodebito.GeraBoletoNegociacaoDTO;
import br.com.elotech.tributos.enums.negociacaodebito.TipoNegociacao;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.PagamentoNegociadoRateioService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NegociacaoDebitoService {
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final PagamentoNegociadoRateioService pagamentoNegociadoRateioService;
    private final DebitoService debitoService;
    private final GeraDebitoService geraDebitoService;
    private final GeraBoletoService geraBoletoService;
    private final CadastroGeralService cadastroGeralService;
    private final ContextService contextService;
    private final BoletoRepository boletoRepository;

    public List<PagamentoNegociadoDebOrigem> createDebitosOrigem(ParametrosPagamentoNegociadoDTO params, PagamentoNegociado negociacao) {
        return params.getDebitos().stream().map(origemDTO -> {
            PagamentoNegociadoDebOrigem origem = PagamentoNegociadoDebOrigem.from((DebitoPagamentoNegociadoDTO)origemDTO);
            origem.setPagamentoNegociado(negociacao);
            origem.setParcela((DebitoParcela)this.debitoParcelaRepository.findOne((Object)DebitoParcelaId.from((DebitoPagamentoNegociadoDTO)origemDTO)));
            return origem;
        }).collect(Collectors.toList());
    }

    public DebitoPagamentoNegociadoDTO criaDebitoRestante(DebitoPagamentoNegociadoDTO debitoDTO) {
        return this.pagamentoNegociadoRateioService.criaDebitoRestante(debitoDTO);
    }

    public DebitoIdDTO gerarNovoDebito(DebitoPagamentoNegociadoDTO debitoDTO, String programa) {
        DebitoPagamentoNegociadoDTO debitoRestante = this.criaDebitoRestante(debitoDTO);
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoRestante.getIdDebito());
        return this.gerarNovoDebito(debitoRestante, debito, programa);
    }

    public DebitoIdDTO gerarNovoDebito(DebitoPagamentoNegociadoDTO debitoRestante, Debito debito, String programa) {
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(debitoRestante.getExercicio());
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)debitoRestante.getTipoCadastro()));
        debitoManualDTO.setCadastroGeral(debitoRestante.getCadastroGeral());
        debitoManualDTO.setDivida(debitoRestante.getDivida());
        debitoManualDTO.setSubDivida(this.debitoService.getNextValueSubdivida(NextSubdividaValueParams.of((Debito)debito)));
        debitoManualDTO.setDataLancamento(LocalDate.now());
        debitoManualDTO.setFormaCorrecao(debito.getFormaCorrecao().getId());
        debitoManualDTO.setPrograma(programa);
        if (debitoRestante.getTributosAgrupados().isEmpty()) {
            DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
            debitoManualTributoDTO.setTributo(debitoRestante.getTributo());
            debitoManualTributoDTO.setValorTributo(debitoRestante.getValorNovoDebito());
            debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
            debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
            debitoManualDTO.getTributos().add(debitoManualTributoDTO);
        } else {
            debitoRestante.getTributosAgrupados().forEach(tributos -> {
                DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
                debitoManualTributoDTO.setTributo(tributos.getTributo());
                debitoManualTributoDTO.setValorTributo(tributos.getValorNovoDebito());
                debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
                debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
                debitoManualDTO.getTributos().add(debitoManualTributoDTO);
            });
        }
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setParcela(debitoRestante.getParcela());
        debitoManualParcelaDTO.setSituacao(TipoSituacaoParcela.ABERTO.getValue());
        debitoManualParcelaDTO.setSituacaoLegal(Long.valueOf(debitoRestante.getSituacaoLegal().longValue()));
        debitoManualParcelaDTO.setDataVencimento(debitoRestante.getDataVencimento());
        debitoManualParcelaDTO.setValor(debitoRestante.getValorPrincipal());
        debitoManualParcelaDTO.setValorBaseCalculo(BigDecimal.ZERO);
        debitoManualDTO.setParcelas(List.of(debitoManualParcelaDTO));
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    public Bloqueto createBoleto(ParametrosPagamentoNegociadoDTO params) {
        Long cadastroGeral = params.getFiltro().getCadastroGeral();
        TipoCadastro tipoCadastro = TipoCadastro.fromValue((Long)params.getFiltro().getTipoCadastro());
        CadastroGeral cadastro = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral));
        GeraBoletoNegociacaoDTO dto = new GeraBoletoNegociacaoDTO();
        dto.setEntidade(this.contextService.getEntidadePrincipal());
        dto.setExercicio(this.contextService.getExercicioAtual());
        dto.setDataEmissao(this.contextService.getDataAtual());
        dto.setObservacao(params.getDadosPagamento().getObservacao());
        dto.setDataVencimento(Optional.ofNullable(params.getDadosPagamento().getDataVencimento()).orElse(this.contextService.getDataAtual()));
        dto.setDebitos(params.getDebitos());
        boolean isTipoJudicial = TipoNegociacao.JUDICIAL.equals((Object)params.getFiltro().getTipoNegociacao());
        Bloqueto created = this.geraBoletoService.createBoletoForNegociacao(dto, params.getDadosPagamento().getMotivo(), cadastro, Boolean.valueOf(isTipoJudicial));
        return (Bloqueto)this.boletoRepository.saveAndFlush((Object)created);
    }

    @Generated
    public NegociacaoDebitoService(DebitoParcelaRepository debitoParcelaRepository, PagamentoNegociadoRateioService pagamentoNegociadoRateioService, DebitoService debitoService, GeraDebitoService geraDebitoService, GeraBoletoService geraBoletoService, CadastroGeralService cadastroGeralService, ContextService contextService, BoletoRepository boletoRepository) {
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.pagamentoNegociadoRateioService = pagamentoNegociadoRateioService;
        this.debitoService = debitoService;
        this.geraDebitoService = geraDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.cadastroGeralService = cadastroGeralService;
        this.contextService = contextService;
        this.boletoRepository = boletoRepository;
    }
}

