/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.memoria;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.memoria.MemoriaCadastro;
import br.com.elotech.tributos.dto.memoria.CadastroGeralMemoriaDTO;
import br.com.elotech.tributos.dto.memoria.CadastroImobiliarioMemoriaDTO;
import br.com.elotech.tributos.dto.memoria.GeraCadastroMemoriaDTO;
import br.com.elotech.tributos.dto.memoria.MemoriaCadastroDTO;
import br.com.elotech.tributos.enums.memoria.TabelaCadastroMemoria;
import br.com.elotech.tributos.enums.memoria.TipoMemoriaCadastro;
import br.com.elotech.tributos.repository.memoria.MemoriaCadastroRepository;
import br.com.elotech.tributos.service.memoria.CadastroImobiliarioMemoriaService;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MemoriaCadastroService
extends CrudService<MemoriaCadastro, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoriaCadastroService.class);
    private final MemoriaCadastroRepository repository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final DataSource dataSource;
    private final EntityManager entityManager;
    private final CadastroImobiliarioMemoriaService cadastroImobiliarioMemoriaService;
    private static final String INSERT_SELECT_TEMPLATE = "INSERT INTO %s (%s) SELECT %s";
    private static final String FROM_ALIAS_SRC = " FROM %s src";
    private static final String INNER_JOIN = " INNER JOIN %s rel ON rel.%s = src.%s";
    private static final String AND_REL_PRINCIPAL_TRUE = " AND rel.PRINCIPAL = 'S'";
    private static final String WHERE_CLAUSE = " WHERE src.%s = :%s AND src.%s = :%s";
    private static final String SOURCE_ALIAS = "src.";
    private static final String JOIN_ALIAS = "rel.";
    private static final String ID_MEMORIA_CADASTRO = "IDMEMORIACADASTRO";
    private static final String TIPO_CADASTRO = "TIPOCADASTRO";
    private static final String CADASTRO_GERAL = "CADASTROGERAL";
    private static final String ID_LOGRADOURO_TESTADA = "IDLOGRADOUROTESTADA";
    private static final String ID_KEY = "idkey";
    private static final String ID = "id";
    private static final String REFERENCIA = "referencia";

    @Transactional
    public Contencioso generateAndAssociarMemoriaCadastro(Contencioso contencioso, Boolean isPermitidoSubstituirMemoria) {
        log.debug("Agrupando d\u00e9bitos v\u00e1lidos por cadastro");
        Map debitosAgrupadosPorCadastro = this.groupDebitosValidosPorCadastro(contencioso, isPermitidoSubstituirMemoria);
        if (Boolean.TRUE.equals(isPermitidoSubstituirMemoria)) {
            this.validateExisteDebitoImobiliarioAgrupado(debitosAgrupadosPorCadastro);
        }
        log.info("Processando {} cadastros para gera\u00e7\u00e3o de mem\u00f3ria", (Object)debitosAgrupadosPorCadastro.size());
        debitosAgrupadosPorCadastro.forEach((cadastroGeral, debitos) -> {
            ContenciosoDebito firstDebito = (ContenciosoDebito)debitos.get(0);
            GeraCadastroMemoriaDTO geraCadastroMemoriaDTO = this.buildGeraCadastroMemoriaDTO(contencioso.getContenciosoId(), contencioso.getExercicio(), cadastroGeral, firstDebito.getId().getExercicio(), contencioso.getData());
            log.debug("Gerando mem\u00f3ria para cadastro {} do exerc\u00edcio {}", cadastroGeral, (Object)firstDebito.getId().getExercicio());
            MemoriaCadastro memoriaCadastro = this.generateMemoriaCadastro(geraCadastroMemoriaDTO);
            log.debug("Associando mem\u00f3ria ID {} a {} d\u00e9bitos", (Object)memoriaCadastro.getId(), (Object)debitos.size());
            debitos.forEach(debito -> debito.setMemoriaCadastro(memoriaCadastro));
        });
        return contencioso;
    }

    private Map<Long, List<ContenciosoDebito>> groupDebitosValidosPorCadastro(Contencioso contencioso, Boolean isPermitidoSubstituirMemoria) {
        Map<Long, List<ContenciosoDebito>> debitosAgrupados = contencioso.getDebitos().stream().filter(contenciosoDebito -> this.isDebitoValidoParaMemoria(contenciosoDebito, isPermitidoSubstituirMemoria)).collect(Collectors.groupingBy(debito -> debito.getId().getCadastroGeral()));
        debitosAgrupados.values().forEach(debitos -> debitos.sort(Comparator.comparing(d -> d.getId().getExercicio()).reversed()));
        return debitosAgrupados;
    }

    private boolean isDebitoValidoParaMemoria(ContenciosoDebito debito, Boolean isPermitidoSubstituirMemoria) {
        return (isPermitidoSubstituirMemoria != false || debito.getMemoriaCadastro() == null) && debito.getId().getTipoCadastro() == TipoCadastro.IMOBILIARIO;
    }

    private void validateExisteDebitoImobiliarioAgrupado(Map<Long, List<ContenciosoDebito>> debitosAgrupadosPorCadastro) {
        boolean isEmptyDebitoImobiliarioAgrupado;
        boolean bl = isEmptyDebitoImobiliarioAgrupado = debitosAgrupadosPorCadastro.isEmpty() || debitosAgrupadosPorCadastro.values().stream().allMatch(List::isEmpty);
        if (isEmptyDebitoImobiliarioAgrupado) {
            throw new EloValidationException("Nenhuma mem\u00f3ria foi gerada, pois n\u00e3o h\u00e1 d\u00e9bitos com cadastro imobili\u00e1rio v\u00e1lido.");
        }
    }

    private GeraCadastroMemoriaDTO buildGeraCadastroMemoriaDTO(Long contenciosoId, Long exercicioContencioso, Long cadastroGeral, Long exercicio, LocalDate dataMemoria) {
        GeraCadastroMemoriaDTO dto = new GeraCadastroMemoriaDTO();
        dto.setCadastroGeral(cadastroGeral);
        dto.setDescricao(String.format("Mem\u00f3ria do Cadastro Imobili\u00e1rio %d referente ao Contencioso %d/%d", cadastroGeral, contenciosoId, exercicioContencioso));
        dto.setExercicio(exercicio);
        dto.setDataMemoria(dataMemoria);
        dto.setTipo(TipoMemoriaCadastro.CONTENCIOSO);
        return dto;
    }

    public MemoriaCadastro generateMemoriaCadastro(GeraCadastroMemoriaDTO dto) {
        log.info("Iniciando gera\u00e7\u00e3o de mem\u00f3ria do cadastro imobili\u00e1rio {} para exerc\u00edcio {}", (Object)dto.getCadastroGeral(), (Object)dto.getExercicio());
        try {
            MemoriaCadastro memoriaCadastro = this.saveMemoriaCadastro(dto);
            this.entityManager.flush();
            this.copyAllTables(memoriaCadastro.getId(), dto);
            log.info("Gera\u00e7\u00e3o conclu\u00edda para ID {}", (Object)memoriaCadastro.getId());
            return memoriaCadastro;
        }
        catch (Exception ex) {
            log.error("Erro na gera\u00e7\u00e3o de mem\u00f3ria: {}", (Object)ex.getMessage(), (Object)ex);
            throw new EloValidationException("Falha ao gerar mem\u00f3ria de cadastro. " + ex.getMessage());
        }
    }

    private MemoriaCadastro saveMemoriaCadastro(GeraCadastroMemoriaDTO dto) {
        MemoriaCadastro memoriaCadastro = new MemoriaCadastro();
        memoriaCadastro.setExercicio(dto.getExercicio());
        memoriaCadastro.setDescricao(dto.getDescricao());
        memoriaCadastro.setDataMemoria(dto.getDataMemoria());
        memoriaCadastro.setTipo(dto.getTipo());
        log.debug("Salvando registro de mem\u00f3ria de cadastro");
        return (MemoriaCadastro)this.repository.save((Object)memoriaCadastro);
    }

    private void copyAllTables(Long idMemoriaCadastro, GeraCadastroMemoriaDTO dto) throws SQLException {
        for (TabelaCadastroMemoria tabela : TabelaCadastroMemoria.values()) {
            log.info("Copiando de {} para {}", (Object)tabela.getOrigem(), (Object)tabela.getDestino());
            this.copyTable(idMemoriaCadastro, tabela.getOrigem(), tabela.getDestino(), dto);
        }
    }

    public void copyTable(Long idMemoriaCadastro, String origem, String destino, GeraCadastroMemoriaDTO dto) throws SQLException {
        List columns = this.getTableColumns(destino);
        if ((columns = this.processColumns(columns, destino)).isEmpty()) {
            log.warn("Tabela {} n\u00e3o possui colunas", (Object)destino);
            return;
        }
        Boolean join = this.requiresJoin(destino);
        String alias = Boolean.TRUE.equals(join) ? JOIN_ALIAS : SOURCE_ALIAS;
        String sql = this.generateInsertSql(columns, origem, destino, alias, join);
        MapSqlParameterSource params = this.buildParameters(idMemoriaCadastro, dto.getCadastroGeral());
        this.executeInsert(sql, params);
    }

    public String generateInsertSql(List<String> columns, String origem, String destino, String alias, Boolean join) {
        String selectClause = this.buildSelectClause(columns, alias, join, destino);
        String fromClause = this.buildFromClause(origem, destino);
        String whereClause = this.buildWhereClause();
        return String.format(INSERT_SELECT_TEMPLATE, destino, String.join((CharSequence)",", columns), selectClause + fromClause + whereClause);
    }

    private List<String> getTableColumns(String tableName) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String schema = this.getSchema(connection, metaData);
            ResultSet resultSet = metaData.getColumns(null, schema, this.resolveTableName(tableName), null);
            ArrayList<String> columns = new ArrayList<String>();
            while (resultSet.next()) {
                columns.add(resultSet.getString("COLUMN_NAME").toLowerCase());
            }
            ArrayList<String> arrayList = columns;
            return arrayList;
        }
    }

    private List<String> processColumns(List<String> columns, String destino) {
        List<String> processedColumns = columns.stream().filter(col -> !ID_KEY.equalsIgnoreCase((String)col)).collect(Collectors.toList());
        if (this.isTableComColunaIdIgnorada(destino)) {
            processedColumns = processedColumns.stream().filter(col -> !ID.equalsIgnoreCase((String)col)).collect(Collectors.toList());
        }
        return processedColumns;
    }

    private String getSchema(Connection connection, DatabaseMetaData metaData) throws SQLException {
        DatabaseType dbType = this.getDatabaseType();
        return DatabaseType.POSTGRES.equals((Object)dbType) || DatabaseType.H2.equals((Object)dbType) ? connection.getSchema() : metaData.getUserName();
    }

    private String resolveTableName(String name) {
        DatabaseType dbType = this.getDatabaseType();
        return DatabaseType.POSTGRES.equals((Object)dbType) ? name.toLowerCase() : name.toUpperCase();
    }

    public DatabaseType getDatabaseType() {
        return SqlUtils.getDatabaseType((DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
    }

    private Boolean requiresJoin(String table) {
        return Arrays.asList(TabelaCadastroMemoria.TRIBLOGRADOUROTESTADAEXERCICIO.getDestino(), TabelaCadastroMemoria.RESPOSTATERRENO.getDestino(), TabelaCadastroMemoria.RESPOSTASEGMENTO.getDestino(), TabelaCadastroMemoria.RESPOSTALOGRADOURO.getDestino()).contains(table);
    }

    private Boolean isTableRespostas(String table) {
        return Arrays.asList(TabelaCadastroMemoria.RESPOSTATERRENO.getDestino(), TabelaCadastroMemoria.RESPOSTASEGMENTO.getDestino(), TabelaCadastroMemoria.RESPOSTALOGRADOURO.getDestino()).contains(table);
    }

    private boolean isTableComColunaIdIgnorada(String destino) {
        return Boolean.TRUE.equals(this.isTableRespostas(destino)) || destino.equals(TabelaCadastroMemoria.TRIBIMOBILIARIOTESTADAGENERICA.getDestino()) || destino.equals(TabelaCadastroMemoria.TRIBIMOBILIARIOSITUACAO.getDestino());
    }

    private String buildFromClause(String origem, String destino) {
        if (destino.equals(TabelaCadastroMemoria.TRIBLOGRADOUROTESTADAEXERCICIO.getDestino())) {
            return this.buildLogradouroJoin(origem, ID_LOGRADOURO_TESTADA, Boolean.TRUE);
        }
        if (destino.equals(TabelaCadastroMemoria.RESPOSTATERRENO.getDestino())) {
            return this.buildRespostaJoin(TabelaCadastroMemoria.TRIBCADASTROGERAL.getOrigem(), origem, TabelaCadastroMemoria.TRIBCADASTROGERAL.getDestino());
        }
        if (destino.equals(TabelaCadastroMemoria.RESPOSTASEGMENTO.getDestino())) {
            return this.buildRespostaJoin(TabelaCadastroMemoria.TRIBIMOBILIARIOSEGMENTO.getOrigem(), origem, TabelaCadastroMemoria.TRIBIMOBILIARIOSEGMENTO.getDestino(), Boolean.TRUE);
        }
        if (destino.equals(TabelaCadastroMemoria.RESPOSTALOGRADOURO.getDestino())) {
            return this.buildLogradouroJoin(origem, REFERENCIA, Boolean.FALSE);
        }
        return String.format(FROM_ALIAS_SRC, origem);
    }

    private String buildLogradouroJoin(String tabelaRelacionamento, String campoRelacionamento, Boolean utilizaTagPrincipal) {
        Object joinFormat = " FROM %s src INNER JOIN %s rel ON rel.%s = src.%s";
        if (Boolean.TRUE.equals(utilizaTagPrincipal)) {
            joinFormat = (String)joinFormat + AND_REL_PRINCIPAL_TRUE;
        }
        return String.format((String)joinFormat, TabelaCadastroMemoria.TRIBIMOBILIARIOTESTADA.getOrigem(), tabelaRelacionamento, campoRelacionamento, ID_LOGRADOURO_TESTADA);
    }

    private String buildRespostaJoin(String origem, String tabelaRelacionamento, String tabelaMemoria) {
        return this.buildRespostaJoin(origem, tabelaRelacionamento, tabelaMemoria, Boolean.FALSE);
    }

    private String buildRespostaJoin(String origem, String tabelaRelacionamento, String tabelaMemoria, Boolean isSegmento) {
        return String.format(" FROM %s src INNER JOIN %s rel ON rel.%s = src.%s INNER JOIN %s m ON m.idmemoriacadastro = :IDMEMORIACADASTRO  AND m.tipocadastro = src.tipocadastro  AND m.cadastrogeral = src.cadastrogeral %s ", origem, tabelaRelacionamento, REFERENCIA, ID_KEY, tabelaMemoria, Boolean.FALSE.equals(isSegmento) ? "" : " AND m.sequencia = src.sequencia ");
    }

    private String buildSelectClause(List<String> columns, String alias, Boolean join, String destino) {
        String prefix;
        String string = prefix = Boolean.TRUE.equals(join) ? "DISTINCT " : "";
        if (alias.equals(JOIN_ALIAS) && Boolean.TRUE.equals(this.isTableRespostas(destino))) {
            return prefix + columns.stream().map(col -> {
                if (ID_MEMORIA_CADASTRO.equalsIgnoreCase((String)col)) {
                    return String.format(":%s", ID_MEMORIA_CADASTRO);
                }
                if (REFERENCIA.equalsIgnoreCase((String)col)) {
                    return destino.equals(TabelaCadastroMemoria.RESPOSTALOGRADOURO.getDestino()) ? String.format("%s%s", SOURCE_ALIAS, ID_LOGRADOURO_TESTADA) : String.format("m.%s", ID_KEY);
                }
                return String.format("rel.%s", col);
            }).collect(Collectors.joining(","));
        }
        return prefix + columns.stream().map(col -> ID_MEMORIA_CADASTRO.equalsIgnoreCase((String)col) ? String.format(":%s", ID_MEMORIA_CADASTRO) : String.format("%s%s", alias, col)).collect(Collectors.joining(","));
    }

    private String buildWhereClause() {
        return String.format(WHERE_CLAUSE, TIPO_CADASTRO, TIPO_CADASTRO, CADASTRO_GERAL, CADASTRO_GERAL);
    }

    private MapSqlParameterSource buildParameters(Long idMemoriaCadastro, Long cadastroGeral) {
        return new MapSqlParameterSource().addValue(ID_MEMORIA_CADASTRO, (Object)idMemoriaCadastro).addValue(TIPO_CADASTRO, (Object)TipoCadastro.IMOBILIARIO.getValue()).addValue(CADASTRO_GERAL, (Object)cadastroGeral);
    }

    private void executeInsert(String sql, MapSqlParameterSource params) {
        try {
            int affected = this.jdbcTemplate.update(sql, (SqlParameterSource)params);
            log.info("{} registros inseridos com sucesso", (Object)affected);
        }
        catch (Exception ex) {
            log.error("Erro na execu\u00e7\u00e3o do insert: {}", (Object)ex.getMessage(), (Object)ex);
            throw new EloValidationException("Falha ao executar inser\u00e7\u00e3o. " + ex.getMessage());
        }
    }

    public MemoriaCadastroDTO findByIdDTO(Long id) {
        MemoriaCadastro memoriaCadastro = (MemoriaCadastro)this.repository.findById((Object)id).orElseThrow(RestException::notFound);
        return MemoriaCadastroDTO.from((MemoriaCadastro)memoriaCadastro);
    }

    public MemoriaCadastroDTO findByCadastroDTO(Long idMemoria, Long tipoCadastro, Long cadastroGeral) {
        return this.cadastroImobiliarioMemoriaService.findByCadastroDTO(idMemoria, tipoCadastro, cadastroGeral);
    }

    public Page<CadastroGeralMemoriaDTO> searchCadastros(Long idMemoriaCadastro, String search, Pageable pageable) {
        return this.cadastroImobiliarioMemoriaService.searchCadastros(idMemoriaCadastro, search, pageable);
    }

    public CadastroImobiliarioMemoriaDTO saveCadastroImobiliarioDTO(CadastroImobiliarioMemoriaDTO dto) {
        return this.cadastroImobiliarioMemoriaService.saveDTO(dto);
    }

    @Generated
    public MemoriaCadastroService(MemoriaCadastroRepository repository, NamedParameterJdbcTemplate jdbcTemplate, DataSource dataSource, EntityManager entityManager, CadastroImobiliarioMemoriaService cadastroImobiliarioMemoriaService) {
        this.repository = repository;
        this.jdbcTemplate = jdbcTemplate;
        this.dataSource = dataSource;
        this.entityManager = entityManager;
        this.cadastroImobiliarioMemoriaService = cadastroImobiliarioMemoriaService;
    }
}

