/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracoes.disponibilizados.requerimento;

import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.TipoRequerimentoItem;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.dto.integracoes.disponibilizados.requerimentos.ConsultaStatusRequerimentoResponse;
import br.com.elotech.tributos.dto.integracoes.disponibilizados.requerimentos.IntegracaoNovoRequerimentoRequest;
import br.com.elotech.tributos.dto.integracoes.disponibilizados.requerimentos.IntegracaoNovoRequerimentoResponse;
import br.com.elotech.tributos.dto.requerimento.RequerimentoDTO;
import br.com.elotech.tributos.dto.requerimento.RequerimentoItemDTO;
import br.com.elotech.tributos.repository.requerimento.RequerimentoRepository;
import br.com.elotech.tributos.service.CadastroAvulsoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoRequerimentoService;
import br.com.elotech.tributos.service.requerimento.RequerimentoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.ContatoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.ContatoPessoaTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaAndCadastroAvulsoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoNovoRequerimentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoNovoRequerimentoService.class);
    private final TipoRequerimentoService tipoRequerimentoService;
    private final RequerimentoRepository requerimentoRepository;
    private final CadastroAvulsoService cadastroAvulsoService;
    private final ParametroGeralService parametroGeralService;
    private final CadastroGeralService cadastroGeralService;
    private final RequerimentoService requerimentoService;
    private final AisePdfService aisePdfService;
    private final ContextService contextService;

    public Optional<ConsultaStatusRequerimentoResponse> consultarBoleto(Long requerimentoId, Long anoRequerimento) {
        return this.requerimentoRepository.consultaSituacaoBoleto(requerimentoId, anoRequerimento);
    }

    public IntegracaoNovoRequerimentoResponse novoRequerimento(IntegracaoNovoRequerimentoRequest request) {
        try {
            return this.doNovoRequerimento(request);
        }
        catch (RestException e) {
            log.error("Ocorreu complica\u00e7\u00e3o ao gerar d\u00e9bito da taxa de inscri\u00e7\u00e3o de concurso p\u00fablico", (Throwable)e);
            throw new RestException(e.getStatus(), e.getMessage());
        }
        catch (Exception e) {
            log.error("Ocorreu complica\u00e7\u00e3o ao gerar d\u00e9bito da taxa de inscri\u00e7\u00e3o de concurso p\u00fablico", (Throwable)e);
            throw new RestException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    private IntegracaoNovoRequerimentoResponse doNovoRequerimento(IntegracaoNovoRequerimentoRequest request) {
        TipoRequerimento tipoRequerimento = this.findTipoRequerimento(request.getTipoRequerimento());
        CadastroGeral cadastroAvulso = this.findCadastro(request);
        Requerimento requerimento = this.doRequerimento(request, tipoRequerimento, cadastroAvulso);
        Bloqueto bloqueto = requerimento.getBoleto();
        String urlImpressao = this.geraUrlImpressao(bloqueto, requerimento);
        return IntegracaoNovoRequerimentoResponse.with((Requerimento)requerimento).andUrlImpressao(urlImpressao);
    }

    private CadastroGeral findCadastro(IntegracaoNovoRequerimentoRequest request) {
        IncluirPessoaRequestDTO pessoaRequest = this.mountIncluirPessoaRequestDTO(request);
        IncluirPessoaAndCadastroAvulsoResponseDTO cadastroResponse = this.incluirPessoaEGerarCadastroAvulso(pessoaRequest);
        TipoCadastro tipoCadastro = TipoCadastro.fromValue((Long)cadastroResponse.getTipoCadastro());
        return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroResponse.getCadastroGeral()).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro. Tipo: %s, cadastro: %s", cadastroResponse.getTipoCadastro(), cadastroResponse.getCadastroGeral())));
    }

    private String geraUrlImpressao(Bloqueto bloqueto, Requerimento requerimento) {
        return this.requerimentoService.determinarRelatorioParaImpressao(requerimento).map(idRelatorio -> this.aisePdfService.fetchBoletoRequerimento(bloqueto.getBloqueto(), bloqueto.getExercicioBloqueto(), Long.valueOf(idRelatorio.getRelatorio().longValue()), idRelatorio.getTipoRelatorio().getTipo())).orElseGet(() -> this.aisePdfService.fetchBloquetoByExercicio(bloqueto.getBloqueto(), bloqueto.getExercicioBloqueto()));
    }

    private IncluirPessoaAndCadastroAvulsoResponseDTO incluirPessoaEGerarCadastroAvulso(IncluirPessoaRequestDTO pessoaRequest) {
        return this.cadastroAvulsoService.incluirCadastroAvulsoEPessoa(pessoaRequest);
    }

    private Requerimento doRequerimento(IntegracaoNovoRequerimentoRequest request, TipoRequerimento tipoRequerimento, CadastroGeral cadastroAvulso) {
        List itens = this.mapToRequerimentoItemDTO(tipoRequerimento.getItens());
        RequerimentoDTO requerimentoDTO = this.mountRequerimento(tipoRequerimento, cadastroAvulso, request.getObservacoes());
        requerimentoDTO.setItens(itens);
        RequerimentoId requerimentoId = this.requerimentoService.gerar(requerimentoDTO);
        return (Requerimento)this.requerimentoService.findOne((Serializable)requerimentoId);
    }

    private RequerimentoDTO mountRequerimento(TipoRequerimento tipoRequerimento, CadastroGeral cadastroAvulso, List<String> observacaoRequest) {
        String observacao = "Requerimento solicitado por meio de integra\u00e7\u00e3o ";
        RequerimentoDTO requerimento = new RequerimentoDTO();
        LocalDate currentDate = this.contextService.getDataAtual();
        requerimento.setEntidade(this.contextService.getEntidadePrincipal());
        requerimento.setExercicio(this.contextService.getExercicioAtual());
        requerimento.setTipoCadastro(cadastroAvulso.getTipoCadastro().getValue());
        requerimento.setCadastroGeral(cadastroAvulso.getCadastroGeral());
        requerimento.setDataLancamento(currentDate);
        requerimento.setDataVencimento(this.generateDate(tipoRequerimento, currentDate));
        requerimento.setTipoRequerimento(tipoRequerimento.getId());
        requerimento.setRequerente(cadastroAvulso.getPessoa().getId());
        requerimento.getObservacoes().add(observacao);
        requerimento.getObservacoes().addAll(observacaoRequest);
        return requerimento;
    }

    private List<RequerimentoItemDTO> mapToRequerimentoItemDTO(List<TipoRequerimentoItem> itens) {
        return itens.stream().map(item -> {
            RequerimentoItemDTO dto = RequerimentoItemDTO.from((TipoRequerimentoItem)item);
            if (Boolean.TRUE.equals(item.getQuantidadeFixa())) {
                dto.setQuantidade(item.getQuantidade());
            }
            return dto;
        }).toList();
    }

    private LocalDate generateDate(TipoRequerimento tipoRequerimento, LocalDate dataBase) {
        return this.tipoRequerimentoService.generateDate(tipoRequerimento, dataBase);
    }

    private IncluirPessoaRequestDTO mountIncluirPessoaRequestDTO(IntegracaoNovoRequerimentoRequest request) {
        IncluirPessoaRequestDTO pessoa = this.mountPessoa(request);
        ContatoPessoaTransportDTO contatoTransport = this.mountContatos(request);
        EnderecoPessoaTransportDTO enderecoTransport = this.mountEndereco(request);
        pessoa.setContatos(contatoTransport);
        pessoa.setEnderecos(enderecoTransport);
        return pessoa;
    }

    private IncluirPessoaRequestDTO mountPessoa(IntegracaoNovoRequerimentoRequest request) {
        IncluirPessoaRequestDTO pessoa = new IncluirPessoaRequestDTO();
        pessoa.setTipoPessoa(request.getCnpjCpf().length() == 11 ? TipoPessoa.FISICA : TipoPessoa.JURIDICA);
        pessoa.setNome(request.getNome());
        pessoa.setNomeFantasia(request.getNome());
        pessoa.setCnpjCpf(request.getCnpjCpf());
        return pessoa;
    }

    private EnderecoPessoaTransportDTO mountEndereco(IntegracaoNovoRequerimentoRequest request) {
        EnderecoPessoaRequestDTO endereco = new EnderecoPessoaRequestDTO();
        endereco.setTipoEndereco(EnderecoTipo.RESIDENCIAL);
        endereco.setTipoLogradouro(request.getTipoLogradouro());
        endereco.setLogradouro(request.getLogradouro());
        endereco.setBairro(request.getBairro());
        endereco.setNumero(request.getNumero());
        endereco.setComplemento(request.getComplemento());
        endereco.setCidade(request.getCidade());
        endereco.setUnidadeFederacao(request.getUf());
        endereco.setCep(request.getCep());
        EnderecoPessoaTransportDTO enderecoTransport = new EnderecoPessoaTransportDTO();
        enderecoTransport.setItems(Collections.singletonList(endereco));
        return enderecoTransport;
    }

    private ContatoPessoaTransportDTO mountContatos(IntegracaoNovoRequerimentoRequest request) {
        ContatoPessoaRequestDTO contato = new ContatoPessoaRequestDTO();
        contato.setNome(request.getNome());
        contato.setEmail(request.getEmail());
        contato.setTelefoneCelular(request.getCelular());
        ContatoPessoaTransportDTO transport = new ContatoPessoaTransportDTO();
        transport.setItems(Collections.singletonList(contato));
        return transport;
    }

    private TipoRequerimento findTipoRequerimento(String tipoRequerimentoIdEscolhido) {
        String tipoRequerimentoId;
        if (tipoRequerimentoIdEscolhido != null) {
            tipoRequerimentoId = tipoRequerimentoIdEscolhido;
        } else {
            ParametroGeral parametro = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.TIPO_REQUERIMENTO_PADRAO_INTEGRACAO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            tipoRequerimentoId = Optional.ofNullable(parametro.getValor()).orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o existe Tipo Requerimento padronizado. Por favor, verifique o par\u00e2metro."));
        }
        return (TipoRequerimento)this.tipoRequerimentoService.findById((Serializable)Long.valueOf(tipoRequerimentoId)).orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi encontrado o Tipo Requerimento para gera\u00e7\u00e3o de taxa de inscri\u00e7\u00e3o de concurso. Por favor, contate a prefeitura! Tipo requerimento:" + tipoRequerimentoId));
    }

    @Generated
    public IntegracaoNovoRequerimentoService(TipoRequerimentoService tipoRequerimentoService, RequerimentoRepository requerimentoRepository, CadastroAvulsoService cadastroAvulsoService, ParametroGeralService parametroGeralService, CadastroGeralService cadastroGeralService, RequerimentoService requerimentoService, AisePdfService aisePdfService, ContextService contextService) {
        this.tipoRequerimentoService = tipoRequerimentoService;
        this.requerimentoRepository = requerimentoRepository;
        this.cadastroAvulsoService = cadastroAvulsoService;
        this.parametroGeralService = parametroGeralService;
        this.cadastroGeralService = cadastroGeralService;
        this.requerimentoService = requerimentoService;
        this.aisePdfService = aisePdfService;
        this.contextService = contextService;
    }
}

