/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogatewayprocessos;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.gatewayprocessos.client.dto.ProcessoDTO;
import br.com.elotech.gatewayprocessos.client.dto.ProcessoParams;
import br.com.elotech.gatewayprocessos.client.feign.ProcessoSEIFeignClient;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import feign.FeignException;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoProcessoSeiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoProcessoSeiService.class);
    private final Optional<ProcessoSEIFeignClient> processoSEIFeignClient;
    private final EntidadeServiceImpl entidadeService;

    public ProcessoDTO findProcessoSei(String processoSei) {
        ProcessoSEIFeignClient client = (ProcessoSEIFeignClient)this.processoSEIFeignClient.orElseThrow(() -> new EloValidationException("O client do sei n\u00e3o est\u00e1 dispon\u00edvel em ambiente onPremise."));
        Entidade entidadePrincipal = (Entidade)this.entidadeService.getEntidadePrincipal().orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a entidade principal."));
        if (Objects.isNull(entidadePrincipal.getIdUnico())) {
            throw new EloValidationException("A entidade %d - %s n\u00e3o possui o idUnico definido.".formatted(entidadePrincipal.getId(), entidadePrincipal.getNome()));
        }
        ProcessoParams processoParams = ProcessoParams.builder().identificadorProcesso(processoSei).idEntidade(entidadePrincipal.getIdUnico()).build();
        try {
            return client.find(processoParams);
        }
        catch (FeignException feignException) {
            if (feignException.status() == HttpStatus.BAD_REQUEST.value()) {
                throw new RestException(HttpStatus.NOT_FOUND, "ProcessoSEI %s n\u00e3o localizado.".formatted(processoSei), (Throwable)feignException);
            }
            log.error("Ocorreu um erro ao se comunicar com a API do Gateway de Processos: ", (Throwable)feignException);
            throw new RestException(HttpStatus.valueOf((int)feignException.status()), String.format("Erro ao localizar o ProcessoSEI %s: %s", processoSei, feignException.getMessage()), (Throwable)feignException);
        }
    }

    @Generated
    public IntegracaoProcessoSeiService(Optional<ProcessoSEIFeignClient> processoSEIFeignClient, EntidadeServiceImpl entidadeService) {
        this.processoSEIFeignClient = processoSEIFeignClient;
        this.entidadeService = entidadeService;
    }
}

