/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.CadastroSocioFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.SocioFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.tuple.TupleUtils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.postgresql.util.PGobject;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoSocioFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<CadastroSocioFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-socio-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlFinal = String.format(sql, sqlFiltro, "");
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlPagination = this.getSqlPagination(pageable);
        return String.format(sql, sqlFiltro, sqlPagination);
    }

    public RowMapper<CadastroSocioFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> {
            CadastroSocioFintelSgoIntegracaoDTO cadastro = this.mapperCadastro(rs);
            cadastro.setSocios(this.mapperSocio(rs));
            return cadastro;
        };
    }

    private CadastroSocioFintelSgoIntegracaoDTO mapperCadastro(ResultSet rs) throws SQLException {
        CadastroSocioFintelSgoIntegracaoDTO cadastro = new CadastroSocioFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("TipoCadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroSocioFintelSgoIntegracaoDTO)cadastro).setTipoCadastro(arg_0));
        Optional.ofNullable(rs.getString("CadastroGeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroSocioFintelSgoIntegracaoDTO)cadastro).setCadastroGeral(arg_0));
        return cadastro;
    }

    private List<SocioFintelSgoIntegracaoDTO> mapperSocio(ResultSet rs) throws SQLException {
        Object[] socios;
        HashMap<String, SocioFintelSgoIntegracaoDTO> socioMapeado = new HashMap<String, SocioFintelSgoIntegracaoDTO>();
        Array socioArray = rs.getArray("socios");
        if (socioArray == null) {
            return Collections.emptyList();
        }
        for (Object element : socios = (Object[])socioArray.getArray()) {
            PGobject pgObj = (PGobject)element;
            String tuple = pgObj.getValue();
            List socio = TupleUtils.parse((String)tuple);
            String id = String.format("%s-%s-%s", socio.get(0), socio.get(1), socio.get(2));
            if (socioMapeado.containsKey(id)) continue;
            SocioFintelSgoIntegracaoDTO objectSocio = new SocioFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)socio.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setTipoCadastro(arg_0));
            Optional.ofNullable((String)socio.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setCadastroGeral(arg_0));
            Optional.ofNullable((String)socio.get(2)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setNome(arg_0));
            Optional.ofNullable((String)socio.get(3)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setVinculo(arg_0));
            Optional.ofNullable((String)socio.get(4)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setPrincipal(arg_0));
            Optional.ofNullable((String)socio.get(5)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setDescVinculo(arg_0));
            Optional.ofNullable((String)socio.get(6)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setPercentual(arg_0));
            Optional.ofNullable((String)socio.get(7)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setSigla(arg_0));
            Optional.ofNullable((String)socio.get(8)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setLogradouro(arg_0));
            Optional.ofNullable((String)socio.get(9)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setNumero(arg_0));
            Optional.ofNullable((String)socio.get(10)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setBairro(arg_0));
            Optional.ofNullable((String)socio.get(11)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setCidade(arg_0));
            Optional.ofNullable((String)socio.get(12)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setUf(arg_0));
            Optional.ofNullable((String)socio.get(13)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setCnpjCpf(arg_0));
            Optional.ofNullable((String)socio.get(14)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setRg(arg_0));
            Optional.ofNullable((String)socio.get(15)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setOrgaoEmissor(arg_0));
            Optional.ofNullable((String)socio.get(16)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setTelefoneResidencial(arg_0));
            Optional.ofNullable((String)socio.get(17)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setTelefoneComercial(arg_0));
            Optional.ofNullable((String)socio.get(18)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setTelefoneCelular(arg_0));
            Optional.ofNullable((String)socio.get(19)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setEmail(arg_0));
            Optional.ofNullable((String)socio.get(20)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setTipoPessoa(arg_0));
            Optional.ofNullable((String)socio.get(21)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setComplementoEndereco(arg_0));
            Optional.ofNullable((String)socio.get(22)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setCep(arg_0));
            Optional.ofNullable((String)socio.get(23)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((SocioFintelSgoIntegracaoDTO)objectSocio).setPessoa(arg_0));
            socioMapeado.put(id, objectSocio);
        }
        ArrayList<SocioFintelSgoIntegracaoDTO> list = new ArrayList<SocioFintelSgoIntegracaoDTO>(socioMapeado.values());
        list.sort(Comparator.comparing(SocioFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal, Long tipoCadastro, Long cadastroGeral) {
        Object filtro = "";
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            filtro = " and tcg.dataalteracao between ':dataInicial' and ':dataFinal'";
            filtro = ((String)filtro).replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = ((String)filtro).replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
        }
        if (Objects.nonNull(tipoCadastro) && Objects.nonNull(cadastroGeral)) {
            filtro = (String)filtro + " and (tcg.tipocadastro = :tipoCadastro and tcg.cadastrogeral = :cadastroGeral)";
            filtro = ((String)filtro).replace(":tipoCadastro", String.valueOf(tipoCadastro));
            filtro = ((String)filtro).replace(":cadastroGeral", String.valueOf(cadastroGeral));
        }
        return filtro;
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

