/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.DebitoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoDebitoFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<DebitoFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-debito-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlFinal = String.format(sql, sqlFiltro, "");
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlPagination = this.getSqlPagination(pageable);
        return String.format(sql, sqlFiltro, sqlPagination);
    }

    public RowMapper<DebitoFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> this.mapperDebito(rs);
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private DebitoFintelSgoIntegracaoDTO mapperDebito(ResultSet rs) throws SQLException {
        DebitoFintelSgoIntegracaoDTO debito = new DebitoFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("TipoCadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setTipoCadastro(arg_0));
        Optional.ofNullable(rs.getString("CadastroGeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setCadastroGeral(arg_0));
        Optional.ofNullable(rs.getString("Exercicio")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setExercicio(arg_0));
        Optional.ofNullable(rs.getString("GuiaRecolhimento")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setGuiaRecolhimento(arg_0));
        Optional.ofNullable(rs.getString("Subdivida")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setSubDivida(arg_0));
        Optional.ofNullable(rs.getString("Parcela")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setParcela(arg_0));
        Optional.ofNullable(rs.getString("DataLancamento")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setDataLancamento(arg_0));
        Optional.ofNullable(rs.getString("DataVencimento")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setDataVencimento(arg_0));
        Optional.ofNullable(rs.getString("Valor")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setValor(arg_0));
        Optional.ofNullable(rs.getString("Ativa")).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setAtiva(arg_0));
        Optional.ofNullable(rs.getString("Juizo")).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setJuizo(arg_0));
        Optional.ofNullable(rs.getString("situacaoDebito")).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setSituacaoDebito(arg_0));
        Optional.ofNullable(rs.getString("Aliquota")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setAliquota(arg_0));
        Optional.ofNullable(rs.getString("SistemaGeracao")).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setSistemaGeracao(arg_0));
        Optional.ofNullable(rs.getString("Parcelado")).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setParcelado(arg_0));
        Optional.ofNullable(rs.getString("Reparcelado")).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setReparcelado(arg_0));
        Optional.ofNullable(rs.getString("MesReferencia")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((DebitoFintelSgoIntegracaoDTO)debito).setMesReferencia(arg_0));
        return debito;
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal, Long tipoCadastro, Long cadastroGeral) {
        Object filtro = "";
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            filtro = " and tdp.datasituacao between ':dataInicial' AND ':dataFinal'";
            filtro = ((String)filtro).replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = ((String)filtro).replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
        }
        if (Objects.nonNull(tipoCadastro) && Objects.nonNull(cadastroGeral)) {
            filtro = (String)filtro + " and (tcg.tipocadastro = :tipoCadastro and tcg.cadastrogeral = :cadastroGeral)";
            filtro = ((String)filtro).replace(":tipoCadastro", String.valueOf(tipoCadastro));
            filtro = ((String)filtro).replace(":cadastroGeral", String.valueOf(cadastroGeral));
        }
        return filtro;
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

