/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.CadastroMobiliarioFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.MobiliarioAtividadeFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.MobiliarioCnaeFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.tuple.TupleUtils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.postgresql.util.PGobject;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoCadastroMobiliarioFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<CadastroMobiliarioFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-mobiliario-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlFinal = String.format(sql, sqlFiltro, "");
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlPagination = this.getSqlPagination(pageable);
        return String.format(sql, sqlFiltro, sqlPagination);
    }

    public RowMapper<CadastroMobiliarioFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> {
            CadastroMobiliarioFintelSgoIntegracaoDTO mobiliario = this.mapperMobiliario(rs);
            mobiliario.setCnaes(this.mapperCnae(rs));
            mobiliario.setAtividades(this.mapperAtividade(rs));
            return mobiliario;
        };
    }

    private CadastroMobiliarioFintelSgoIntegracaoDTO mapperMobiliario(ResultSet rs) throws SQLException {
        CadastroMobiliarioFintelSgoIntegracaoDTO mobiliario = new CadastroMobiliarioFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("DataAlvara")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataAlvara(arg_0));
        Optional.ofNullable(rs.getString("SuperSimples")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setSuperSimples(arg_0));
        Optional.ofNullable(rs.getString("SubstituicaoTributaria")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setSubstituicaoTributaria(arg_0));
        Optional.ofNullable(rs.getString("DispensaNotaFiscal")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDispensaNotaFiscal(arg_0));
        Optional.ofNullable(rs.getString("TipoOperacao")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setTipoOperacao(arg_0));
        Optional.ofNullable(rs.getString("IdNotificacaoFiscalizacao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setIdNotificacaoFiscalizacao(arg_0));
        Optional.ofNullable(rs.getString("TipoCadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setTipoCadastro(arg_0));
        Optional.ofNullable(rs.getString("CadastroGeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCadastroGeral(arg_0));
        Optional.ofNullable(rs.getString("PessoaMobiliario")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setPessoaMobiliario(arg_0));
        Optional.ofNullable(rs.getString("CnpjCpf")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCnpjCpf(arg_0));
        Optional.ofNullable(rs.getString("Nome")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setNome(arg_0));
        Optional.ofNullable(rs.getString("Estimado")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setEstimado(arg_0));
        Optional.ofNullable(rs.getString("Municipio")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setMunicipio(arg_0));
        Optional.ofNullable(rs.getString("Arbit")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setArbit(arg_0));
        Optional.ofNullable(rs.getString("Arbit2")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setArbit2(arg_0));
        Optional.ofNullable(rs.getString("Arbit3")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setArbit3(arg_0));
        Optional.ofNullable(rs.getString("TipoLogradouro")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setTipoLogradouro(arg_0));
        Optional.ofNullable(rs.getString("Logradouro")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setLogradouro(arg_0));
        Optional.ofNullable(rs.getString("Numero")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setNumero(arg_0));
        Optional.ofNullable(rs.getString("ComplementoCadGeral")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setComplementoCadGeral(arg_0));
        Optional.ofNullable(rs.getString("Bairro")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setBairro(arg_0));
        Optional.ofNullable(rs.getString("Cidade")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCidade(arg_0));
        Optional.ofNullable(rs.getString("Uf")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setUf(arg_0));
        Optional.ofNullable(rs.getString("Cep")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCep(arg_0));
        Optional.ofNullable(rs.getString("CodigoCgcm")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCodigoCgcm(arg_0));
        Optional.ofNullable(rs.getString("InscricaoCadastral")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("ZonaInsc")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setZonaInsc(arg_0));
        Optional.ofNullable(rs.getString("QuadraInsc")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setQuadraInsc(arg_0));
        Optional.ofNullable(rs.getString("DataInsc")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataInsc(arg_0));
        Optional.ofNullable(rs.getString("TaxaLocalizacao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setTaxaLocalizacao(arg_0));
        Optional.ofNullable(rs.getString("AreaUtilizada")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAreaUtilizada(arg_0));
        Optional.ofNullable(rs.getString("CodigoBombeiro")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCodigoBombeiro(arg_0));
        Optional.ofNullable(rs.getString("AreaBombeiro")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAreaBombeiro(arg_0));
        Optional.ofNullable(rs.getString("QtdAptos")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setQtdAptos(arg_0));
        Optional.ofNullable(rs.getString("NumEmpregados")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setNumEmpregados(arg_0));
        Optional.ofNullable(rs.getString("QualiSuper")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setQualiSuper(arg_0));
        Optional.ofNullable(rs.getString("QualiTec")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setQualiTec(arg_0));
        Optional.ofNullable(rs.getString("ComAmb")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setComAmb(arg_0));
        Optional.ofNullable(rs.getString("QtdComAmb")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setQtdComAmb(arg_0));
        Optional.ofNullable(rs.getString("OcupSolo")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setOcupSolo(arg_0));
        Optional.ofNullable(rs.getString("QtdOcupSolo")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setQtdOcupSolo(arg_0));
        Optional.ofNullable(rs.getString("NumSocios")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setNumSocios(arg_0));
        Optional.ofNullable(rs.getString("SituacaoEstabelecimento")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setSituacaoEstabelecimento(arg_0));
        Optional.ofNullable(rs.getString("NumeroAlvara")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setNumeroAlvara(arg_0));
        Optional.ofNullable(rs.getString("DataValidadeAlvara")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataValidadeAlvara(arg_0));
        Optional.ofNullable(rs.getString("DataAbertura")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataAbertura(arg_0));
        Optional.ofNullable(rs.getString("DataEncerramento")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataEncerramento(arg_0));
        Optional.ofNullable(rs.getString("ProtocoloAbertura")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setProtocoloAbertura(arg_0));
        Optional.ofNullable(rs.getString("DataProtocoloAbertura")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataProtocoloAbertura(arg_0));
        Optional.ofNullable(rs.getString("DataAuditoriaInicio")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataAuditoriaInicio(arg_0));
        Optional.ofNullable(rs.getString("DataAuditoriaFim")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataAuditoriaFim(arg_0));
        Optional.ofNullable(rs.getString("DataHomologacao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataHomologacao(arg_0));
        Optional.ofNullable(rs.getString("CodigoFiscal")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCodigoFiscal(arg_0));
        Optional.ofNullable(rs.getString("NomeFiscal")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setNomeFiscal(arg_0));
        Optional.ofNullable(rs.getString("Notificacao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setNotificacao(arg_0));
        Optional.ofNullable(rs.getString("AnoNotificacao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAnoNotificacao(arg_0));
        Optional.ofNullable(rs.getString("IdAutoInfracaoFiscal")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setIdAutoInfracaoFiscal(arg_0));
        Optional.ofNullable(rs.getString("EmiteNotaFiscal")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setEmiteNotaFiscal(arg_0));
        Optional.ofNullable(rs.getString("CmcResponsavel")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCmcResponsavel(arg_0));
        Optional.ofNullable(rs.getString("Email")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setEmail(arg_0));
        Optional.ofNullable(rs.getString("Telefone")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setTelefone(arg_0));
        Optional.ofNullable(rs.getString("DataAlteracao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setDataAlteracao(arg_0));
        Optional.ofNullable(rs.getString("Atividade1")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAtividade1(arg_0));
        Optional.ofNullable(rs.getString("Atividade2")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAtividade2(arg_0));
        Optional.ofNullable(rs.getString("Atividade3")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAtividade3(arg_0));
        Optional.ofNullable(rs.getString("Atividade4")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAtividade4(arg_0));
        Optional.ofNullable(rs.getString("CodigoIss1")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCodigoIss1(arg_0));
        Optional.ofNullable(rs.getString("CodigoIss2")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCodigoIss2(arg_0));
        Optional.ofNullable(rs.getString("CodigoIss3")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCodigoIss3(arg_0));
        Optional.ofNullable(rs.getString("ExclusaoLogica")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setExclusaoLogica(arg_0));
        Optional.ofNullable(rs.getString("AtividadePrincipal")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setAtividadePrincipal(arg_0));
        Optional.ofNullable(rs.getString("ObservacaoAlvara")).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setObservacaoAlvara(arg_0));
        Optional.ofNullable(rs.getString("TipoCadastroImobiliario")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setTipoCadastroImobiliario(arg_0));
        Optional.ofNullable(rs.getString("CadastroGeralImobiliario")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroMobiliarioFintelSgoIntegracaoDTO)mobiliario).setCadastroGeralImobiliario(arg_0));
        return mobiliario;
    }

    private List<MobiliarioAtividadeFintelSgoIntegracaoDTO> mapperAtividade(ResultSet rs) throws SQLException {
        Object[] atividades;
        HashMap<String, MobiliarioAtividadeFintelSgoIntegracaoDTO> atividadeMapeado = new HashMap<String, MobiliarioAtividadeFintelSgoIntegracaoDTO>();
        Array atividadeArray = rs.getArray("atividades");
        if (atividadeArray == null) {
            return Collections.emptyList();
        }
        for (Object element : atividades = (Object[])atividadeArray.getArray()) {
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null) continue;
            List atividade = TupleUtils.parse((String)tuple);
            String id = String.format("%s-%s-%s", atividade.get(0), atividade.get(1), atividade.get(2));
            atividadeMapeado.computeIfAbsent(id, k -> {
                MobiliarioAtividadeFintelSgoIntegracaoDTO objectAtividade = new MobiliarioAtividadeFintelSgoIntegracaoDTO();
                Optional.ofNullable((String)atividade.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((MobiliarioAtividadeFintelSgoIntegracaoDTO)objectAtividade).setTipoCadastro(arg_0));
                Optional.ofNullable((String)atividade.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((MobiliarioAtividadeFintelSgoIntegracaoDTO)objectAtividade).setCadastroGeral(arg_0));
                Optional.ofNullable((String)atividade.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((MobiliarioAtividadeFintelSgoIntegracaoDTO)objectAtividade).setAtividade(arg_0));
                Optional.ofNullable((String)atividade.get(3)).ifPresent(arg_0 -> ((MobiliarioAtividadeFintelSgoIntegracaoDTO)objectAtividade).setDescAtividade(arg_0));
                Optional.ofNullable((String)atividade.get(4)).ifPresent(arg_0 -> ((MobiliarioAtividadeFintelSgoIntegracaoDTO)objectAtividade).setAtividadePrincipal(arg_0));
                return objectAtividade;
            });
        }
        ArrayList<MobiliarioAtividadeFintelSgoIntegracaoDTO> list = new ArrayList<MobiliarioAtividadeFintelSgoIntegracaoDTO>(atividadeMapeado.values());
        list.sort(Comparator.comparing(MobiliarioAtividadeFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private List<MobiliarioCnaeFintelSgoIntegracaoDTO> mapperCnae(ResultSet rs) throws SQLException {
        Object[] cnaes;
        HashMap<String, MobiliarioCnaeFintelSgoIntegracaoDTO> cnaeMapeado = new HashMap<String, MobiliarioCnaeFintelSgoIntegracaoDTO>();
        Array contatoArray = rs.getArray("cnaes");
        if (contatoArray == null) {
            return Collections.emptyList();
        }
        for (Object element : cnaes = (Object[])contatoArray.getArray()) {
            List cnae;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || cnaeMapeado.containsKey(id = String.format("%s-%s-%s", (cnae = TupleUtils.parse((String)tuple)).get(0), cnae.get(1), cnae.get(2)))) continue;
            MobiliarioCnaeFintelSgoIntegracaoDTO objectCnae = new MobiliarioCnaeFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)cnae.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((MobiliarioCnaeFintelSgoIntegracaoDTO)objectCnae).setTipoCadastro(arg_0));
            Optional.ofNullable((String)cnae.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((MobiliarioCnaeFintelSgoIntegracaoDTO)objectCnae).setCadastroGeral(arg_0));
            Optional.ofNullable((String)cnae.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((MobiliarioCnaeFintelSgoIntegracaoDTO)objectCnae).setCodigo(arg_0));
            Optional.ofNullable((String)cnae.get(3)).ifPresent(arg_0 -> ((MobiliarioCnaeFintelSgoIntegracaoDTO)objectCnae).setDescCnae(arg_0));
            Optional.ofNullable((String)cnae.get(4)).ifPresent(arg_0 -> ((MobiliarioCnaeFintelSgoIntegracaoDTO)objectCnae).setCnaePrincipal(arg_0));
            Optional.ofNullable((String)cnae.get(5)).ifPresent(arg_0 -> ((MobiliarioCnaeFintelSgoIntegracaoDTO)objectCnae).setInativo(arg_0));
            Optional.ofNullable((String)cnae.get(6)).ifPresent(arg_0 -> ((MobiliarioCnaeFintelSgoIntegracaoDTO)objectCnae).setGrauRisco(arg_0));
            cnaeMapeado.put(id, objectCnae);
        }
        ArrayList<MobiliarioCnaeFintelSgoIntegracaoDTO> list = new ArrayList<MobiliarioCnaeFintelSgoIntegracaoDTO>(cnaeMapeado.values());
        list.sort(Comparator.comparing(MobiliarioCnaeFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal, Long tipoCadastro, Long cadastroGeral) {
        Object filtro = "";
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            filtro = " and ((tcg.dataalteracao between ':dataInicial' and ':dataFinal')  or (tcg.datainclusao between ':dataInicial' and ':dataFinal'))";
            filtro = ((String)filtro).replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = ((String)filtro).replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
        }
        if (Objects.nonNull(tipoCadastro) && Objects.nonNull(cadastroGeral)) {
            filtro = (String)filtro + " and (tcg.tipocadastro = :tipoCadastro and tcg.cadastrogeral = :cadastroGeral)";
            filtro = ((String)filtro).replace(":tipoCadastro", String.valueOf(tipoCadastro));
            filtro = ((String)filtro).replace(":cadastroGeral", String.valueOf(cadastroGeral));
        }
        return filtro;
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

