/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.CadastroImobiliarioFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ImobiliarioAreaVerdeFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ImobiliarioProprietarioFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ImobiliarioSegmentoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ImobiliarioTerrenoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ImobiliarioTestadaFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.tuple.TupleUtils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.postgresql.util.PGobject;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoCadastroImobiliarioFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<CadastroImobiliarioFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-imobiliario-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlFinal = String.format(sql, sqlFiltro, "");
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlPagination = this.getSqlPagination(pageable);
        return String.format(sql, sqlFiltro, sqlPagination);
    }

    public RowMapper<CadastroImobiliarioFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> {
            CadastroImobiliarioFintelSgoIntegracaoDTO imobiliario = this.mapperImobiliario(rs);
            imobiliario.setProprietarios(this.mapperProprietarios(rs));
            imobiliario.setTerrenos(this.mapperTerrenos(rs));
            imobiliario.setSegmentos(this.mapperSegmentos(rs));
            imobiliario.setAreasVerdes(this.mapperAreasVerdes(rs));
            imobiliario.setTestadas(this.mapperTestadas(rs));
            return imobiliario;
        };
    }

    private CadastroImobiliarioFintelSgoIntegracaoDTO mapperImobiliario(ResultSet rs) throws SQLException {
        CadastroImobiliarioFintelSgoIntegracaoDTO imobiliario = new CadastroImobiliarioFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("tipocadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setTipoCadastro(arg_0));
        Optional.ofNullable(rs.getString("cadastrogeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCadastroGeral(arg_0));
        Optional.ofNullable(rs.getString("tipooperacao")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setTipoOperacao(arg_0));
        Optional.ofNullable(rs.getString("pessoa")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setPessoa(arg_0));
        Optional.ofNullable(rs.getString("nome")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setNome(arg_0));
        Optional.ofNullable(rs.getString("tipopessoa")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setTipoPessoa(arg_0));
        Optional.ofNullable(rs.getString("cnpj_cpf")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCnpjCpf(arg_0));
        Optional.ofNullable(rs.getString("complemento")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setComplemento(arg_0));
        Optional.ofNullable(rs.getString("codigosistemaanterior")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCodigoSistemaAnterior(arg_0));
        Optional.ofNullable(rs.getString("suspensoemissao")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setSuspensaoEmissao(arg_0));
        Optional.ofNullable(rs.getString("exclusaologica")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setExclusaoLogica(arg_0));
        Optional.ofNullable(rs.getString("englobado")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setEnglobado(arg_0));
        Optional.ofNullable(rs.getString("datainclusao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDataInclusao(arg_0));
        Optional.ofNullable(rs.getString("dataalteracao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDataAlteracao(arg_0));
        Optional.ofNullable(rs.getString("logradouro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLogradouro(arg_0));
        Optional.ofNullable(rs.getString("tipologradouro")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setTipoLogradouro(arg_0));
        Optional.ofNullable(rs.getString("desclogradouro")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDescLogradouro(arg_0));
        Optional.ofNullable(rs.getString("numero")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setNumero(arg_0));
        Optional.ofNullable(rs.getString("bairro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setBairro(arg_0));
        Optional.ofNullable(rs.getString("cep")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCep(arg_0));
        Optional.ofNullable(rs.getString("desccidade")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDescCidade(arg_0));
        Optional.ofNullable(rs.getString("descbairro")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDescBairro(arg_0));
        Optional.ofNullable(rs.getString("inscricaocadastral")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("inscricaocadastralanterior")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setInscricaoCadastralAnterior(arg_0));
        Optional.ofNullable(rs.getString("trecho_inscricaocadastral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setTrechoInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("quadra_inscricaocadastral")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setQuadraInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("lote_inscricaocadastral")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLoteInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("distrito_inscricaocadastral")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDistritoInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("setor_inscricaocadastral")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setSetorInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("unidade_inscricaocadastral")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setUnidadeInscricaoCadastral(arg_0));
        Optional.ofNullable(rs.getString("distrito_descr")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDistritoDescr(arg_0));
        Optional.ofNullable(rs.getString("descdistrito")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDescDistrito(arg_0));
        Optional.ofNullable(rs.getString("setor_descr")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setSetorDescr(arg_0));
        Optional.ofNullable(rs.getString("trecho_descr")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setTrechoDescr(arg_0));
        Optional.ofNullable(rs.getString("quadra_descr")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setQuadraDescr(arg_0));
        Optional.ofNullable(rs.getString("lote_descr")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLoteDescr(arg_0));
        Optional.ofNullable(rs.getString("unidade_descr")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setUnidadeDescr(arg_0));
        Optional.ofNullable(rs.getString("imobiliaria")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setImobiliaria(arg_0));
        Optional.ofNullable(rs.getString("condominio")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCondominio(arg_0));
        Optional.ofNullable(rs.getString("desccondominio")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDescCondominio(arg_0));
        Optional.ofNullable(rs.getString("loteamento")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLoteamento(arg_0));
        Optional.ofNullable(rs.getString("descloteamento")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDescLoteamento(arg_0));
        Optional.ofNullable(rs.getString("tipoimovel")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setTipoImovel(arg_0));
        Optional.ofNullable(rs.getString("anoaliquotaprogressiva")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setAnoAliquotaProgressiva(arg_0));
        Optional.ofNullable(rs.getString("arealote")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setAreaLote(arg_0));
        Optional.ofNullable(rs.getString("profundidademedia")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setProfundidadeMedia(arg_0));
        Optional.ofNullable(rs.getString("areatotalconstruida")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setAreaTotalConstruida(arg_0));
        Optional.ofNullable(rs.getString("limitacercamuro")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLimiteCercaMuro(arg_0));
        Optional.ofNullable(rs.getString("imovelproprio")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setImovelProprio(arg_0));
        Optional.ofNullable(rs.getString("matricula")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setMatricula(arg_0));
        Optional.ofNullable(rs.getString("cartorio")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCartorio(arg_0));
        Optional.ofNullable(rs.getString("datamatricula")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDataMatricula(arg_0));
        Optional.ofNullable(rs.getString("livro")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLivro(arg_0));
        Optional.ofNullable(rs.getString("folha")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setFolha(arg_0));
        Optional.ofNullable(rs.getString("facequadra")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setFaceQuadra(arg_0));
        Optional.ofNullable(rs.getString("caucionado")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCaucionado(arg_0));
        Optional.ofNullable(rs.getString("latitude")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLatitude(arg_0));
        Optional.ofNullable(rs.getString("longitude")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setLongitude(arg_0));
        Optional.ofNullable(rs.getString("areautillote")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setAreaUtilLote(arg_0));
        Optional.ofNullable(rs.getString("areaprivativa")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setAreaPrivativa(arg_0));
        Optional.ofNullable(rs.getString("areacomum")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setAreaComum(arg_0));
        Optional.ofNullable(rs.getString("complementolote")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setComplementoLote(arg_0));
        Optional.ofNullable(rs.getString("codisencao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setCodIsencao(arg_0));
        Optional.ofNullable(rs.getString("descisencao")).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setDescIsencao(arg_0));
        Optional.ofNullable(rs.getString("patrimonio")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setPatrimonio(arg_0));
        Optional.ofNullable(rs.getString("areaverde")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setAreaVerde(arg_0));
        Optional.ofNullable(rs.getString("situacaolote")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroImobiliarioFintelSgoIntegracaoDTO)imobiliario).setSituacaoLote(arg_0));
        return imobiliario;
    }

    private List<ImobiliarioProprietarioFintelSgoIntegracaoDTO> mapperProprietarios(ResultSet rs) throws SQLException {
        Object[] proprietarios;
        HashMap<String, ImobiliarioProprietarioFintelSgoIntegracaoDTO> proprietariosMapeados = new HashMap<String, ImobiliarioProprietarioFintelSgoIntegracaoDTO>();
        Array proprietariosArray = rs.getArray("proprietarios");
        if (proprietariosArray == null) {
            return Collections.emptyList();
        }
        for (Object element : proprietarios = (Object[])proprietariosArray.getArray()) {
            List proprietario;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || proprietariosMapeados.containsKey(id = String.format("%s-%s-%s", (proprietario = TupleUtils.parse((String)tuple)).get(0), proprietario.get(1), proprietario.get(2)))) continue;
            ImobiliarioProprietarioFintelSgoIntegracaoDTO objectProprietario = new ImobiliarioProprietarioFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)proprietario.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setTipoCadastro(arg_0));
            Optional.ofNullable((String)proprietario.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setCadastroGeral(arg_0));
            Optional.ofNullable((String)proprietario.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setPessoa(arg_0));
            Optional.ofNullable((String)proprietario.get(3)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setTipoPessoa(arg_0));
            Optional.ofNullable((String)proprietario.get(4)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setNome(arg_0));
            Optional.ofNullable((String)proprietario.get(5)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setNomeFantasia(arg_0));
            Optional.ofNullable((String)proprietario.get(6)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setCnpjCpf(arg_0));
            Optional.ofNullable((String)proprietario.get(7)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setRg(arg_0));
            Optional.ofNullable((String)proprietario.get(8)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setOrgaoEmissor(arg_0));
            Optional.ofNullable((String)proprietario.get(9)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setPrincipal(arg_0));
            Optional.ofNullable((String)proprietario.get(10)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setVinculo(arg_0));
            Optional.ofNullable((String)proprietario.get(11)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setDescTipoVinculo(arg_0));
            Optional.ofNullable((String)proprietario.get(12)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setPercentual(arg_0));
            Optional.ofNullable((String)proprietario.get(13)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setSigla(arg_0));
            Optional.ofNullable((String)proprietario.get(14)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setDescLogradouro(arg_0));
            Optional.ofNullable((String)proprietario.get(15)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setNumero(arg_0));
            Optional.ofNullable((String)proprietario.get(16)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setCep(arg_0));
            Optional.ofNullable((String)proprietario.get(17)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setComplemento(arg_0));
            Optional.ofNullable((String)proprietario.get(18)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setUnidadeFederacao(arg_0));
            Optional.ofNullable((String)proprietario.get(19)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setDescBairro(arg_0));
            Optional.ofNullable((String)proprietario.get(20)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setDescCidade(arg_0));
            Optional.ofNullable((String)proprietario.get(21)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setTelRes(arg_0));
            Optional.ofNullable((String)proprietario.get(22)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setTelCom(arg_0));
            Optional.ofNullable((String)proprietario.get(23)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setCelular(arg_0));
            Optional.ofNullable((String)proprietario.get(24)).ifPresent(arg_0 -> ((ImobiliarioProprietarioFintelSgoIntegracaoDTO)objectProprietario).setEmail(arg_0));
            proprietariosMapeados.put(id, objectProprietario);
        }
        ArrayList<ImobiliarioProprietarioFintelSgoIntegracaoDTO> list = new ArrayList<ImobiliarioProprietarioFintelSgoIntegracaoDTO>(proprietariosMapeados.values());
        list.sort(Comparator.comparing(ImobiliarioProprietarioFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private List<ImobiliarioTerrenoFintelSgoIntegracaoDTO> mapperTerrenos(ResultSet rs) throws SQLException {
        Object[] terrenos;
        HashMap<String, ImobiliarioTerrenoFintelSgoIntegracaoDTO> terrenosMapeados = new HashMap<String, ImobiliarioTerrenoFintelSgoIntegracaoDTO>();
        Array terrenosArray = rs.getArray("terrenos");
        if (terrenosArray == null) {
            return Collections.emptyList();
        }
        for (Object element : terrenos = (Object[])terrenosArray.getArray()) {
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null) continue;
            List terreno = TupleUtils.parse((String)tuple);
            String id = String.format("%s-%s-%s-%s", terreno.get(0), terreno.get(1), terreno.get(2), terreno.get(3));
            terrenosMapeados.computeIfAbsent(id, k -> {
                ImobiliarioTerrenoFintelSgoIntegracaoDTO objectTerreno = new ImobiliarioTerrenoFintelSgoIntegracaoDTO();
                Optional.ofNullable((String)terreno.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTerrenoFintelSgoIntegracaoDTO)objectTerreno).setTipoCadastro(arg_0));
                Optional.ofNullable((String)terreno.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTerrenoFintelSgoIntegracaoDTO)objectTerreno).setCadastroGeral(arg_0));
                Optional.ofNullable((String)terreno.get(2)).ifPresent(arg_0 -> ((ImobiliarioTerrenoFintelSgoIntegracaoDTO)objectTerreno).setCampo(arg_0));
                Optional.ofNullable((String)terreno.get(3)).ifPresent(arg_0 -> ((ImobiliarioTerrenoFintelSgoIntegracaoDTO)objectTerreno).setResposta(arg_0));
                return objectTerreno;
            });
        }
        ArrayList<ImobiliarioTerrenoFintelSgoIntegracaoDTO> list = new ArrayList<ImobiliarioTerrenoFintelSgoIntegracaoDTO>(terrenosMapeados.values());
        list.sort(Comparator.comparing(ImobiliarioTerrenoFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private List<ImobiliarioSegmentoFintelSgoIntegracaoDTO> mapperSegmentos(ResultSet rs) throws SQLException {
        Object[] segmentos;
        HashMap<String, ImobiliarioSegmentoFintelSgoIntegracaoDTO> segmentosMapeados = new HashMap<String, ImobiliarioSegmentoFintelSgoIntegracaoDTO>();
        Array segmentosArray = rs.getArray("segmentos");
        if (segmentosArray == null) {
            return Collections.emptyList();
        }
        for (Object element : segmentos = (Object[])segmentosArray.getArray()) {
            List segmento;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || segmentosMapeados.containsKey(id = String.format("%s-%s-%s", (segmento = TupleUtils.parse((String)tuple)).get(0), segmento.get(1), segmento.get(2)))) continue;
            ImobiliarioSegmentoFintelSgoIntegracaoDTO objectSegmento = new ImobiliarioSegmentoFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)segmento.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setTipoCadastro(arg_0));
            Optional.ofNullable((String)segmento.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setCadastroGeral(arg_0));
            Optional.ofNullable((String)segmento.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setSequencia(arg_0));
            Optional.ofNullable((String)segmento.get(3)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setTipoSegmento(arg_0));
            Optional.ofNullable((String)segmento.get(4)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setAreaConstruida(arg_0));
            Optional.ofNullable((String)segmento.get(5)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setPrincipal(arg_0));
            Optional.ofNullable((String)segmento.get(6)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setCampo(arg_0));
            Optional.ofNullable((String)segmento.get(7)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setResposta(arg_0));
            Optional.ofNullable((String)segmento.get(8)).ifPresent(arg_0 -> ((ImobiliarioSegmentoFintelSgoIntegracaoDTO)objectSegmento).setSituacaoSegmento(arg_0));
            segmentosMapeados.put(id, objectSegmento);
        }
        ArrayList<ImobiliarioSegmentoFintelSgoIntegracaoDTO> list = new ArrayList<ImobiliarioSegmentoFintelSgoIntegracaoDTO>(segmentosMapeados.values());
        list.sort(Comparator.comparing(ImobiliarioSegmentoFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private List<ImobiliarioAreaVerdeFintelSgoIntegracaoDTO> mapperAreasVerdes(ResultSet rs) throws SQLException {
        Object[] areasVerdes;
        HashMap<String, ImobiliarioAreaVerdeFintelSgoIntegracaoDTO> areasVerdesMapeadas = new HashMap<String, ImobiliarioAreaVerdeFintelSgoIntegracaoDTO>();
        Array areasVerdesArray = rs.getArray("areasverdes");
        if (areasVerdesArray == null) {
            return Collections.emptyList();
        }
        for (Object element : areasVerdes = (Object[])areasVerdesArray.getArray()) {
            List areaVerde;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || areasVerdesMapeadas.containsKey(id = String.format("%s-%s-%s", (areaVerde = TupleUtils.parse((String)tuple)).get(0), areaVerde.get(1), areaVerde.get(2)))) continue;
            ImobiliarioAreaVerdeFintelSgoIntegracaoDTO objectAreaVerde = new ImobiliarioAreaVerdeFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)areaVerde.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioAreaVerdeFintelSgoIntegracaoDTO)objectAreaVerde).setTipoCadastro(arg_0));
            Optional.ofNullable((String)areaVerde.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioAreaVerdeFintelSgoIntegracaoDTO)objectAreaVerde).setCadastroGeral(arg_0));
            Optional.ofNullable((String)areaVerde.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioAreaVerdeFintelSgoIntegracaoDTO)objectAreaVerde).setSequencia(arg_0));
            Optional.ofNullable((String)areaVerde.get(3)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((ImobiliarioAreaVerdeFintelSgoIntegracaoDTO)objectAreaVerde).setArea(arg_0));
            Optional.ofNullable((String)areaVerde.get(4)).ifPresent(arg_0 -> ((ImobiliarioAreaVerdeFintelSgoIntegracaoDTO)objectAreaVerde).setSigla(arg_0));
            Optional.ofNullable((String)areaVerde.get(5)).ifPresent(arg_0 -> ((ImobiliarioAreaVerdeFintelSgoIntegracaoDTO)objectAreaVerde).setTipo(arg_0));
            areasVerdesMapeadas.put(id, objectAreaVerde);
        }
        ArrayList<ImobiliarioAreaVerdeFintelSgoIntegracaoDTO> list = new ArrayList<ImobiliarioAreaVerdeFintelSgoIntegracaoDTO>(areasVerdesMapeadas.values());
        list.sort(Comparator.comparing(ImobiliarioAreaVerdeFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private List<ImobiliarioTestadaFintelSgoIntegracaoDTO> mapperTestadas(ResultSet rs) throws SQLException {
        Object[] testadas;
        HashMap<String, ImobiliarioTestadaFintelSgoIntegracaoDTO> testadasMapeadas = new HashMap<String, ImobiliarioTestadaFintelSgoIntegracaoDTO>();
        Array testadasArray = rs.getArray("testadas");
        if (testadasArray == null) {
            return Collections.emptyList();
        }
        for (Object element : testadas = (Object[])testadasArray.getArray()) {
            List testada;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || testadasMapeadas.containsKey(id = String.format("%s-%s-%s", (testada = TupleUtils.parse((String)tuple)).get(0), testada.get(1), testada.get(2)))) continue;
            ImobiliarioTestadaFintelSgoIntegracaoDTO objectTestada = new ImobiliarioTestadaFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)testada.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setTipoCadastro(arg_0));
            Optional.ofNullable((String)testada.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setCadastroGeral(arg_0));
            Optional.ofNullable((String)testada.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setCodTestada(arg_0));
            Optional.ofNullable((String)testada.get(3)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setPrincipal(arg_0));
            Optional.ofNullable((String)testada.get(4)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setTipoLogradouro(arg_0));
            Optional.ofNullable((String)testada.get(5)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setLogCod(arg_0));
            Optional.ofNullable((String)testada.get(6)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setLogDescr(arg_0));
            Optional.ofNullable((String)testada.get(7)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setLogTrechoCod(arg_0));
            Optional.ofNullable((String)testada.get(8)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setLogTrechoDescr(arg_0));
            Optional.ofNullable((String)testada.get(9)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((ImobiliarioTestadaFintelSgoIntegracaoDTO)objectTestada).setTamanhoTestada(arg_0));
            testadasMapeadas.put(id, objectTestada);
        }
        ArrayList<ImobiliarioTestadaFintelSgoIntegracaoDTO> list = new ArrayList<ImobiliarioTestadaFintelSgoIntegracaoDTO>(testadasMapeadas.values());
        list.sort(Comparator.comparing(ImobiliarioTestadaFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal, Long tipoCadastro, Long cadastroGeral) {
        Object filtro = "";
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            filtro = " and (((':dataInicial' = '1899-12-30') AND (':dataFinal' = '1899-12-30')) OR      (((':dataInicial' <> '1899-12-30') AND (':dataFinal' <> '1899-12-30'))  AND       ((tcg.dataalteracao between ':dataInicial' and ':dataFinal') or        (tcg.dataexclusaologica between ':dataInicial' and ':dataFinal'))))";
            filtro = ((String)filtro).replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = ((String)filtro).replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
        }
        if (Objects.nonNull(tipoCadastro) && Objects.nonNull(cadastroGeral)) {
            filtro = (String)filtro + " and (tcg.tipocadastro = :tipoCadastro and tcg.cadastrogeral = :cadastroGeral)";
            filtro = ((String)filtro).replace(":tipoCadastro", String.valueOf(tipoCadastro));
            filtro = ((String)filtro).replace(":cadastroGeral", String.valueOf(cadastroGeral));
        }
        return filtro;
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

