/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.CadastroAvulsoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoCadastroAvulsoFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<CadastroAvulsoFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-cadastroavulso-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlFinal = String.format(sql, sqlFiltro, "");
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal(), filtro.getTipoCadastro(), filtro.getCadastroGeral());
        String sqlPagination = this.getSqlPagination(pageable);
        return String.format(sql, sqlFiltro, sqlPagination);
    }

    public RowMapper<CadastroAvulsoFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> this.mapperCadastroAvulso(rs);
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private CadastroAvulsoFintelSgoIntegracaoDTO mapperCadastroAvulso(ResultSet rs) throws SQLException {
        CadastroAvulsoFintelSgoIntegracaoDTO cadastroAvulso = new CadastroAvulsoFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("TipoCadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setTipoCadastro(arg_0));
        Optional.ofNullable(rs.getString("TipoCadastro_Descr")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setTipoCadastroDescr(arg_0));
        Optional.ofNullable(rs.getString("Pessoa")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setPessoa(arg_0));
        Optional.ofNullable(rs.getString("CadastroGeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setCadastroGeral(arg_0));
        Optional.ofNullable(rs.getString("Proprietario_Descr")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setProprietarioDescr(arg_0));
        Optional.ofNullable(rs.getString("CNPJ_CPF")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setCnpjCpf(arg_0));
        Optional.ofNullable(rs.getString("Logradouro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setLogradouro(arg_0));
        Optional.ofNullable(rs.getString("Sigla")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setSigla(arg_0));
        Optional.ofNullable(rs.getString("Logradouro_Descr")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setLogradouroDescr(arg_0));
        Optional.ofNullable(rs.getString("Numero")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setNumero(arg_0));
        Optional.ofNullable(rs.getString("Complemento")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setComplemento(arg_0));
        Optional.ofNullable(rs.getString("Bairro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setBairro(arg_0));
        Optional.ofNullable(rs.getString("Bairro_Descr")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setBairroDescr(arg_0));
        Optional.ofNullable(rs.getString("Cidade")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setCidade(arg_0));
        Optional.ofNullable(rs.getString("Cidade_Descr")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setCidadeDescr(arg_0));
        Optional.ofNullable(rs.getString("UnidadeFederacao")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setUnidadeFederacao(arg_0));
        Optional.ofNullable(rs.getString("UF_Descr")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setUfDescr(arg_0));
        Optional.ofNullable(rs.getString("ExclusaoLogica")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setExclusaoLogica(arg_0));
        Optional.ofNullable(rs.getString("Usuario")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setUsuario(arg_0));
        Optional.ofNullable(rs.getString("DataInclusao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setDataInclusao(arg_0));
        Optional.ofNullable(rs.getString("DataAlteracao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setDataAlteracao(arg_0));
        Optional.ofNullable(rs.getString("email")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setEmail(arg_0));
        Optional.ofNullable(rs.getString("telefoneresidencial")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setTelefoneResidencial(arg_0));
        Optional.ofNullable(rs.getString("cep")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setCep(arg_0));
        Optional.ofNullable(rs.getString("tipopessoa")).ifPresent(arg_0 -> ((CadastroAvulsoFintelSgoIntegracaoDTO)cadastroAvulso).setTipoPessoa(arg_0));
        return cadastroAvulso;
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal, Long tipoCadastro, Long cadastroGeral) {
        Object filtro = "";
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            filtro = " and (tcg.dataalteracao between ':dataInicial' and ':dataFinal')";
            filtro = ((String)filtro).replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = ((String)filtro).replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
        }
        if (Objects.nonNull(tipoCadastro) && Objects.nonNull(cadastroGeral)) {
            filtro = (String)filtro + " and (tcg.tipocadastro = :tipoCadastro and tcg.cadastrogeral = :cadastroGeral) ";
            filtro = ((String)filtro).replace(":tipoCadastro", String.valueOf(tipoCadastro));
            filtro = ((String)filtro).replace(":cadastroGeral", String.valueOf(cadastroGeral));
        }
        return filtro;
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

