/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo;

import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.enums.integracaofintelsgo.IntegracaoFintelSgoEnum;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoFintelSgoService {
    private final EntityManager entityManager;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ContextService context;

    public Page<?> findAllByIntegracao(IntegracaoFintelSgoEnum integracao, FiltroIntegracaoFintelSgoDTO filtros, Pageable pageable) {
        Long entidade = this.context.getEntidadePrincipal();
        Long exercicio = this.context.getExercicioAtual();
        ClassificacaoIntegracaoFintelSgo classificacao = integracao.getClassificacao();
        String sql = classificacao.getSql(filtros, pageable);
        sql = sql.replace(":entidade", entidade.toString());
        sql = sql.replace(":exercicio", exercicio.toString());
        String sqlCount = classificacao.getCountSql(filtros);
        sqlCount = sqlCount.replace(":entidade", entidade.toString());
        sqlCount = sqlCount.replace(":exercicio", exercicio.toString());
        Long totalElements = this.getCount(sqlCount);
        List result = this.getResult(sql, classificacao.getMapper());
        return new PageImpl(result, pageable, totalElements.longValue());
    }

    private Long getCount(String sqlCount) {
        Object object = this.entityManager.createNativeQuery(sqlCount).getSingleResult();
        return Long.valueOf(object.toString());
    }

    private <T> List<T> getResult(String sql, RowMapper<T> mapper) {
        return this.jdbcTemplate.query(sql, Map.of(), mapper);
    }

    @Generated
    public IntegracaoFintelSgoService(EntityManager entityManager, NamedParameterJdbcTemplate jdbcTemplate, ContextService context) {
        this.entityManager = entityManager;
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
    }
}

