/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintel;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualIssDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.fintel.BaixaAutomaticaBloquetoValoresFintelDTO;
import br.com.elotech.tributos.dto.fintel.BloquetoFintelDTO;
import br.com.elotech.tributos.dto.fintel.FetchBoletoFintelResourcesDTO;
import br.com.elotech.tributos.dto.fintel.GeracaoDebitoEBoletoFintelResponse;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.integracaofintel.ConsultaBoletoFintelService;
import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;

@Service
@Transactional
public class ProcessaPagamentoLoteFintelService
extends WebServiceGatewaySupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessaPagamentoLoteFintelService.class);
    private final Long SUB_DIVIDA_ISS_HOMOLOGADO = 100L;
    public static final String BAIXA_MANUAL = "BAIXAMANUALFINTEL";
    public static final String BAIXA_AUTOMATICA = "BAIXAAUTOMATICAFINTEL";
    private final DividaService dividaService;
    private final TipoMensagemService tipoMensagemService;
    private final GeraDebitoService geraDebitoService;
    private final GeraBoletoService geraBoletoService;
    private final EntityManager entityManager;
    private final ExercicioService exercicioService;
    private final DebitoService debitoService;
    private final ConsultaBoletoFintelService consultaBoletoFintelService;

    private boolean validaBoletoZerado(BloquetoFintelDTO bloquetoFintel) {
        boolean retorno = false;
        for (BaixaAutomaticaBloquetoValoresFintelDTO valores : bloquetoFintel.getValoresAgrupados().getAgrupados()) {
            BigDecimal valorTotal;
            if (valores == null || (valorTotal = valores.getValorTotal()) == null || valorTotal.compareTo(BigDecimal.ZERO) != 0) continue;
            retorno = true;
        }
        return retorno;
    }

    private BaixaAutomaticaDetalhe mensagemRetorno(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, TipoMensagemEnum tipoMensagemEnum, Object ... args) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(tipoMensagemEnum);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagem(String.format(tipoMensagemEnum.getDescricao(), args));
        return baixaAutomaticaDetalhe;
    }

    public BaixaAutomaticaDetalhe verificarLoteSequenciaFintel(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Optional bloquetoFintelResponse;
        String nossoNumero = baixaAutomaticaDetalhe.getNossoNumero();
        try {
            bloquetoFintelResponse = this.consultaBoletoFintelService.loadBloquetoFintel(nossoNumero);
        }
        catch (Exception e) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.ERRO_NAO_IDENTIFICADO);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(e.getMessage());
            return baixaAutomaticaDetalhe;
        }
        if (bloquetoFintelResponse.isEmpty()) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.BOLETO_NAO_IDENTIFICADO, new Object[0]);
        }
        BloquetoFintelDTO bloquetoFintel = (BloquetoFintelDTO)bloquetoFintelResponse.get();
        if (Objects.isNull(bloquetoFintel.getCadastroGeral()) || bloquetoFintel.getCadastroGeral().equals(0L)) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.CADASTRO_MOBILIARIO_NAO_ENCONTRADO, new Object[0]);
        }
        if (Objects.isNull(bloquetoFintel.getValoresAgrupados()) || bloquetoFintel.getValoresAgrupados().getAgrupados().isEmpty()) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.BOLETO_ZERADO, new Object[0]);
        }
        BigDecimal valorTotalCalculado = BigDecimal.ZERO;
        BigDecimal valorTotalBloqueto = BigDecimal.ZERO;
        for (BaixaAutomaticaBloquetoValoresFintelDTO valores : bloquetoFintel.getValoresAgrupados().getAgrupados()) {
            if (valores == null) continue;
            valorTotalCalculado = valorTotalCalculado.add(valores.getValorTotalCalculado());
            valorTotalBloqueto = valorTotalBloqueto.add(valores.getValorTotal());
        }
        if (baixaAutomaticaDetalhe.getValorPago().doubleValue() != valorTotalCalculado.doubleValue()) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.VALORTOTAL_DIFERENTE_VALORPAGO_FINTEL, new Object[]{valorTotalCalculado, baixaAutomaticaDetalhe.getValorPago()});
        }
        if (this.validaBoletoZerado(bloquetoFintel)) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.BOLETO_ZERADO, new Object[0]);
        }
        if (!valorTotalBloqueto.equals(valorTotalCalculado)) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.VALORES_TOTAIS_DIFERENTES_FINTEL, new Object[]{valorTotalBloqueto, valorTotalCalculado, baixaAutomaticaDetalhe.getMesMovimento(), baixaAutomaticaDetalhe.getAnoMovimento()});
        }
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_VALIDADO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagem(String.format("D\u00edvida %d validada com sucesso", bloquetoFintel.getCodigoTributo()));
        return baixaAutomaticaDetalhe;
    }

    private List<Debito> gerarDebito(FetchBoletoFintelResourcesDTO dadosConsulta, BloquetoFintelDTO bloquetoFintel) {
        log.debug("Gerando debito para o boleto. NossoNumero: [{}]", (Object)bloquetoFintel.getNossoNumero());
        AtomicLong mesReferencia = new AtomicLong(0L);
        AtomicLong anoReferencia = new AtomicLong(0L);
        AtomicDouble valorPago = new AtomicDouble(0.0);
        return bloquetoFintel.getValoresAgrupados().getAgrupados().stream().peek(agrupado -> {
            log.debug("Consultando D\u00edvida / Tributo para o m\u00eas de refer\u00eancia [{}]", (Object)agrupado.getMesReferencia());
            mesReferencia.set(this.getMesReferencia(agrupado.getMesReferencia()));
            anoReferencia.set(this.getAnoReferencia(agrupado.getMesReferencia()));
            valorPago.set(agrupado.getValorTotalCalculado().doubleValue());
        }).map(agrupado -> {
            Long dividaId = bloquetoFintel.getCodigoTributo();
            return this.getDividaTributo(dividaId, Long.valueOf(dadosConsulta.getEntidade()), Long.valueOf(anoReferencia.get()));
        }).filter(Optional::isPresent).peek(dividaTributo -> log.debug("Encontrado D\u00edvida [{}] / Tributo [{}]", (Object)((DividaTributo)dividaTributo.get()).getDivida().getDivida(), (Object)((DividaTributo)dividaTributo.get()).getTributo().getTributo())).map(dividaTributo -> {
            Long mes = mesReferencia.get();
            Long ano = anoReferencia.get();
            BigDecimal valor = BigDecimal.valueOf(valorPago.get());
            return TipoDivida.ISS_HOMOLOGADO.equals((Object)((DividaTributo)dividaTributo.get()).getDivida().getTipoDivida()) ? this.geraDebitoFintelIss(dadosConsulta, bloquetoFintel, dividaTributo, mes, ano, valor) : this.geraDebitoFintel(dadosConsulta, bloquetoFintel, dividaTributo, mes, ano, valor);
        }).filter(Optional::isPresent).peek(debito -> log.debug("Debito Gerado [{}]", (Object)((Debito)debito.get()).getId())).map(Optional::get).collect(Collectors.toList());
    }

    private Bloqueto gerarBoleto(BloquetoFintelDTO bloquetoFintel, List<DebitoParcelaDTO> debitoParcelaDTOS) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setEmiteBoletoFintel(Boolean.valueOf(true));
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(debitoParcelaDTOS.size() == 1 ? TipoBloqueto.PARCELADO : TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setDebitos(debitoParcelaDTOS);
        Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoletoSuperSimples(geraBoletoDTO).stream().findFirst().orElseThrow(() -> new IllegalStateException("Erro ao gerar boleto"));
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        boleto.setCodigoBarras(bloquetoFintel.getCodigoBarra());
        boleto.setNossoNumero(bloquetoFintel.getCodigoBarra().substring(27));
        boleto.setDvNossoNumero("");
        boleto.setDataVencimento(bloquetoFintel.getDataVencimento());
        boleto.setDataEmissao(bloquetoFintel.getDataEmissao());
        boleto.setDataLimitePagamento(bloquetoFintel.getDataValidade());
        boleto.setCampo1("");
        boleto.setCampo2("");
        boleto.setCampo3("");
        boleto.setCampo4("");
        boleto.setCampo5("");
        boleto.setCodigoBarrasFormatado("");
        this.entityManager.flush();
        return boleto;
    }

    public GeracaoDebitoEBoletoFintelResponse gerarDebitoEBoleto(FetchBoletoFintelResourcesDTO dadosConsulta) {
        String nossoNumero = dadosConsulta.getNossoNumero();
        GeracaoDebitoEBoletoFintelResponse response = GeracaoDebitoEBoletoFintelResponse.create();
        Optional bloquetoFintel = this.consultaBoletoFintelService.loadBloquetoFintel(nossoNumero);
        bloquetoFintel.map(dto -> this.gerarDebito(dadosConsulta, (BloquetoFintelDTO)bloquetoFintel.get())).map(debitos -> {
            response.withDebitos(debitos);
            return debitos.stream().map(DebitoParcelaDTO::fromUltimaParcelaDebito).toList();
        }).filter(e -> !e.isEmpty()).map(debitoParcelaDTOS -> {
            Bloqueto bloqueto = this.gerarBoleto((BloquetoFintelDTO)bloquetoFintel.get(), debitoParcelaDTOS);
            response.withBloqueto(bloqueto);
            return bloqueto;
        });
        return response;
    }

    private Long getMesReferencia(String competencia) {
        return !competencia.isEmpty() ? Long.parseLong(competencia.substring(5, 7)) : 0L;
    }

    private Long getAnoReferencia(String competencia) {
        return !competencia.isEmpty() ? Long.parseLong(competencia.substring(0, 4)) : 0L;
    }

    private Optional<Debito> geraDebitoFintel(FetchBoletoFintelResourcesDTO dadosConsulta, BloquetoFintelDTO BloquetoFintel, Optional<DividaTributo> dividaTributo, Long mesReferencia, Long anoReferencia, BigDecimal valorPago) {
        Long dividaId = BloquetoFintel.getCodigoTributo();
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
        if (dividaTributo.isPresent()) {
            debitoManualTributoDTO.setTributo(dividaTributo.get().getTributo().getTributo());
            debitoManualTributoDTO.setValorTributo(valorPago);
            debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
            debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
        }
        if (anoReferencia > this.exercicioService.getExercicio()) {
            debitoManualDTO.setExercicio(this.exercicioService.getExercicio());
        } else {
            debitoManualDTO.setExercicio(anoReferencia);
        }
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)BloquetoFintel.getTipoCadastro()));
        debitoManualDTO.setCadastroGeral(BloquetoFintel.getCadastroGeral());
        debitoManualDTO.setDivida(dividaId);
        debitoManualDTO.setDataLancamento(dadosConsulta.getDataMovimentoLote());
        debitoManualDTO.setDataInclusao(dadosConsulta.getDataMovimentoLote());
        debitoManualDTO.setPrograma(dadosConsulta.getOrigem());
        DebitoManualObservacaoDTO debitoManualObservacaoDTO = DebitoManualObservacaoDTO.of((String)this.mountObservacaoDebito(dadosConsulta));
        debitoManualDTO.getObservacoes().add(debitoManualObservacaoDTO);
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setParcela(Long.valueOf(1L));
        debitoManualParcelaDTO.setDataVencimento(dadosConsulta.getDataVencimento());
        debitoManualParcelaDTO.setValor(valorPago);
        debitoManualParcelaDTO.setDataSituacao(dadosConsulta.getDataMovimentoLote());
        debitoManualParcelaDTO.setAnoReferencia(anoReferencia);
        debitoManualParcelaDTO.setMesReferencia(mesReferencia);
        debitoManualDTO.getParcelas().add(debitoManualParcelaDTO);
        debitoManualDTO.getTributos().add(debitoManualTributoDTO);
        DebitoIdDTO debitoIdDTO = this.geraDebitoService.geraDebitoManual(debitoManualDTO);
        this.entityManager.flush();
        return this.debitoService.findByCompositeKey(debitoIdDTO.getEntidade(), debitoIdDTO.getExercicio(), debitoIdDTO.getTipoCadastro(), debitoIdDTO.getCadastroGeral(), debitoIdDTO.getDivida(), debitoIdDTO.getSubDivida());
    }

    private Optional<Debito> geraDebitoFintelIss(FetchBoletoFintelResourcesDTO dadosConsulta, BloquetoFintelDTO bloquetoFintel, Optional<DividaTributo> dividaTributo, Long mesReferencia, Long anoReferencia, BigDecimal valorPago) {
        Long dividaId = bloquetoFintel.getCodigoTributo();
        Long novaSubDivida = this.SUB_DIVIDA_ISS_HOMOLOGADO + mesReferencia;
        DebitoManualIssDTO debitoManualIssDTO = new DebitoManualIssDTO();
        dividaTributo.ifPresent(arg_0 -> ((DebitoManualIssDTO)debitoManualIssDTO).setTributo(arg_0));
        if (anoReferencia > this.exercicioService.getExercicio()) {
            debitoManualIssDTO.setExercicio(this.exercicioService.getExercicio());
        } else {
            debitoManualIssDTO.setExercicio(anoReferencia);
        }
        debitoManualIssDTO.setBaixaAutomatica(Boolean.TRUE);
        debitoManualIssDTO.setTipoCadastro(TipoCadastro.fromValue((Long)bloquetoFintel.getTipoCadastro()));
        debitoManualIssDTO.setCadastroGeral(bloquetoFintel.getCadastroGeral());
        debitoManualIssDTO.setDivida(dividaId);
        debitoManualIssDTO.setSubDivida(novaSubDivida);
        debitoManualIssDTO.setDataLancamento(dadosConsulta.getDataMovimentoLote());
        debitoManualIssDTO.setDataInclusao(dadosConsulta.getDataMovimentoLote());
        debitoManualIssDTO.setProgram(dadosConsulta.getOrigem());
        DebitoManualObservacaoDTO debitoManualObservacaoDTO = DebitoManualObservacaoDTO.of((String)this.mountObservacaoDebito(dadosConsulta));
        debitoManualIssDTO.getObservacoes().add(debitoManualObservacaoDTO);
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setDataVencimento(dadosConsulta.getDataVencimento());
        debitoManualParcelaDTO.setValor(valorPago);
        debitoManualParcelaDTO.setDataSituacao(dadosConsulta.getDataMovimentoLote());
        debitoManualParcelaDTO.setAnoReferencia(anoReferencia);
        debitoManualParcelaDTO.setMesReferencia(mesReferencia);
        debitoManualIssDTO.getParcelas().add(debitoManualParcelaDTO);
        Optional<Debito> debito = this.geraDebitoService.geraDebitoManualIss(debitoManualIssDTO).stream().findFirst();
        debito.ifPresent(a -> this.entityManager.flush());
        return debito;
    }

    private Optional<DividaTributo> getDividaTributo(Long dividaId, Long entidade, Long anoMovimento) {
        Long exercicioAtual = this.exercicioService.getExercicio();
        Long exercicio = anoMovimento > exercicioAtual ? exercicioAtual : anoMovimento;
        return this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, dividaId).map(Divida::getTributos).map(tributos -> tributos.stream().filter(DividaTributo::getReceitaPadrao).findFirst()).orElseThrow(() -> new EloValidationException(String.format("D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d para entidade %d", dividaId, exercicio, entidade)));
    }

    private String mountObservacaoDebito(FetchBoletoFintelResourcesDTO dadosConsulta) {
        boolean isBaixaAutomatica = BAIXA_AUTOMATICA.equals(dadosConsulta.getOrigem());
        String mainMessage = String.format("D\u00e9bito gerado pela baixa %s de lote %d/%d", isBaixaAutomatica ? "autom\u00e1tica" : "manual", dadosConsulta.getLote(), dadosConsulta.getExercicio());
        if (isBaixaAutomatica) {
            mainMessage = mainMessage.concat(String.format(" sequencia %d", dadosConsulta.getSequenciaArquivo()));
        }
        return mainMessage;
    }

    @Generated
    public ProcessaPagamentoLoteFintelService(DividaService dividaService, TipoMensagemService tipoMensagemService, GeraDebitoService geraDebitoService, GeraBoletoService geraBoletoService, EntityManager entityManager, ExercicioService exercicioService, DebitoService debitoService, ConsultaBoletoFintelService consultaBoletoFintelService) {
        this.dividaService = dividaService;
        this.tipoMensagemService = tipoMensagemService;
        this.geraDebitoService = geraDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.entityManager = entityManager;
        this.exercicioService = exercicioService;
        this.debitoService = debitoService;
        this.consultaBoletoFintelService = consultaBoletoFintelService;
    }
}

