/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintel;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.integracaofintel.ConsultaBoletoFintelService;
import br.com.elotech.tributos.service.integracaofintel.ProcessaPagamentoLoteFintelService;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoFintelService {
    public static final String FINTEL_PREFIX = "4444";
    private final ProcessaPagamentoLoteFintelService processamento;
    private final ConsultaBoletoFintelService consulta;
    private final ParametroGeralService parametroGeralService;

    public boolean isNossoNumeroDeBoletoFintel(String nossoNumero) {
        return nossoNumero.startsWith(FINTEL_PREFIX);
    }

    public boolean isIntegradoFintel() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.INTEGRADO_FINTEL, ModuloEnum.MODULO_TRIBUTARIO.getValue()).equals(SimNao.SIM.getSigla());
    }

    public ProcessaPagamentoLoteFintelService processar() {
        return this.processamento;
    }

    public ConsultaBoletoFintelService consultar() {
        return this.consulta;
    }

    @Generated
    public IntegracaoFintelService(ProcessaPagamentoLoteFintelService processamento, ConsultaBoletoFintelService consulta, ParametroGeralService parametroGeralService) {
        this.processamento = processamento;
        this.consulta = consulta;
        this.parametroGeralService = parametroGeralService;
    }
}

