/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintel;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.fintel.BloquetoFintelDTO;
import br.com.elotech.tributos.dto.fintel.ParametrosIntegracaoFintelDTO;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.integracaofintel.ParseXMLUtils;
import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ConsultaBoletoFintelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultaBoletoFintelService.class);
    private static final Map<String, ParametrosIntegracaoFintelDTO> CACHED_PARAMETROS_INTEGRACAO = new HashMap();
    private final RestTemplate restTemplate;
    private final ParametroGeralService parametroGeralService;

    public Optional<BloquetoFintelDTO> loadBloquetoFintel(String nossoNumero) {
        String tenantId = TenantContextHolder.getCurrentTenantId();
        try {
            ParametrosIntegracaoFintelDTO parametros = this.getCachedParametrosIntegracao(tenantId);
            log.debug("Iniciando Login na Fintel");
            Stopwatch stopwatch = Stopwatch.createStarted();
            String token = this.realizarLogin(parametros);
            stopwatch.stop();
            log.debug(String.format("Finalizado Login na Fintel com dura\u00e7\u00e3o de %d m %d s %d ms", stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            log.debug(String.format("Iniciando Busca do nossoNumero %s na Fintel", nossoNumero));
            stopwatch = Stopwatch.createStarted();
            String responseXml = this.buscarGuia(token, nossoNumero, parametros);
            stopwatch.stop();
            log.debug(String.format("Finalizado Busca do nossoNumero %s na Fintel com dura\u00e7\u00e3o de %d m %d s %d ms", nossoNumero, stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            return Optional.ofNullable(this.parseXML(responseXml));
        }
        catch (EloValidationException e) {
            log.error(String.format("Falha ao Buscar nossoNumero %s na Fintel. Erro: %s", nossoNumero, e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            log.error(String.format("Falha ao Buscar nossoNumero %s na Fintel. Erro: %s", nossoNumero, e.getMessage()));
            throw new EloValidationException("Erro inesperado na integra\u00e7\u00e3o com a FINTEL: " + e.getMessage());
        }
    }

    private String realizarLogin(ParametrosIntegracaoFintelDTO parametros) throws EloValidationException {
        String soapActionLogin = parametros.getSoapEndPointUrl() + "/Login";
        try {
            String response = this.callSoapWebService(soapActionLogin, this.mountXMLLoginRequest(parametros), parametros);
            return this.parseReturnTag(response);
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao chamar servi\u00e7o SOAP de Login da FINTEL: " + e.getMessage());
        }
    }

    private String buscarGuia(String token, String nossoNumero, ParametrosIntegracaoFintelDTO parametrosIntegracaoFintelDTO) throws EloValidationException {
        String soapActionGuia = parametrosIntegracaoFintelDTO.getSoapEndPointUrl() + "/GetGuiaById";
        try {
            return this.callSoapWebService(soapActionGuia, this.mountXMLGetBloqueto(token, nossoNumero, parametrosIntegracaoFintelDTO.getSoapUri()), parametrosIntegracaoFintelDTO);
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao chamar servi\u00e7o SOAP para buscar guia da FINTEL: " + e.getMessage());
        }
    }

    private String parseReturnTag(String responseXml) throws EloValidationException {
        try {
            return ParseXMLUtils.extractTagContent((String)responseXml, (String)"return");
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao processa tag 'return' do retorno da FINTEL: " + e.getMessage());
        }
    }

    private BloquetoFintelDTO parseXML(String responseXml) throws EloValidationException {
        try {
            String dataContent = this.parseReturnTag(responseXml);
            return Objects.isNull(dataContent) ? null : (BloquetoFintelDTO)ParseXMLUtils.unmarshalRetorno((String)dataContent, BloquetoFintelDTO.class, xml -> !xml.contains("ISS-e: guia n\u00e3o encontrada"));
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao converter XML de retorno da integra\u00e7\u00e3o com a FINTEL: " + e.getMessage());
        }
    }

    private String callSoapWebService(String soapAction, String xmlRequest, ParametrosIntegracaoFintelDTO parametrosIntegracaoFintelDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_XML);
        headers.set("SOAPAction", soapAction);
        HttpEntity request = new HttpEntity((Object)xmlRequest, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(parametrosIntegracaoFintelDTO.getSoapEndPointUrl(), HttpMethod.POST, request, String.class, new Object[0]);
        return (String)response.getBody();
    }

    private String mountXMLGetBloqueto(String key, String nossoNumero, String soapUri) throws SOAPException, IOException {
        return this.createSoapRequest("getGuiaById", Map.of("key", key, "nosnum", nossoNumero), soapUri);
    }

    private String mountXMLLoginRequest(ParametrosIntegracaoFintelDTO parametrosIntegracaoFintelDTO) throws SOAPException, IOException {
        String usuarioFintel = parametrosIntegracaoFintelDTO.getUsuarioFintel();
        String senhaFintel = parametrosIntegracaoFintelDTO.getSenhaFintel();
        return this.createSoapRequest("Login", Map.of("login", usuarioFintel, "pwd", senhaFintel), parametrosIntegracaoFintelDTO.getSoapUri());
    }

    private String createSoapRequest(String bodyName, Map<String, String> parameters, String soapURI) throws SOAPException, IOException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        Name soapBodyName = soapFactory.createName(bodyName, "", soapURI);
        SOAPBodyElement bodyElement = soapBody.addBodyElement(soapBodyName);
        TreeMap<String, String> sortedParameters = new TreeMap<String, String>(parameters);
        for (Map.Entry entry : sortedParameters.entrySet()) {
            SOAPElement element = bodyElement.addChildElement((String)entry.getKey());
            element.addTextNode((String)entry.getValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)out);
        return out.toString();
    }

    private ParametrosIntegracaoFintelDTO getCachedParametrosIntegracao(String tenantId) {
        ParametrosIntegracaoFintelDTO params = CACHED_PARAMETROS_INTEGRACAO.getOrDefault(tenantId, null);
        if (Objects.isNull(params)) {
            params = this.getParametrosFintel();
            CACHED_PARAMETROS_INTEGRACAO.putIfAbsent(tenantId, params);
        }
        return params;
    }

    public void loadCachedParameters() {
        this.getCachedParametrosIntegracao(TenantContextHolder.getCurrentTenantId());
    }

    public void removeCachedParameters() {
        CACHED_PARAMETROS_INTEGRACAO.remove(TenantContextHolder.getCurrentTenantId());
    }

    private ParametrosIntegracaoFintelDTO getParametrosFintel() {
        log.debug("Consultando par\u00e2metros para comunica\u00e7\u00e3o com a Fintel");
        BiConsumer<ParametroGeralEnum, Consumer> setValor = (paramEnum, consumer) -> {
            String modulo = ModuloEnum.MODULO_TRIBUTARIO.getValue();
            String param = this.parametroGeralService.getParamValueAsString(paramEnum, modulo);
            consumer.accept(param);
        };
        ParametrosIntegracaoFintelDTO parametrosIntegracaoFintelDTO = new ParametrosIntegracaoFintelDTO();
        setValor.accept(ParametroGeralEnum.ENDPOINT_FINTEL, arg_0 -> ((ParametrosIntegracaoFintelDTO)parametrosIntegracaoFintelDTO).setSoapEndPointUrl(arg_0));
        setValor.accept(ParametroGeralEnum.URI_FINTEL, arg_0 -> ((ParametrosIntegracaoFintelDTO)parametrosIntegracaoFintelDTO).setSoapUri(arg_0));
        setValor.accept(ParametroGeralEnum.USUARIO_FINTEL, arg_0 -> ((ParametrosIntegracaoFintelDTO)parametrosIntegracaoFintelDTO).setUsuarioFintel(arg_0));
        setValor.accept(ParametroGeralEnum.SENHA_FINTEL, arg_0 -> ((ParametrosIntegracaoFintelDTO)parametrosIntegracaoFintelDTO).setSenhaFintel(arg_0));
        return parametrosIntegracaoFintelDTO;
    }

    @Generated
    public ConsultaBoletoFintelService(RestTemplate restTemplate, ParametroGeralService parametroGeralService) {
        this.restTemplate = restTemplate;
        this.parametroGeralService = parametroGeralService;
    }
}

