/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoelogeo;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.SituacaoImobiliario;
import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.SolicitacaoAlvara;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.solicitacaotestada.SolicitacaoTestadaLog;
import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroGeralElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroGeralExistsElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroGeralPostElogeoDTO;
import br.com.elotech.tributos.repository.SolicitacaoAlvaraRepository;
import br.com.elotech.tributos.repository.solicitacaotestada.SolicitacaoTestadaLogRepository;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.service.integracaoelogeo.CadastroImobiliarioElogeo;
import br.com.elotech.tributos.util.EloRequireNonNull;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public abstract class CadastroImobiliarioElogeoServiceAbstract
implements CadastroImobiliarioElogeo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroImobiliarioElogeoServiceAbstract.class);
    protected final CadastroGeralService cadastroGeralService;
    protected final CadastroImobiliarioService cadastroImobiliarioService;
    protected final DistritoService distritoService;
    protected final SetorService setorService;
    protected final BairroService bairroService;
    protected final SetorQuadraService setorQuadraService;
    protected final SolicitacaoTestadaLogRepository solicitacaoTestadaLogRepository;
    protected final SolicitacaoAlvaraRepository solicitacaoAlvaraRepository;
    protected final LogradouroService logradouroService;
    protected final LoteamentoService loteamentoService;
    protected final CondominioService condominioService;
    protected final ParametroGeralService parametroGeralService;

    protected abstract void mergeBoletins(CadastroGeralPostElogeoDTO var1, CadastroImobiliario var2);

    protected abstract CadastroImobiliario prepareElogeoToSave(CadastroImobiliario var1, Boolean var2, CadastroGeralPostElogeoDTO var3);

    protected abstract CadastroGeralElogeoDTO entityToElogeoDTO(CadastroImobiliario var1);

    public Page<CadastroGeralElogeoDTO> findAllElogeoDTO(Pageable page, String search) {
        return this.cadastroImobiliarioService.findByRsql(search, page).map(arg_0 -> this.entityToElogeoDTO(arg_0));
    }

    public CadastroGeralElogeoDTO findByCadastroGeralElogeoDTO(Long cadastroGeral) {
        CadastroImobiliario cadastroImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroGeral);
        if (Objects.isNull(cadastroImobiliario)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar o Cadastro Imobili\u00e1rio com o C\u00f3digo '%d'.", cadastroGeral));
        }
        return this.entityToElogeoDTO(cadastroImobiliario);
    }

    public Page<CadastroGeralElogeoDTO> findByRSQL(String search, Pageable pageable) {
        return this.cadastroImobiliarioService.findByRsql(search, pageable).map(arg_0 -> this.entityToElogeoDTO(arg_0));
    }

    public CadastroGeralExistsElogeoDTO exists(Long cadastroGeral) {
        CadastroGeralExistsElogeoDTO dto = new CadastroGeralExistsElogeoDTO();
        dto.setCadastroLocalizado(Boolean.valueOf(this.cadastroGeralService.exists(TipoCadastro.IMOBILIARIO, cadastroGeral)));
        return dto;
    }

    public CadastroGeralElogeoDTO saveElogeoDTO(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, Boolean novoCadastro, Long cadastroGeral) {
        LOGGER.info("In\u00edcio atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}", (Object)cadastroGeralPostElogeoDTO.getCodigo(), (Object)cadastroGeralPostElogeoDTO.getTipo());
        if (!novoCadastro.booleanValue() && !cadastroGeralPostElogeoDTO.getCodigo().equals(cadastroGeral)) {
            throw new EloValidationException(String.format("C\u00f3digo do Cadastro %d diferente do Request %d.", cadastroGeral, cadastroGeralPostElogeoDTO.getCodigo()));
        }
        cadastroGeralPostElogeoDTO.setCodigo(this.cadastroImobiliarioService.validateAndGetCadastroGeralSequence(cadastroGeralPostElogeoDTO.getCodigo()));
        CadastroImobiliario cadastroImobiliarioToSave = cadastroGeralPostElogeoDTO.toEntity();
        cadastroImobiliarioToSave.setDistritoLocalizacao((Distrito)this.distritoService.findById((Serializable)((Object)cadastroGeralPostElogeoDTO.getImobiliario().getDistrito())).orElseThrow(() -> new EloValidationException(String.format("Distrito %s n\u00e3o localizado.", cadastroGeralPostElogeoDTO.getImobiliario().getDistrito()))));
        cadastroImobiliarioToSave.setSetorLocalizacao((Setor)EloRequireNonNull.eloRequireNonNull((Object)this.setorService.findByDistritoDistritoAndSetor(cadastroGeralPostElogeoDTO.getImobiliario().getDistrito(), cadastroGeralPostElogeoDTO.getImobiliario().getSetor()), (String)String.format("Setor %s n\u00e3o localizado.", cadastroGeralPostElogeoDTO.getImobiliario().getSetor())));
        cadastroImobiliarioToSave.setQuadraLocalizacao((SetorQuadra)EloRequireNonNull.eloRequireNonNull((Object)this.setorQuadraService.findBySetorDistritoDistritoAndSetorSetorAndQuadra(cadastroGeralPostElogeoDTO.getImobiliario().getDistrito(), cadastroGeralPostElogeoDTO.getImobiliario().getSetor(), cadastroGeralPostElogeoDTO.getImobiliario().getQuadra()), (String)String.format("Quadra %s n\u00e3o localizada.", cadastroGeralPostElogeoDTO.getImobiliario().getQuadra())));
        cadastroImobiliarioToSave.setBairro((Bairro)this.bairroService.findByBairroAndCidadeEntidadePrincipal(cadastroGeralPostElogeoDTO.getBairro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Bairro %s n\u00e3o localizado.", cadastroGeralPostElogeoDTO.getBairro().getCodigo()))));
        if (Objects.nonNull(cadastroGeralPostElogeoDTO.getImobiliario().getCondominio())) {
            this.setCondominioToSave(cadastroGeralPostElogeoDTO, cadastroImobiliarioToSave);
        }
        if (Objects.nonNull(cadastroGeralPostElogeoDTO.getImobiliario().getLoteamento())) {
            this.setLoteamentoToSave(cadastroGeralPostElogeoDTO, cadastroImobiliarioToSave);
        }
        this.setProprietariosToSave(cadastroGeralPostElogeoDTO, cadastroImobiliarioToSave);
        if (Objects.nonNull(cadastroGeralPostElogeoDTO.getImobiliario().getSegmentos())) {
            this.setSegmentosToSave(cadastroGeralPostElogeoDTO, cadastroImobiliarioToSave);
        }
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_IMOBILIARIO).booleanValue() && Objects.nonNull(cadastroGeralPostElogeoDTO.getImobiliario().getSituacao())) {
            this.setSituacaoImobiliarioToSave(cadastroGeralPostElogeoDTO, cadastroImobiliarioToSave);
        }
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA).booleanValue()) {
            this.setTestadasGenericaToSave(cadastroGeralPostElogeoDTO, cadastroImobiliarioToSave);
            this.validaNumeroNuloTestadaGenericaPrincipal(cadastroGeralPostElogeoDTO);
        } else {
            this.setTestadasToSave(cadastroGeralPostElogeoDTO, novoCadastro, cadastroGeral, cadastroImobiliarioToSave);
        }
        cadastroImobiliarioToSave.validaCamposFiscalizacao();
        CadastroImobiliario prepared = this.prepareElogeoToSave(cadastroImobiliarioToSave, novoCadastro, cadastroGeralPostElogeoDTO);
        CadastroImobiliario saved = (CadastroImobiliario)this.cadastroImobiliarioService.save((EloEntity)prepared, null);
        this.mergeBoletins(cadastroGeralPostElogeoDTO, saved);
        CadastroGeralElogeoDTO cadastroGeralElogeoDTO = this.entityToElogeoDTO(saved);
        LOGGER.info("Fim atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}", (Object)cadastroGeralElogeoDTO.getCodigo(), (Object)cadastroGeralElogeoDTO.getTipo());
        return cadastroGeralElogeoDTO;
    }

    private void setCondominioToSave(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroImobiliarioToSave.setCondominio(Optional.ofNullable(this.condominioService.findBySetorDistritoDistritoAndSetorSetorAndCondominio(cadastroGeralPostElogeoDTO.getImobiliario().getDistrito(), cadastroGeralPostElogeoDTO.getImobiliario().getSetor(), cadastroGeralPostElogeoDTO.getImobiliario().getCondominio().getCodigo())).orElseThrow(() -> new EloValidationException(String.format("Condom\u00ednio %s do Distrito %s e Setor %s n\u00e3o localizado.", cadastroGeralPostElogeoDTO.getImobiliario().getCondominio().getCodigo(), cadastroGeralPostElogeoDTO.getImobiliario().getDistrito(), cadastroGeralPostElogeoDTO.getImobiliario().getSetor()))));
    }

    private void setLoteamentoToSave(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroImobiliarioToSave.setLoteamento(Optional.ofNullable(this.loteamentoService.findBySetorDistritoDistritoAndSetorSetorAndLoteamento(cadastroGeralPostElogeoDTO.getImobiliario().getDistrito(), cadastroGeralPostElogeoDTO.getImobiliario().getSetor(), cadastroGeralPostElogeoDTO.getImobiliario().getLoteamento().getCodigo())).orElseThrow(() -> new EloValidationException(String.format("Loteamento %s do Distrito %s e Setor %s n\u00e3o localizado.", cadastroGeralPostElogeoDTO.getImobiliario().getLoteamento().getCodigo(), cadastroGeralPostElogeoDTO.getImobiliario().getDistrito(), cadastroGeralPostElogeoDTO.getImobiliario().getSetor()))));
    }

    private void setProprietariosToSave(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroGeralPostElogeoDTO.getProprietarios().stream().map(proprietario -> {
            Pessoa pessoa = (Pessoa)EloRequireNonNull.eloRequireNonNull((Object)((Pessoa)this.cadastroImobiliarioService.getEm().find(Pessoa.class, (Object)proprietario.getPessoa().getId())), (String)String.format("Pessoa %s n\u00e3o localizada.", proprietario.getPessoa().getId()));
            Vinculo vinculo = (Vinculo)EloRequireNonNull.eloRequireNonNull((Object)((Vinculo)this.cadastroImobiliarioService.getEm().find(Vinculo.class, (Object)proprietario.getVinculo().getId())), (String)String.format("V\u00ednculo %s n\u00e3o localizado.", proprietario.getVinculo().getId()));
            return proprietario.toEntity(pessoa, vinculo);
        }).forEach(cadastroImobiliarioToSave.getProprietarios()::add);
    }

    private void setSegmentosToSave(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroGeralPostElogeoDTO.getImobiliario().getSegmentos().stream().map(segmento -> {
            TipoSegmento tipoSegmento = (TipoSegmento)EloRequireNonNull.eloRequireNonNull((Object)((TipoSegmento)this.cadastroImobiliarioService.getEm().find(TipoSegmento.class, (Object)segmento.getTipo().getId())), (String)String.format("Tipo de Segmento %s n\u00e3o localizado.", segmento.getTipo().getId()));
            if (Boolean.TRUE.equals(this.cadastroImobiliarioService.utilizaSituacaoSegmento())) {
                SituacaoSegmentoImob situacaoSegmentoImob = (SituacaoSegmentoImob)EloRequireNonNull.eloRequireNonNull((Object)((SituacaoSegmentoImob)this.cadastroImobiliarioService.getEm().find(SituacaoSegmentoImob.class, (Object)segmento.getSituacao().getId())), (String)String.format("Situa\u00e7\u00e3o de Segmento %s n\u00e3o localizada.", segmento.getSituacao().getId()));
                return segmento.toEntity(cadastroGeralPostElogeoDTO.getCodigo(), tipoSegmento, situacaoSegmentoImob);
            }
            return segmento.toEntity(cadastroGeralPostElogeoDTO.getCodigo(), tipoSegmento);
        }).forEach(cadastroImobiliarioToSave.getSegmentos()::add);
    }

    private void setSituacaoImobiliarioToSave(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroImobiliarioToSave.setSituacaoImobiliario((SituacaoImobiliario)EloRequireNonNull.eloRequireNonNull((Object)((SituacaoImobiliario)this.cadastroImobiliarioService.getEm().find(SituacaoImobiliario.class, (Object)cadastroGeralPostElogeoDTO.getImobiliario().getSituacao().getId())), (String)String.format("Situa\u00e7\u00e3o do Imobili\u00e1rio %s n\u00e3o encontrada.", cadastroGeralPostElogeoDTO.getImobiliario().getSituacao().getId())));
    }

    private void setTestadasGenericaToSave(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroGeralPostElogeoDTO.getImobiliario().getTestadasGenericas().stream().map(testadaGenerica -> {
            Logradouro logradouro = (Logradouro)this.logradouroService.findByLogradouroAndCidadeEntidadePrincipal(testadaGenerica.getLogradouro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Logradouro %s da Testada Gen\u00e9rica n\u00e3o encontrado.", testadaGenerica.getLogradouro().getCodigo())));
            return testadaGenerica.toEntity(logradouro);
        }).forEach(cadastroImobiliarioToSave.getTestadasGenericas()::add);
    }

    private void validaNumeroNuloTestadaGenericaPrincipal(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO) {
        boolean isTestadaPrincipalSemNumero = cadastroGeralPostElogeoDTO.getImobiliario().getTestadasGenericas().stream().anyMatch(testadaGenerica -> {
            BooleanSimNao isPrincipal = BooleanSimNao.fromValue((String)testadaGenerica.getPrincipal());
            boolean isNumeroEmpty = StringUtils.isEmpty((String)testadaGenerica.getNumero());
            return BooleanSimNao.SIM.equals((Object)isPrincipal) && isNumeroEmpty;
        });
        if (isTestadaPrincipalSemNumero) {
            throw new EloValidationException("O n\u00famero da testada gen\u00e9rica principal deve ser preenchido.");
        }
    }

    private void setTestadasToSave(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, Boolean novoCadastro, Long cadastroGeral, CadastroImobiliario cadastroImobiliarioToSave) {
        CadastroImobiliario cadImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroGeral);
        if (Objects.nonNull(cadastroGeral) && !novoCadastro.booleanValue() && Objects.nonNull(cadImobiliario)) {
            try {
                List testadasRemovidas = this.separarTestadasRemovidas(cadastroGeralPostElogeoDTO, cadImobiliario);
                Long testadaPrincipal = cadImobiliario.getTestadas().stream().filter(CadastroImobiliarioTestada::getPrincipal).findFirst().orElseThrow().getIdLogradouroTestada();
                this.removeVinculoSolicitacaoByTestadaRemovida(cadastroGeral, testadasRemovidas, testadaPrincipal);
            }
            catch (NoSuchElementException e) {
                throw new EloValidationException(String.format("Cadastro Imobili\u00e1rio %d, n\u00e3o possui uma testada principal", cadastroGeral));
            }
        }
        this.adicionarTestadasASalvar(cadastroGeralPostElogeoDTO, cadastroImobiliarioToSave, cadImobiliario);
    }

    private List<CadastroImobiliarioTestada> separarTestadasRemovidas(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadImobiliario) {
        return cadImobiliario.getTestadas().stream().filter(testada -> cadastroGeralPostElogeoDTO.getImobiliarioTestadas().stream().noneMatch(cadTestada -> cadTestada.getSecaoId().equals(testada.getIdLogradouroTestada()))).collect(Collectors.toList());
    }

    private void removeVinculoSolicitacaoByTestadaRemovida(Long cadastroGeral, List<CadastroImobiliarioTestada> testadasRemovidas, Long testadaPrincipal) {
        for (CadastroImobiliarioTestada testada : testadasRemovidas) {
            Optional solicitacao = this.solicitacaoAlvaraRepository.getSolicitacaoByLogradouroTestadaAndCadastroGeral(testada.getIdLogradouroTestada(), cadastroGeral);
            if (!solicitacao.isPresent()) continue;
            this.solicitacaoAlvaraRepository.save((Object)new SolicitacaoAlvara((Long)solicitacao.get(), testadaPrincipal, cadastroGeral));
            this.saveLogSolicitacaoTestada(cadastroGeral, testada, solicitacao, testadaPrincipal);
        }
    }

    private void adicionarTestadasASalvar(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario cadastroImobiliarioToSave, CadastroImobiliario cadastroImobiliarioOriginal) {
        if (Objects.nonNull(cadastroImobiliarioOriginal)) {
            cadastroGeralPostElogeoDTO.getImobiliarioTestadas().forEach(testadaGeo -> cadastroImobiliarioOriginal.getTestadas().stream().filter(testada -> testadaGeo.getSecaoId().equals(testada.getIdLogradouroTestada())).forEach(cadastroImobiliarioToSave.getTestadas()::add));
        }
        if (cadastroImobiliarioToSave.getTestadas().isEmpty()) {
            cadastroGeralPostElogeoDTO.getImobiliarioTestadas().stream().map(testada -> {
                LogradouroTestada logradouroTestada = (LogradouroTestada)EloRequireNonNull.eloRequireNonNull((Object)((LogradouroTestada)this.cadastroImobiliarioService.getEm().find(LogradouroTestada.class, (Object)testada.getSecaoId())), (String)String.format("Se\u00e7\u00e3o %s da Testada n\u00e3o localizada.", testada.getSecaoId()));
                return testada.toEntity(logradouroTestada);
            }).forEach(cadastroImobiliarioToSave.getTestadas()::add);
        }
    }

    private void saveLogSolicitacaoTestada(Long cadastroGeral, CadastroImobiliarioTestada testada, Optional<Long> solicitacao, Long testadaPrincipal) {
        SolicitacaoTestadaLog log = new SolicitacaoTestadaLog();
        log.setTipoCadastro(TipoCadastro.IMOBILIARIO.getValue());
        log.setCadastroGeral(cadastroGeral);
        log.setIdTestadaNova(testadaPrincipal);
        log.setIdTestadaAntiga(testada.getIdLogradouroTestada());
        log.setNumeroSolicitacaoAlvara(solicitacao.orElseThrow());
        this.solicitacaoTestadaLogRepository.save((Object)log);
    }

    @Generated
    public CadastroImobiliarioElogeoServiceAbstract(CadastroGeralService cadastroGeralService, CadastroImobiliarioService cadastroImobiliarioService, DistritoService distritoService, SetorService setorService, BairroService bairroService, SetorQuadraService setorQuadraService, SolicitacaoTestadaLogRepository solicitacaoTestadaLogRepository, SolicitacaoAlvaraRepository solicitacaoAlvaraRepository, LogradouroService logradouroService, LoteamentoService loteamentoService, CondominioService condominioService, ParametroGeralService parametroGeralService) {
        this.cadastroGeralService = cadastroGeralService;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.distritoService = distritoService;
        this.setorService = setorService;
        this.bairroService = bairroService;
        this.setorQuadraService = setorQuadraService;
        this.solicitacaoTestadaLogRepository = solicitacaoTestadaLogRepository;
        this.solicitacaoAlvaraRepository = solicitacaoAlvaraRepository;
        this.logradouroService = logradouroService;
        this.loteamentoService = loteamentoService;
        this.condominioService = condominioService;
        this.parametroGeralService = parametroGeralService;
    }
}

