/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoOperacaoTce;
import br.com.elotech.tributos.domain.integracaocontabil.LoteIntegracaoContabil;
import br.com.elotech.tributos.domain.integracaocontabil.LoteItemIntegracaoContabil;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoContabilPayload;
import br.com.elotech.tributos.dto.integracaocontabil.LoteItemPagamentoIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import br.com.elotech.tributos.repository.integracaocontabil.LoteIntegracaoContabilRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContaBancariaService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.service.integracaocontabil.LoteItemIntegracaoContabilService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoteIntegracaoContabilService
extends CrudService<LoteIntegracaoContabil, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoteIntegracaoContabilService.class);
    private final LoteIntegracaoContabilRepository loteIntegracaoContabilRepository;
    private final LoteItemIntegracaoContabilService loteItemIntegracaoContabilService;
    private final ContaBancariaService contaBancariaService;
    private final ContextService contextService;
    private final MovimentacaoDiariaService movimentacaoDiariaService;

    private void corrigeLoteRestituicao(LoteIntegracaoContabil loteIntegracaoContabil) {
        if (TipoMovimento.RESTITUICAO.equals((Object)loteIntegracaoContabil.getTipoLote())) {
            loteIntegracaoContabil.getLoteItens().stream().filter(item -> Boolean.TRUE.equals(item.getTributoPrincipal())).forEach(item -> item.setTributoPrincipal(Boolean.FALSE));
        }
    }

    public LoteIntegracaoContabil geraLoteIntegracaoPagamento(PagamentoLote pagamentoLote) {
        List itens = this.createLoteItemIntegracaoContabil(this.loteItemIntegracaoContabilService.findItensLotePagamento(pagamentoLote.getId().getEntidade(), pagamentoLote.getId().getExercicio(), pagamentoLote.getId().getLote())).collect(Collectors.toList());
        LoteIntegracaoContabil loteIntegracaoContabil = this.createLoteIntegracaoPagamento(pagamentoLote, pagamentoLote.getDataMovimento(), itens);
        return (LoteIntegracaoContabil)this.loteIntegracaoContabilRepository.save((Object)loteIntegracaoContabil);
    }

    public List<LoteIntegracaoContabil> geraLotesIntegracaoPagamentoRegimeDataPagamento(PagamentoLote pagamentoLote) {
        Map<LocalDate, List<LoteItemIntegracaoContabil>> itensByDataPagamento = this.createLoteItemIntegracaoContabil(this.loteItemIntegracaoContabilService.findItensLotePagamento(pagamentoLote.getId().getEntidade(), pagamentoLote.getId().getExercicio(), pagamentoLote.getId().getLote())).collect(Collectors.groupingBy(LoteItemIntegracaoContabil::getDataPagamento));
        ArrayList lotes = new ArrayList();
        itensByDataPagamento.forEach((dataPagamento, itens) -> lotes.add(this.createLoteIntegracaoPagamento(pagamentoLote, dataPagamento, itens)));
        return this.loteIntegracaoContabilRepository.saveAll(lotes);
    }

    public List<LoteIntegracaoContabil> geraIntegracaoEstornoPagamento(LocalDate dataEstorno) {
        Map<Long, List<LoteItemPagamentoIntegracaoContabilDTO>> lotesPorContaBancaria = this.loteItemIntegracaoContabilService.findItensEstornoPagamento(dataEstorno).stream().collect(Collectors.groupingBy(LoteItemPagamentoIntegracaoContabilDTO::getIdContaContabil));
        return this.createLoteIntegracaoContabil(dataEstorno, lotesPorContaBancaria, TipoMovimento.ESTORNO_PAGAMENTO);
    }

    public List<LoteIntegracaoContabil> geraIntegracaoRestituicao(LocalDate dataRestituicao) {
        Map<Long, List<LoteItemPagamentoIntegracaoContabilDTO>> lotesPorContaBancaria = this.loteItemIntegracaoContabilService.findItensRestituicao(dataRestituicao).stream().collect(Collectors.groupingBy(LoteItemPagamentoIntegracaoContabilDTO::getIdContaContabil));
        return this.createLoteIntegracaoContabil(dataRestituicao, lotesPorContaBancaria, TipoMovimento.RESTITUICAO);
    }

    public List<LoteIntegracaoContabil> geraIntegracaoReabilitacaoPagamento(LocalDate dataReabilitacao) {
        Map<Long, List<LoteItemPagamentoIntegracaoContabilDTO>> lotesPorContaBancaria = this.loteItemIntegracaoContabilService.findItensReabilitacaoPagamento(dataReabilitacao).stream().collect(Collectors.groupingBy(LoteItemPagamentoIntegracaoContabilDTO::getIdContaContabil));
        return this.createLoteIntegracaoContabil(dataReabilitacao, lotesPorContaBancaria, TipoMovimento.REABILITACAO_PAGAMENTO);
    }

    public List<LoteIntegracaoContabil> geraIntegracaoEstornoCredito(LocalDate dataEstorno) {
        Map<Long, List<LoteItemPagamentoIntegracaoContabilDTO>> lotesPorContaBancaria = this.loteItemIntegracaoContabilService.findItensEstornoCredito(dataEstorno).stream().collect(Collectors.groupingBy(LoteItemPagamentoIntegracaoContabilDTO::getIdContaContabil));
        return this.createLoteIntegracaoContabil(dataEstorno, lotesPorContaBancaria, TipoMovimento.ESTORNO_CREDITO);
    }

    private List<LoteIntegracaoContabil> createLoteIntegracaoContabil(LocalDate data, Map<Long, List<LoteItemPagamentoIntegracaoContabilDTO>> lotesPorContabancaria, TipoMovimento tipoLote) {
        ArrayList<LoteIntegracaoContabil> lotesIntegracao = new ArrayList<LoteIntegracaoContabil>();
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = data.getYear();
        lotesPorContabancaria.forEach((idContaBancaria, itens) -> {
            LoteIntegracaoContabil loteIntegracaoContabil;
            LoteIntegracaoContabil loteIntegracaoContabilFound = this.loteIntegracaoContabilRepository.findLoteIntegracaoFinanceira(entidade, exercicio, idContaBancaria, tipoLote, data);
            if (Objects.nonNull(loteIntegracaoContabilFound) && !SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)loteIntegracaoContabilFound.getSituacaoIntegracaoContabil())) {
                return;
            }
            LoteIntegracaoContabil loteIntegracaoContabil2 = loteIntegracaoContabil = Objects.isNull(loteIntegracaoContabilFound) ? new LoteIntegracaoContabil() : loteIntegracaoContabilFound;
            if (Objects.isNull(loteIntegracaoContabilFound)) {
                loteIntegracaoContabil.setEntidade(entidade);
                loteIntegracaoContabil.setExercicio(exercicio);
                loteIntegracaoContabil.setTipoLote(tipoLote);
                loteIntegracaoContabil.setDataLote(data);
                loteIntegracaoContabil.setContaBancaria((ContaBancaria)this.contaBancariaService.findOne((Serializable)idContaBancaria));
            }
            loteIntegracaoContabil.setDataSolicitacaoIntegracao(LocalDateTime.now());
            loteIntegracaoContabil.setUsuarioCpfCnpjIntegracao(SecurityUtils.getUserAise());
            loteIntegracaoContabil.setSituacaoIntegracaoContabil(SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO);
            loteIntegracaoContabil.getLoteItens().clear();
            List novosItens = this.createLoteItemIntegracaoContabil(itens).collect(Collectors.toList());
            loteIntegracaoContabil.getLoteItens().addAll(novosItens);
            this.corrigeLoteRestituicao(loteIntegracaoContabil);
            lotesIntegracao.add((LoteIntegracaoContabil)this.loteIntegracaoContabilRepository.save((Object)loteIntegracaoContabil));
        });
        return lotesIntegracao;
    }

    private List<LoteItemIntegracaoContabil> generateItemIntegracao(LoteItemPagamentoIntegracaoContabilDTO item) {
        ArrayList<LoteItemIntegracaoContabil> itens = new ArrayList<LoteItemIntegracaoContabil>();
        TipoOperacaoTce tipoOperacaoDeducao = Optional.ofNullable(item.getIdTipoOperacaoDeducao()).map(idTipoOperacao -> (TipoOperacaoTce)this.getEm().getReference(TipoOperacaoTce.class, idTipoOperacao)).orElse(null);
        if (item.getValorPrincipal().compareTo(BigDecimal.ZERO) > 0 || item.getValorDescontoTributo().compareTo(BigDecimal.ZERO) > 0) {
            itens.add(LoteItemIntegracaoContabil.of((LoteItemPagamentoIntegracaoContabilDTO)item, (String)item.getClassificacaoTributo(), (BigDecimal)item.getValorPrincipal(), (BigDecimal)item.getValorDescontoTributo(), (TipoOperacaoTce)tipoOperacaoDeducao, (Boolean)Boolean.TRUE));
        }
        if (item.getValorJuros().compareTo(BigDecimal.ZERO) > 0 || item.getValorDescontoJuros().compareTo(BigDecimal.ZERO) > 0) {
            itens.add(LoteItemIntegracaoContabil.of((LoteItemPagamentoIntegracaoContabilDTO)item, (String)ClassificacaoTributo.JUROS.getValue(), (BigDecimal)item.getValorJuros(), (BigDecimal)item.getValorDescontoJuros(), (TipoOperacaoTce)tipoOperacaoDeducao, (Boolean)Boolean.FALSE));
        }
        if (item.getValorMulta().compareTo(BigDecimal.ZERO) > 0 || item.getValorDescontoMulta().compareTo(BigDecimal.ZERO) > 0) {
            itens.add(LoteItemIntegracaoContabil.of((LoteItemPagamentoIntegracaoContabilDTO)item, (String)ClassificacaoTributo.MULTA.getValue(), (BigDecimal)item.getValorMulta(), (BigDecimal)item.getValorDescontoMulta(), (TipoOperacaoTce)tipoOperacaoDeducao, (Boolean)Boolean.FALSE));
        }
        if (item.getValorCorrecao().compareTo(BigDecimal.ZERO) > 0 || item.getValorDescontoCorrecao().compareTo(BigDecimal.ZERO) > 0) {
            itens.add(LoteItemIntegracaoContabil.of((LoteItemPagamentoIntegracaoContabilDTO)item, (String)ClassificacaoTributo.CORRECAO.getValue(), (BigDecimal)item.getValorCorrecao(), (BigDecimal)item.getValorDescontoCorrecao(), (TipoOperacaoTce)tipoOperacaoDeducao, (Boolean)Boolean.FALSE));
        }
        return itens;
    }

    public void updateStatus(IntegracaoContabilPayload payload) {
        Optional lote = this.loteIntegracaoContabilRepository.findById((Object)payload.getId());
        if (!lote.isPresent()) {
            log.info("Lote de integra\u00e7\u00e3o financeira {} n\u00e3o encontrado.", (Object)payload.getId());
            return;
        }
        ((LoteIntegracaoContabil)lote.get()).setSituacaoIntegracaoContabil(payload.getSituacao());
        log.info("Situa\u00e7\u00e3o do lote de integra\u00e7\u00e3o financeira {} atualizado.", (Object)payload.getId());
        if (SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)payload.getSituacao())) {
            ((LoteIntegracaoContabil)lote.get()).setDataEstornoIntegracao(Optional.ofNullable(payload.getData()).orElse(LocalDateTime.now()));
            ((LoteIntegracaoContabil)lote.get()).setUsuarioCpfCnpjEstornoIntegracao(Optional.ofNullable(payload.getUsuario()).orElse(SecurityUtils.getUserAise()));
            this.movimentacaoDiariaService.reverterIntegracaoData(((LoteIntegracaoContabil)lote.get()).getDataLote());
            log.info("Movimenta\u00e7\u00e3o di\u00e1ria na data {}, atualizada para {}.", (Object)DateUtils.localDateToStringFormatoBrasileiro((LocalDate)((LoteIntegracaoContabil)lote.get()).getDataLote()), (Object)SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao());
        }
        this.loteIntegracaoContabilRepository.save((Object)((LoteIntegracaoContabil)lote.get()));
        log.info("Atualiza\u00e7\u00e3o de lote de integra\u00e7\u00e3o financeira finalizado.");
    }

    public LoteIntegracaoContabil findLoteIntegracaoByPagamentoLoteId(PagamentoLote pagamentoLote) {
        return this.loteIntegracaoContabilRepository.findByPagamentoLoteId(pagamentoLote.getId());
    }

    private Stream<LoteItemIntegracaoContabil> createLoteItemIntegracaoContabil(List<LoteItemPagamentoIntegracaoContabilDTO> itens) {
        return itens.stream().map(arg_0 -> this.generateItemIntegracao(arg_0)).flatMap(Collection::stream).filter(arg_0 -> this.validValorTributoOrValorDeducao(arg_0));
    }

    private boolean validValorTributoOrValorDeducao(LoteItemIntegracaoContabil item) {
        return Objects.nonNull(item.getValorTributo()) && BigDecimal.ZERO.compareTo(item.getValorTributo()) != 0 || Objects.nonNull(item.getValorDeducao()) && BigDecimal.ZERO.compareTo(item.getValorDeducao()) != 0;
    }

    private LoteIntegracaoContabil createLoteIntegracaoPagamento(PagamentoLote pagamentoLote, LocalDate dataMovimento, List<LoteItemIntegracaoContabil> itens) {
        LoteIntegracaoContabil loteIntegracaoContabilFound = this.loteIntegracaoContabilRepository.findByDataLoteAndEntidadeAndExercicioAndPagamentoLoteIdLoteAndSituacaoIntegracaoContabil(dataMovimento, pagamentoLote.getId().getEntidade(), pagamentoLote.getId().getExercicio(), pagamentoLote.getId().getLote(), SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE);
        LoteIntegracaoContabil loteIntegracaoContabil = Objects.isNull(loteIntegracaoContabilFound) ? new LoteIntegracaoContabil() : loteIntegracaoContabilFound;
        Long entidadeRegistro = Optional.ofNullable(pagamentoLote.getConvenio()).map(Convenio::getEntidadeRegistro).map(Entidade::getId).orElse(null);
        if (Objects.isNull(loteIntegracaoContabilFound)) {
            loteIntegracaoContabil.setEntidade(pagamentoLote.getId().getEntidade());
            loteIntegracaoContabil.setExercicio(pagamentoLote.getId().getExercicio());
            loteIntegracaoContabil.setDataLote(dataMovimento);
            loteIntegracaoContabil.setTipoLote(TipoMovimento.PAGAMENTO);
            loteIntegracaoContabil.setLote(pagamentoLote.getId().getLote());
            loteIntegracaoContabil.setPagamentoLote(pagamentoLote);
            loteIntegracaoContabil.setContaBancaria(pagamentoLote.getContaBancaria());
            loteIntegracaoContabil.setEntidadeBaixa(entidadeRegistro);
        }
        loteIntegracaoContabil.setDataSolicitacaoIntegracao(LocalDateTime.now());
        loteIntegracaoContabil.setUsuarioCpfCnpjIntegracao(SecurityUtils.getUserAise());
        loteIntegracaoContabil.setSituacaoIntegracaoContabil(SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO);
        loteIntegracaoContabil.getLoteItens().clear();
        loteIntegracaoContabil.getLoteItens().addAll(itens);
        return loteIntegracaoContabil;
    }

    @Generated
    public LoteIntegracaoContabilService(LoteIntegracaoContabilRepository loteIntegracaoContabilRepository, LoteItemIntegracaoContabilService loteItemIntegracaoContabilService, ContaBancariaService contaBancariaService, ContextService contextService, MovimentacaoDiariaService movimentacaoDiariaService) {
        this.loteIntegracaoContabilRepository = loteIntegracaoContabilRepository;
        this.loteItemIntegracaoContabilService = loteItemIntegracaoContabilService;
        this.contaBancariaService = contaBancariaService;
        this.contextService = contextService;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
    }
}

