/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonial;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonialPorTipoMovimentoDTO;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonialProvisao;
import br.com.elotech.tributos.domain.integracaocontabil.ItemIntegracaoPatrimonial;
import br.com.elotech.tributos.domain.integracaocontabil.ItemIntegracaoPatrimonialProvisao;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoPatrimonialContabilidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoPatrimonialPayload;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialAgrupadorDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.repository.integracaocontabil.IntegracaoPatrimonialProvisaoRepository;
import br.com.elotech.tributos.repository.integracaocontabil.IntegracaoPatrimonialRepository;
import br.com.elotech.tributos.repository.integracaocontabil.ItemIntegracaoPatrimonialProvisaoRepository;
import br.com.elotech.tributos.repository.integracaocontabil.ItemIntegracaoPatrimonialRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoPatrimonialService
extends CrudService<IntegracaoPatrimonial, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoPatrimonialService.class);
    private final IntegracaoPatrimonialRepository integracaoPatrimonialRepository;
    private final ItemIntegracaoPatrimonialRepository itemIntegracaoPatrimonialRepository;
    private final MovimentacaoDiariaService movimentacaoDiariaService;
    private final EntidadeServiceImpl entidadeService;
    private final Publisher publisher;
    private final ParametroGeralService parametroGeralService;
    private final IntegracaoPatrimonialProvisaoRepository integracaoPatrimonialProvisaoRepository;
    private final ItemIntegracaoPatrimonialProvisaoRepository itemIntegracaoPatrimonialProvisaoRepository;
    private final ContextService contextService;

    public Optional<IntegracaoPatrimonialContabilidadeDTO> findByIdDTO(Long id) {
        Long entidade = this.contextService.getEntidadePrincipal();
        String uf = this.entidadeService.getInfoEntidadePrincipal().map(EntidadeDTO::getUnidadeFederacao).orElse(null);
        if (this.getParametroIntegracaoEntidade(ParametroGeralEnum.INTEGRACAO_PATRIMONIAL_POR_ENTIDADE).booleanValue()) {
            Optional<IntegracaoPatrimonialContabilidadeDTO> integracaoContabilidade = this.integracaoPatrimonialProvisaoRepository.findById((Object)id).map(ip -> ip.toDto(uf));
            if (!integracaoContabilidade.isEmpty()) {
                return integracaoContabilidade;
            }
            return this.integracaoPatrimonialRepository.findById((Object)id).map(ip -> ip.toDto(uf, Boolean.valueOf(true), entidade));
        }
        return this.integracaoPatrimonialRepository.findById((Object)id).map(ip -> ip.toDto(uf, Boolean.valueOf(false), entidade));
    }

    public List<IntegracaoPatrimonial> geraIntegracaoPatrimonial(List<LocalDate> datasMovimento) {
        log.debug("Iniciando integra\u00e7\u00e3o patrimonial das datas {}", datasMovimento);
        List movimentacoes = this.integracaoPatrimonialRepository.findInscricoesDiversas(datasMovimento);
        log.debug("Carregou movimenta\u00e7\u00e3o de inscri\u00e7\u00e3o. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findCancelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de cancelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findEstornoCancelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de estorno de cancelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findEstornosParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de estornos de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findReabilitacoesParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de reabilita\u00e7\u00e3o de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findAtualizacaoMonetariaParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de atualiza\u00e7\u00e3o monet\u00e1ria de parcelamentos de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findEstornosAtualizacaoMonetariaParcelamentos(datasMovimento));
        log.debug("Carregou movimenta\u00e7\u00e3o de estorno de atualiza\u00e7\u00e3o monet\u00e1ria de parcelamentos de parcelamentos. Movimenta\u00e7\u00f5es at\u00e9 o momento: {}", (Object)movimentacoes.size());
        log.debug("Foram encontrados {} registros para o periodo selecionado ", (Object)movimentacoes.size());
        List<IntegracaoPatrimonial> integracoesPatrimoniais = movimentacoes.stream().collect(Collectors.groupingBy(ItemIntegracaoPatrimonialDTO::toItemIntegracaoPatrimonialAgrupador)).entrySet().stream().map(arg_0 -> this.toIntegracaoPatrimonial(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        log.debug("Finalizada gera\u00e7\u00e3o dos itens da integra\u00e7\u00e3o patrimonial");
        return integracoesPatrimoniais;
    }

    private IntegracaoPatrimonial toIntegracaoPatrimonial(Map.Entry<ItemIntegracaoPatrimonialAgrupadorDTO, List<ItemIntegracaoPatrimonialDTO>> movimentacoes) {
        IntegracaoPatrimonial integracaoPatrimonial;
        LocalDate dataMovimento;
        Long entidade = movimentacoes.getKey().getEntidade();
        IntegracaoPatrimonial integracaoPatrimonialFound = this.integracaoPatrimonialRepository.findByEntidadeAndDataMovimento(entidade, dataMovimento = movimentacoes.getKey().getDataMovimentacao());
        if (Objects.nonNull(integracaoPatrimonialFound) && !SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)integracaoPatrimonialFound.getSituacaoIntegracaoPatrimonial())) {
            log.debug("Ignorando os resultados do dia {} pois ele est\u00e1 na situa\u00e7\u00e3o {}.", (Object)dataMovimento, (Object)integracaoPatrimonialFound.getSituacaoIntegracaoPatrimonial());
            return null;
        }
        IntegracaoPatrimonial integracaoPatrimonial2 = integracaoPatrimonial = Objects.isNull(integracaoPatrimonialFound) ? new IntegracaoPatrimonial() : integracaoPatrimonialFound;
        if (Objects.isNull(integracaoPatrimonialFound)) {
            integracaoPatrimonial.setDataMovimento(dataMovimento);
            integracaoPatrimonial.setEntidade(entidade);
            integracaoPatrimonial.setExercicio(Long.valueOf(dataMovimento.getYear()));
        } else {
            this.itemIntegracaoPatrimonialRepository.deleteByIntegracaoId(integracaoPatrimonial.getId());
        }
        integracaoPatrimonial.setDataSolicitacaoIntegracao(LocalDateTime.now());
        integracaoPatrimonial.setUsuarioCpfCnpjIntegracao(SecurityUtils.getUserAise());
        integracaoPatrimonial.setSituacaoIntegracaoPatrimonial(SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO);
        this.integracaoPatrimonialRepository.save((Object)integracaoPatrimonial);
        List itens = movimentacoes.getValue().stream().map(dto -> ItemIntegracaoPatrimonial.from((ItemIntegracaoPatrimonialDTO)dto, (IntegracaoPatrimonial)integracaoPatrimonial)).collect(Collectors.toList());
        this.itemIntegracaoPatrimonialRepository.saveAll(itens);
        if (this.getParametroIntegracaoEntidade(ParametroGeralEnum.INTEGRACAO_PATRIMONIAL_POR_ENTIDADE).booleanValue()) {
            this.integracaoPatrimonialRepository.flush();
            this.itemIntegracaoPatrimonialRepository.flush();
        }
        return integracaoPatrimonial;
    }

    public IntegracaoPatrimonialProvisao geraIntegracaoPatrimonialProvisao(List<ItemIntegracaoPatrimonial> itensIntegracaoPatrimonial) {
        IntegracaoPatrimonial integracaoPatrimonial = itensIntegracaoPatrimonial.getFirst().getIntegracao();
        IntegracaoPatrimonialProvisao integracaoPatrimonialProvisao = new IntegracaoPatrimonialProvisao();
        integracaoPatrimonialProvisao.setDataMovimento(integracaoPatrimonial.getDataMovimento());
        integracaoPatrimonialProvisao.setEntidade(itensIntegracaoPatrimonial.getFirst().getEntidadeBaixa());
        integracaoPatrimonialProvisao.setExercicio(Long.valueOf(integracaoPatrimonial.getDataMovimento().getYear()));
        integracaoPatrimonialProvisao.setDataSolicitacaoIntegracao(LocalDateTime.now());
        integracaoPatrimonialProvisao.setUsuarioCpfCnpjIntegracao(SecurityUtils.getUserAise());
        integracaoPatrimonialProvisao.setLoteIntegracaoPatrimonial(integracaoPatrimonial.getId());
        integracaoPatrimonialProvisao.setSituacaoIntegracaoPatrimonial(SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO);
        this.integracaoPatrimonialProvisaoRepository.save((Object)integracaoPatrimonialProvisao);
        List itens = itensIntegracaoPatrimonial.stream().map(dto -> ItemIntegracaoPatrimonialProvisao.from((ItemIntegracaoPatrimonial)dto, (IntegracaoPatrimonialProvisao)integracaoPatrimonialProvisao)).collect(Collectors.toList());
        this.itemIntegracaoPatrimonialProvisaoRepository.saveAll(itens);
        return integracaoPatrimonialProvisao;
    }

    public void updateStatus(IntegracaoPatrimonialPayload payload) {
        if (this.getParametroIntegracaoEntidade(ParametroGeralEnum.INTEGRACAO_PATRIMONIAL_POR_ENTIDADE).booleanValue()) {
            this.loteIntegracaoProvisaoAtualizar(payload);
        }
        this.atualizaStatusLotePatrimonial(payload.getId(), payload.getSituacao(), payload.getUsuario(), payload.getData());
    }

    public void loteIntegracaoProvisaoAtualizar(IntegracaoPatrimonialPayload payload) {
        Optional opt = this.integracaoPatrimonialProvisaoRepository.findById((Object)payload.getId());
        if (opt.isPresent()) {
            IntegracaoPatrimonialProvisao integracaoPatrimonialProvisao = (IntegracaoPatrimonialProvisao)opt.get();
            this.atualizarStatusProvisao(integracaoPatrimonialProvisao, payload.getId(), payload.getSituacao());
            if (SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)payload.getSituacao())) {
                this.atualizaStatusLotePatrimonial(integracaoPatrimonialProvisao.getLoteIntegracaoPatrimonial(), SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE, payload.getUsuario(), payload.getData());
            }
        } else {
            this.atualizaStatusLotePatrimonial(payload.getId(), payload.getSituacao(), payload.getUsuario(), payload.getData());
        }
    }

    public void atualizaStatusLotePatrimonial(Long id, SituacaoIntegracaoContabil situacao, String usuario, LocalDateTime data) {
        this.atualizarStatusIntegracaoPatrimonial(id, situacao, usuario, data);
        log.info("Atualiza\u00e7\u00e3o de lote de integra\u00e7\u00e3o patrimonial finalizado.");
        if (this.getParametroIntegracaoEntidade(ParametroGeralEnum.INTEGRACAO_PATRIMONIAL_POR_ENTIDADE).booleanValue() && SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)situacao)) {
            log.info("Vai atualizar o estorno do lote de provis\u00e3o {}.", (Object)id);
            this.atualizarStatusEstornadoProvisaoPorLote(id, usuario, data);
        }
    }

    private void atualizarStatusProvisao(IntegracaoPatrimonialProvisao integracaoPatrimonialProvisao, Long idLote, SituacaoIntegracaoContabil situacaoIntegracaoContabil) {
        log.info("Inicio da atualiza\u00e7\u00e3o da provis\u00e3o do status do lote  integra\u00e7\u00e3o patrimonial {} atualizado.", (Object)idLote);
        integracaoPatrimonialProvisao.setSituacaoIntegracaoPatrimonial(situacaoIntegracaoContabil);
        if (situacaoIntegracaoContabil.equals((Object)SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE)) {
            integracaoPatrimonialProvisao.setSituacaoIntegracaoPatrimonial(SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE);
            integracaoPatrimonialProvisao.setDataEstornoIntegracao(LocalDateTime.now());
            log.info("Situa\u00e7\u00e3o do lote provis\u00e3o de integra\u00e7\u00e3o patrimonial {} atualizado.", (Object)idLote);
            this.movimentacaoDiariaService.reverterIntegracaoData(integracaoPatrimonialProvisao.getDataMovimento());
            log.info("Movimenta\u00e7\u00e3o di\u00e1ria da provis\u00e3o na data {}, atualizada para {}.", (Object)DateUtils.localDateToStringFormatoBrasileiro((LocalDate)integracaoPatrimonialProvisao.getDataMovimento()), (Object)SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao());
        }
        this.integracaoPatrimonialProvisaoRepository.save((Object)integracaoPatrimonialProvisao);
    }

    private void atualizarStatusIntegracaoPatrimonial(Long id, SituacaoIntegracaoContabil situacao, String usuario, LocalDateTime data) {
        this.integracaoPatrimonialRepository.findById((Object)id).ifPresent(integracaoPatrimonial -> {
            integracaoPatrimonial.setSituacaoIntegracaoPatrimonial(situacao);
            log.info("Situa\u00e7\u00e3o do lote de integra\u00e7\u00e3o patrimonial {} atualizado.", (Object)id);
            if (SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)situacao)) {
                integracaoPatrimonial.setDataEstornoIntegracao(Optional.ofNullable(data).orElse(LocalDateTime.now()));
                integracaoPatrimonial.setUsuarioCpfCnpjEstornoIntegracao(Optional.ofNullable(usuario).orElse(SecurityUtils.getUserAise()));
                this.movimentacaoDiariaService.reverterIntegracaoData(integracaoPatrimonial.getDataMovimento());
                log.info("Movimenta\u00e7\u00e3o di\u00e1ria na data {}, atualizada para {}.", (Object)DateUtils.localDateToStringFormatoBrasileiro((LocalDate)integracaoPatrimonial.getDataMovimento()), (Object)SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao());
            }
            this.integracaoPatrimonialRepository.save(integracaoPatrimonial);
        });
    }

    private void atualizarStatusEstornadoProvisaoPorLote(Long id, String usuario, LocalDateTime dataEstorno) {
        Optional opt = this.integracaoPatrimonialProvisaoRepository.findByLoteIntegracaoPatrimonial(id);
        if (opt.isPresent()) {
            IntegracaoPatrimonialProvisao integracaoPatrimonialProvisao = (IntegracaoPatrimonialProvisao)opt.get();
            integracaoPatrimonialProvisao.setSituacaoIntegracaoPatrimonial(SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE);
            integracaoPatrimonialProvisao.setDataEstornoIntegracao(Optional.ofNullable(dataEstorno).orElse(LocalDateTime.now()));
            integracaoPatrimonialProvisao.setUsuarioCpfCnpjEstornoIntegracao(Optional.ofNullable(usuario).orElse(SecurityUtils.getUserAise()));
            log.info("Situa\u00e7\u00e3o do lote provis\u00e3o de integra\u00e7\u00e3o patrimonial {} atualizado.", (Object)id);
            this.movimentacaoDiariaService.reverterIntegracaoData(integracaoPatrimonialProvisao.getDataMovimento());
            log.info("Movimenta\u00e7\u00e3o di\u00e1ria da provis\u00e3o na data {}, atualizada para {}.", (Object)DateUtils.localDateToStringFormatoBrasileiro((LocalDate)integracaoPatrimonialProvisao.getDataMovimento()), (Object)SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao());
            this.integracaoPatrimonialProvisaoRepository.save((Object)integracaoPatrimonialProvisao);
        }
    }

    public List<IntegracaoPatrimonialPorTipoMovimentoDTO> findTotaisPorTipoMovimentoAndId(Long id) {
        IntegracaoPatrimonial integracaoPatrimonial = (IntegracaoPatrimonial)this.integracaoPatrimonialRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Integra\u00e7\u00e3o Patrimonial %s n\u00e3o encontrada.", id)));
        List totais = this.integracaoPatrimonialRepository.findTotaisPorTipoMovimentoAndId(integracaoPatrimonial.getId());
        totais.sort(Comparator.comparing(total -> total.getTipoMovimento().getDescricao()));
        return totais;
    }

    public TotalizadorIntegracaoPatrimonialDTO getTotalSearch(String search) {
        return this.integracaoPatrimonialRepository.getTotalSearch(search);
    }

    public void republish(Long id) {
        IntegracaoPatrimonial integracaoPatrimonial = (IntegracaoPatrimonial)this.integracaoPatrimonialRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Integra\u00e7\u00e3o Patrimonial %s n\u00e3o encontrada.", id)));
        if (!SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.equals((Object)integracaoPatrimonial.getSituacaoIntegracaoPatrimonial())) {
            throw new EloValidationException(String.format("Apenas lotes com status %s podem ser reenviados.", SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.getDescricao()));
        }
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoPatrimonial.toPayload());
    }

    public void updateItensPatrimonialPorEntidade(Long id) {
        this.integracaoPatrimonialRepository.updateItensPatrimonialPorEntidade(id);
    }

    public Boolean getParametroIntegracaoEntidade(ParametroGeralEnum parametroGeralEnum) {
        try {
            return this.parametroGeralService.getParamValueAsBoolean(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public List<ItemIntegracaoPatrimonial> itensIntegracaoPatrimonial(Long idIntegracaoContabil, Long entidadePrincipal) {
        return this.itemIntegracaoPatrimonialRepository.findByItemIntegracaoEntidade(idIntegracaoContabil, entidadePrincipal);
    }

    @Generated
    public IntegracaoPatrimonialService(IntegracaoPatrimonialRepository integracaoPatrimonialRepository, ItemIntegracaoPatrimonialRepository itemIntegracaoPatrimonialRepository, MovimentacaoDiariaService movimentacaoDiariaService, EntidadeServiceImpl entidadeService, Publisher publisher, ParametroGeralService parametroGeralService, IntegracaoPatrimonialProvisaoRepository integracaoPatrimonialProvisaoRepository, ItemIntegracaoPatrimonialProvisaoRepository itemIntegracaoPatrimonialProvisaoRepository, ContextService contextService) {
        this.integracaoPatrimonialRepository = integracaoPatrimonialRepository;
        this.itemIntegracaoPatrimonialRepository = itemIntegracaoPatrimonialRepository;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
        this.entidadeService = entidadeService;
        this.publisher = publisher;
        this.parametroGeralService = parametroGeralService;
        this.integracaoPatrimonialProvisaoRepository = integracaoPatrimonialProvisaoRepository;
        this.itemIntegracaoPatrimonialProvisaoRepository = itemIntegracaoPatrimonialProvisaoRepository;
        this.contextService = contextService;
    }
}

