/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipo;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoDetalheDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoFiltroDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoResumoTodosTiposDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoResumoValoresTodosTiposDTO;
import br.com.elotech.tributos.repository.integracaocontabil.ArrecadacaoRepository;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoService {
    private final ArrecadacaoRepository arrecadacaoRepository;

    public ArrecadacaoService(ArrecadacaoRepository arrecadacaoRepository) {
        this.arrecadacaoRepository = arrecadacaoRepository;
    }

    public List<ArrecadacaoResumoTodosTiposDTO> imprimirResumoArrecadacaoTodosOsTipos(ArrecadacaoPorTipoFiltroDTO filtro, Pageable pageable) {
        return this.arrecadacaoRepository.consultaResumoArrecadacaoTodosOsTipos(filtro, pageable);
    }

    public ArrecadacaoResumoValoresTodosTiposDTO consultaResumoArrecadacaoTodosOsTipos(ArrecadacaoPorTipoFiltroDTO filtro, Pageable pageable) {
        ArrecadacaoResumoValoresTodosTiposDTO resumoValoresTodosTiposDTO = new ArrecadacaoResumoValoresTodosTiposDTO();
        resumoValoresTodosTiposDTO.setItens(this.arrecadacaoRepository.consultaResumoArrecadacaoTodosOsTipos(filtro, pageable));
        return resumoValoresTodosTiposDTO;
    }

    public Page<ArrecadacaoPorTipoDetalheDTO> consultaResumoArrecadacaoPorTipoDetalhe(ArrecadacaoPorTipoFiltroDTO filtro, Pageable pageable) {
        ArrayList listaCompleta = new ArrayList();
        ArrecadacaoPorTipo tipo = Optional.ofNullable(filtro.getTipo()).orElseThrow(() -> new EloValidationException("O filtro informado deve conter o Tipo da arrecada\u00e7\u00e3o."));
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$integracaocontabil$ArrecadacaoPorTipo[tipo.ordinal()]) {
            case 1: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorPagamentoDetalhe(filtro));
                break;
            }
            case 2: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorEstornoPagamentoDetalhe(filtro));
                break;
            }
            case 3: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorReabilitacaoEstornoPagamentoDetalhe(filtro));
                break;
            }
            case 4: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorCreditoDetalhe(filtro));
                break;
            }
            case 5: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorEstornoCreditoDetalhe(filtro));
            }
        }
        List resultado = listaCompleta.stream().sorted(Comparator.comparing(ArrecadacaoPorTipoDetalheDTO::getExercicio).thenComparing(ArrecadacaoPorTipoDetalheDTO::getItem)).skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(resultado, pageable, (long)listaCompleta.size());
    }
}

