/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.itau;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class ItauUtilsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ItauUtilsService.class);
    private static String ITAU_FLOW_ID = "f68492aa-81ed-4de2-8447-54ff780717a0";
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private final ParametroGeralService parametroGeralService;
    private final ConfigurableEnvironment configurableEnvironment;

    public String getAccessToken(byte[] certificado, String senhaCertificado, String nomeArquivo, String identifyer, String identifyerValue) throws JsonProcessingException {
        IntegracaoTokenService tokenService = this.getTokenService();
        this.throwDebugLog(identifyer, identifyerValue, "Buscando token");
        Optional accessToken = tokenService.getAccessToken(Banco.CODIGO_BANCO_ITAU, IntegracaoTokenOperation.BOLETO);
        if (accessToken.isPresent()) {
            this.throwDebugLog(identifyer, identifyerValue, "Token encontrado");
            return (String)accessToken.get();
        }
        this.throwDebugLog(identifyer, identifyerValue, "N\u00e3o h\u00e1 um token v\u00e1lido. Ser\u00e1 gerado um novo");
        JsonNode response = this.generateNewAccessToken(certificado, senhaCertificado, nomeArquivo, identifyer, identifyerValue);
        this.throwDebugLog(identifyer, identifyerValue, "Token gerado. Salvando no banco para utiliza\u00e7\u00e3o");
        return tokenService.saveIntegracaoToken(Banco.CODIGO_BANCO_ITAU, IntegracaoTokenOperation.BOLETO, response);
    }

    public <T> HttpEntity<T> createHeaders(String accessToken, T body, String identifyer, String identifyerValue) {
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
        this.throwDebugLog(identifyer, identifyerValue, "Buscou o clientId");
        this.throwDebugLog(identifyer, identifyerValue, "Montou a requisi\u00e7\u00e3o");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("oxy")) {
            headers.set("Authorization", String.format("Bearer %s", accessToken));
        } else {
            headers.set("x-sandbox-token", accessToken);
        }
        headers.set("x-itau-correlationID", UUID.randomUUID().toString());
        headers.set("x-itau-flowID", ITAU_FLOW_ID);
        headers.set("x-itau-apikey", clientId);
        this.throwDebugLog(identifyer, identifyerValue, "Montou os headers");
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    private JsonNode generateNewAccessToken(byte[] certificado, String senhaCertificado, String nomeArquivo, String identifyer, String identifyerValue) {
        this.throwDebugLog(identifyer, identifyerValue, "Iniciando gera\u00e7\u00e3o do Access Token");
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_URL);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
        String clientSecret = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTSECRET);
        this.throwDebugLog(identifyer, identifyerValue, "Buscou os parametros para a  gera\u00e7\u00e3o do Access Token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("x-itau-correlationID", UUID.randomUUID().toString());
        headers.set("x-itau-flowID", ITAU_FLOW_ID);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)clientId);
        body.add((Object)"client_secret", (Object)clientSecret);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado, (String)nomeArquivo).exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("access_token")) {
                if (log.isDebugEnabled()) {
                    String responseString = Optional.ofNullable(response).map(Object::toString).orElse("A resposta veio nula");
                    this.throwDebugLog(identifyer, identifyerValue, String.format("Erro na resposta de gera\u00e7\u00e3o do token: %s", responseString));
                }
                throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
            }
            return response;
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), (Throwable)ex);
        }
    }

    private IntegracaoTokenService getTokenService() {
        return this.integracaoTokenServices.stream().filter(s -> s.accept("JWT")).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token JWT"));
    }

    public String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(valor) || StringUtils.isEmpty((String)valor)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private void throwDebugLog(String identifyer, String identifyerValue, String msg) {
        log.debug(" {} {}: {} ", new Object[]{identifyer, identifyerValue, msg});
    }

    @Generated
    public ItauUtilsService(List<IntegracaoTokenService> integracaoTokenServices, ParametroGeralService parametroGeralService, ConfigurableEnvironment configurableEnvironment) {
        this.integracaoTokenServices = integracaoTokenServices;
        this.parametroGeralService = parametroGeralService;
        this.configurableEnvironment = configurableEnvironment;
    }
}

