/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.itau;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CodigoBarrasQrCodePixItauDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.GerarQrCodePixItauRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.QrCodePixItauErroDTO;
import br.com.elotech.tributos.dto.itau.ItauPixPago;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.itau.ItauUtilsService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;

@Service
public class IntegracaoBoletoItauService
implements IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoItauService.class);
    private static String ITAU_FLOW_ID = "f68492aa-81ed-4de2-8447-54ff780717a0";
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ParametroPixRepository parametroPixRepository;
    private final ConfigurableEnvironment configurableEnvironment;
    private final ContextService contextService;
    private final BloquetoService bloquetoService;
    private final ItauUtilsService itauUtilsService;

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto bloqueto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            Validate.notNull((Object)bloqueto, (String)"O boleto \u00e9 obrigat\u00f3rio para gerar o qrcode do pix.");
            integracaoBoletoPixLog.setBloqueto(bloqueto.getId());
            log.debug("IdBoleto {}: Iniciando processo para login na api", (Object)bloqueto.getId());
            String txid = bloqueto.generateTxIdPix();
            log.debug("IdBoleto {}: gerou o txId", (Object)bloqueto.getId());
            String url = String.format("%s/cobv/%s", this.itauUtilsService.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), txid);
            log.debug("idBoleto {}: criouUrl", (Object)bloqueto.getId());
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(bloqueto.getEntidade());
            log.debug("IdBoleto {}: Buscou o ParametroPix", (Object)bloqueto.getId());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
            String nomeCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getNomeArquivoCertificadoItau).orElse(null);
            log.debug("IdBoleto {}: Buscou os dados do certificado", (Object)bloqueto.getId());
            String accessToken = this.itauUtilsService.getAccessToken(certificado, senhaCertificado, nomeCertificado, "Boleto ", bloqueto.getId().toString());
            GerarQrCodePixItauRequestDTO dto = GerarQrCodePixItauRequestDTO.from((Bloqueto)bloqueto);
            HttpEntity requestEntity = this.itauUtilsService.createHeaders(accessToken, (Object)dto, "Boleto", bloqueto.getId().toString());
            HttpMethod httpMethod = HttpMethod.PUT;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            integracaoBoletoPixLog.setUrlRequest(url);
            log.debug("IdBoleto {}: Montou o corpo da requisi\u00e7\u00e3o", (Object)bloqueto.getId());
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado, (String)nomeCertificado).exchange(url, httpMethod, requestEntity, JsonNode.class, new Object[0]).getBody();
            log.debug("IdBoleto {}: Retornou a requisi\u00e7\u00e3o", (Object)bloqueto.getId());
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
            resultDto.setTextoQrCode(response.get("pixCopiaECola").asText());
            resultDto.setTxid(response.get("txid").asText());
            IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
            return integracaoPixResponseDTO;
        }
        catch (RestException e) {
            QrCodePixItauErroDTO dtoErros = this.converteErroResposta(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            log.debug("IdBoleto {}: Come\u00e7ou a salvar o log", (Object)bloqueto.getId());
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
            log.debug("IdBoleto {}: Terminou de salvar o log", (Object)bloqueto.getId());
        }
    }

    public IntegracaoBoletoPixLog updateCodigoBarrasBoleto(CodigoBarrasQrCodePixItauDTO boleto) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.ALTERA_CODIGO_BARRAS_QR_CODE);
        try {
            Validate.notNull((Object)boleto, (String)"O boleto \u00e9 obrigat\u00f3rio para fazer a altera\u00e7\u00e3o");
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            String txid = boleto.getTxid();
            String url = String.format("%s/cobv/%s", this.itauUtilsService.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), txid);
            GerarQrCodePixItauRequestDTO dto = GerarQrCodePixItauRequestDTO.alteracaoQrCodePixItau((CodigoBarrasQrCodePixItauDTO)boleto);
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
            String nomeCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getNomeArquivoCertificadoItau).orElse(null);
            HttpMethod httpMethod = HttpMethod.PATCH;
            HttpHeaders headers = this.getHttpHeaders(certificado, senhaCertificado, nomeCertificado, boleto.getId());
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setTxid(txid);
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado, (String)nomeCertificado).exchange(url, httpMethod, requestEntity, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            return integracaoBoletoPixLog;
        }
        catch (RestException e) {
            QrCodePixItauErroDTO dtoErros = this.converteErroResposta(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
            throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private HttpHeaders getHttpHeaders(byte[] certificado, String senhaCertificado, String nomeCertificado, Long idBoleto) throws JsonProcessingException {
        String clientId = this.itauUtilsService.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
        String accessToken = this.itauUtilsService.getAccessToken(certificado, senhaCertificado, nomeCertificado, "Boleto", idBoleto.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("x-itau-correlationID", UUID.randomUUID().toString());
        headers.set("x-itau-flowID", ITAU_FLOW_ID);
        headers.set("x-itau-apikey", clientId);
        if (AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("oxy")) {
            headers.set("Authorization", String.format("Bearer %s", accessToken));
        } else {
            headers.set("x-sandbox-token", accessToken);
        }
        return headers;
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private QrCodePixItauErroDTO converteErroResposta(String json) {
        try {
            JsonNode jsonNode = this.mapper.readTree(json);
            if (jsonNode.has("codigo_erro")) {
                QrCodePixItauErroDTO dto = new QrCodePixItauErroDTO();
                dto.setTitle(jsonNode.get("codigo_erro").asText());
                dto.setMessage(jsonNode.has("mensagem") ? jsonNode.get("mensagem").asText() : null);
                dto.setDetail(jsonNode.has("acao") ? jsonNode.get("acao").asText() : null);
                return dto;
            }
            return (QrCodePixItauErroDTO)this.mapper.readValue(json, QrCodePixItauErroDTO.class);
        }
        catch (JsonProcessingException e) {
            QrCodePixItauErroDTO erroDTO = new QrCodePixItauErroDTO();
            erroDTO.setTitle("Erro ao ler o json do retorno com erro. " + e.getMessage());
            return erroDTO;
        }
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_BANCO_ITAU;
    }

    public ConsultaPixResponseDTO getPagamento(Optional<String> txid, Optional<String> endToendIdentification, Convenio convenio) {
        if (endToendIdentification.isPresent()) {
            ConsultaPixResponseDTO pagamento = this.getPagamentoByE2E(endToendIdentification.get());
            Optional bloqueto = this.bloquetoService.findByTxid(pagamento.getTxid());
            pagamento.fillBoletoInfo(bloqueto);
            return pagamento;
        }
        throw new RestException(HttpStatus.NOT_IMPLEMENTED, String.format("Pesquisa por txid ainda n\u00e3o implementada para o convenio %s.", convenio.getConvenio()));
    }

    public ConsultaPixResponseDTO getPagamentoByE2E(String endToendIdentification) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PIX_E2E);
        try {
            integracaoBoletoPixLog.setCodigoE2E(endToendIdentification);
            String url = String.format("%s/pix/%s", this.itauUtilsService.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), endToendIdentification);
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(this.contextService.getEntidadePrincipal());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
            String nomeCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getNomeArquivoCertificadoItau).orElse(null);
            String accessToken = this.itauUtilsService.getAccessToken(certificado, senhaCertificado, nomeCertificado, "E2E", endToendIdentification);
            HttpEntity requestEntity = this.itauUtilsService.createHeaders(accessToken, null, "E2E", endToendIdentification);
            HttpMethod httpMethod = HttpMethod.GET;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            ItauPixPago response = (ItauPixPago)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado, (String)nomeCertificado).exchange(url, httpMethod, requestEntity, ItauPixPago.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            ConsultaPixResponseDTO consultaPixResponseDTO = ConsultaPixResponseDTO.fromItauPixPago((ItauPixPago)response);
            return consultaPixResponseDTO;
        }
        catch (RestException e) {
            throw new RestException(e.getStatus(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    @Generated
    public IntegracaoBoletoItauService(ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ParametroPixRepository parametroPixRepository, ConfigurableEnvironment configurableEnvironment, ContextService contextService, BloquetoService bloquetoService, ItauUtilsService itauUtilsService) {
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.parametroPixRepository = parametroPixRepository;
        this.configurableEnvironment = configurableEnvironment;
        this.contextService = contextService;
        this.bloquetoService = bloquetoService;
        this.itauUtilsService = itauUtilsService;
    }
}

