/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.delbank;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.CertificadoDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.ResponseErrorDelbankDTO;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DelBankService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelBankService.class);
    private final ObjectMapper mapper;
    private final ParametroGeralService parametroGeralService;
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final BancoRepository bancoRepository;
    private final ConvenioService convenioService;
    private final ParametroPixRepository parametroPixRepository;
    private final ContextService contextService;
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_TYPE_JSON = "application/json";
    private static final String X_DELBANK_API_KEY = "x-delbank-api-key";

    public <T> T converteErroResposta(String json, Class<T> valueType) {
        try {
            return (T)this.mapper.readValue(json, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public HttpHeaders criarHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set(X_DELBANK_API_KEY, this.getParametro(ParametroGeralEnum.DELBANK_CHAVE_AUTENTICACAO));
        headers.set(HEADER_CONTENT_TYPE, HEADER_CONTENT_TYPE_JSON);
        return headers;
    }

    public String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isEmpty((String)valor)) {
                throw new RestException(HttpStatus.BAD_REQUEST, String.format("O par\u00e2metro %s n\u00e3o foi configurado.", parametroGeralEnum.name()));
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public CertificadoDelBankDTO getCertificado() {
        ParametroPix parametroPix = this.getParametroPixByEntidade(this.contextService.getEntidadePrincipal());
        return CertificadoDelBankDTO.builder().arquivoCertificado(this.getCertificadoByParametroPix(parametroPix)).senhaCertificado(this.getSenhaCertificadoByParametroPix(parametroPix)).nomeArquivo(this.getNomeCertificadoByParametroPix(parametroPix)).build();
    }

    public ParametroPix getParametroPixByEntidade(Long entidade) {
        return this.parametroPixRepository.getByEntidade(entidade);
    }

    public RestTemplate getRestTemplate(byte[] certificado, String senhaCertificado, String nomeArquivo) {
        try {
            return RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado, (String)nomeArquivo);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public byte[] getCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoDelBank).orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado o arquivo do certificado para o Delbank"));
    }

    public String getSenhaCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoDelBank).orElse(null);
    }

    public String getNomeCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getNomeArquivoCertificadoDelBank).orElse(null);
    }

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_DELBANK)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o DelBank!"));
    }

    public Convenio getConvenio(Long idConvenio) {
        return (Convenio)this.convenioService.findById((Serializable)idConvenio).orElseThrow(() -> new EloValidationException(String.format("Conv\u00eanio %d n\u00e3o encontrado.", idConvenio)));
    }

    public IntegracaoBoletoPixLog builderErrorRegistro(IntegracaoBoletoPixLog integracaoBoletoPixLog, RestException e) {
        ResponseErrorDelbankDTO dtoErros = (ResponseErrorDelbankDTO)this.converteErroResposta(e.getMessage(), ResponseErrorDelbankDTO.class);
        String descricaoErros = Optional.ofNullable(dtoErros).filter(ResponseErrorDelbankDTO::hasErro).map(ResponseErrorDelbankDTO::getErrosConcatenado).orElseGet(() -> String.format("%s / %s", e.getStatus(), e.getMessage()));
        integracaoBoletoPixLog.setJsonResponse(e.getMessage());
        integracaoBoletoPixLog.setDescricaoErro(descricaoErros);
        return integracaoBoletoPixLog;
    }

    @Generated
    public DelBankService(ObjectMapper mapper, ParametroGeralService parametroGeralService, ParametroCNAB240Repository parametroCNAB240Repository, BancoRepository bancoRepository, ConvenioService convenioService, ParametroPixRepository parametroPixRepository, ContextService contextService) {
        this.mapper = mapper;
        this.parametroGeralService = parametroGeralService;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.bancoRepository = bancoRepository;
        this.convenioService = convenioService;
        this.parametroPixRepository = parametroPixRepository;
        this.contextService = contextService;
    }
}

